/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternetTexture
extends SimpleTexture {
    private final String url;
    private final ResourceLocation resourceLocation;
    @Nullable
    private final Runnable onDownloaded;
    @Nullable
    private TextureLocation textureLocation = null;
    @Nullable
    private CompletableFuture<Void> future = null;

    public InternetTexture(String url, ResourceLocation resourceLocation, @Nullable Runnable onDownloaded) {
        super(resourceLocation);
        this.url = url;
        this.resourceLocation = resourceLocation;
        this.onDownloaded = onDownloaded;
    }

    public InternetTexture(String url, ResourceLocation resourceLocation) {
        this(url, resourceLocation, null);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public Optional<TextureLocation> getTextureLocation() {
        return Optional.ofNullable(this.textureLocation);
    }

    private void loadCallback(NativeImage image) {
        if (this.onDownloaded != null) {
            this.onDownloaded.run();
        }
        Minecraft.m_91087_().execute(() -> {
            if (RenderSystem.isOnRenderThread()) {
                this.upload(image);
            } else {
                RenderSystem.recordRenderCall(() -> this.upload(image));
            }
        });
    }

    private void upload(NativeImage image) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)image.m_84982_(), (int)image.m_85084_());
        image.m_85040_(0, 0, 0, true);
        this.textureLocation = new TextureLocation(this.resourceLocation, image.m_84982_(), image.m_85084_());
    }

    @Nullable
    private NativeImage load(InputStream stream) {
        NativeImage image = null;
        try {
            image = NativeImage.m_85058_((InputStream)stream);
        }
        catch (Exception exception) {
            NostalgicTweaks.LOGGER.error("Error while loading native internet image\n%s", exception);
        }
        return image;
    }

    public void m_6704_(@NotNull ResourceManager resourceManager) throws IOException {
        if (this.future != null) {
            return;
        }
        this.future = CompletableFuture.runAsync(() -> {
            HttpURLConnection connection = null;
            NostalgicTweaks.LOGGER.debug("Downloading internet texture from: %s", this.url);
            try {
                connection = (HttpURLConnection)new URL(this.url).openConnection(Minecraft.m_91087_().m_91096_());
                connection.connect();
                if (connection.getResponseCode() / 100 != 2) {
                    return;
                }
                NativeImage image = this.load(connection.getInputStream());
                if (image != null) {
                    this.loadCallback(image);
                }
            }
            catch (Exception exception) {
                NostalgicTweaks.LOGGER.error("Couldn't download internet texture\n%s", exception);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }, Util.m_183991_());
    }
}

