/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.renderer;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mod.adrenix.nostalgic.util.client.gui.GuiOffset;
import mod.adrenix.nostalgic.util.client.gui.GuiUtil;
import mod.adrenix.nostalgic.util.client.renderer.MatrixUtil;
import mod.adrenix.nostalgic.util.client.renderer.TextureLayer;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import mod.adrenix.nostalgic.util.common.color.Color;
import mod.adrenix.nostalgic.util.common.color.Gradient;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import mod.adrenix.nostalgic.util.common.math.Rectangle;
import mod.adrenix.nostalgic.util.common.sprite.GuiSprite;
import mod.adrenix.nostalgic.util.common.sprite.GuiSpriteScaling;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

public abstract class RenderUtil {
    private static boolean isPausedBatching = false;
    private static boolean isBatching = false;
    private static int fillZOffset = 0;
    private static int batchIndex = 0;
    private static TextureLayer layer = TextureLayer.DEFAULT;
    private static TextureLocation texture;
    private static RenderType renderType;
    private static final Tesselator MOD_TESSELATOR;
    private static final ArrayDeque<Runnable> DEFERRED_QUEUE;
    private static final ArrayDeque<Scissor> SCISSOR_QUEUE;
    private static final ArrayDeque<LineBuffer> LINE_QUEUE;
    private static final HashSet<TextureLayer> TEXTURE_LAYERS;
    private static final ArrayDeque<ItemBuffer> ITEM_MODEL_QUEUE;
    private static final ArrayDeque<ItemBuffer> BLOCK_MODEL_QUEUE;
    private static final ArrayDeque<Consumer<BufferBuilder>> FILL_VERTICES;
    private static final MultiBufferSource.BufferSource FONT_BATCH;
    private static final MultiBufferSource.BufferSource FONT_IMMEDIATE;

    public static void setFillZOffset(int offset) {
        fillZOffset = offset;
    }

    public static boolean isBatching() {
        return isBatching;
    }

    public static void pauseBatching() {
        isPausedBatching = true;
        isBatching = false;
    }

    public static void resumeBatching() {
        isPausedBatching = false;
        isBatching = true;
    }

    public static MultiBufferSource.BufferSource fontBuffer() {
        if (isBatching) {
            return FONT_BATCH;
        }
        return FONT_IMMEDIATE;
    }

    public static void pushScissor(int startX, int startY, int endX, int endY) {
        Scissor scissor = new Scissor(ScissorType.NORMAL, startX, startY, endX, endY);
        SCISSOR_QUEUE.push(scissor);
        scissor.enable();
    }

    public static void pushScissor(Rectangle rectangle) {
        RenderUtil.pushScissor(rectangle.startX(), rectangle.startY(), rectangle.endX(), rectangle.endY());
    }

    public static void pushZoneScissor(int startX, int startY, int endX, int endY) {
        SCISSOR_QUEUE.push(new Scissor(ScissorType.ZONE, startX, startY, endX, endY));
        GuiUtil.enableScissor(startX, startY, endX, endY);
    }

    public static void pushZoneScissor(Rectangle rectangle) {
        RenderUtil.pushZoneScissor(rectangle.startX(), rectangle.startY(), rectangle.endX(), rectangle.endY());
    }

    public static void popScissor() {
        Scissor scissor = SCISSOR_QUEUE.poll();
        if (scissor == null) {
            return;
        }
        if (SCISSOR_QUEUE.isEmpty()) {
            GuiUtil.disableScissor();
        } else {
            Scissor peek = SCISSOR_QUEUE.peek();
            GuiUtil.enableScissor(peek.startX, peek.startY, peek.endX, peek.endY);
        }
    }

    public static void setRenderType(RenderType type) {
        renderType = type;
    }

    public static BufferBuilder getTesselatorBuilder() {
        return MOD_TESSELATOR.m_85915_();
    }

    public static BufferBuilder getAndBeginFill() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder builder = RenderUtil.getTesselatorBuilder();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        return builder;
    }

    public static void endFill(BufferBuilder builder) {
        if (builder.m_85732_()) {
            RenderUtil.draw(builder);
        }
        RenderSystem.disableBlend();
    }

    public static BufferBuilder getAndBeginLine(float width) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172757_);
        RenderSystem.lineWidth((float)width);
        BufferBuilder builder = RenderUtil.getTesselatorBuilder();
        builder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        return builder;
    }

    public static void endLine(BufferBuilder builder) {
        RenderUtil.draw(builder);
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.disableBlend();
    }

    public static BufferBuilder getAndBeginTexture(ResourceLocation location) {
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        BufferBuilder builder = RenderUtil.getTesselatorBuilder();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        return builder;
    }

    public static BufferBuilder getAndBeginTexture(TextureLocation location) {
        texture = location;
        return RenderUtil.getAndBeginTexture((ResourceLocation)location);
    }

    public static void pushLayer(TextureLayer textureLayer) {
        layer = textureLayer;
        TEXTURE_LAYERS.add(textureLayer);
    }

    public static void popLayer() {
        layer = TextureLayer.DEFAULT;
    }

    public static void endTexture(BufferBuilder builder) {
        RenderUtil.draw(builder);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        texture = null;
    }

    private static Matrix4f getMatrix(PoseStack poseStack) {
        return isBatching ? new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_()) : poseStack.m_85850_().m_252922_();
    }

    public static void batch(Runnable runnable) {
        RenderUtil.beginBatching();
        runnable.run();
        RenderUtil.endBatching();
    }

    public static void beginBatching() {
        ++batchIndex;
        isBatching = true;
    }

    public static void deferredRenderer(Runnable deferred) {
        DEFERRED_QUEUE.add(deferred);
    }

    private static void draw(BufferBuilder builder) {
        BufferBuilder.RenderedBuffer rendered = builder.m_231168_();
        if (rendered == null) {
            return;
        }
        if (renderType == null) {
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)rendered);
        } else {
            renderType.m_110185_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)rendered);
            renderType.m_110188_();
            if (!isBatching) {
                renderType = null;
            }
        }
    }

    private static void endBatchingFills(BufferBuilder builder) {
        if (FILL_VERTICES.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        while (!FILL_VERTICES.isEmpty()) {
            FILL_VERTICES.pollLast().accept(builder);
        }
        RenderUtil.draw(builder);
        RenderSystem.disableBlend();
    }

    private static void endBatchingLines(BufferBuilder builder) {
        if (LINE_QUEUE.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172757_);
        LINE_QUEUE.stream().map(LineBuffer::width).distinct().forEach(width -> {
            RenderSystem.lineWidth((float)width.floatValue());
            if (!builder.m_85732_()) {
                builder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
            }
            LINE_QUEUE.stream().filter(line -> line.width == width.floatValue()).forEach(line -> {
                float nx = MathUtil.sign(line.x2 - line.x1);
                float ny = MathUtil.sign(line.y2 - line.y1);
                builder.m_252986_(line.matrix, line.x1, line.y1, 0.0f).m_193479_(line.colorFrom).m_5601_(nx, ny, 0.0f).m_5752_();
                builder.m_252986_(line.matrix, line.x2, line.y2, 0.0f).m_193479_(line.colorTo).m_5601_(nx, ny, 0.0f).m_5752_();
            });
            RenderUtil.draw(builder);
        });
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.disableBlend();
        LINE_QUEUE.clear();
    }

    private static void endBatchingTextures(BufferBuilder builder) {
        if (TEXTURE_LAYERS.isEmpty()) {
            return;
        }
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.enableBlend();
        TEXTURE_LAYERS.stream().sorted(Comparator.comparingInt(TextureLayer::getIndex)).forEach(layer -> {
            layer.textureMap.forEach((location, queue) -> {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!builder.m_85732_()) {
                    builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                }
                if (location instanceof TextureLocation) {
                    TextureLocation sheet = (TextureLocation)((Object)((Object)location));
                    queue.forEach(buffer -> RenderUtil.blitTexture(sheet, (VertexConsumer)builder, buffer.matrix, buffer.x, buffer.y, buffer.uOffset, buffer.vOffset, buffer.uWidth, buffer.vHeight, buffer.rgba));
                } else {
                    queue.forEach(buffer -> RenderUtil.blit256(buffer.matrix, buffer.x, buffer.y, buffer.uOffset, buffer.vOffset, buffer.uWidth, buffer.vHeight, buffer.rgba));
                }
                RenderUtil.draw(builder);
            });
            layer.textureLightMap.forEach((location, queue) -> {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
                if (location instanceof TextureLocation) {
                    TextureLocation sheet = (TextureLocation)((Object)((Object)location));
                    queue.stream().collect(Collectors.groupingBy(TextureBuffer::hashColor)).forEach((argb, buffers) -> {
                        if (!builder.m_85732_()) {
                            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                        }
                        float r = ((TextureBuffer)buffers.get((int)0)).rgba[0];
                        float g = ((TextureBuffer)buffers.get((int)0)).rgba[1];
                        float b = ((TextureBuffer)buffers.get((int)0)).rgba[2];
                        float a = ((TextureBuffer)buffers.get((int)0)).rgba[3];
                        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
                        buffers.forEach(buffer -> RenderUtil.blitTexture(sheet, (VertexConsumer)builder, buffer.matrix, buffer.x, buffer.y, buffer.uOffset, buffer.vOffset, buffer.uWidth, buffer.vHeight, buffer.rgba));
                        RenderUtil.draw(builder);
                    });
                } else {
                    queue.stream().collect(Collectors.groupingBy(TextureBuffer::hashColor)).forEach((argb, buffers) -> {
                        if (!builder.m_85732_()) {
                            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                        }
                        float r = ((TextureBuffer)buffers.get((int)0)).rgba[0];
                        float g = ((TextureBuffer)buffers.get((int)0)).rgba[1];
                        float b = ((TextureBuffer)buffers.get((int)0)).rgba[2];
                        float a = ((TextureBuffer)buffers.get((int)0)).rgba[3];
                        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
                        buffers.forEach(buffer -> RenderUtil.blit256(buffer.matrix, buffer.x, buffer.y, buffer.uOffset, buffer.vOffset, buffer.uWidth, buffer.vHeight, buffer.rgba));
                        RenderUtil.draw(builder);
                    });
                }
            });
            layer.spriteMap.forEach((sprite, queue) -> {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!builder.m_85732_()) {
                    builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                }
                queue.forEach(buffer -> RenderUtil.innerBlit(builder, buffer));
                RenderUtil.draw(builder);
            });
            layer.spriteLightMap.forEach((sprite, queue) -> {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite);
                queue.stream().collect(Collectors.groupingBy(SpriteBuffer::hashColor)).forEach((argb, buffers) -> {
                    if (!builder.m_85732_()) {
                        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                    }
                    float r = ((SpriteBuffer)buffers.get((int)0)).rgba[0];
                    float g = ((SpriteBuffer)buffers.get((int)0)).rgba[1];
                    float b = ((SpriteBuffer)buffers.get((int)0)).rgba[2];
                    float a = ((SpriteBuffer)buffers.get((int)0)).rgba[3];
                    RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
                    buffers.forEach(buffer -> RenderUtil.innerBlit(builder, buffer));
                    RenderUtil.draw(builder);
                });
            });
        });
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TEXTURE_LAYERS.forEach(TextureLayer::clear);
        TEXTURE_LAYERS.clear();
    }

    private static void endBatchingItemsQueue() {
        if (ITEM_MODEL_QUEUE.isEmpty()) {
            return;
        }
        PoseStack poseStack = new PoseStack();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        ITEM_MODEL_QUEUE.forEach(item -> {
            poseStack.m_85850_().m_252922_().set((Matrix4fc)item.matrix);
            Minecraft.m_91087_().m_91291_().m_115143_(item.itemStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)buffer, item.packedLight, OverlayTexture.f_118083_, item.model);
        });
        buffer.m_109911_();
        ITEM_MODEL_QUEUE.clear();
        Lighting.m_84931_();
    }

    private static void endBatchingBlocksQueue() {
        if (BLOCK_MODEL_QUEUE.isEmpty()) {
            return;
        }
        PoseStack poseStack = new PoseStack();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        BLOCK_MODEL_QUEUE.forEach(block -> {
            poseStack.m_85850_().m_252922_().set((Matrix4fc)block.matrix);
            Minecraft.m_91087_().m_91291_().m_115143_(block.itemStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)buffer, block.packedLight, OverlayTexture.f_118083_, block.model);
        });
        buffer.m_109911_();
        BLOCK_MODEL_QUEUE.clear();
    }

    public static void endBatching() {
        if (isPausedBatching) {
            RenderUtil.resumeBatching();
        }
        if (batchIndex > 0) {
            --batchIndex;
        }
        if (!isBatching || batchIndex > 0) {
            fillZOffset = 0;
            return;
        }
        BufferBuilder builder = RenderUtil.getTesselatorBuilder();
        RenderSystem.enableDepthTest();
        RenderUtil.endBatchingFills(builder);
        RenderUtil.endBatchingLines(builder);
        RenderUtil.endBatchingTextures(builder);
        RenderUtil.endBatchingItemsQueue();
        RenderUtil.endBatchingBlocksQueue();
        RenderSystem.enableDepthTest();
        FONT_BATCH.m_109911_();
        RenderSystem.disableDepthTest();
        fillZOffset = 0;
        isBatching = false;
        renderType = null;
        if (DEFERRED_QUEUE.isEmpty()) {
            return;
        }
        RenderUtil.batch(() -> {
            while (!DEFERRED_QUEUE.isEmpty()) {
                DEFERRED_QUEUE.poll().run();
            }
        });
    }

    public static boolean flush() {
        boolean isFlushed;
        boolean bl = isFlushed = batchIndex > 0;
        while (batchIndex > 0) {
            RenderUtil.endBatching();
        }
        return isFlushed;
    }

    public static void fill(VertexConsumer consumer, Matrix4f matrix, float x0, float y0, float x1, float y1, int argb) {
        float z = 0.0f;
        consumer.m_252986_(matrix, x0, y1, z).m_193479_(argb).m_5752_();
        consumer.m_252986_(matrix, x1, y1, z).m_193479_(argb).m_5752_();
        consumer.m_252986_(matrix, x1, y0, z).m_193479_(argb).m_5752_();
        consumer.m_252986_(matrix, x0, y0, z).m_193479_(argb).m_5752_();
    }

    public static void fill(VertexConsumer consumer, float x0, float y0, float x1, float y1, int argb) {
        float z = 0.0f;
        consumer.m_5483_((double)x0, (double)y1, (double)z).m_193479_(argb).m_5752_();
        consumer.m_5483_((double)x1, (double)y1, (double)z).m_193479_(argb).m_5752_();
        consumer.m_5483_((double)x1, (double)y0, (double)z).m_193479_(argb).m_5752_();
        consumer.m_5483_((double)x0, (double)y0, (double)z).m_193479_(argb).m_5752_();
    }

    public static void fill(VertexConsumer consumer, GuiGraphics graphics, float x0, float y0, float x1, float y1, int argb) {
        RenderUtil.fill(consumer, graphics.m_280168_().m_85850_().m_252922_(), x0, y0, x1, y1, argb);
    }

    public static void fill(GuiGraphics graphics, float x0, float y0, float x1, float y1, int argb) {
        RenderUtil.fillGradient(graphics.m_280168_(), x0, y0, x1, y1, argb, argb, true);
    }

    public static void fill(GuiGraphics graphics, float x0, float y0, float x1, float y1, Color color) {
        int argb = color.get();
        RenderUtil.fillGradient(graphics.m_280168_(), x0, y0, x1, y1, argb, argb, true);
    }

    private static void fillGradient(PoseStack poseStack, float x0, float y0, float x1, float y1, int colorFrom, int colorTo, boolean isVertical) {
        float z = isBatching ? (float)fillZOffset : 0.0f;
        Matrix4f matrix = RenderUtil.getMatrix(poseStack);
        Consumer<BufferBuilder> vertices = builder -> {
            if (isVertical) {
                builder.m_252986_(matrix, x0, y1, z).m_193479_(colorTo).m_5752_();
                builder.m_252986_(matrix, x1, y1, z).m_193479_(colorTo).m_5752_();
                builder.m_252986_(matrix, x1, y0, z).m_193479_(colorFrom).m_5752_();
                builder.m_252986_(matrix, x0, y0, z).m_193479_(colorFrom).m_5752_();
            } else {
                builder.m_252986_(matrix, x0, y1, z).m_193479_(colorFrom).m_5752_();
                builder.m_252986_(matrix, x1, y1, z).m_193479_(colorTo).m_5752_();
                builder.m_252986_(matrix, x1, y0, z).m_193479_(colorTo).m_5752_();
                builder.m_252986_(matrix, x0, y0, z).m_193479_(colorFrom).m_5752_();
            }
        };
        if (!isBatching) {
            BufferBuilder builder2 = RenderUtil.getAndBeginFill();
            vertices.accept(builder2);
            RenderUtil.endFill(builder2);
        } else {
            FILL_VERTICES.push(vertices);
        }
    }

    public static void fromTopGradient(GuiGraphics graphics, float x0, float y0, float x1, float y1, int colorFrom, int colorTo) {
        RenderUtil.fillGradient(graphics.m_280168_(), x0, y0, x1, y1, colorFrom, colorTo, true);
    }

    public static void fromTopGradient(GuiGraphics graphics, float x0, float y0, float x1, float y1, Color colorFrom, Color colorTo) {
        RenderUtil.fillGradient(graphics.m_280168_(), x0, y0, x1, y1, colorFrom.get(), colorTo.get(), true);
    }

    public static void fromLeftGradient(GuiGraphics graphics, float x0, float y0, float x1, float y1, int colorFrom, int colorTo) {
        RenderUtil.fillGradient(graphics.m_280168_(), x0, y0, x1, y1, colorFrom, colorTo, false);
    }

    public static void fromLeftGradient(GuiGraphics graphics, float x0, float y0, float x1, float y1, Color colorFrom, Color colorTo) {
        RenderUtil.fillGradient(graphics.m_280168_(), x0, y0, x1, y1, colorFrom.get(), colorTo.get(), false);
    }

    public static void gradient(Gradient gradient, GuiGraphics graphics, float x0, float y0, float x1, float y1) {
        int from = gradient.from().get();
        int to = gradient.to().get();
        switch (gradient.direction()) {
            case VERTICAL: {
                RenderUtil.fromTopGradient(graphics, x0, y0, x1, y1, from, to);
                break;
            }
            case HORIZONTAL: {
                RenderUtil.fromLeftGradient(graphics, x0, y0, x1, y1, from, to);
            }
        }
    }

    public static void lineGradient(GuiGraphics graphics, float x0, float y0, float x1, float y1, float width, int colorFrom, int colorTo) {
        float z = 0.0f;
        Matrix4f matrix = RenderUtil.getMatrix(graphics.m_280168_());
        if (isBatching) {
            new LineBuffer(matrix, x0, y0, x1, y1, width, colorFrom, colorTo);
        } else {
            BufferBuilder builder = RenderUtil.getAndBeginLine(width);
            builder.m_252986_(matrix, x0, y0, z).m_193479_(colorFrom).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            builder.m_252986_(matrix, x1, y1, z).m_193479_(colorTo).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            RenderUtil.endLine(builder);
        }
    }

    public static void line(GuiGraphics graphics, float x0, float y0, float x1, float y1, float width, int argb) {
        RenderUtil.lineGradient(graphics, x0, y0, x1, y1, width, argb, argb);
    }

    public static void vLine(GuiGraphics graphics, float x0, float y0, float y1, int argb) {
        RenderUtil.fill(graphics, x0, y0, x0 + 1.0f, y1, argb);
    }

    public static void vLine(GuiGraphics graphics, float x0, float y0, float y1, Color color) {
        RenderUtil.vLine(graphics, x0, y0, y1, color.get());
    }

    public static void hLine(GuiGraphics graphics, float x0, float y0, float x1, int argb) {
        RenderUtil.fill(graphics, x0, y0, x1, y0 + 1.0f, argb);
    }

    public static void hLine(GuiGraphics graphics, float x0, float y0, float x1, Color color) {
        RenderUtil.hLine(graphics, x0, y0, x1, color.get());
    }

    public static void outline(GuiGraphics graphics, float x0, float y0, float width, float height, float thickness, int argb) {
        boolean notBatching;
        boolean bl = notBatching = !isBatching;
        if (notBatching) {
            RenderUtil.beginBatching();
        }
        RenderUtil.fill(graphics, x0, y0 + thickness, x0 + thickness, y0 + height - thickness, argb);
        RenderUtil.fill(graphics, x0 + width - thickness, y0, x0 + width, y0 + height - thickness, argb);
        RenderUtil.fill(graphics, x0, y0, x0 + width - thickness, y0 + thickness, argb);
        RenderUtil.fill(graphics, x0, y0 + height - thickness, x0 + width, y0 + height, argb);
        if (notBatching) {
            RenderUtil.endBatching();
        }
    }

    public static void outline(GuiGraphics graphics, float x0, float y0, float width, float height, float thickness, Color color) {
        RenderUtil.outline(graphics, x0, y0, width, height, thickness, color.get());
    }

    public static void outline(GuiGraphics graphics, float x0, float y0, float width, float height, int argb) {
        RenderUtil.outline(graphics, x0, y0, width, height, 1.0f, argb);
    }

    public static void outline(GuiGraphics graphics, float x0, float y0, float width, float height, Color color) {
        RenderUtil.outline(graphics, x0, y0, width, height, color.get());
    }

    public static void circle(GuiGraphics graphics, float centerX, float centerY, float radius, int argb) {
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        builder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        for (float f = 0.0f; f < 360.0f; f += 4.5f) {
            float rads = (float)Math.toRadians(f);
            float x = (float)((double)centerX + Math.sin(rads) * (double)radius);
            float y = (float)((double)centerY + Math.cos(rads) * (double)radius);
            builder.m_252986_(matrix, x, y, 0.0f).m_193479_(argb).m_5752_();
        }
        RenderUtil.draw(builder);
        RenderSystem.disableBlend();
    }

    public static void putTransparentBulkData(PoseStack.Pose pose, VertexConsumer vertexConsumer, BakedQuad quad, float brightness, float alpha) {
        int light = new Color(brightness, brightness, brightness, alpha).get();
        int[] vertices = quad.m_111303_();
        Vec3i dirNormal = quad.m_111306_().m_122436_();
        Matrix4f posMatrix = pose.m_252922_();
        Vector3f normal = pose.m_252943_().transform(new Vector3f((float)dirNormal.m_123341_(), (float)dirNormal.m_123342_(), (float)dirNormal.m_123343_()));
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            for (int i = 0; i < vertices.length / 8; ++i) {
                intBuffer.clear();
                intBuffer.put(vertices, i * 8, 8);
                float x = byteBuffer.getFloat(0);
                float y = byteBuffer.getFloat(4);
                float z = byteBuffer.getFloat(8);
                Vector4f pos = posMatrix.transform(new Vector4f(x, y, z, 1.0f));
                vertexConsumer.m_5954_(pos.x(), pos.y(), pos.z(), 1.0f, 1.0f, 1.0f, alpha, byteBuffer.getFloat(16), byteBuffer.getFloat(20), OverlayTexture.f_118083_, light, normal.x(), normal.y(), normal.z());
            }
        }
    }

    public static void blitTexture(TextureLocation texture, GuiGraphics graphics, float x, float y, int uOffset, int vOffset, int uWidth, int vHeight) {
        if (isBatching) {
            TextureBuffer.create(RenderUtil.getMatrix(graphics.m_280168_()), texture, x, y, uOffset, vOffset, uWidth, vHeight);
            return;
        }
        BufferBuilder builder = RenderUtil.getAndBeginTexture(texture);
        RenderUtil.blitTexture((VertexConsumer)builder, graphics, x, y, uOffset, vOffset, uWidth, vHeight);
        RenderUtil.endTexture(builder);
    }

    public static void blitTexture(TextureLocation texture, GuiGraphics graphics, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        RenderUtil.blitTexture(texture, graphics, (float)x, (float)y, uOffset, vOffset, uWidth, vHeight);
    }

    public static void blitTexture(VertexConsumer consumer, GuiGraphics graphics, float x, float y, int uOffset, int vOffset, int uWidth, int vHeight) {
        if (texture == null) {
            return;
        }
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        RenderUtil.blitTexture(texture, consumer, matrix, x, y, uOffset, vOffset, uWidth, vHeight, RenderSystem.getShaderColor());
    }

    private static void blitTexture(TextureLocation texture, VertexConsumer consumer, Matrix4f matrix, float x, float y, int uOffset, int vOffset, int uWidth, int vHeight, float[] rgba) {
        float x2 = x + (float)uWidth;
        float y2 = y + (float)vHeight;
        float minU = (float)uOffset / (float)texture.getWidth();
        float maxU = (float)(uOffset + uWidth) / (float)texture.getWidth();
        float minV = (float)vOffset / (float)texture.getHeight();
        float maxV = (float)(vOffset + vHeight) / (float)texture.getHeight();
        int color = new Color(rgba[0], rgba[1], rgba[2], rgba[3]).get();
        consumer.m_252986_(matrix, x, y2, 0.0f).m_7421_(minU, maxV).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix, x2, y2, 0.0f).m_7421_(maxU, maxV).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix, x2, y, 0.0f).m_7421_(maxU, minV).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix, x, y, 0.0f).m_7421_(minU, minV).m_193479_(color).m_5752_();
    }

    public static void blitTexture(VertexConsumer consumer, GuiGraphics graphics, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        RenderUtil.blitTexture(consumer, graphics, (float)x, (float)y, uOffset, vOffset, uWidth, vHeight);
    }

    private static void blitTexture(Matrix4f matrix, int width, int height, float[] rgba) {
        BufferBuilder builder = RenderUtil.getTesselatorBuilder();
        int color = new Color(rgba[0], rgba[1], rgba[2], rgba[3]).get();
        builder.m_252986_(matrix, 0.0f, (float)height, 0.0f).m_7421_(0.0f, 1.0f).m_193479_(color).m_5752_();
        builder.m_252986_(matrix, (float)width, (float)height, 0.0f).m_7421_(1.0f, 1.0f).m_193479_(color).m_5752_();
        builder.m_252986_(matrix, (float)width, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_193479_(color).m_5752_();
    }

    private static void blitTexture(TextureLocation location, Matrix4f matrix) {
        RenderUtil.blitTexture(matrix, location.getWidth(), location.getHeight(), RenderSystem.getShaderColor());
    }

    public static void blitTexture(TextureLocation location, GuiGraphics graphics, int x, int y) {
        RenderUtil.blitTexture(location, graphics, 1.0f, x, y);
    }

    public static void blitTexture(TextureLocation location, GuiGraphics graphics, float scale, int x, int y) {
        int width = location.getWidth();
        int height = location.getHeight();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_((double)x, (double)y, 0.0);
        graphics.m_280168_().m_85841_(scale, scale, scale);
        if (isBatching) {
            TextureBuffer.create(RenderUtil.getMatrix(graphics.m_280168_()), location, 0.0f, 0.0f, 0, 0, width, height);
            graphics.m_280168_().m_85849_();
            return;
        }
        BufferBuilder builder = RenderUtil.getAndBeginTexture(location);
        RenderUtil.blitTexture(location, graphics.m_280168_().m_85850_().m_252922_());
        RenderUtil.endTexture(builder);
        graphics.m_280168_().m_85849_();
    }

    public static void blitTexture(VertexConsumer consumer, GuiGraphics graphics, int x, int y, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        float[] rgba = RenderSystem.getShaderColor();
        float x2 = x + uWidth;
        float y2 = y + vHeight;
        float minU = uOffset / (float)textureWidth;
        float maxU = (uOffset + (float)uWidth) / (float)textureWidth;
        float minV = vOffset / (float)textureHeight;
        float maxV = (vOffset + (float)vHeight) / (float)textureHeight;
        int color = new Color(rgba[0], rgba[1], rgba[2], rgba[3]).get();
        consumer.m_252986_(matrix, (float)x, y2, 0.0f).m_7421_(minU, maxV).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix, x2, y2, 0.0f).m_7421_(maxU, maxV).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix, x2, (float)y, 0.0f).m_7421_(maxU, minV).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_(minU, minV).m_193479_(color).m_5752_();
    }

    private static void blit256(VertexConsumer consumer, Matrix4f matrix, float x, float y, int uOffset, int vOffset, int uWidth, int vHeight, float[] rgba) {
        float x2 = x + (float)uWidth;
        float y2 = y + (float)vHeight;
        float minU = (float)uOffset / 256.0f;
        float maxU = (float)(uOffset + uWidth) / 256.0f;
        float minV = (float)vOffset / 256.0f;
        float maxV = (float)(vOffset + vHeight) / 256.0f;
        int color = new Color(rgba[0], rgba[1], rgba[2], rgba[3]).get();
        consumer.m_252986_(matrix, x, y2, 0.0f).m_7421_(minU, maxV).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix, x2, y2, 0.0f).m_7421_(maxU, maxV).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix, x2, y, 0.0f).m_7421_(maxU, minV).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix, x, y, 0.0f).m_7421_(minU, minV).m_193479_(color).m_5752_();
    }

    public static void blit256(VertexConsumer consumer, GuiGraphics graphics, float x, float y, int uOffset, int vOffset, int uWidth, int vHeight) {
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        RenderUtil.blit256(consumer, matrix, x, y, uOffset, vOffset, uWidth, vHeight, RenderSystem.getShaderColor());
    }

    public static void blit256(VertexConsumer consumer, GuiGraphics graphics, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        RenderUtil.blit256(consumer, graphics, (float)x, (float)y, uOffset, vOffset, uWidth, vHeight);
    }

    private static void blit256(Matrix4f matrix, float x, float y, int uOffset, int vOffset, int uWidth, int vHeight, float[] rgba) {
        RenderUtil.blit256((VertexConsumer)RenderUtil.getTesselatorBuilder(), matrix, x, y, uOffset, vOffset, uWidth, vHeight, rgba);
    }

    public static void blit256(ResourceLocation location, GuiGraphics graphics, float x, float y, int uOffset, int vOffset, int uWidth, int vHeight) {
        Matrix4f matrix = RenderUtil.getMatrix(graphics.m_280168_());
        if (isBatching) {
            TextureBuffer.create(matrix, location, x, y, uOffset, vOffset, uWidth, vHeight);
            return;
        }
        BufferBuilder builder = RenderUtil.getAndBeginTexture(location);
        RenderUtil.blit256(matrix, x, y, uOffset, vOffset, uWidth, vHeight, RenderSystem.getShaderColor());
        RenderUtil.endTexture(builder);
    }

    public static void blit256(ResourceLocation location, GuiGraphics graphics, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        RenderUtil.blit256(location, graphics, (float)x, (float)y, uOffset, vOffset, uWidth, vHeight);
    }

    public static void blitSprite(GuiSprite sprite, GuiGraphics graphics, float scale, int x, int y, int width, int height) {
        GuiSpriteScaling spriteScaling = sprite.getScaling();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        graphics.m_280168_().m_85841_(scale, scale, scale);
        if (spriteScaling instanceof GuiSpriteScaling.Stretch) {
            RenderUtil.blitSprite(sprite, graphics.m_280168_(), 0, 0, width, height);
        } else if (spriteScaling instanceof GuiSpriteScaling.Tile) {
            GuiSpriteScaling.Tile tile = (GuiSpriteScaling.Tile)spriteScaling;
            RenderUtil.blitTiledSprite(sprite, graphics.m_280168_(), 0, 0, width, height, 0, 0, tile.width(), tile.height(), tile.width(), tile.height());
        } else if (spriteScaling instanceof GuiSpriteScaling.NineSlice) {
            GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)spriteScaling;
            RenderUtil.blitNineSlicedSprite(sprite, nineSlice, graphics.m_280168_(), 0, 0, width, height);
        }
        graphics.m_280168_().m_85849_();
    }

    public static void blitSprite(GuiSprite sprite, GuiGraphics graphics, int x, int y, int width, int height) {
        RenderUtil.blitSprite(sprite, graphics, 1.0f, x, y, width, height);
    }

    public static void blitSprite(GuiSprite sprite, GuiGraphics graphics, int x, int y) {
        RenderUtil.blitSprite(sprite, graphics, 1.0f, x, y, sprite.getWidth(), sprite.getHeight());
    }

    private static void blitSprite(GuiSprite sprite, PoseStack poseStack, int x, int y, int width, int height) {
        if (width != 0 && height != 0) {
            RenderUtil.innerBlit(sprite.atlasLocation(), poseStack, x, x + width, y, y + height, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1());
        }
    }

    private static void blitSprite(GuiSprite sprite, PoseStack poseStack, int sliceWidth, int sliceHeight, int tileWidth, int tileHeight, int x, int y, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        float minU = sprite.getU((float)tileWidth / (float)sliceWidth);
        float maxU = sprite.getU((float)(tileWidth + width) / (float)sliceWidth);
        float minV = sprite.getV((float)tileHeight / (float)sliceHeight);
        float maxV = sprite.getV((float)(tileHeight + height) / (float)sliceHeight);
        RenderUtil.innerBlit(sprite.atlasLocation(), poseStack, x, x + width, y, y + height, minU, maxU, minV, maxV);
    }

    private static void innerBlit(ResourceLocation atlasLocation, PoseStack poseStack, float x1, float x2, float y1, float y2, float minU, float maxU, float minV, float maxV) {
        if (isBatching) {
            SpriteBuffer.create(RenderUtil.getMatrix(poseStack), atlasLocation, x1, x2, y1, y2, minU, maxU, minV, maxV);
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.enableBlend();
        float[] rgba = RenderSystem.getShaderColor();
        int color = new Color(rgba[0], rgba[1], rgba[2], rgba[3]).get();
        BufferBuilder builder = RenderUtil.getTesselatorBuilder();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        builder.m_252986_(matrix, x1, y1, 0.0f).m_193479_(color).m_7421_(minU, minV).m_5752_();
        builder.m_252986_(matrix, x1, y2, 0.0f).m_193479_(color).m_7421_(minU, maxV).m_5752_();
        builder.m_252986_(matrix, x2, y2, 0.0f).m_193479_(color).m_7421_(maxU, maxV).m_5752_();
        builder.m_252986_(matrix, x2, y1, 0.0f).m_193479_(color).m_7421_(maxU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.disableBlend();
    }

    private static void innerBlit(BufferBuilder builder, SpriteBuffer buffer) {
        int color = new Color(buffer.rgba[0], buffer.rgba[1], buffer.rgba[2], buffer.rgba[3]).get();
        builder.m_252986_(buffer.matrix, buffer.x1, buffer.y1, 0.0f).m_7421_(buffer.minU, buffer.minV).m_193479_(color).m_5752_();
        builder.m_252986_(buffer.matrix, buffer.x1, buffer.y2, 0.0f).m_7421_(buffer.minU, buffer.maxV).m_193479_(color).m_5752_();
        builder.m_252986_(buffer.matrix, buffer.x2, buffer.y2, 0.0f).m_7421_(buffer.maxU, buffer.maxV).m_193479_(color).m_5752_();
        builder.m_252986_(buffer.matrix, buffer.x2, buffer.y1, 0.0f).m_7421_(buffer.maxU, buffer.minV).m_193479_(color).m_5752_();
    }

    private static void blitTiledSprite(GuiSprite sprite, PoseStack poseStack, int x, int y, int width, int height, int tileWidth, int tileHeight, int spriteWidth, int spriteHeight, int sliceWidth, int sliceHeight) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (spriteWidth > 0 && spriteHeight > 0) {
            for (int i = 0; i < width; i += spriteWidth) {
                int minWidth = Math.min(spriteWidth, width - i);
                for (int j = 0; j < height; j += spriteHeight) {
                    int minHeight = Math.min(spriteHeight, height - j);
                    RenderUtil.blitSprite(sprite, poseStack, sliceWidth, sliceHeight, tileWidth, tileHeight, x + i, y + j, minWidth, minHeight);
                }
            }
        } else {
            throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + spriteWidth + "x" + spriteHeight);
        }
    }

    private static void blitNineSlicedSprite(GuiSprite sprite, GuiSpriteScaling.NineSlice nineSlice, PoseStack poseStack, int x, int y, int width, int height) {
        GuiSpriteScaling.NineSlice.Border border = nineSlice.border();
        int left = Math.min(border.left(), width / 2);
        int right = Math.min(border.right(), width / 2);
        int top = Math.min(border.top(), height / 2);
        int bottom = Math.min(border.bottom(), height / 2);
        if (width == nineSlice.width() && height == nineSlice.height()) {
            RenderUtil.blitSprite(sprite, poseStack, nineSlice.width(), nineSlice.height(), 0, 0, x, y, width, height);
        } else if (height == nineSlice.height()) {
            RenderUtil.blitSprite(sprite, poseStack, nineSlice.width(), nineSlice.height(), 0, 0, x, y, left, height);
            RenderUtil.blitTiledSprite(sprite, poseStack, x + left, y, width - right - left, height, left, 0, nineSlice.width() - right - left, nineSlice.height(), nineSlice.width(), nineSlice.height());
            RenderUtil.blitSprite(sprite, poseStack, nineSlice.width(), nineSlice.height(), nineSlice.width() - right, 0, x + width - right, y, right, height);
        } else if (width == nineSlice.width()) {
            RenderUtil.blitSprite(sprite, poseStack, nineSlice.width(), nineSlice.height(), 0, 0, x, y, width, top);
            RenderUtil.blitTiledSprite(sprite, poseStack, x, y + top, width, height - bottom - top, 0, top, nineSlice.width(), nineSlice.height() - bottom - top, nineSlice.width(), nineSlice.height());
            RenderUtil.blitSprite(sprite, poseStack, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - bottom, x, y + height - bottom, width, bottom);
        } else {
            RenderUtil.blitSprite(sprite, poseStack, nineSlice.width(), nineSlice.height(), 0, 0, x, y, left, top);
            RenderUtil.blitTiledSprite(sprite, poseStack, x + left, y, width - right - left, top, left, 0, nineSlice.width() - right - left, top, nineSlice.width(), nineSlice.height());
            RenderUtil.blitSprite(sprite, poseStack, nineSlice.width(), nineSlice.height(), nineSlice.width() - right, 0, x + width - right, y, right, top);
            RenderUtil.blitSprite(sprite, poseStack, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - bottom, x, y + height - bottom, left, bottom);
            RenderUtil.blitTiledSprite(sprite, poseStack, x + left, y + height - bottom, width - right - left, bottom, left, nineSlice.height() - bottom, nineSlice.width() - right - left, bottom, nineSlice.width(), nineSlice.height());
            RenderUtil.blitSprite(sprite, poseStack, nineSlice.width(), nineSlice.height(), nineSlice.width() - right, nineSlice.height() - bottom, x + width - right, y + height - bottom, right, bottom);
            RenderUtil.blitTiledSprite(sprite, poseStack, x, y + top, left, height - bottom - top, 0, top, left, nineSlice.height() - bottom - top, nineSlice.width(), nineSlice.height());
            RenderUtil.blitTiledSprite(sprite, poseStack, x + left, y + top, width - right - left, height - bottom - top, left, top, nineSlice.width() - right - left, nineSlice.height() - bottom - top, nineSlice.width(), nineSlice.height());
            RenderUtil.blitTiledSprite(sprite, poseStack, x + width - right, y + top, left, height - bottom - top, nineSlice.width() - right, top, right, nineSlice.height() - bottom - top, nineSlice.width(), nineSlice.height());
        }
    }

    private static Matrix4f getModelViewMatrix(PoseStack poseStack, int x, int y) {
        Screen screen;
        double zOffset = 0.0;
        if ((double)MatrixUtil.getZ(poseStack) < 10.0) {
            zOffset = 10.0 - zOffset;
        }
        if ((screen = Minecraft.m_91087_().f_91080_) instanceof GuiOffset) {
            GuiOffset offset = (GuiOffset)screen;
            zOffset += (double)offset.getZOffset();
        }
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_85837_(8.0, 8.0, zOffset);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        Matrix4f matrix = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        poseStack.m_85849_();
        return matrix;
    }

    public static int getItemModelBrightness(float brightness) {
        int light = Mth.m_14045_((int)Math.round(15.0f * brightness), (int)0, (int)15);
        return light << 4 | light << 20;
    }

    public static void renderItem(GuiGraphics graphics, ItemStack itemStack, int x, int y) {
        RenderUtil.renderItem(graphics, itemStack, x, y, RenderUtil.getItemModelBrightness(1.0f));
    }

    public static void renderItem(GuiGraphics graphics, ItemStack itemStack, int x, int y, float brightness) {
        RenderUtil.renderItem(graphics, itemStack, x, y, RenderUtil.getItemModelBrightness(brightness));
    }

    public static void renderItem(GuiGraphics graphics, ItemStack itemStack, int x, int y, int packedLight) {
        boolean isLightingFlat;
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        BakedModel model = renderer.m_174264_(itemStack, null, null, 0);
        boolean bl = isLightingFlat = !model.m_7547_();
        if (!isBatching) {
            if (isLightingFlat) {
                Lighting.m_84930_();
            }
            PoseStack viewStack = new PoseStack();
            viewStack.m_85850_().m_252922_().set((Matrix4fc)RenderUtil.getModelViewMatrix(graphics.m_280168_(), x, y));
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            renderer.m_115143_(itemStack, ItemDisplayContext.GUI, false, viewStack, (MultiBufferSource)buffer, packedLight, OverlayTexture.f_118083_, model);
            buffer.m_109911_();
            if (isLightingFlat) {
                Lighting.m_84931_();
            }
        } else {
            ItemBuffer.create(graphics, itemStack, model, x, y, packedLight);
        }
    }

    static {
        MOD_TESSELATOR = new Tesselator(1536);
        DEFERRED_QUEUE = new ArrayDeque();
        SCISSOR_QUEUE = new ArrayDeque();
        LINE_QUEUE = new ArrayDeque();
        TEXTURE_LAYERS = new HashSet();
        ITEM_MODEL_QUEUE = new ArrayDeque();
        BLOCK_MODEL_QUEUE = new ArrayDeque();
        FILL_VERTICES = new ArrayDeque();
        FONT_BATCH = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(1536));
        FONT_IMMEDIATE = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(1536));
    }

    private record Scissor(ScissorType scissorType, int startX, int startY, int endX, int endY) {
        public void enable() {
            SCISSOR_QUEUE.stream().filter(ScissorType::isZone).findFirst().ifPresentOrElse(zone -> {
                int x0 = Mth.m_14045_((int)this.startX, (int)zone.startX, (int)zone.endX);
                int y0 = Mth.m_14045_((int)this.startY, (int)zone.startY, (int)zone.endY);
                int x1 = Mth.m_14045_((int)this.endX, (int)zone.startX, (int)zone.endX);
                int y1 = Mth.m_14045_((int)this.endY, (int)zone.startY, (int)zone.endY);
                GuiUtil.enableScissor(x0, y0, x1, y1);
            }, () -> GuiUtil.enableScissor(this.startX, this.startY, this.endX, this.endY));
        }
    }

    private static enum ScissorType {
        NORMAL,
        ZONE;


        public static boolean isZone(Scissor scissor) {
            return scissor.scissorType.equals((Object)ZONE);
        }
    }

    record LineBuffer(Matrix4f matrix, float x1, float y1, float x2, float y2, float width, int colorFrom, int colorTo) {
        LineBuffer {
            LINE_QUEUE.add(new LineBuffer(matrix, x1, y1, x2, y2, width, colorFrom, colorTo));
        }
    }

    record TextureBuffer(Matrix4f matrix, float x, float y, int uOffset, int vOffset, int uWidth, int vHeight, float[] rgba) {
        static void create(Matrix4f matrix, ResourceLocation location, float x, float y, int uOffset, int vOffset, int uWidth, int vHeight) {
            float[] color = RenderSystem.getShaderColor();
            float[] rgba = new float[]{color[0], color[1], color[2], color[3]};
            layer.add(location, new TextureBuffer(matrix, x, y, uOffset, vOffset, uWidth, vHeight, rgba));
            TEXTURE_LAYERS.add(layer);
        }

        int hashColor() {
            return Arrays.hashCode(this.rgba);
        }
    }

    record SpriteBuffer(Matrix4f matrix, float x1, float x2, float y1, float y2, float minU, float maxU, float minV, float maxV, float[] rgba) {
        static void create(Matrix4f matrix, ResourceLocation atlasLocation, float x1, float x2, float y1, float y2, float minU, float maxU, float minV, float maxV) {
            float[] color = RenderSystem.getShaderColor();
            float[] rgba = new float[]{color[0], color[1], color[2], color[3]};
            layer.add(atlasLocation, new SpriteBuffer(matrix, x1, x2, y1, y2, minU, maxU, minV, maxV, rgba));
            TEXTURE_LAYERS.add(layer);
        }

        int hashColor() {
            return Arrays.hashCode(this.rgba);
        }
    }

    private static class ItemBuffer {
        private final int packedLight;
        private final BakedModel model;
        private final ItemStack itemStack;
        private final Matrix4f matrix;

        static void create(GuiGraphics graphics, ItemStack itemStack, BakedModel model, int x, int y, int packedLight) {
            if (itemStack.m_41619_()) {
                return;
            }
            ItemBuffer itemBuffer = new ItemBuffer(graphics.m_280168_(), itemStack, model, x, y, packedLight);
            if (model.m_7547_()) {
                BLOCK_MODEL_QUEUE.add(itemBuffer);
            } else {
                ITEM_MODEL_QUEUE.add(itemBuffer);
            }
        }

        private ItemBuffer(PoseStack poseStack, ItemStack itemStack, BakedModel model, int x, int y, int packedLight) {
            this.packedLight = packedLight;
            this.itemStack = itemStack;
            this.model = model;
            this.matrix = RenderUtil.getModelViewMatrix(poseStack, x, y);
        }
    }
}

