/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.renderer;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import mod.adrenix.nostalgic.util.client.renderer.RenderUtil;
import mod.adrenix.nostalgic.util.common.math.MathUtil;
import net.minecraft.resources.ResourceLocation;

public class TextureLayer {
    public static final TextureLayer DEFAULT = new TextureLayer(Integer.MAX_VALUE);
    final int index;
    final LinkedHashMap<ResourceLocation, ArrayDeque<RenderUtil.TextureBuffer>> textureMap;
    final LinkedHashMap<ResourceLocation, ArrayDeque<RenderUtil.TextureBuffer>> textureLightMap;
    final LinkedHashMap<ResourceLocation, ArrayDeque<RenderUtil.SpriteBuffer>> spriteMap;
    final LinkedHashMap<ResourceLocation, ArrayDeque<RenderUtil.SpriteBuffer>> spriteLightMap;

    public static TextureLayer withIndex(int index) {
        return new TextureLayer(index);
    }

    private TextureLayer(int index) {
        this.index = index;
        this.textureMap = new LinkedHashMap();
        this.textureLightMap = new LinkedHashMap();
        this.spriteMap = new LinkedHashMap();
        this.spriteLightMap = new LinkedHashMap();
    }

    void add(ResourceLocation texture, RenderUtil.TextureBuffer buffer) {
        LinkedHashMap<ResourceLocation, ArrayDeque<RenderUtil.TextureBuffer>> map = MathUtil.getLargest(buffer.rgba()[0], buffer.rgba()[1], buffer.rgba()[2]) > 1.0f ? this.textureLightMap : this.textureMap;
        if (map.containsKey(texture)) {
            map.get(texture).add(buffer);
        } else {
            ArrayDeque<RenderUtil.TextureBuffer> queue = new ArrayDeque<RenderUtil.TextureBuffer>();
            queue.add(buffer);
            map.put(texture, queue);
        }
    }

    void add(ResourceLocation atlasLocation, RenderUtil.SpriteBuffer buffer) {
        LinkedHashMap<ResourceLocation, ArrayDeque<RenderUtil.SpriteBuffer>> map = MathUtil.getLargest(buffer.rgba()[0], buffer.rgba()[1], buffer.rgba()[2]) > 1.0f ? this.spriteLightMap : this.spriteMap;
        if (map.containsKey(atlasLocation)) {
            map.get(atlasLocation).add(buffer);
        } else {
            ArrayDeque<RenderUtil.SpriteBuffer> queue = new ArrayDeque<RenderUtil.SpriteBuffer>();
            queue.add(buffer);
            map.put(atlasLocation, queue);
        }
    }

    void clear() {
        this.textureMap.clear();
        this.textureLightMap.clear();
        this.spriteMap.clear();
        this.spriteLightMap.clear();
    }

    int getIndex() {
        return this.index;
    }
}

