/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.search;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mod.adrenix.nostalgic.util.client.search.LevenshteinResult;

interface LevenshteinDatabase<T> {
    default public List<Map.Entry<T, Double>> findEntries(String query, double threshold) {
        double cacheThreshold = this.getThreshold();
        this.setThreshold(threshold);
        List<Map.Entry<T, Double>> entries = this.levenshtein().apply(query.toLowerCase().trim());
        this.setThreshold(cacheThreshold);
        return entries;
    }

    default public List<T> findValues(String query, double threshold) {
        return this.findEntries(query, threshold).stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }

    default public List<T> findValues(String query) {
        return this.findValues(query, 0.01);
    }

    public LevenshteinResult<T> levenshtein();

    public Map<String, T> getDatabase();

    public void setThreshold(double var1);

    public double getThreshold();

    default public void reset() {
        this.getDatabase().clear();
    }
}

