/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.search;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import mod.adrenix.nostalgic.util.client.search.algorithm.NormalizedLevenshtein;
import mod.adrenix.nostalgic.util.common.ThreadMaker;
import net.minecraft.Util;

public class LevenshteinResult<T> {
    private final Map<String, T> map;
    private final double threshold;

    private LevenshteinResult(Map<String, T> map, double threshold) {
        this.map = map;
        this.threshold = threshold;
    }

    public static <V> LevenshteinResult<V> with(Map<String, V> map, double threshold) {
        return new LevenshteinResult<V>(map, threshold);
    }

    public List<Map.Entry<T, Double>> apply(String query) {
        int sizeOfMap = this.map.values().size();
        boolean isEmpty = query.isEmpty() || query.isBlank();
        ArrayList results = new ArrayList(sizeOfMap);
        HashMap pointers = new HashMap(sizeOfMap);
        Consumer<Map.Entry> processor = entry -> {
            double levenshtein = NormalizedLevenshtein.get((String)pointers.get(entry), query);
            if (levenshtein >= this.threshold) {
                entry.setValue(levenshtein);
            } else {
                entry.setValue(-1.0);
            }
        };
        this.map.forEach((key, value) -> {
            AbstractMap.SimpleEntry<Object, Double> entry = new AbstractMap.SimpleEntry<Object, Double>(value, 1.0);
            results.add(entry);
            pointers.put(entry, key);
        });
        if (isEmpty) {
            return results;
        }
        if (sizeOfMap > 1000) {
            HashSet<CompletableFuture<Void>> processes = new HashSet<CompletableFuture<Void>>();
            int numberOfProcessors = ThreadMaker.getNumberOfProcessors();
            int chunkSize = sizeOfMap / numberOfProcessors;
            int leftOver = sizeOfMap % numberOfProcessors;
            for (int i = 0; i < numberOfProcessors; ++i) {
                int startIndex = i * chunkSize;
                int endIndex = startIndex + chunkSize + (i == numberOfProcessors - 1 ? leftOver : 0);
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> results.subList(startIndex, endIndex).forEach(processor), Util.m_183991_());
                processes.add(future);
            }
            processes.forEach(CompletableFuture::join);
        } else {
            results.forEach((Consumer<Map.Entry<T, Double>>)processor);
        }
        results.removeIf(entry -> (Double)entry.getValue() < 0.0);
        results.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
        return results;
    }
}

