/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.client.search;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import mod.adrenix.nostalgic.util.client.search.Database;
import mod.adrenix.nostalgic.util.client.search.SearchTag;

public class TweakDatabase
extends Database<Tweak<?>> {
    private static final TweakDatabase TWEAK_SEARCH = new TweakDatabase();
    private String lastQuery = "";

    private TweakDatabase() {
        this.init();
    }

    private void init() {
        if (!this.map.isEmpty()) {
            this.map.clear();
        }
        TweakPool.filter(Tweak::isNotIgnored).forEach(tweak -> this.map.put(tweak.getTranslation().getString().toLowerCase(), tweak));
    }

    public static TweakDatabase getInstance() {
        return TWEAK_SEARCH;
    }

    @Override
    public Map<String, Tweak<?>> getDatabase() {
        Optional<SearchTag> tag = SearchTag.get(this.lastQuery);
        if (tag.isPresent()) {
            return tag.get().getMap();
        }
        return this.map;
    }

    @Override
    public List<Map.Entry<Tweak<?>, Double>> findEntries(String query, double threshold) {
        this.lastQuery = query;
        double cacheThreshold = this.threshold;
        this.setThreshold(threshold);
        String trimmed = query.toLowerCase().replaceFirst("#\\w+", "").trim();
        List<Map.Entry<Tweak<?>, Double>> results = this.levenshtein().apply(trimmed);
        if (trimmed.isEmpty() || trimmed.isBlank()) {
            results.sort(Map.Entry.comparingByKey(Tweak::compareTranslationName));
        }
        this.setThreshold(cacheThreshold);
        return results;
    }

    @Override
    public void reset() {
        this.init();
        SearchTag.stream().forEach(SearchTag::init);
    }
}

