/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.util.common.ClassUtil;
import mod.adrenix.nostalgic.util.common.function.BooleanSupplier;

public abstract class CollectionUtil {
    public static <T> Optional<T> last(Collection<T> collection) {
        if (collection.isEmpty()) {
            return Optional.empty();
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return Optional.of(list.get(list.size() - 1));
        }
        return collection.stream().skip(collection.size() - 1).findFirst();
    }

    public static <T> Optional<T> last(Stream<T> stream) {
        return CollectionUtil.last(stream.toList());
    }

    public static <T> Optional<T> first(Collection<T> collection) {
        if (collection.isEmpty()) {
            return Optional.empty();
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return Optional.of(list.get(0));
        }
        return collection.stream().findFirst();
    }

    public static <T> Optional<T> first(Stream<T> stream) {
        return stream.findFirst();
    }

    public static <T, U extends T> Stream<U> fromCast(Stream<T> stream, Class<U> classType) {
        return stream.filter(v -> ClassUtil.isInstanceOf(v, classType));
    }

    public static <T, U extends T> Stream<U> fromCast(Collection<T> collection, Class<U> classType) {
        return CollectionUtil.fromCast(collection.stream(), classType);
    }

    public static <T, U> Stream<U> fromClass(Stream<T> stream, Class<U> classType) {
        return stream.filter(v -> ClassUtil.isInstanceOf(v, classType));
    }

    public static <T, U> Stream<U> fromClass(Collection<T> collection, Class<U> classType) {
        return CollectionUtil.fromClass(collection.stream(), classType);
    }

    public static <T, R> Predicate<T> distinct(Function<? super T, R> extractor) {
        HashMap seen = new HashMap();
        return t -> seen.putIfAbsent(extractor.apply(t), true) == null;
    }

    public static <T, R> Stream<T> distinct(Stream<T> stream, Function<? super T, R> extractor) {
        return stream.filter(CollectionUtil.distinct(extractor));
    }

    public static <T, R> Stream<T> distinct(Collection<T> collection, Function<? super T, R> extractor) {
        return CollectionUtil.distinct(collection.stream(), extractor);
    }

    public static <T> List<List<T>> partition(Collection<T> collection, int size) {
        return Lists.partition(collection.stream().toList(), (int)size);
    }

    public static <T> List<List<T>> partition(Stream<T> stream, int size) {
        return Lists.partition(stream.toList(), (int)size);
    }

    public static <T> void partition(Collection<T> collection, int size, Consumer<List<T>> consumer) {
        CollectionUtil.partition(collection, size).forEach(consumer);
    }

    public static <T> void partition(Collection<T> collection, int size, BiConsumer<T, Integer> consumer) {
        Lists.partition(collection.stream().toList(), (int)size).forEach(partition -> {
            for (int i = 0; i < partition.size(); ++i) {
                consumer.accept(partition.get(i), i);
            }
        });
    }

    public static <T> void partition(Stream<T> stream, int size, Consumer<List<T>> consumer) {
        CollectionUtil.partition(stream.toList(), size, consumer);
    }

    public static <T> void partition(Stream<T> stream, int size, BiConsumer<T, Integer> consumer) {
        CollectionUtil.partition(stream.toList(), size, consumer);
    }

    public static <T> void forLoop(Collection<T> collection, BiConsumer<T, Integer> consumer) {
        List<T> list = collection.stream().toList();
        for (int i = 0; i < list.size(); ++i) {
            consumer.accept(list.get(i), i);
        }
    }

    public static <T> void forLoop(Stream<T> stream, BiConsumer<T, Integer> consumer) {
        CollectionUtil.forLoop(stream.toList(), consumer);
    }

    public static Runnable runAll(Runnable ... runnables) {
        return () -> {
            for (Runnable runnable : runnables) {
                runnable.run();
            }
        };
    }

    public static <T> Stream<T> filterAll(Stream<T> stream, Collection<Predicate<T>> collection) {
        for (Predicate<T> predicate : collection) {
            stream = stream.filter(predicate);
        }
        return stream;
    }

    @SafeVarargs
    public static <T> Stream<T> filterAll(Stream<T> stream, Predicate<T> ... predicates) {
        return CollectionUtil.filterAll(stream, Arrays.asList(predicates));
    }

    @SafeVarargs
    public static <T> Stream<T> filterAll(Collection<T> collection, Predicate<T> ... predicates) {
        return CollectionUtil.filterOut(collection.stream(), predicates);
    }

    public static <T> Stream<T> filterOut(Stream<T> stream, Collection<Predicate<T>> collection) {
        for (Predicate predicate : collection) {
            stream = stream.filter(t -> !predicate.test(t));
        }
        return stream;
    }

    @SafeVarargs
    public static <T> Stream<T> filterOut(Stream<T> stream, Predicate<T> ... predicates) {
        return CollectionUtil.filterOut(stream, Arrays.asList(predicates));
    }

    @SafeVarargs
    public static <T> Stream<T> filterOut(Collection<T> collection, Predicate<T> ... predicates) {
        return CollectionUtil.filterOut(collection.stream(), predicates);
    }

    public static <T> boolean test(Collection<T> collection, Predicate<T> predicate) {
        HashSet suppliers = new HashSet();
        boolean isListened = false;
        collection.forEach(t -> suppliers.add(() -> predicate.test(t)));
        for (Supplier supplier : suppliers) {
            boolean result = (Boolean)supplier.get();
            if (isListened) continue;
            isListened = result;
        }
        return isListened;
    }

    public static <T> boolean test(Stream<T> stream, Predicate<T> function) {
        return CollectionUtil.test(stream.toList(), function);
    }

    public static BooleanSupplier areAnyTrue(BooleanSupplier ... suppliers) {
        return () -> Arrays.stream(suppliers).anyMatch(BooleanSupplier::getAsBoolean);
    }

    public static BooleanSupplier areAllTrue(BooleanSupplier ... suppliers) {
        return () -> Arrays.stream(suppliers).allMatch(BooleanSupplier::getAsBoolean);
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> link(T ... elements) {
        return new LinkedHashSet<T>(Arrays.asList(elements));
    }

    public static boolean isEmpty(Stream<?> stream) {
        return stream.findAny().isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !map.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !collection.isEmpty();
    }

    public static boolean isUnmodifiable(Collection<?> collection) {
        try {
            collection.addAll(Collections.emptyList());
            return false;
        }
        catch (UnsupportedOperationException exception) {
            return true;
        }
    }

    public static boolean isModifiable(Collection<?> collection) {
        return !CollectionUtil.isUnmodifiable(collection);
    }

    public static boolean isUnmodifiable(Map<?, ?> map) {
        try {
            map.putAll(Map.of());
            return false;
        }
        catch (UnsupportedOperationException exception) {
            return true;
        }
    }

    public static boolean isModifiable(Map<?, ?> map) {
        return !CollectionUtil.isUnmodifiable(map);
    }
}

