/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.array;

import java.util.ArrayList;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public abstract class ArrayUtil {
    public static void copy(float[] from, float[] to) {
        if (from.length != to.length) {
            throw new AssertionError((Object)"Both arrays must be the same size to copy");
        }
        System.arraycopy(from, 0, to, 0, from.length);
    }

    @Nullable
    public static <T> T get(T[] array, int index) {
        int bound = array.length - 1;
        if (index <= bound && index >= 0) {
            return array[index];
        }
        return null;
    }

    public static <T> Optional<T> get(ArrayList<T> list, int index) {
        if (index < 0 || index >= list.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable(list.get(index));
    }

    public static <T> Optional<T> first(ArrayList<T> list) {
        return ArrayUtil.get(list, 0);
    }

    public static <T> Optional<T> last(ArrayList<T> list) {
        return ArrayUtil.get(list, list.size() - 1);
    }

    public static <T> void popPush(ArrayList<T> list, T push, int maxSize) {
        list.add(0, push);
        if (list.size() > maxSize) {
            while (list.size() > maxSize) {
                list.remove(list.size() - 1);
            }
        }
    }
}

