/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.array;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class UniqueArrayList<E>
extends ArrayList<E> {
    public UniqueArrayList() {
    }

    public UniqueArrayList(Collection<? extends E> collection) {
        super(collection);
    }

    public UniqueArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public E set(int index, E element) {
        this.remove(element);
        return super.set(Mth.m_14045_((int)index, (int)0, (int)(this.size() - 1)), element);
    }

    @Override
    public boolean add(E element) {
        this.remove(element);
        return super.add(element);
    }

    @Override
    public void add(int index, E element) {
        this.remove(element);
        super.add(Mth.m_14045_((int)index, (int)0, (int)this.size()), element);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.removeAll(collection);
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        this.removeAll(collection);
        return super.addAll(Mth.m_14045_((int)index, (int)0, (int)this.size()), collection);
    }

    public void moveToFront(E element) {
        this.remove(element);
        this.add(0, element);
    }

    public void moveToEnd(E element) {
        this.remove(element);
        this.add(element);
    }

    public void moveAfter(E move, E after) {
        int index = this.indexOf(after);
        if (index == -1) {
            return;
        }
        if (super.remove(move)) {
            super.add(index, move);
        } else {
            super.add(index + 1, move);
        }
    }

    @Override
    @Nullable
    public E getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.get(0);
    }

    @Override
    @Nullable
    public E getLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    public void ifPresent(int index, Consumer<? super E> consumer) {
        if (index < 0 || index >= this.size()) {
            return;
        }
        Object applyTo = this.get(index);
        if (applyTo != null) {
            consumer.accept(applyTo);
        }
    }

    @Nullable
    public <R> R map(int index, Function<? super E, ? extends R> map) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        Object element = this.get(index);
        if (element != null) {
            return map.apply(element);
        }
        return null;
    }
}

