/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.asset;

import java.util.Optional;
import mod.adrenix.nostalgic.util.common.asset.ModSprite;
import mod.adrenix.nostalgic.util.common.asset.TextureLocation;
import mod.adrenix.nostalgic.util.common.sprite.GuiSprite;
import mod.adrenix.nostalgic.util.common.sprite.SpriteAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class TextureIcon {
    public static final TextureIcon EMPTY = new TextureIcon(0, 0);
    private final int width;
    private final int height;
    private float maxBrightness;
    @Nullable
    private TextureLocation textureLocation;
    @Nullable
    private GuiSprite sprite;
    @Nullable
    private Block block;
    @Nullable
    private Item item;

    private TextureIcon(int width, int height) {
        this.width = width;
        this.height = height;
        this.maxBrightness = 1.02f;
    }

    private TextureIcon(@Nullable Item item) {
        this(16, 16);
        this.item = item;
    }

    private TextureIcon(@Nullable ResourceLocation spriteLocation, int width, int height) {
        this(width, height);
        this.sprite = GuiSprite.stretch(new SpriteAtlas(spriteLocation, width, height));
    }

    private TextureIcon(TextureLocation location) {
        this(location.getWidth(), location.getHeight());
        this.textureLocation = location;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getMaxBrightenAmount() {
        return this.maxBrightness;
    }

    public Optional<TextureLocation> getTextureLocation() {
        return Optional.ofNullable(this.textureLocation);
    }

    public Optional<GuiSprite> getSprite() {
        return Optional.ofNullable(this.sprite);
    }

    public Optional<Block> getBlock() {
        return Optional.ofNullable(this.block);
    }

    public Optional<Item> getItem() {
        return Optional.ofNullable(this.item);
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public TextureIcon maxBrightness(float amount) {
        this.maxBrightness = amount;
        return this;
    }

    public static TextureIcon fromItem(Item item) {
        TextureIcon icon = new TextureIcon(item);
        icon.item = item;
        return icon;
    }

    public static TextureIcon fromBlock(Block block) {
        TextureIcon icon = new TextureIcon(block.m_5456_());
        icon.block = block;
        return icon;
    }

    public static TextureIcon fromTexture(TextureLocation location) {
        return new TextureIcon(location);
    }

    public static TextureIcon fromSprite(ResourceLocation spriteLocation, int width, int height) {
        return new TextureIcon(spriteLocation, width, height);
    }

    public static TextureIcon fromSprite(String path, int width, int height) {
        return TextureIcon.fromSprite(ModSprite.icon(path), width, height);
    }

    public static TextureIcon fromSprite(ResourceLocation spriteLocation, int width, int height, float maxBrightness) {
        return TextureIcon.fromSprite(spriteLocation, width, height).maxBrightness(maxBrightness);
    }

    public static TextureIcon fromSprite(String path, int width, int height, float maxBrightness) {
        return TextureIcon.fromSprite(ModSprite.icon(path), width, height, maxBrightness);
    }

    public static TextureIcon fromSprite(ResourceLocation spriteLocation, int squareSize) {
        return new TextureIcon(spriteLocation, squareSize, squareSize);
    }

    public static TextureIcon fromSprite(String path, int squareSize) {
        return TextureIcon.fromSprite(ModSprite.icon(path), squareSize);
    }

    public static TextureIcon fromSprite(ResourceLocation spriteLocation, int squareSize, float maxBrightness) {
        return TextureIcon.fromSprite(spriteLocation, squareSize).maxBrightness(maxBrightness);
    }

    public static TextureIcon fromSprite(String path, int squareSize, float maxBrightness) {
        return TextureIcon.fromSprite(ModSprite.icon(path), squareSize, maxBrightness);
    }
}

