/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.asset;

import mod.adrenix.nostalgic.util.common.asset.GameAsset;
import mod.adrenix.nostalgic.util.common.asset.ModAsset;
import net.minecraft.resources.ResourceLocation;

public class TextureLocation
extends ResourceLocation {
    public static final ResourceLocation DEV_MODE = ModAsset.texture("gui/nt_dev.png");
    public static final ResourceLocation BLOCK_SHADOW = ModAsset.texture("block_shadow.png");
    public static final ResourceLocation INVENTORY = ModAsset.texture("gui/inventory.png");
    public static final ResourceLocation MOJANG_ALPHA = ModAsset.texture("gui/mojang_alpha.png");
    public static final ResourceLocation MOJANG_BETA = ModAsset.texture("gui/mojang_beta.png");
    public static final ResourceLocation MOJANG_RELEASE_ORANGE = ModAsset.texture("gui/mojang_release_orange.png");
    public static final ResourceLocation MOJANG_RELEASE_BLACK = ModAsset.texture("gui/mojang_release_black.png");
    public static final ResourceLocation PANORAMA_OVERLAY = ModAsset.texture("panorama/overlay.png");
    public static final ResourceLocation MINECRAFT_LOGO = GameAsset.texture("gui/title/minecraft.png");
    public static final TextureLocation NT_LOGO_64 = new TextureLocation(ModAsset.icon("nt_logo_64.png"), 64);
    public static final TextureLocation NT_SUPPORTER_64 = new TextureLocation(ModAsset.icon("nt_supporter_64.png"), 64);
    public static final TextureLocation SOUND_256 = new TextureLocation(ModAsset.twemoji("sound_256.png"), 256);
    public static final TextureLocation CANDY_256 = new TextureLocation(ModAsset.twemoji("candy_256.png"), 256);
    public static final TextureLocation JUGGLER_256 = new TextureLocation(ModAsset.twemoji("juggler_256.png"), 256);
    public static final TextureLocation CONTROLLER_256 = new TextureLocation(ModAsset.twemoji("controller_256.png"), 256);
    public static final TextureLocation NOSTALGIC_TWEAKS = new TextureLocation("nostalgic_tweaks.png", 1920, 182);
    public static final String MISSING_BETA = String.format("assets/%s/textures/missing/beta.png", "nostalgic_tweaks");
    public static final String MISSING_1_5 = String.format("assets/%s/textures/missing/1_5.png", "nostalgic_tweaks");
    public static final String MISSING_1_6_1_12 = String.format("assets/%s/textures/missing/1_6-1_12.png", "nostalgic_tweaks");
    private final int width;
    private final int height;

    public TextureLocation(ResourceLocation resourceLocation, int width, int height) {
        super(resourceLocation.m_135827_(), resourceLocation.m_135815_());
        this.width = width;
        this.height = height;
    }

    public TextureLocation(String path, int width, int height) {
        super("nostalgic_tweaks:textures/" + path);
        this.width = width;
        this.height = height;
    }

    public TextureLocation(ResourceLocation resourceLocation, int size) {
        this(resourceLocation, size, size);
    }

    public TextureLocation(String path, int size) {
        this(path, size, size);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getAverageSize() {
        return (float)(this.width + this.height) / 2.0f;
    }
}

