/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.color;

import java.util.Random;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mod.adrenix.nostalgic.util.common.color.HexUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class Color {
    public static final Color TRANSPARENT = new Color(0xFFFFFF, 0.0).lock();
    public static final Color WHITE = new Color(0xFFFFFF).lock();
    public static final Color BLACK = new Color(0).lock();
    public static final Color RED = new Color(0xFF0000).lock();
    public static final Color ALERT_RED = new Color(0xBC0000).lock();
    public static final Color FRENCH_PUCE = new Color(5508622).lock();
    public static final Color GOLDEN_GATE_BRIDGE = new Color(12662840).lock();
    public static final Color COPPER_RED = new Color(12676163).lock();
    public static final Color ATOMIC_TANGERINE = new Color(16553056).lock();
    public static final Color ORANGE = new Color(0xFF8000).lock();
    public static final Color MUSTARD = new Color(14851840).lock();
    public static final Color RIPE_MANGO = new Color(16758310).lock();
    public static final Color SUMMER_YELLOW = new Color(16770172).lock();
    public static final Color LEMON_YELLOW = new Color(0xFFFFA0).lock();
    public static final Color LATTE_GOLD = new Color(15124364).lock();
    public static final Color YELLOW = new Color(0xFFFF00).lock();
    public static final Color SCHOOL_BUS = new Color(16766976).lock();
    public static final Color BRASS = new Color(12688963).lock();
    public static final Color DEER_BROWN = new Color(12158300).lock();
    public static final Color DARK_BROWN = new Color(6311713).lock();
    public static final Color LIVER_BROWN = new Color(6305313).lock();
    public static final Color LIME = new Color(0xBFFF00).lock();
    public static final Color VIVID_LIME = new Color(10867483).lock();
    public static final Color GREEN = new Color(65280).lock();
    public static final Color GREEN_APPLE = new Color(5030211).lock();
    public static final Color MANTIS_GREEN = new Color(5610548).lock();
    public static final Color MUGHAL_GREEN = new Color(2449441).lock();
    public static final Color BLUE = new Color(255).lock();
    public static final Color SPACE_CADET = new Color(928341).lock();
    public static final Color METALLIC_BLUE = new Color(2837372).lock();
    public static final Color DARK_BLUE = new Color(0x303060).lock();
    public static final Color MOJANG_PURPLE = new Color(0x373363).lock();
    public static final Color IRIS_BLUE = new Color(5595339).lock();
    public static final Color FRENCH_SKY_BLUE = new Color(8891903).lock();
    public static final Color MAYA_BLUE = new Color(7522812).lock();
    public static final Color CYAN = new Color(65535).lock();
    public static final Color LIGHT_BLUE = new Color(49151).lock();
    public static final Color CORNFLOWER_BLUE = new Color(2065063).lock();
    public static final Color SHADOW_BLUE = new Color(7309983).lock();
    public static final Color PINK = new Color(0xFF00FF).lock();
    public static final Color PURPLE = new Color(0xBF00FF).lock();
    public static final Color PURPLE_PLUM = new Color(10830785).lock();
    public static final Color AMERICAN_PURPLE = new Color(5382496).lock();
    public static final Color RICH_BLACK = new Color(328960).lock();
    public static final Color INK_BLACK = new Color(0x121212).lock();
    public static final Color OLIVE_BLACK = new Color(0x202020).lock();
    public static final Color DARK_CHARCOAL = new Color(0x313131).lock();
    public static final Color DARK_GRAY = new Color(0x3F3F3F).lock();
    public static final Color ASPHALT_GRAY = new Color(5658452).lock();
    public static final Color SONIC_SILVER = new Color(0x777777).lock();
    public static final Color GRAY = new Color(0x808080).lock();
    public static final Color TAUPE_GRAY = new Color(0x888888).lock();
    public static final Color PHILIPPINE_GRAY = new Color(0x8B8B8B).lock();
    public static final Color QUICK_SILVER = new Color(0xA0A0A0).lock();
    public static final Color SILVER_CHALICE = new Color(0xACACAC).lock();
    public static final Color LIGHT_GRAY = new Color(0xC0C0C0).lock();
    public static final Color NOSTALGIC_GRAY = new Color(0xE0E0E0).lock();
    public static final Color AZURE_WHITE = new Color(13951474).lock();
    public static final Color CADET_GRAY = new Color(9478067).lock();
    private int color;
    private boolean locked = false;
    @Nullable
    IntSupplier supplier = null;

    public static Color fromFormatting(ChatFormatting formatting) {
        return formatting.m_126665_() == null ? WHITE : new Color(formatting.m_126665_());
    }

    public static Color getRandomColor() {
        Random random = new Random();
        float r = random.nextFloat();
        float g = random.nextFloat();
        float b = random.nextFloat();
        return new Color(r, g, b);
    }

    public static Color getHSBColor(float h, float s, float b) {
        return new Color(Color.HSBtoRGB(h, s, b));
    }

    public static Color getHSBColor(float h, float s, float b, float a) {
        return new Color(Color.HSBtoRGB(h, s, b), (double)a);
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        hue = Mth.m_14036_((float)hue, (float)0.0f, (float)1.0f);
        saturation = Mth.m_14036_((float)saturation, (float)0.0f, (float)1.0f);
        brightness = Mth.m_14036_((float)brightness, (float)0.0f, (float)1.0f);
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            int dark;
            r = dark = (int)(brightness * 255.0f + 0.5f);
            g = dark;
            b = dark;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static float[] RGBtoHSB(int r, int g, int b, float[] hsbValues) {
        float hue;
        int cMin;
        int cMax;
        r = Mth.m_14045_((int)r, (int)0, (int)255);
        g = Mth.m_14045_((int)g, (int)0, (int)255);
        b = Mth.m_14045_((int)b, (int)0, (int)255);
        if (hsbValues == null) {
            hsbValues = new float[3];
        }
        if (b > (cMax = Math.max(r, g))) {
            cMax = b;
        }
        if (b < (cMin = Math.min(r, g))) {
            cMin = b;
        }
        float brightness = (float)cMax / 255.0f;
        float saturation = cMax != 0 ? (float)(cMax - cMin) / (float)cMax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float cRed = (float)(cMax - r) / (float)(cMax - cMin);
            float cGreen = (float)(cMax - g) / (float)(cMax - cMin);
            float cBlue = (float)(cMax - b) / (float)(cMax - cMin);
            hue = r == cMax ? cBlue - cGreen : (g == cMax ? 2.0f + cRed - cBlue : 4.0f + cGreen - cRed);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbValues[0] = hue;
        hsbValues[1] = saturation;
        hsbValues[2] = brightness;
        return hsbValues;
    }

    public static float[] RGBtoHSB(int r, int g, int b) {
        return Color.RGBtoHSB(r, g, b, null);
    }

    public static Color empty() {
        return new Color(0xFFFFFF, 0.0);
    }

    public Color(IntSupplier argb) {
        this.supplier = argb;
        this.color = argb.getAsInt();
    }

    public Color(Supplier<Color> colorSupplier) {
        this.supplier = () -> ((Color)colorSupplier.get()).color;
        this.color = colorSupplier.get().color;
    }

    public Color(int r, int g, int b, int a) {
        r = Mth.m_14045_((int)r, (int)0, (int)255);
        g = Mth.m_14045_((int)g, (int)0, (int)255);
        b = Mth.m_14045_((int)b, (int)0, (int)255);
        a = Mth.m_14045_((int)a, (int)0, (int)255);
        this.color = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int r, int g, int b, double alpha) {
        this(r, g, b, (int)(Mth.m_14008_((double)alpha, (double)0.0, (double)1.0) * 255.0));
    }

    public Color(int rgb) {
        this.color = 0xFF000000 | rgb;
    }

    public Color(int rgb, int a) {
        this.color = a << 24 | rgb & 0xFFFFFF;
    }

    public Color(int rgb, double alpha) {
        this(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, (int)(Mth.m_14008_((double)alpha, (double)0.0, (double)1.0) * 255.0));
    }

    public Color(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Color(float r, float g, float b, float a) {
        this((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public Color(Color color, double alpha) {
        this(color.getRed(), color.getGreen(), color.getBlue(), (int)(Mth.m_14008_((double)alpha, (double)0.0, (double)1.0) * 255.0));
    }

    public Color(Color color) {
        this.color = color.get();
        this.supplier = color.supplier;
        this.locked = false;
    }

    public Color(float[] rgba) {
        this(rgba[0], rgba[1], rgba[2], rgba.length == 4 ? rgba[3] : 1.0f);
    }

    public Color(int[] rgba) {
        this(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public Color(int[] rgb, int alpha) {
        this(rgb[0], rgb[1], rgb[2], alpha);
    }

    public Color(int[] rgb, double alpha) {
        this(rgb[0], rgb[1], rgb[2], (int)(Mth.m_14008_((double)alpha, (double)0.0, (double)1.0) * 255.0));
    }

    public Color(String hexInput) {
        this(HexUtil.parseRGBA(hexInput));
    }

    public Color lock() {
        this.locked = true;
        return this;
    }

    public void set(int rgb) {
        if (this.locked) {
            return;
        }
        this.color = 0xFF000000 | rgb;
    }

    public void set(Color color) {
        if (this.locked) {
            return;
        }
        this.color = color.get();
    }

    public void set(float h, float s, float b) {
        if (this.locked) {
            return;
        }
        this.color = Color.HSBtoRGB(h, s, b);
    }

    public void setAlpha(double alpha) {
        if (this.locked) {
            return;
        }
        this.color = new Color(this.get(), alpha).get();
    }

    public Color fromAlpha(double alpha) {
        return new Color(this, alpha);
    }

    public Color fromAlpha(int alpha) {
        return this.fromAlpha((double)Mth.m_14045_((int)alpha, (int)0, (int)255) / 255.0);
    }

    public boolean isTransparent() {
        return this.getAlpha() < 255;
    }

    public boolean isOpaque() {
        return this.getAlpha() == 255;
    }

    public int get() {
        if (this.supplier != null) {
            return this.supplier.getAsInt();
        }
        return this.color;
    }

    public int getRed() {
        return this.get() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.get() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.get() & 0xFF;
    }

    public int getAlpha() {
        return this.get() >> 24 & 0xFF;
    }

    public int getRGB() {
        return this.getRed() << 16 | this.getGreen() << 8 | this.getBlue();
    }

    public int getOpaque() {
        return 0xFF000000 | this.getRed() << 16 | this.getGreen() << 8 | this.getBlue();
    }

    public float getFloatRed() {
        return (float)this.getRed() / 255.0f;
    }

    public float getFloatGreen() {
        return (float)this.getGreen() / 255.0f;
    }

    public float getFloatBlue() {
        return (float)this.getBlue() / 255.0f;
    }

    public float getFloatAlpha() {
        return (float)this.getAlpha() / 255.0f;
    }

    public float getHue() {
        return this.getHSBComponents()[0];
    }

    public float getSaturation() {
        return this.getHSBComponents()[1];
    }

    public float getBrightness() {
        return this.getHSBComponents()[2];
    }

    public int getHueAsRGB() {
        return Color.HSBtoRGB(this.getHue(), 1.0f, 1.0f);
    }

    public float[] getHSBComponents() {
        return Color.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public float[] getComponents() {
        float r = this.getFloatRed();
        float g = this.getFloatGreen();
        float b = this.getFloatBlue();
        float a = this.getFloatAlpha();
        return new float[]{r, g, b, a};
    }

    public int[] getIntComponents() {
        return new int[]{this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha()};
    }

    public int[] getIntComponents(int[] array) {
        if (array.length != 3 && array.length != 4) {
            return this.getIntComponents();
        }
        array[0] = this.getRed();
        array[1] = this.getGreen();
        array[2] = this.getBlue();
        if (array.length == 4) {
            array[3] = this.getAlpha();
        }
        return array;
    }

    public Color brighter() {
        return this.brighten(0.3);
    }

    public Color brighten(double amount) {
        amount = Mth.m_14008_((double)(1.0 - amount), (double)0.0, (double)1.0);
        int r = this.getRed();
        int g = this.getGreen();
        int b = this.getBlue();
        int a = this.getAlpha();
        int i = (int)(1.0 / (1.0 - amount));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i, a);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        r = Math.min((int)((double)r / amount), 255);
        g = Math.min((int)((double)g / amount), 255);
        b = Math.min((int)((double)b / amount), 255);
        return new Color(r, g, b, a);
    }

    public Color brighterOrDarker() {
        Color brighter = this.brighter();
        if (brighter.equals(WHITE)) {
            return this.darker();
        }
        return brighter;
    }

    public Color darker() {
        return this.darken(0.3);
    }

    public Color darken(double amount) {
        amount = Mth.m_14008_((double)(1.0 - amount), (double)0.0, (double)1.0);
        int r = Math.max((int)((double)this.getRed() * amount), 0);
        int g = Math.max((int)((double)this.getGreen() * amount), 0);
        int b = Math.max((int)((double)this.getBlue() * amount), 0);
        return new Color(r, g, b, this.getAlpha());
    }

    public Color darkerOrBrighter() {
        Color darker = this.darker();
        if (darker.equals(BLACK)) {
            return this.brighter();
        }
        return darker;
    }

    public MutableComponent apply(String text) {
        return Component.m_237113_((String)text).m_130938_(style -> style.m_178520_(this.get()));
    }

    public MutableComponent apply(Component component) {
        return component.m_6881_().m_130938_(style -> style.m_178520_(this.get()));
    }

    public boolean isEmpty() {
        return this.equals(TRANSPARENT);
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public boolean matches(Style style) {
        if (style.m_131135_() == null) {
            return false;
        }
        return style.m_131135_().m_131265_() == this.getRGB();
    }

    public int hashCode() {
        return this.color;
    }

    public boolean equals(Object object) {
        return object instanceof Color && ((Color)object).get() == this.get();
    }

    public String toString() {
        int alpha = this.getAlpha();
        int red = this.getRed();
        int green = this.getGreen();
        int blue = this.getBlue();
        String name = this.getClass().getName();
        String hex = String.format("#%08X", this.get());
        return name + "[a=" + alpha + ",r=" + red + ",g=" + green + ",b=" + blue + ",#AARRGGBB=" + hex + "]";
    }
}

