/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.color;

import mod.adrenix.nostalgic.util.common.color.Color;

public enum ColorElement {
    HUE(0.0, 1.0),
    SATURATION(0.0, 1.0),
    BRIGHTNESS(0.0, 1.0),
    RED(0.0, 255.0),
    GREEN(0.0, 255.0),
    BLUE(0.0, 255.0),
    ALPHA(0.0, 1.0);

    private final double min;
    private final double max;

    private ColorElement(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean isHSB() {
        return switch (this) {
            case HUE, SATURATION, BRIGHTNESS -> true;
            default -> false;
        };
    }

    public boolean isRGB() {
        return switch (this) {
            case RED, GREEN, BLUE -> true;
            default -> false;
        };
    }

    public double getValue(Color color) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case HUE -> color.getHue();
            case SATURATION -> color.getSaturation();
            case BRIGHTNESS -> color.getBrightness();
            case RED -> color.getRed();
            case GREEN -> color.getGreen();
            case BLUE -> color.getBlue();
            case ALPHA -> color.getFloatAlpha();
        };
    }

    public double getInterval() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case RED, GREEN, BLUE -> 1.0;
            case HUE, SATURATION, BRIGHTNESS, ALPHA -> 0.01;
        };
    }

    public void apply(Number number, Color color) {
        float[] hsb = color.getHSBComponents();
        int[] rgb = color.getIntComponents();
        float floatAlpha = color.getFloatAlpha();
        int intAlpha = color.getAlpha();
        float floatValue = number.floatValue();
        int intValue = number.intValue();
        switch (this) {
            case HUE: {
                color.set(Color.getHSBColor(floatValue, hsb[1], hsb[2], floatAlpha));
                break;
            }
            case SATURATION: {
                color.set(Color.getHSBColor(hsb[0], floatValue, hsb[2], floatAlpha));
                break;
            }
            case BRIGHTNESS: {
                color.set(Color.getHSBColor(hsb[0], hsb[1], floatValue, floatAlpha));
                break;
            }
            case RED: {
                color.set(new Color(intValue, rgb[1], rgb[2], intAlpha));
                break;
            }
            case GREEN: {
                color.set(new Color(rgb[0], intValue, rgb[2], intAlpha));
                break;
            }
            case BLUE: {
                color.set(new Color(rgb[0], rgb[1], intValue, intAlpha));
                break;
            }
            case ALPHA: {
                color.setAlpha(floatValue);
            }
        }
    }
}

