/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import mod.adrenix.nostalgic.util.common.data.Holder;

public class FlagHolder
extends Holder<Boolean> {
    private final LinkedHashSet<FlagHolder> radios = new LinkedHashSet();

    public static FlagHolder on() {
        return new FlagHolder(true);
    }

    public static FlagHolder off() {
        return new FlagHolder(false);
    }

    public static void radio(Collection<FlagHolder> flags) {
        for (FlagHolder holder : flags) {
            holder.radios.addAll(flags);
        }
    }

    public static void radio(FlagHolder ... flags) {
        FlagHolder.radio(Arrays.asList(flags));
    }

    public FlagHolder(boolean flag) {
        super(flag);
    }

    public void toggle() {
        if (this.radios.isEmpty()) {
            this.set((Boolean)this.get() == false);
        } else {
            boolean state = (Boolean)this.get();
            this.radios.forEach(FlagHolder::disable);
            this.set(!state);
        }
    }

    public void enable() {
        this.set(true);
    }

    public void disable() {
        this.set(false);
    }

    public boolean ifDisabledThenEnable() {
        if (!((Boolean)this.value).booleanValue()) {
            this.enable();
            return true;
        }
        return false;
    }

    public boolean ifEnabledThenDisable() {
        if (((Boolean)this.value).booleanValue()) {
            this.disable();
            return true;
        }
        return false;
    }
}

