/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.data;

import mod.adrenix.nostalgic.util.common.data.Holder;
import net.minecraft.util.Mth;

public class NumberHolder<T extends Number>
extends Holder<T> {
    public static <T extends Number> NumberHolder<T> create(T startWith) {
        return new NumberHolder<T>(startWith);
    }

    private NumberHolder(T number) {
        super(number);
    }

    private void setSafely(Number value) {
        if (this.value instanceof Byte) {
            this.set(value.byteValue());
        } else if (this.value instanceof Short) {
            this.set(value.shortValue());
        } else if (this.value instanceof Integer) {
            this.set(value.intValue());
        } else if (this.value instanceof Long) {
            this.set(value.longValue());
        } else if (this.value instanceof Float) {
            this.set((Number)Float.valueOf(value.floatValue()));
        } else if (this.value instanceof Double) {
            this.set(value.doubleValue());
        }
    }

    public void setAndClamp(T number, T min, T max) {
        this.setSafely(Mth.m_14008_((double)((Number)number).doubleValue(), (double)((Number)min).doubleValue(), (double)((Number)max).doubleValue()));
    }

    public boolean compareAndSet(T expect, T update) {
        if (((Number)this.value).equals(expect)) {
            this.set(update);
            return true;
        }
        return false;
    }

    public T getAndSet(T number) {
        Number currentValue = (Number)this.value;
        this.set(number);
        return (T)currentValue;
    }

    public T setAndGet(T number) {
        this.set(number);
        return (T)((Number)this.value);
    }

    public T getAndAdd(T number) {
        Number currentValue = (Number)this.value;
        this.setSafely(((Number)this.value).doubleValue() + ((Number)number).doubleValue());
        return (T)currentValue;
    }

    public T addAndGet(T number) {
        this.setSafely(((Number)this.value).doubleValue() + ((Number)number).doubleValue());
        return (T)((Number)this.value);
    }

    public T getAndSubtract(T number) {
        Number currentValue = (Number)this.value;
        this.setSafely(((Number)this.value).doubleValue() - ((Number)number).doubleValue());
        return (T)currentValue;
    }

    public T subtractAndGet(T number) {
        this.setSafely(((Number)this.value).doubleValue() - ((Number)number).doubleValue());
        return (T)((Number)this.value);
    }

    public T getAndMultiply(T number) {
        Number currentValue = (Number)this.value;
        this.setSafely(((Number)this.value).doubleValue() * ((Number)number).doubleValue());
        return (T)currentValue;
    }

    public T multiplyAndGet(T number) {
        this.setSafely(((Number)this.value).doubleValue() * ((Number)number).doubleValue());
        return (T)((Number)this.value);
    }

    public T getAndDivide(T number) {
        Number currentValue = (Number)this.value;
        this.setSafely(((Number)this.value).doubleValue() / ((Number)number).doubleValue());
        return (T)currentValue;
    }

    public T divideAndGet(T number) {
        this.setSafely(((Number)this.value).doubleValue() / ((Number)number).doubleValue());
        return (T)((Number)this.value);
    }
}

