/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.data;

import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class RecursionAvoidance {
    private boolean processing = false;

    public static RecursionAvoidance create() {
        return new RecursionAvoidance();
    }

    private RecursionAvoidance() {
    }

    public void process(Runnable runnable) {
        if (this.processing) {
            return;
        }
        this.processing = true;
        runnable.run();
        this.processing = false;
    }

    @Nullable
    public <T> T process(Supplier<T> supplier) {
        if (this.processing) {
            return null;
        }
        this.processing = true;
        T result = supplier.get();
        this.processing = false;
        return result;
    }

    public <T> T process(Supplier<T> supplier, T whenProcessing) {
        if (this.processing) {
            return whenProcessing;
        }
        this.processing = true;
        T result = supplier.get();
        this.processing = false;
        return result;
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public boolean isParked() {
        return !this.isProcessing();
    }
}

