/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.function;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface ForEachWithPrevious {
    public static <T> Builder<T> create(Stream<T> stream) {
        return new Builder<T>(stream.toList());
    }

    public static <T> Builder<T> create(Collection<T> collection) {
        return new Builder<T>(collection);
    }

    public static <T> Builder<T> create(T[] array) {
        return new Builder<T>(Arrays.asList(array));
    }

    public static class Builder<T> {
        private final Collection<T> elements;
        private BiConsumer<T, T> forEach = (a, b) -> {};
        private Consumer<T> first = null;
        private Consumer<T> last = null;
        private Consumer<T> equal = null;
        private Predicate<T> returnNextWhenNext = null;
        private Predicate<T> returnNextWhenPrev = null;
        private Predicate<T> returnPrevWhenNext = null;
        private Runnable whenFinished = null;

        private Builder(Collection<T> elements) {
            this.elements = elements;
        }

        public Builder<T> forEach(BiConsumer<T, T> biConsumer) {
            this.forEach = biConsumer;
            return this;
        }

        public Builder<T> applyToFirst(Consumer<T> consumer) {
            this.first = consumer;
            return this;
        }

        public Builder<T> applyToLast(Consumer<T> consumer) {
            this.last = consumer;
            return this;
        }

        public Builder<T> applyToEqual(Consumer<T> consumer) {
            this.equal = consumer;
            return this;
        }

        public Builder<T> returnNextWhenNext(Predicate<T> predicate) {
            this.returnNextWhenNext = predicate;
            return this;
        }

        public Builder<T> returnNextWhenPrev(Predicate<T> function) {
            this.returnNextWhenPrev = function;
            return this;
        }

        public Builder<T> returnPrevWhenNext(Predicate<T> predicate) {
            this.returnPrevWhenNext = predicate;
            return this;
        }

        public Builder<T> whenFinished(Runnable runnable) {
            this.whenFinished = runnable;
            return this;
        }

        public Optional<T> run() {
            boolean isFirst = true;
            Object last = null;
            for (Object next : this.elements) {
                if (isFirst) {
                    if (this.first != null) {
                        this.first.accept(next);
                    }
                    last = next;
                    isFirst = false;
                }
                if (this.returnNextWhenNext != null && this.returnNextWhenNext.test(next)) {
                    return Optional.of(next);
                }
                if (next.equals(last)) {
                    if (this.equal == null) continue;
                    this.equal.accept(next);
                    continue;
                }
                if (this.returnNextWhenPrev != null && this.returnNextWhenPrev.test(last)) {
                    return Optional.of(next);
                }
                if (this.returnPrevWhenNext != null && this.returnPrevWhenNext.test(next)) {
                    return Optional.of(last);
                }
                this.forEach.accept(last, next);
                last = next;
            }
            if (this.last != null) {
                this.last.accept(last);
            }
            if (this.whenFinished != null) {
                this.whenFinished.run();
            }
            boolean isReturnUndefined = this.returnNextWhenNext == null && this.returnNextWhenPrev == null && this.returnPrevWhenNext == null;
            return isReturnUndefined ? Optional.ofNullable(last) : Optional.empty();
        }
    }
}

