/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.io;

import com.google.common.collect.Lists;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.adrenix.nostalgic.NostalgicTweaks;
import mod.adrenix.nostalgic.util.common.io.BackupFile;
import net.minecraft.Util;
import org.jetbrains.annotations.Nullable;

public abstract class PathUtil {
    public static long getSizeOfDirectory(Path directory) {
        long size = 0L;
        try (Stream<Path> walk = Files.walk(directory, new FileVisitOption[0]);){
            size = walk.filter(path -> Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)).mapToLong(path -> {
                try {
                    return Files.size(path);
                }
                catch (Exception e) {
                    return 0L;
                }
            }).sum();
        }
        catch (IOException exception) {
            NostalgicTweaks.LOGGER.error("An IO error occurred when getting directory size\n%s", exception);
        }
        return size;
    }

    public static CompletableFuture<Long> getFutureSizeOfDirectory(Path directory) {
        return CompletableFuture.supplyAsync(() -> PathUtil.getSizeOfDirectory(directory), Util.m_183991_());
    }

    public static String getFormattedFileSize(long size) {
        String[] types = new String[]{"B", "KB", "MB", "GB", "TB"};
        int index = (int)(Math.log10(size) / 3.0);
        double typeValue = 1 << index * 10;
        return new DecimalFormat("#,##0.0").format((double)size / typeValue) + " " + types[index];
    }

    public static boolean isDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public static boolean isNotDirectory(Path path) {
        return !PathUtil.isDirectory(path);
    }

    public static boolean isBackupFile(Path path) {
        return !Files.isDirectory(path, new LinkOption[0]) && path.getFileName().toString().matches(BackupFile.FILE_REGEX);
    }

    public static boolean isJsonFile(Path file) {
        return PathUtil.getFileExtension(file).equals("json");
    }

    public static String getDirectorySlash() {
        return Util.m_137581_() == Util.OS.WINDOWS ? "\\" : "/";
    }

    public static List<String> getFilenames(Path dir, Predicate<? super Path> filter) throws IOException {
        try (Stream<Path> stream = Files.list(dir);){
            List list = stream.filter(filter).map(Path::getFileName).map(Path::toString).collect(Collectors.toCollection(ArrayList::new));
            return list;
        }
    }

    public static long getCreationTime(Path path) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
        }
        catch (IOException exception) {
            return 0L;
        }
    }

    public static long getLastModifiedTime(Path path) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
        }
        catch (IOException exception) {
            return 0L;
        }
    }

    public static String parseEpochTime(long timeInMillis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), TimeZone.getDefault().toZoneId()).format(DateTimeFormatter.ofPattern("EEEE, ee MMMM yyyy hh:mm a"));
    }

    public static String getFileExtension(Path path) {
        if (PathUtil.isDirectory(path)) {
            return "";
        }
        String filename = path.getFileName().toString();
        int dotIndex = filename.lastIndexOf(46);
        return dotIndex == -1 ? "" : filename.substring(dotIndex + 1);
    }

    public static List<Path> getOldestFiles(Path dir, @Nullable Predicate<? super Path> filter) throws IOException {
        try (Stream<Path> stream = Files.list(dir);){
            if (filter == null) {
                filter = file -> true;
            }
            List list = stream.filter(filter).filter(PathUtil::isNotDirectory).sorted(Comparator.comparingLong(PathUtil::getCreationTime)).collect(Collectors.toCollection(LinkedList::new));
            return list;
        }
    }

    public static List<Path> getOldestFiles(Path dir) throws IOException {
        return PathUtil.getOldestFiles(dir, null);
    }

    public static List<Path> getOldestModified(Path dir, @Nullable Predicate<? super Path> filter) throws IOException {
        try (Stream<Path> stream = Files.list(dir);){
            if (filter == null) {
                filter = file -> true;
            }
            List list = stream.filter(filter).filter(PathUtil::isNotDirectory).sorted(Comparator.comparingLong(PathUtil::getLastModifiedTime)).collect(Collectors.toCollection(LinkedList::new));
            return list;
        }
    }

    public static List<Path> getOldestModified(Path dir) throws IOException {
        return PathUtil.getOldestModified(dir, null);
    }

    public static List<Path> getNewestFiles(Path dir, Predicate<? super Path> filter) throws IOException {
        return Lists.reverse(PathUtil.getOldestFiles(dir, filter));
    }

    public static List<Path> getNewestFiles(Path dir) throws IOException {
        return Lists.reverse(PathUtil.getOldestFiles(dir));
    }

    public static List<Path> getNewestModified(Path dir, Predicate<? super Path> filter) throws IOException {
        return Lists.reverse(PathUtil.getOldestModified(dir, filter));
    }

    public static List<Path> getNewestModified(Path dir) throws IOException {
        return Lists.reverse(PathUtil.getOldestModified(dir));
    }

    public static void delete(Path path) {
        try {
            PathUtil.deleteWithoutCatch(path);
        }
        catch (NoSuchFileException exception) {
            NostalgicTweaks.LOGGER.error("File: %s - does not exist so it cannot be deleted", path);
        }
        catch (IOException exception) {
            NostalgicTweaks.LOGGER.error("Could not delete %s\n%s", path, exception);
        }
    }

    public static void deleteWithoutCatch(Path path) throws IOException {
        Files.delete(path);
        NostalgicTweaks.LOGGER.info("Deleted: %s", path.getFileName().toString());
    }

    public static Path getOrCreatePath(String path) {
        try {
            return Files.createDirectories(Platform.getConfigFolder().resolve(path), new FileAttribute[0]);
        }
        catch (IOException exception) {
            NostalgicTweaks.LOGGER.error("Could not resolve config path (%s)\n%s", path, exception);
            return null;
        }
    }

    public static Path getLogsPath() {
        try {
            return Files.createDirectories(Platform.getGameFolder().resolve("logs"), new FileAttribute[0]);
        }
        catch (IOException exception) {
            NostalgicTweaks.LOGGER.error("Could not resolve game logs path\n%s", exception);
            return Platform.getGameFolder();
        }
    }

    public static Path getConfigPath() {
        return PathUtil.getOrCreatePath("nostalgic_tweaks");
    }

    public static Path getBackupPath() {
        return PathUtil.getOrCreatePath("nostalgic_tweaks/backup");
    }

    public static Path getPacksPath() {
        return PathUtil.getOrCreatePath("nostalgic_tweaks/packs");
    }

    public static Path getPresetsPath() {
        return PathUtil.getOrCreatePath("nostalgic_tweaks/presets");
    }
}

