/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.lang;

import java.util.function.Supplier;
import mod.adrenix.nostalgic.util.common.lang.DecodeLang;
import mod.adrenix.nostalgic.util.common.lang.Translation;
import net.minecraft.network.chat.Component;

public interface Lang {
    public static final Translation TITLE = new Translation("gui.nostalgic_tweaks.title");
    public static final Translation EMPTY = new Translation("gui.nostalgic_tweaks.empty");

    public static Translation literal(String literal) {
        return new Translation(literal);
    }

    public static Translation component(Component component) {
        return new Translation(DecodeLang.findAndReplace(component).getString());
    }

    public static Supplier<Component> supply(Supplier<Boolean> supplier, Translation ifTrue, Translation ifFalse) {
        return () -> (Boolean)supplier.get() != false ? ifTrue.get(new Object[0]) : ifFalse.get(new Object[0]);
    }

    public static interface Enum {
        public static final String PARENT_KEY = "gui.nostalgic_tweaks.enum.";
        public static final Translation CLASSIC = Enum.from("generic.classic");
        public static final Translation ALPHA = Enum.from("generic.alpha");
        public static final Translation BETA = Enum.from("generic.beta");
        public static final Translation MODERN = Enum.from("generic.modern");
        public static final Translation ALPHA_BETA = Enum.from("generic.alpha_beta");
        public static final Translation PLAIN_CLASSIC = Enum.from("generic.plain_classic");
        public static final Translation INF_DEV = Enum.from("generic.inf_dev");
        public static final Translation DISABLED = Enum.from("generic.disabled");
        public static final Translation MUSIC_ALPHA = Enum.from("musicType.alpha");
        public static final Translation MUSIC_BETA = Enum.from("musicType.beta");
        public static final Translation MUSIC_BLENDED = Enum.from("musicType.blended");
        public static final Translation SCREEN_HOME = Enum.from("menuOption.home");
        public static final Translation SCREEN_PACKS = Enum.from("menuOption.packs");
        public static final Translation SCREEN_CONFIG = Enum.from("menuOption.config");
        public static final Translation SOLID_COLOR = Enum.from("colorType.solid");
        public static final Translation GRADIENT_COLOR = Enum.from("colorType.gradient");
        public static final Translation STAMINA_REGAIN_NORMAL = Enum.from("staminaRegain.normal");
        public static final Translation STAMINA_REGAIN_HALF = Enum.from("staminaRegain.half");
        public static final Translation STAMINA_REGAIN_NONE = Enum.from("staminaRegain.none");
        public static final Translation BACKGROUND_SOLID_BLACK = Enum.from("guiBackground.solid_black");
        public static final Translation BACKGROUND_SOLID_BLUE = Enum.from("guiBackground.solid_blue");
        public static final Translation BACKGROUND_GRADIENT_BLUE = Enum.from("guiBackground.gradient_blue");
        public static final Translation RECIPE_BOOK_DISABLED = Enum.from("recipeBook.disabled");
        public static final Translation RECIPE_BOOK_LARGE = Enum.from("recipeBook.large");
        public static final Translation RECIPE_BOOK_SMALL = Enum.from("recipeBook.small");
        public static final Translation DEBUG_CHART_DISABLED = Enum.from("debugChart.disabled");
        public static final Translation DEBUG_CHART_CLASSIC = Enum.from("debugChart.classic");
        public static final Translation DEBUG_CHART_MODERN = Enum.from("debugChart.modern");
        public static final Translation INVENTORY_SHIELD_INVISIBLE = Enum.from("inventoryShield.invisible");
        public static final Translation INVENTORY_SHIELD_MIDDLE_RIGHT = Enum.from("inventoryShield.middle_right");
        public static final Translation INVENTORY_SHIELD_BOTTOM_LEFT = Enum.from("inventoryShield.bottom_left");
        public static final Translation RENDER_ORDER_FIRST = Enum.from("renderOrder.first");
        public static final Translation RENDER_ORDER_LAST = Enum.from("renderOrder.last");
        public static final Translation ANIMATION_LINEAR = Enum.from("animationType.linear");
        public static final Translation ANIMATION_EASE_IN_SINE = Enum.from("animationType.ease_in_sine");
        public static final Translation ANIMATION_EASE_IN_EXPO = Enum.from("animationType.ease_in_expo");
        public static final Translation ANIMATION_EASE_IN_CUBIC = Enum.from("animationType.ease_in_cubic");
        public static final Translation ANIMATION_EASE_IN_CIRCULAR = Enum.from("animationType.ease_in_circular");
        public static final Translation ANIMATION_EASE_OUT_SINE = Enum.from("animationType.ease_out_sine");
        public static final Translation ANIMATION_EASE_OUT_EXPO = Enum.from("animationType.ease_out_expo");
        public static final Translation ANIMATION_EASE_OUT_CUBIC = Enum.from("animationType.ease_out_cubic");
        public static final Translation ANIMATION_EASE_OUT_CIRCULAR = Enum.from("animationType.ease_out_circular");
        public static final Translation ANIMATION_EASE_IN_OUT_SINE = Enum.from("animationType.ease_in_out_sine");
        public static final Translation ANIMATION_EASE_IN_OUT_EXPO = Enum.from("animationType.ease_in_out_expo");
        public static final Translation ANIMATION_EASE_IN_OUT_CUBIC = Enum.from("animationType.ease_in_out_cubic");
        public static final Translation ANIMATION_EASE_IN_OUT_CIRCULAR = Enum.from("animationType.ease_in_out_circular");
        public static final Translation CORNER_TOP_LEFT = Enum.from("corner.top_left");
        public static final Translation CORNER_TOP_RIGHT = Enum.from("corner.top_right");
        public static final Translation CORNER_BOTTOM_LEFT = Enum.from("corner.bottom_left");
        public static final Translation CORNER_BOTTOM_RIGHT = Enum.from("corner.bottom_right");
        public static final Translation FOG_ALPHA_R164 = Enum.from("worldFog.alpha_r164");
        public static final Translation FOG_R17_R118 = Enum.from("worldFog.r17_r118");

        private static Translation from(String name) {
            return new Translation(PARENT_KEY + name);
        }
    }

    public static interface Warning {
        public static final Translation POLYTONE = Warning.from("polytone");
        public static final Translation OPTIFINE = Warning.from("optifine");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.warning." + name);
        }
    }

    public static interface Issue {
        public static final Translation SODIUM = Issue.from("sodium");
        public static final Translation OPTIFINE = Issue.from("optifine");
        public static final Translation POLYTONE = Issue.from("polytone");
        public static final Translation IRIS = Issue.from("iris");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.issue." + name);
        }
    }

    public static interface Alert {
        public static final Translation NONE = Alert.from("none");
        public static final Translation VOID = Alert.from("void");
        public static final Translation SHIELD = Alert.from("shield");
        public static final Translation BRIGHTNESS = Alert.from("brightness");
        public static final Translation DYNAMIC_FOG = Alert.from("dynamic_fog");
        public static final Translation DYNAMIC_SKY = Alert.from("dynamic_sky");
        public static final Translation UNIVERSAL_FOG = Alert.from("universal_fog");
        public static final Translation UNIVERSAL_SKY = Alert.from("universal_sky");
        public static final Translation OVERWORLD_FOG_DENSITY = Alert.from("overworld_fog_density");
        public static final Translation OVERWORLD_FOG_COLOR = Alert.from("overworld_fog_color");
        public static final Translation NETHER_FOG_DENSITY = Alert.from("nether_fog_density");
        public static final Translation NETHER_FOG_COLOR = Alert.from("nether_fog_color");
        public static final Translation FOOD_STACKING = Alert.from("food_stacking");
        public static final Translation FOOD_HEALTH = Alert.from("food_health");
        public static final Translation ARM_SWAY = Alert.from("arm_sway");
        public static final Translation STAMINA_SPRINTING = Alert.from("stamina_sprinting");
        public static final Translation WINDOW_TITLE_DISABLED = Alert.from("window_title_disabled");
        public static final Translation ROW_HIGHLIGHT_DISABLED = Alert.from("row_highlight_disabled");
        public static final Translation CUSTOM_GUI_GRADIENT = Alert.from("custom_gui_gradient");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.alert." + name);
        }
    }

    public static interface Help {
        public static final Translation HEADER = Help.from("header");
        public static final Translation TWEAK_TAGS_TITLE = Help.from("tweak_tags.title");
        public static final Translation TWEAK_TAGS_MESSAGE = Help.from("tweak_tags.message");
        public static final Translation SEARCH_TAGS_TITLE = Help.from("search_tags.title");
        public static final Translation SEARCH_TAGS_MESSAGE = Help.from("search_tags.message");
        public static final Translation SHORTCUT_TITLE = Help.from("shortcut.title");
        public static final Translation SHORTCUT_MESSAGE = Help.from("shortcut.message");
        public static final Translation SHORTCUT_SEARCH = Help.from("shortcut.search");
        public static final Translation SHORTCUT_SAVE = Help.from("shortcut.save");
        public static final Translation SHORTCUT_EXIT = Help.from("shortcut.exit");
        public static final Translation SHORTCUT_JUMP = Help.from("shortcut.jump");
        public static final Translation SHORTCUT_ALL = Help.from("shortcut.all");
        public static final Translation SHORTCUT_CATEGORY = Help.from("shortcut.category");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.overlay.manage.help." + name);
        }
    }

    public static interface Manage {
        public static final Translation TITLE = Manage.from("title");
        public static final Translation HOT_SWAP = Manage.from("hot_swap");
        public static final Translation HOT_SWAP_INFO = Manage.from("hot_swap.info");
        public static final Translation TOGGLE_VIEW_SCREEN = Manage.from("menu_options.view_screen");
        public static final Translation TOGGLE_VIEW_INFO = Manage.from("menu_options.view_info");
        public static final Translation PERSISTENT_SCREEN = Manage.from("menu_options.persistent_screen");
        public static final Translation PERSISTENT_INFO = Manage.from("menu_options.persistent_info");
        public static final Translation PERSISTENCE = Manage.from("menu_options.persistence");
        public static final Translation RESET_CONFIG = Manage.from("menu_options.reset_config");
        public static final Translation RESET_CONFIG_INFO = Manage.from("menu_options.reset_config_info");
        public static final Translation RESET_CONFIG_BACKUP = Manage.from("menu_options.reset_config_backup");
        public static final Translation IMPORT_ADVISORY_TITLE = Manage.from("import_advisory.title");
        public static final Translation IMPORT_ADVISORY_MESSAGE = Manage.from("import_advisory.message");
        public static final Translation IMPORT_EXPORT_HEADER = Manage.from("import_export.header");
        public static final Translation CLIENT_IMPORT = Manage.from("import_export.client_import");
        public static final Translation CLIENT_EXPORT = Manage.from("import_export.client_export");
        public static final Translation SERVER_IMPORT = Manage.from("import_export.server_import");
        public static final Translation SERVER_EXPORT = Manage.from("import_export.server_export");
        public static final Translation CREATE_BACKUP_HELP = Manage.from("create_backup.help");
        public static final Translation CREATE_BACKUP_VIEW = Manage.from("create_backup.view");
        public static final Translation CREATE_BACKUP_CLIENT = Manage.from("create_backup.client");
        public static final Translation CREATE_BACKUP_SERVER = Manage.from("create_backup.server");
        public static final Translation VIEW_BACKUPS_WAITING = Manage.from("view_backups.waiting");
        public static final Translation VIEW_BACKUPS_DISCONNECTED = Manage.from("view_backups.disconnected");
        public static final Translation VIEW_BACKUPS_LAST_MODIFIED = Manage.from("view_backups.last_modified");
        public static final Translation VIEW_BACKUPS_FILENAME = Manage.from("view_backups.filename");
        public static final Translation VIEW_BACKUPS_EMPTY = Manage.from("view_backups.empty");
        public static final Translation CONFIG_PRESETS_EMPTY = Manage.from("config_presets.empty");
        public static final Translation CONFIG_PRESETS_FILENAME = Manage.from("config_presets.filename");
        public static final Translation CONFIG_PRESETS_LAST_MODIFIED = Manage.from("config_presets.last_modified");
        public static final Translation OPERATIONS_WIP = Manage.from("operations.wip");
        public static final Translation OPERATIONS_WIP_MESSAGE = Manage.from("operations.wip.message");
        public static final Translation OPERATIONS_LAN = Manage.from("operations.lan");
        public static final Translation OPERATIONS_LAN_MESSAGE = Manage.from("operations.lan.message");
        public static final Translation OPERATIONS_SSO = Manage.from("operations.sso");
        public static final Translation OPERATIONS_SSO_MESSAGE = Manage.from("operations.sso.message");
        public static final Translation OPERATIONS_LOGGING = Manage.from("operations.logging");
        public static final Translation OPERATIONS_LOGGING_MESSAGE = Manage.from("operations.logging.message");
        public static final Translation OPERATIONS_DEBUG = Manage.from("operations.debug");
        public static final Translation OPERATIONS_DEBUG_MESSAGE = Manage.from("operations.debug.message");
        public static final Translation TOGGLE_ALL_HEADER = Manage.from("toggle_all.header");
        public static final Translation TOGGLE_ALL_ENABLE = Manage.from("toggle_all.enable");
        public static final Translation TOGGLE_ALL_DISABLE = Manage.from("toggle_all.disable");
        public static final Translation TOGGLE_ALL_LOCAL = Manage.from("toggle_all.local");
        public static final Translation TOGGLE_ALL_NETWORK = Manage.from("toggle_all.network");
        public static final Translation TOGGLE_ALL_LOCAL_INFO = Manage.from("toggle_all.local.info");
        public static final Translation TOGGLE_ALL_NETWORK_INFO = Manage.from("toggle_all.network.info");
        public static final Translation TOGGLE_ALL_ENABLE_INFO = Manage.from("toggle_all.enable.info");
        public static final Translation TOGGLE_ALL_DISABLE_INFO = Manage.from("toggle_all.disable.info");
        public static final Translation TOGGLE_ALL_APPLY_INFO = Manage.from("toggle_all.apply.info");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.overlay.manage." + name);
        }
    }

    public static interface Status {
        public static final Translation TITLE = Status.from("title");
        public static final Translation LOADED = Status.from("loaded");
        public static final Translation WAIT = Status.from("wait");
        public static final Translation WARN = Status.from("warn");
        public static final Translation FAIL = Status.from("fail");
        public static final Translation CONFLICT = Status.from("conflict");
        public static final Translation CLIENT_ONLY = Status.from("client_only");
        public static final Translation NO_CONNECTION = Status.from("no_connection");
        public static final Translation DYNAMIC = Status.from("dynamic");
        public static final Translation DYNAMIC_OPERATOR = Status.from("dynamic_operator");
        public static final Translation DYNAMIC_VERIFIED = Status.from("dynamic_verified");
        public static final Translation DYNAMIC_UNVERIFIED = Status.from("dynamic_unverified");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.overlay.status." + name);
        }
    }

    public static interface Picker {
        public static final Translation TITLE = Picker.from("title");
        public static final Translation OPEN = Picker.from("open");
        public static final Translation SAMPLE = Picker.from("sample");
        public static final Translation OPACITY = Picker.from("opacity");
        public static final Translation PALETTE = Picker.from("palette");
        public static final Translation HINT = Picker.from("hint");
        public static final Translation RANDOM = Picker.from("random");
        public static final Translation RECENT = Picker.from("recent");
        public static final Translation RANDOMIZE = Picker.from("randomize");
        public static final Translation CLEAR = Picker.from("clear");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.overlay.picker." + name);
        }
    }

    public static interface Info {
        public static final Translation IMPORT_CLIENT_TITLE = Info.from("import_client.title");
        public static final Translation IMPORT_CLIENT_MESSAGE = Info.from("import_client.message");
        public static final Translation IMPORT_SERVER_TITLE = Info.from("import_server.title");
        public static final Translation IMPORT_SERVER_MESSAGE = Info.from("import_server.message");
        public static final Translation EXPORT_CLIENT_TITLE = Info.from("export_client.title");
        public static final Translation EXPORT_CLIENT_MESSAGE = Info.from("export_client.message");
        public static final Translation EXPORT_SERVER_TITLE = Info.from("export_server.title");
        public static final Translation EXPORT_SERVER_MESSAGE = Info.from("export_server.message");
        public static final Translation CREATE_BACKUP_TITLE = Info.from("create_backup.title");
        public static final Translation CREATE_BACKUP_MESSAGE = Info.from("create_backup.message");
        public static final Translation CREATE_PRESET_TITLE = Info.from("create_preset.title");
        public static final Translation CREATE_PRESET_MESSAGE = Info.from("create_preset.message");
        public static final Translation SENT_PRESET_TITLE = Info.from("sent_preset.title");
        public static final Translation SENT_PRESET_MESSAGE = Info.from("sent_preset.message");
        public static final Translation FILTER_BY_CATEGORY = Info.from("filter_by_category");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.overlay.info." + name);
        }
    }

    public static interface Error {
        public static final Translation IO_TITLE = Error.from("io_title");
        public static final Translation SERVER_TITLE = Error.from("server_title");
        public static final Translation JAVA_TITLE = Error.from("java.title");
        public static final Translation JAVA_MESSAGE = Error.from("java.message");
        public static final Translation APPLY_TITLE = Error.from("apply.title");
        public static final Translation APPLY_MESSAGE = Error.from("apply.message");
        public static final Translation IMPORT_TITLE = Error.from("import.title");
        public static final Translation IMPORT_MESSAGE = Error.from("import.message");
        public static final Translation CREATE_BACKUP_TITLE = Error.from("create_backup.title");
        public static final Translation CREATE_BACKUP_MESSAGE = Error.from("create_backup.message");
        public static final Translation VIEW_CLIENT_BACKUPS = Error.from("view_client_backups");
        public static final Translation DELETE_CONFIG_PRESET = Error.from("delete_config_preset");
        public static final Translation DELETE_CLIENT_BACKUP = Error.from("delete_client_backup");
        public static final Translation DELETE_SERVER_BACKUP = Error.from("delete_server_backup");
        public static final Translation DELETE_ALL_BACKUPS = Error.from("delete_all_backups");
        public static final Translation DELETE_ALL_PRESETS = Error.from("delete_all_presets");
        public static final Translation INSPECT_FILE = Error.from("inspect_file");
        public static final Translation NONEXISTENT_FILE = Error.from("nonexistent_file");
        public static final Translation SERVER_APPLY = Error.from("server_apply");
        public static final Translation SERVER_BACKUPS = Error.from("server_backups");
        public static final Translation DOWNLOAD_WRITER = Error.from("download_writer");
        public static final Translation VIEW_CONFIG_PRESETS = Error.from("view_config_presets");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.overlay.error." + name);
        }
    }

    public static interface Overlay {
        public static final Translation DRAG_TIP = Overlay.from("drag");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.overlay." + name);
        }
    }

    public static interface Text {
        public static final Translation TOGGLE = Text.from("toggle");
        public static final Translation WAIT = Text.from("wait");
        public static final Translation WARN = Text.from("warn");
        public static final Translation FAIL = Text.from("fail");
        public static final Translation LOADED = Text.from("loaded");
        public static final Translation MOD_CONFLICT = Text.from("mod_conflict");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.text." + name);
        }
    }

    public static interface Tag {
        public static final Translation CONFLICT = Tag.from("conflict");
        public static final Translation NEW = Tag.from("new");
        public static final Translation NEW_TOOLTIP = Tag.from("new.info");
        public static final Translation ALERT = Tag.from("alert");
        public static final Translation CLIENT = Tag.from("client");
        public static final Translation CLIENT_TOOLTIP = Tag.from("client.info");
        public static final Translation SERVER = Tag.from("server");
        public static final Translation SERVER_TOOLTIP = Tag.from("server.info");
        public static final Translation DYNAMIC = Tag.from("dynamic");
        public static final Translation DYNAMIC_TOOLTIP = Tag.from("dynamic.info");
        public static final Translation RELOAD = Tag.from("reload");
        public static final Translation RELOAD_TOOLTIP = Tag.from("reload.info");
        public static final Translation WARNING = Tag.from("warning");
        public static final Translation SYNC = Tag.from("sync");
        public static final Translation SYNC_TOOLTIP = Tag.from("sync.info");
        public static final Translation NO_SSO = Tag.from("no_sso");
        public static final Translation NO_SSO_HEADER = Tag.from("no_sso.header");
        public static final Translation NO_SSO_TOOLTIP = Tag.from("no_sso.info");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.tag." + name);
        }
    }

    public static interface TweakRow {
        public static final Translation ENABLED = TweakRow.from("enabled");
        public static final Translation DISABLED = TweakRow.from("disabled");
        public static final Translation CACHE = TweakRow.from("cache");
        public static final Translation CACHE_CLIENT = TweakRow.from("cache_client");
        public static final Translation NETWORK_DISCONNECTED = TweakRow.from("network_disconnected");
        public static final Translation STAR_OFF = TweakRow.from("star_off");
        public static final Translation STAR = TweakRow.from("star");
        public static final Translation RESET = TweakRow.from("reset");
        public static final Translation RESET_OFF = TweakRow.from("reset_off");
        public static final Translation STATUS = TweakRow.from("status");
        public static final Translation MODERN = TweakRow.from("modern");
        public static final Translation MODERN_OFF = TweakRow.from("modern_off");
        public static final Translation DESCRIPTION = TweakRow.from("description");
        public static final Translation NO_IMPL = TweakRow.from("no_impl");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.row.tweak." + name);
        }
    }

    public static interface Listing {
        public static final Translation ADD = Listing.from("add");
        public static final Translation SEARCHING = Listing.from("searching");
        public static final Translation DISABLED_TITLE = Listing.from("disabled_title");
        public static final Translation DISABLED_MESSAGE = Listing.from("disabled_message");
        public static final Translation DISABLED_WARNING = Listing.from("disabled_warning");
        public static final Translation WILDCARD_TITLE = Listing.from("wildcard_title");
        public static final Translation WILDCARD_MESSAGE = Listing.from("wildcard_message");
        public static final Translation WILDCARD_HELP = Listing.from("wildcard_help");
        public static final Translation INVALID_ITEM = Listing.from("invalid_item");
        public static final Translation INVALID_TYPE = Listing.from("invalid_type");
        public static final Translation INVALID_MESSAGE = Listing.from("invalid_message");
        public static final Translation ALREADY_ADDED = Listing.from("already_added");
        public static final Translation NOTHING_FOUND = Listing.from("nothing_found");
        public static final Translation NOTHING_SAVED = Listing.from("nothing_saved");
        public static final Translation ITEM_INFO = Listing.from("item_info");
        public static final Translation INPUT_COPIED = Listing.from("input_copied");
        public static final Translation EMPTY_FAVORITES = Listing.from("empty_favorites");
        public static final Translation EMPTY_SUGGESTIONS = Listing.from("empty_suggestions");
        public static final Translation OPEN_SUGGESTIONS = Listing.from("open_suggestions");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.listing." + name);
        }
    }

    public static interface Tooltip {
        public static final Translation HIDE = Tooltip.from("hide");
        public static final Translation SHIFT = Tooltip.from("shift");
        public static final Translation QUICK = Tooltip.from("quick");
        public static final Translation MANAGE = Tooltip.from("manage");
        public static final Translation FILTER = Tooltip.from("filter");
        public static final Translation FILTER_SEARCH = Tooltip.from("filter_search");
        public static final Translation FILTER_SEARCH_INFO = Tooltip.from("filter_search_info");
        public static final Translation MANAGE_LISTING = Tooltip.from("manage_listing");
        public static final Translation HOME_INIT = Tooltip.from("home_init");
        public static final Translation HOME_DEBUG = Tooltip.from("home_debug");
        public static final Translation HOME_SODIUM = Tooltip.from("home_sodium");
        public static final Translation HOME_WARNING = Tooltip.from("home_warning");
        public static final Translation HOME_SUPPORTERS = Tooltip.from("home_supporters");
        public static final Translation SODIUM_PROPERTIES = Tooltip.from("sodium_properties");
        public static final Translation SODIUM_COPY_PROPERTY = Tooltip.from("sodium_copy_property");
        public static final Translation FILTER_DISABLED = Tooltip.from("filter_disabled");
        public static final Translation FAVORITE_DISABLED = Tooltip.from("favorite_disabled");
        public static final Translation FAVORITE = Tooltip.from("favorite");
        public static final Translation ALL = Tooltip.from("all");
        public static final Translation ALL_DISABLED = Tooltip.from("all_disabled");
        public static final Translation NOT_OPERATOR = Tooltip.from("not_operator");
        public static final Translation NOT_CONNECTED_OR_OPERATOR = Tooltip.from("not_connected_or_operator");
        public static final Translation FINISH = Tooltip.from("finish");
        public static final Translation COPY = Tooltip.from("copy");
        public static final Translation UNDO = Tooltip.from("undo");
        public static final Translation SAVE = Tooltip.from("save");
        public static final Translation ADD = Tooltip.from("add");
        public static final Translation SAVE_LAN = Tooltip.from("save_lan");
        public static final Translation SAVE_SSO = Tooltip.from("save_sso");
        public static final Translation SAVE_MAX_BACKUP = Tooltip.from("save_max_backup");
        public static final Translation SAVE_TWEAK_LOCAL = Tooltip.from("save_tweak_local");
        public static final Translation SAVE_TWEAK_NETWORK = Tooltip.from("save_tweak_network");
        public static final Translation SAVE_BACKUP = Tooltip.from("save_backup");
        public static final Translation EDIT_BACKUP = Tooltip.from("edit_backup");
        public static final Translation DELETE_BACKUP = Tooltip.from("delete_backup");
        public static final Translation INSPECT_BACKUP = Tooltip.from("inspect_backup");
        public static final Translation DOWNLOAD_BACKUP = Tooltip.from("download_backup");
        public static final Translation DELETE_PRESET = Tooltip.from("delete_preset");
        public static final Translation INSPECT_PRESET = Tooltip.from("inspect_preset");
        public static final Translation APPLY_PRESET = Tooltip.from("apply_preset");
        public static final Translation APPLY_CLIENT_BACKUP = Tooltip.from("apply_client_backup");
        public static final Translation APPLY_SERVER_BACKUP = Tooltip.from("apply_server_backup");
        public static final Translation OPEN_BACKUP_FOLDER = Tooltip.from("open_backup_folder");
        public static final Translation OPEN_PRESETS_FOLDER = Tooltip.from("open_presets_folder");
        public static final Translation SEND_PRESET_TO_SERVER = Tooltip.from("send_preset_to_server");
        public static final Translation REFRESH_VIEW = Tooltip.from("refresh_view");
        public static final Translation REVIEW_CHANGES = Tooltip.from("review_changes");
        public static final Translation DELETE_ALL_BACKUPS = Tooltip.from("delete_all_backups");
        public static final Translation DELETE_ALL_PRESETS = Tooltip.from("delete_all_presets");
        public static final Translation CREATE_PRESET = Tooltip.from("create_preset");
        public static final Translation OPEN_DISCORD = Tooltip.from("open_discord");
        public static final Translation KEYBOARD_SHORTCUT = Tooltip.from("keyboard_shortcut");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.tooltip." + name);
        }
    }

    public static interface Button {
        public static final Translation SAVE = Button.from("save");
        public static final Translation MANAGE = Button.from("manage");
        public static final Translation DOWNLOAD = Button.from("download");
        public static final Translation RECONNECT = Button.from("reconnect");
        public static final Translation SUGGESTIONS = Button.from("suggestions");
        public static final Translation MENU_OPTIONS = Button.from("menu_options");
        public static final Translation IMPORT_AND_EXPORT = Button.from("import_and_export");
        public static final Translation SERVER_OPERATIONS = Button.from("server_operations");
        public static final Translation TOGGLE_ALL_TWEAKS = Button.from("toggle_all_tweaks");
        public static final Translation SEND_TO_SERVER = Button.from("send_to_server");
        public static final Translation REVIEW_CHANGES = Button.from("review_changes");
        public static final Translation CONFIG_PRESETS = Button.from("config_presets");
        public static final Translation CREATE_PRESET = Button.from("create_preset");
        public static final Translation LOGICAL_SIDE = Button.from("logical_side");
        public static final Translation CREATE_BACKUP = Button.from("create_backup");
        public static final Translation CLIENT_BACKUP = Button.from("client_backup");
        public static final Translation SERVER_BACKUP = Button.from("server_backup");
        public static final Translation CLIENT_IMPORT = Button.from("client_import");
        public static final Translation CLIENT_EXPORT = Button.from("client_export");
        public static final Translation CLIENT_RELOAD = Button.from("client_reload");
        public static final Translation SERVER_IMPORT = Button.from("server_import");
        public static final Translation SERVER_EXPORT = Button.from("server_export");
        public static final Translation SERVER_RELOAD = Button.from("server_reload");
        public static final Translation VIEW_BACKUPS = Button.from("view_backups");
        public static final Translation OPEN_FOLDER = Button.from("open_folder");
        public static final Translation DISABLE_ALL = Button.from("disable_all");
        public static final Translation DELETE_ALL = Button.from("delete_all");
        public static final Translation ENABLE_ALL = Button.from("enable_all");
        public static final Translation FILTER_ALL = Button.from("filter_all");
        public static final Translation SHOW_ALL = Button.from("show_all");
        public static final Translation EDIT_LIST = Button.from("edit_list");
        public static final Translation VIEW_LIST = Button.from("view_list");
        public static final Translation FAVORITE = Button.from("favorite");
        public static final Translation NETWORK = Button.from("network");
        public static final Translation INSPECT = Button.from("inspect");
        public static final Translation REFRESH = Button.from("refresh");
        public static final Translation SEE_ALL = Button.from("see_all");
        public static final Translation STATUS = Button.from("status");
        public static final Translation DELETE = Button.from("delete");
        public static final Translation FILTER = Button.from("filter");
        public static final Translation EXPORT = Button.from("export");
        public static final Translation IMPORT = Button.from("import");
        public static final Translation MODERN = Button.from("modern");
        public static final Translation LOCAL = Button.from("local");
        public static final Translation QUICK = Button.from("quick");
        public static final Translation RESET = Button.from("reset");
        public static final Translation APPLY = Button.from("apply");
        public static final Translation COPY = Button.from("copy");
        public static final Translation EDIT = Button.from("edit");
        public static final Translation HELP = Button.from("help");
        public static final Translation OKAY = Button.from("okay");
        public static final Translation UNDO = Button.from("undo");
        public static final Translation ADD = Button.from("add");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.button." + name);
        }
    }

    public static interface Slider {
        public static final Translation CAP = Slider.from("cap");
        public static final Translation STACK = Slider.from("stack");
        public static final Translation LIMIT = Slider.from("limit");
        public static final Translation FILES = Slider.from("files");
        public static final Translation SPEED = Slider.from("speed");
        public static final Translation CUSTOM = Slider.from("custom");
        public static final Translation RADIUS = Slider.from("radius");
        public static final Translation OFFSET = Slider.from("offset");
        public static final Translation DENSITY = Slider.from("density");
        public static final Translation MINIMUM = Slider.from("minimum");
        public static final Translation MAXIMUM = Slider.from("maximum");
        public static final Translation SECONDS = Slider.from("seconds");
        public static final Translation ENCROACH = Slider.from("encroach");
        public static final Translation INTENSITY = Slider.from("intensity");
        public static final Translation THICKNESS = Slider.from("thickness");
        public static final Translation PERCENTAGE = Slider.from("percentage");
        public static final Translation BLOCK_LIGHT = Slider.from("block_light");
        public static final Translation Y_LEVEL = Slider.from("y_level");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.slider." + name);
        }
    }

    public static interface Input {
        public static final Translation SEARCH = Input.from("search");
        public static final Translation INVALID_TAG = Input.from("search.invalid_tag");
        public static final Translation TYPE = Input.from("type");
        public static final Translation TIP = Input.from("tip");
        public static final Translation TIP_CLICK = Input.from("tip.click");
        public static final Translation TIP_SEARCH = Input.from("tip.search");
        public static final Translation COPY = Input.from("copy");
        public static final Translation COPY_INFO = Input.from("copy.info");
        public static final Translation PASTE = Input.from("paste");
        public static final Translation PASTE_INFO = Input.from("paste.info");
        public static final Translation CLEAR = Input.from("clear");
        public static final Translation CLEAR_INFO = Input.from("clear.info");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.input." + name);
        }
    }

    public static interface Toast {
        public static final Translation WELCOME_TITLE = Toast.from("welcome_title");
        public static final Translation WELCOME_MESSAGE = Toast.from("welcome_message");
        public static final Translation LAN_CHANGE_TITLE = Toast.from("lan_change_title");
        public static final Translation LAN_CHANGE_MESSAGE = Toast.from("lan_change_message");
        public static final Translation LAN_REJECTED_TITLE = Toast.from("lan_rejected_title");
        public static final Translation LAN_REJECTED_MESSAGE = Toast.from("lan_rejected_message");
        public static final Translation CLIENTBOUND_TWEAK_TITLE = Toast.from("clientbound_tweak_title");
        public static final Translation CLIENTBOUND_TWEAK_MESSAGE = Toast.from("clientbound_tweak_message");
        public static final Translation SERVERBOUND_TWEAK_TITLE = Toast.from("serverbound_tweak_title");
        public static final Translation SERVERBOUND_TWEAK_MESSAGE = Toast.from("serverbound_tweak_message");
        public static final Translation HANDSHAKE_TITLE = Toast.from("handshake_title");
        public static final Translation HANDSHAKE_MESSAGE = Toast.from("handshake_message");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.toast." + name);
        }
    }

    public static interface Pause {
        public static final Translation GAME_MENU = Pause.from("game_menu");
        public static final Translation ACHIEVEMENTS = Pause.from("achievements");
        public static final Translation RETURN_LOWER = Pause.from("return");
        public static final Translation SAVE_LOWER = Pause.from("save");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.screen.pause." + name);
        }
    }

    public static interface Title {
        public static final Translation MODS = Title.from("mods");
        public static final Translation MODS_TEXTURE = Title.from("mods_texture");
        public static final Translation TEXTURE_PACK = Title.from("texture_pack");
        public static final Translation TUTORIAL = Title.from("tutorial");
        public static final Translation COPYRIGHT_ALPHA = Title.from("copyright_alpha");
        public static final Translation COPYRIGHT_BETA = Title.from("copyright_beta");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.screen.title." + name);
        }
    }

    public static interface Level {
        public static final Translation LOADING = Level.from("loading");
        public static final Translation BUILDING = Level.from("building");
        public static final Translation SIMULATE = Level.from("simulate");
        public static final Translation SAVING = Level.from("saving");
        public static final Translation ENTER_NETHER = Level.from("enterNether");
        public static final Translation ENTER_END = Level.from("enterEnd");
        public static final Translation LEAVING_NETHER = Level.from("leaveNether");
        public static final Translation LEAVING_END = Level.from("leaveEnd");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.screen.level." + name);
        }
    }

    public static interface Death {
        public static final Translation SCORE = Death.from("score");
        public static final Translation GAME_OVER = Death.from("game_over");
        public static final Translation TITLE_MENU = Death.from("title_menu");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.screen.death." + name);
        }
    }

    public static interface Worlds {
        public static final Translation ALPHA_EMPTY = Worlds.from("alpha_empty");
        public static final Translation ALPHA_DELETE_TITLE = Worlds.from("alpha_delete_title");
        public static final Translation ALPHA_DELETE_BUTTON = Worlds.from("alpha_delete_button");
        public static final Translation ALPHA_CANNOT_DELETE = Worlds.from("alpha_cannot_delete");
        public static final Translation ALPHA_PAGE_TITLE = Worlds.from("alpha_page_title");
        public static final Translation ALPHA_MOVE_RIGHT = Worlds.from("alpha_move_right");
        public static final Translation ALPHA_MOVE_LEFT = Worlds.from("alpha_move_left");
        public static final Translation BETA_RENAME = Worlds.from("beta_rename");
        public static final Translation BETA_UNKNOWN_LAST_PLAYED = Worlds.from("beta_unknown_last_played");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.screen.worlds." + name);
        }
    }

    public static interface Affirm {
        public static final Translation QUIT_TITLE = Affirm.from("quit_title");
        public static final Translation QUIT_BODY = Affirm.from("quit_body");
        public static final Translation QUIT_DISCARD = Affirm.from("quit_discard");
        public static final Translation QUIT_CANCEL = Affirm.from("quit_cancel");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.screen.affirm." + name);
        }
    }

    public static interface Packs {
        public static final Translation HEADER = Packs.from("header");
        public static final Translation MESSAGE = Packs.from("message");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.screen.packs." + name);
        }
    }

    public static interface Home {
        public static final Translation TITLE = Home.from("title");
        public static final Translation KOFI = Home.from("kofi");
        public static final Translation DISCORD = Home.from("discord");
        public static final Translation GOLDEN_DAYS = Home.from("golden_days");
        public static final Translation SUPPORTERS = Home.from("supporters");
        public static final Translation CONNECTING = Home.from("connecting");
        public static final Translation DISCONNECTED = Home.from("disconnected");
        public static final Translation WRONG_VERSION = Home.from("wrong_version");
        public static final Translation INVALID_DATA = Home.from("invalid_data");
        public static final Translation KOFI_MEMBER = Home.from("kofi_member");
        public static final Translation MOD_CREATOR = Home.from("mod_creator");
        public static final Translation INIT_CONFIG = Home.from("init_config");
        public static final Translation SETUP = Home.from("setup");
        public static final Translation SETUP_INFO = Home.from("setup_info");
        public static final Translation DEFAULT = Home.from("default");
        public static final Translation DEFAULT_INFO = Home.from("default_info");
        public static final Translation DISABLE = Home.from("disable");
        public static final Translation DISABLE_INFO = Home.from("disable_info");
        public static final Translation FPS_INFO = Home.from("fps_info");
        public static final Translation FPS_SWITCH = Home.from("fps_switch");
        public static final Translation DEBUG = Home.from("debug");
        public static final Translation DEBUG_INFO = Home.from("debug_info");
        public static final Translation DEBUG_SWITCH = Home.from("debug_switch");
        public static final Translation DEBUG_SHORTCUT = Home.from("debug_shortcut");
        public static final Translation PREV_PANORAMA = Home.from("prev_panorama");
        public static final Translation PREV_PANORAMA_INFO = Home.from("prev_panorama_info");
        public static final Translation CYCLE_PANORAMA = Home.from("cycle_panorama");
        public static final Translation CYCLE_PANORAMA_INFO = Home.from("cycle_panorama_info");
        public static final Translation NEXT_PANORAMA = Home.from("next_panorama");
        public static final Translation NEXT_PANORAMA_INFO = Home.from("next_panorama_info");
        public static final Translation WARNING_OVERLAY = Home.from("warning_overlay");
        public static final Translation WARNING_BANNER = Home.from("warning_banner");
        public static final Translation WARNING_BANNER_CLICK = Home.from("warning_banner_click");
        public static final Translation SODIUM_TITLE = Home.from("sodium_title");
        public static final Translation SODIUM_CLOUDS_TITLE = Home.from("sodium_clouds_title");
        public static final Translation SODIUM_CLOUDS_INFO = Home.from("sodium_clouds_info");
        public static final Translation SODIUM_CLOUDS_OVERRIDE = Home.from("sodium_clouds_override");
        public static final Translation SODIUM_CLOUDS_RESTART = Home.from("sodium_clouds_restart");
        public static final Translation SODIUM_OPEN_PROPERTIES = Home.from("sodium_open_properties");
        public static final Translation SODIUM_COPY_CLOUDS = Home.from("sodium_copy_clouds");
        public static final Translation SODIUM_MISSING_FILE_HEADER = Home.from("sodium_missing_file_header");
        public static final Translation SODIUM_MISSING_FILE_BODY = Home.from("sodium_missing_file_body");

        private static Translation from(String name) {
            return new Translation("gui.nostalgic_tweaks.screen.home." + name);
        }
    }

    public static interface Vanilla {
        public static final Translation INVENTORY = new Translation("container.inventory");
        public static final Translation GUI_ADVANCEMENTS = new Translation("gui.advancements");
        public static final Translation GUI_CANCEL = new Translation("gui.cancel");
        public static final Translation GUI_STATS = new Translation("gui.stats");
        public static final Translation GUI_DONE = new Translation("gui.done");
        public static final Translation MENU_SINGLEPLAYER = new Translation("menu.singleplayer");
        public static final Translation MENU_MULTIPLAYER = new Translation("menu.multiplayer");
        public static final Translation MENU_DISCONNECT = new Translation("menu.disconnect");
        public static final Translation MENU_OPTIONS = new Translation("menu.options");
        public static final Translation MENU_RETURN_TO_GAME = new Translation("menu.returnToGame");
        public static final Translation MENU_RETURN_TO_TITLE = new Translation("menu.returnToMenu");
        public static final Translation MENU_ONLINE = new Translation("menu.online");
        public static final Translation MENU_MODDED = new Translation("menu.modded");
        public static final Translation MENU_QUIT = new Translation("menu.quit");
        public static final Translation MENU_GAME = new Translation("menu.game");
        public static final Translation MENU_LAN = new Translation("menu.shareToLan");
        public static final Translation SAVE_LEVEL = new Translation("menu.savingLevel");
        public static final Translation WORLD_CREATE = new Translation("selectWorld.create");
        public static final Translation WORLD_DATA_READ = new Translation("selectWorld.data_read");
        public static final Translation WORLD_LOADING_LIST = new Translation("selectWorld.loading_list");
        public static final Translation WORLD_SELECT_TITLE = new Translation("selectWorld.title");
        public static final Translation WORLD_PLAY_SELECTED = new Translation("selectWorld.select");
        public static final Translation WORLD_RESOURCE_LOAD = new Translation("selectWorld.resource_load");
        public static final Translation RESOURCE_PACK_TITLE = new Translation("resourcePack.title");
    }

    public static interface Binding {
        public static final Translation OPEN_CONFIG = new Translation("key.nostalgic_tweaks.open_config");
        public static final Translation TOGGLE_FOG = new Translation("key.nostalgic_tweaks.toggle_fog");
        public static final Translation STOP_SONG = new Translation("key.nostalgic_tweaks.stop_song");
        public static final Translation NEXT_SONG = new Translation("key.nostalgic_tweaks.next_song");
        public static final Translation UNBOUND = new Translation("key.nostalgic_tweaks.unbound");
    }
}

