/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.log;

import dev.architectury.platform.Platform;

public enum LogColor {
    BLACK("\u001b[0;30m", "0"),
    DARK_BLUE("\u001b[0;34m", "1"),
    DARK_GREEN("\u001b[0;32m", "2"),
    DARK_AQUA("\u001b[0;36m", "3"),
    DARK_RED("\u001b[0;31m", "4"),
    DARK_PURPLE("\u001b[0;35m", "5"),
    GOLD("\u001b[0;33m", "6"),
    GRAY("\u001b[0;37m", "7"),
    DARK_GRAY("\u001b[0;30;1m", "8"),
    BLUE("\u001b[0;34;1m", "9"),
    GREEN("\u001b[0;32;1m", "a"),
    AQUA("\u001b[0;36;1m", "b"),
    RED("\u001b[0;31;1m", "c"),
    LIGHT_PURPLE("\u001b[0;35;1m", "d"),
    YELLOW("\u001b[0;33;1m", "e"),
    WHITE("\u001b[0;37;1m", "f"),
    OBFUSCATED("\u001b[5m", "k"),
    BOLD("\u001b[1m", "l"),
    STRIKETHROUGH("\u001b[9m", "m"),
    UNDERLINE("\u001b[4m", "n"),
    ITALIC("\u001b[3m", "o"),
    RESET("\u001b[m", "r");

    private final String ansi;
    private final String mc;

    private LogColor(String ansi, String mc) {
        this.ansi = ansi;
        this.mc = mc;
    }

    public static String apply(LogColor color, String to) {
        return color + to + RESET;
    }

    public String convert(String in) {
        return Platform.isDevelopmentEnvironment() ? in.replaceAll("\u00a7" + this.mc, this.ansi) : in;
    }

    public String toString() {
        return Platform.isDevelopmentEnvironment() ? this.ansi : "";
    }
}

