/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.network;

import java.util.ArrayList;
import mod.adrenix.nostalgic.NostalgicTweaks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;

public abstract class PacketUtil {
    public static <Packet> void sendToPlayer(ServerPlayer player, Packet packet) {
        if (NostalgicTweaks.NETWORK.canPlayerReceive(player, packet.getClass())) {
            NostalgicTweaks.NETWORK.sendToPlayer(player, packet);
            NostalgicTweaks.LOGGER.debug("(S2C) Sent (%s) to (%s)", packet, player);
        } else {
            NostalgicTweaks.LOGGER.debug("(S2C) Player (%s) cannot receive (%s)", player, packet);
        }
    }

    public static <Packet> void sendToAll(Iterable<ServerPlayer> players, Packet packet) {
        ArrayList receivers = new ArrayList();
        players.forEach(player -> {
            if (NostalgicTweaks.NETWORK.canPlayerReceive(player, packet.getClass())) {
                receivers.add(player);
            }
        });
        NostalgicTweaks.NETWORK.sendToPlayers(receivers, packet);
        NostalgicTweaks.LOGGER.debug("(S2C) Sent (%s) to all players", packet);
    }

    public static <Packet> void sendToAll(Packet packet) throws NullPointerException {
        MinecraftServer server = NostalgicTweaks.getServer();
        if (server == null) {
            throw new NullPointerException(String.format("Tried to send (%s) but there was no server instance available", packet.getClass()));
        }
        PacketUtil.sendToAll(server.m_6846_().m_11314_(), packet);
    }

    public static <Packet> void sendToServer(Packet packet) {
        if (NostalgicTweaks.isNetworkVerified()) {
            if (NostalgicTweaks.NETWORK.canServerReceive(packet.getClass())) {
                NostalgicTweaks.NETWORK.sendToServer(packet);
                NostalgicTweaks.LOGGER.debug("(C2S) Sent (%s) to server", packet);
            } else {
                NostalgicTweaks.LOGGER.debug("(C2S) Server cannot receive (%s)", packet);
            }
        } else {
            NostalgicTweaks.LOGGER.info("Mod network is unverified: Not sending (%s)", packet.getClass());
        }
    }

    public static boolean isPlayerOp(ServerPlayer player) {
        return player.m_20310_(2);
    }

    public static void warn(Dist side, Class<?> packet) {
        String receiver = side.equals((Object)Dist.CLIENT) ? "Client" : "Server";
        String bound = side.equals((Object)Dist.CLIENT) ? "server" : "client";
        String warn = String.format("%s is processing (%s) a %s bound packet. This shouldn't happen!", receiver, packet, bound);
        NostalgicTweaks.LOGGER.warn(warn);
    }
}

