/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.sprite;

import mod.adrenix.nostalgic.util.common.sprite.GuiSpriteScaling;
import mod.adrenix.nostalgic.util.common.sprite.SpriteAtlas;
import net.minecraft.resources.ResourceLocation;

public class GuiSprite {
    private final SpriteAtlas atlas;
    private final GuiSpriteScaling scaling;
    private final int width;
    private final int height;
    private final float u0;
    private final float u1;
    private final float v0;
    private final float v1;

    public static GuiSprite stretch(SpriteAtlas atlas, int u0, int v0, int width, int height) {
        return new GuiSprite(atlas, new GuiSpriteScaling.Stretch(), u0, v0, width, height);
    }

    public static GuiSprite stretch(SpriteAtlas atlas) {
        return GuiSprite.stretch(atlas, 0, 0, atlas.getWidth(), atlas.getHeight());
    }

    public static GuiSprite tile(SpriteAtlas atlas, int u0, int v0, int width, int height) {
        return new GuiSprite(atlas, new GuiSpriteScaling.Tile(width, height), u0, v0, width, height);
    }

    public static GuiSprite tile(SpriteAtlas atlas) {
        return GuiSprite.tile(atlas, 0, 0, atlas.getWidth(), atlas.getHeight());
    }

    public static GuiSprite nineSlice(SpriteAtlas atlas, int u0, int v0, int width, int height, int left, int top, int right, int bottom) {
        GuiSpriteScaling.NineSlice.Border border = new GuiSpriteScaling.NineSlice.Border(left, top, right, bottom);
        GuiSpriteScaling.NineSlice nineSlice = new GuiSpriteScaling.NineSlice(width, height, border);
        return new GuiSprite(atlas, nineSlice, u0, v0, width, height);
    }

    public static GuiSprite nineSlice(SpriteAtlas atlas, int u0, int v0, int width, int height, int border) {
        return GuiSprite.nineSlice(atlas, u0, v0, width, height, border, border, border, border);
    }

    public static GuiSprite nineSlice(SpriteAtlas atlas, int left, int top, int right, int bottom) {
        return GuiSprite.nineSlice(atlas, 0, 0, atlas.getWidth(), atlas.getHeight(), left, top, right, bottom);
    }

    public static GuiSprite nineSlice(SpriteAtlas atlas, int border) {
        return GuiSprite.nineSlice(atlas, 0, 0, atlas.getWidth(), atlas.getHeight(), border, border, border, border);
    }

    private GuiSprite(SpriteAtlas atlas, GuiSpriteScaling scaling, int u0, int v0, int width, int height) {
        this.atlas = atlas;
        this.scaling = scaling;
        this.width = width;
        this.height = height;
        this.u0 = (float)u0 / (float)atlas.getWidth();
        this.v0 = (float)v0 / (float)atlas.getHeight();
        this.u1 = (float)(u0 + width) / (float)atlas.getWidth();
        this.v1 = (float)(v0 + height) / (float)atlas.getHeight();
    }

    public ResourceLocation atlasLocation() {
        return this.getAtlas().getLocation();
    }

    public SpriteAtlas getAtlas() {
        return this.atlas;
    }

    public GuiSpriteScaling getScaling() {
        return this.scaling;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getU0() {
        return this.u0;
    }

    public float getU1() {
        return this.u1;
    }

    public float getV0() {
        return this.v0;
    }

    public float getV1() {
        return this.v1;
    }

    public float getU(float u) {
        return this.u0 + (this.u1 - this.u0) * u;
    }

    public float getV(float v) {
        return this.v0 + (this.v1 - this.v0) * v;
    }
}

