/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.text;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;

public abstract class TextWrap {
    public static ArrayList<Component> tooltip(Component translation, int lineLength) {
        String translated = translation.getString();
        ArrayList<String> lines = TextWrap.wrap(translated, lineLength);
        ArrayList<Component> components = new ArrayList<Component>();
        lines.forEach(line -> components.add((Component)Component.m_237113_((String)line)));
        return components;
    }

    public static ArrayList<String> wrap(String string, int lineLength) {
        ArrayList<String> processed = new ArrayList<String>();
        ArrayList<String> lines = new ArrayList<String>();
        String last = "";
        for (String line : string.split(Pattern.quote("\n"))) {
            processed.add(TextWrap.inspect(line, lineLength));
        }
        for (String row : processed) {
            for (String line : row.split(Pattern.quote("\n"))) {
                lines.add(TextWrap.getCodes(last) + line.trim());
                last = lines.get(lines.size() - 1);
            }
        }
        return lines;
    }

    private static String getCodes(String row) {
        Pattern pattern = Pattern.compile(".*(\u00a7.)");
        Matcher matcher = pattern.matcher(row);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private static String inspect(String line, int lineLength) {
        if (line.isEmpty()) {
            return " \n";
        }
        if (line.length() <= lineLength) {
            return line + "\n";
        }
        String[] words = line.split(" ");
        StringBuilder lineBuilder = new StringBuilder();
        StringBuilder trimBuilder = new StringBuilder();
        StringBuilder stripBuilder = new StringBuilder();
        for (String word : words) {
            String stripped = word.replaceAll("\u00a7.", "");
            if (stripBuilder.length() + 1 + stripped.length() <= lineLength) {
                trimBuilder.append(word).append(" ");
                stripBuilder.append(stripped).append(" ");
                continue;
            }
            lineBuilder.append((CharSequence)trimBuilder).append("\n");
            trimBuilder = new StringBuilder();
            trimBuilder.append(word).append(" ");
            stripBuilder = new StringBuilder();
            stripBuilder.append(stripped).append(" ");
        }
        if (!stripBuilder.isEmpty()) {
            lineBuilder.append((CharSequence)trimBuilder);
        }
        return lineBuilder.toString();
    }
}

