/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.timer;

import java.util.concurrent.TimeUnit;
import net.minecraft.Util;

public class FlagTimer {
    private static final int ALWAYS_REPEAT = -1;
    private final boolean startFlag;
    private boolean flag;
    private final long timeInterval;
    private final TimeUnit timeUnit;
    private final int maxRepeat;
    private int repeated;
    private long timeSinceLast;

    FlagTimer(boolean startFlag, long timeInterval, TimeUnit timeUnit, int maxRepeat) {
        this.flag = startFlag;
        this.startFlag = startFlag;
        this.maxRepeat = maxRepeat;
        this.timeSinceLast = 0L;
        this.timeInterval = timeInterval;
        this.timeUnit = timeUnit;
        this.repeated = 0;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public void reset() {
        this.timeSinceLast = Util.m_137550_();
        this.repeated = 0;
        this.flag = this.startFlag;
    }

    public boolean getFlag() {
        if (this.timeSinceLast == 0L) {
            this.timeSinceLast = Util.m_137550_();
        }
        if (this.maxRepeat != -1 && this.repeated >= this.maxRepeat) {
            return this.flag;
        }
        if (Util.m_137550_() - this.timeSinceLast >= this.timeUnit.toMillis(this.timeInterval)) {
            if (this.maxRepeat != -1) {
                ++this.repeated;
            }
            this.timeSinceLast = Util.m_137550_();
            this.flag = !this.flag;
        }
        return this.flag;
    }

    public static Builder create(long delay, TimeUnit time) {
        return new Builder(delay, time);
    }

    public static class Builder {
        private final long timeInterval;
        private final TimeUnit timeUnit;
        private boolean flag = false;
        private int maxRepeat = -1;

        private Builder(long timeInterval, TimeUnit timeUnit) {
            this.timeInterval = timeInterval;
            this.timeUnit = timeUnit;
        }

        public Builder startWith(boolean state) {
            this.flag = state;
            return this;
        }

        public Builder maxRepeat(int maxRepeat) {
            this.maxRepeat = maxRepeat;
            return this;
        }

        public Builder once() {
            this.maxRepeat = 1;
            return this;
        }

        public FlagTimer build() {
            return new FlagTimer(this.flag, this.timeInterval, this.timeUnit, this.maxRepeat);
        }
    }
}

