/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.timer;

import java.util.concurrent.TimeUnit;
import mod.adrenix.nostalgic.NostalgicTweaks;
import net.minecraft.Util;
import net.minecraft.util.Mth;

public class SimpleTimer {
    private static final int NO_REPEAT = -1;
    private boolean debug = false;
    private boolean immediate;
    private boolean waitFirst = false;
    private final long timeInterval;
    private final int maxRepeat;
    private long timeSinceLast = Util.m_137550_();
    private int repeated;

    SimpleTimer(long timeInterval, int maxRepeat) {
        this.timeInterval = timeInterval;
        this.maxRepeat = maxRepeat;
        this.repeated = 0;
    }

    public void waitFirst() {
        this.waitFirst = true;
    }

    public void reset() {
        this.timeSinceLast = Util.m_137550_();
        this.repeated = 0;
    }

    public boolean isMaxReached() {
        return this.repeated == this.maxRepeat;
    }

    public double getProgress() {
        if (this.waitFirst) {
            return 1.0;
        }
        return Mth.m_14008_((double)((double)(Util.m_137550_() - this.timeSinceLast) / (double)this.timeInterval), (double)0.0, (double)1.0);
    }

    public boolean hasElapsed() {
        if (this.waitFirst) {
            this.waitFirst = false;
            this.timeSinceLast = Util.m_137550_();
            if (this.immediate) {
                this.immediate = false;
                return true;
            }
            return false;
        }
        if (this.timeSinceLast == 0L) {
            this.timeSinceLast = Util.m_137550_() - this.timeInterval;
        }
        if (this.maxRepeat != -1 && this.repeated >= this.maxRepeat) {
            return false;
        }
        if (Util.m_137550_() - this.timeSinceLast >= this.timeInterval) {
            if (this.maxRepeat != -1) {
                ++this.repeated;
            }
            this.timeSinceLast = Util.m_137550_();
            if (this.debug) {
                String output = "Timer [timerInterval=%s, maxRepeat=%s, repeated=%s, timeSinceLast=%s] is ready";
                NostalgicTweaks.LOGGER.debug(output, this.timeInterval, this.maxRepeat, this.repeated, this.timeSinceLast);
            }
            return true;
        }
        return false;
    }

    public static Builder create(long duration, TimeUnit time) {
        return new Builder(duration, time, -1);
    }

    public static Builder create(long duration, TimeUnit time, int maxRepeat) {
        return new Builder(duration, time, maxRepeat);
    }

    public static class Builder {
        private final TimeUnit timeUnit;
        private final long duration;
        private final int maxRepeat;
        private boolean immediate = false;
        private boolean waitFirst = false;
        private boolean debug = false;

        private Builder(long duration, TimeUnit timeUnit, int maxRepeat) {
            this.duration = duration;
            this.timeUnit = timeUnit;
            this.maxRepeat = maxRepeat;
        }

        public Builder debug() {
            this.debug = true;
            return this;
        }

        public Builder immediate() {
            this.immediate = true;
            this.waitFirst = true;
            return this;
        }

        public Builder waitFirst() {
            this.waitFirst = true;
            return this;
        }

        public SimpleTimer build() {
            SimpleTimer timer = new SimpleTimer(this.timeUnit.toMillis(this.duration), this.maxRepeat);
            timer.immediate = this.immediate;
            timer.waitFirst = this.waitFirst;
            timer.debug = this.debug;
            return timer;
        }
    }
}

