/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.world;

import mod.adrenix.nostalgic.tweak.listing.ItemListing;
import mod.adrenix.nostalgic.tweak.listing.ItemRule;
import mod.adrenix.nostalgic.util.common.world.ItemUtil;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.AbstractChestBlock;

public abstract class ItemFilter {
    public static boolean isFiltered(Item item, ItemListing<?, ?> list) {
        if (ItemFilter.isUnique(item)) {
            return true;
        }
        if (list.rules().contains((Object)ItemRule.NONE)) {
            return false;
        }
        if (list.rules().contains((Object)ItemRule.ONLY_TOOLS)) {
            return !ItemFilter.isToolLike(item);
        }
        if (list.rules().contains((Object)ItemRule.ONLY_ITEMS)) {
            return !ItemFilter.isItemLike(item);
        }
        if (list.rules().contains((Object)ItemRule.ONLY_BLOCKS)) {
            return !ItemFilter.isBlockLike(item);
        }
        if (list.rules().contains((Object)ItemRule.ONLY_CHESTS)) {
            return !ItemFilter.isChestLike(item);
        }
        if (list.rules().contains((Object)ItemRule.ONLY_EDIBLES)) {
            return !item.m_41472_();
        }
        boolean isToolFiltered = ItemFilter.isToolLike(item) && list.rules().contains((Object)ItemRule.NO_TOOLS);
        boolean isItemFiltered = ItemFilter.isItemLike(item) && list.rules().contains((Object)ItemRule.NO_ITEMS);
        boolean isBlockFiltered = ItemFilter.isBlockLike(item) && list.rules().contains((Object)ItemRule.NO_BLOCKS);
        boolean isEdibleFiltered = item.m_41472_() && list.rules().contains((Object)ItemRule.NO_EDIBLES);
        return isToolFiltered || isItemFiltered || isBlockFiltered || isEdibleFiltered;
    }

    public static boolean isFiltered(ItemStack itemStack, ItemListing<?, ?> list) {
        return ItemFilter.isFiltered(itemStack.m_41720_(), list);
    }

    public static boolean isUnique(Item item) {
        ItemStack itemStack = item.m_7968_();
        ItemStack copyStack = ItemUtil.getItemStack(ItemUtil.getResourceKey(item));
        return itemStack.m_41783_() != null && !itemStack.m_41783_().equals((Object)copyStack.m_41783_());
    }

    public static boolean isToolLike(Item item) {
        return item instanceof DiggerItem || item instanceof SwordItem;
    }

    public static boolean isBlockLike(Item item) {
        return item instanceof BlockItem;
    }

    public static boolean isItemLike(Item item) {
        return !ItemFilter.isToolLike(item) && !ItemFilter.isBlockLike(item);
    }

    public static boolean isChestLike(Item item) {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.m_40614_() instanceof AbstractChestBlock;
        }
        return false;
    }
}

