/*
 * Decompiled with CFR 0.152.
 */
package mod.adrenix.nostalgic.util.common.world;

import java.util.LinkedHashSet;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public abstract class ItemUtil {
    public static Optional<Item> getOptionalItem(String resourceKey) {
        return BuiltInRegistries.f_257033_.m_6612_(ResourceLocation.m_135820_((String)resourceKey));
    }

    public static Item getItem(String resourceKey) {
        return (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)resourceKey));
    }

    public static ItemStack getItemStack(String resourceKey) {
        return ItemUtil.getItem(resourceKey).m_7968_();
    }

    public static Block getBlock(String resourceKey) {
        return (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)resourceKey));
    }

    public static Block getBlockFromItem(Item item) {
        return ItemUtil.getBlock(ItemUtil.getResourceKey(item));
    }

    public static String getResourceKey(Item item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item).toString();
    }

    public static String getResourceKey(ItemStack itemStack) {
        return ItemUtil.getResourceKey(itemStack.m_41720_());
    }

    public static String getResourceKey(Block block) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)block.m_5456_()).toString();
    }

    public static LinkedHashSet<String> getKeysFromItems(Item ... items) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (Item item : items) {
            keys.add(ItemUtil.getResourceKey(item));
        }
        return keys;
    }

    public static boolean isValidKey(String resourceKey) {
        return ItemUtil.getResourceKey(ItemUtil.getItem(resourceKey)).equals(resourceKey);
    }

    public static String getLocalizedItem(String resourceKey) {
        try {
            return ItemUtil.getItem(resourceKey).m_7968_().m_41786_().getString();
        }
        catch (Throwable throwable) {
            return resourceKey;
        }
    }

    public static String getLocalizedItem(ItemStack itemStack) {
        return ItemUtil.getLocalizedItem(ItemUtil.getResourceKey(itemStack.m_41720_()));
    }

    public static boolean hasCustomBarColor(ItemStack itemStack) {
        float maxDamage = itemStack.m_41776_();
        float damageValue = itemStack.m_41773_();
        int color = Mth.m_14169_((float)(Math.max(0.0f, (maxDamage - damageValue) / maxDamage) / 3.0f), (float)1.0f, (float)1.0f);
        return itemStack.m_150949_() != color;
    }
}

