/*
 * Decompiled with CFR 0.152.
 */
package penguinencounter.mediatransport.conversions;

import at.petrak.hexcasting.api.casting.iota.GarbageIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jblas.DoubleMatrix;
import org.jetbrains.annotations.NotNull;
import penguinencounter.mediatransport.casting.mishaps.MishapNotSendable;
import penguinencounter.mediatransport.config.MediaTransportConfig;
import penguinencounter.mediatransport.conversions.Decoder;
import penguinencounter.mediatransport.conversions.Encoder;
import penguinencounter.mediatransport.conversions.TypesKt;
import ram.talia.moreiotas.api.casting.iota.MatrixIota;
import ram.talia.moreiotas.api.casting.iota.StringIota;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u001d\u001a\u00020\u001c2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010!\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010#\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b#\u0010\"\u00a8\u0006$"}, d2={"Lpenguinencounter/mediatransport/conversions/MoreIotasConversions;", "Lpenguinencounter/mediatransport/conversions/Encoder;", "Lpenguinencounter/mediatransport/conversions/Decoder;", "<init>", "()V", "", "type", "", "canDecode", "(I)Z", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "it", "canEncode", "(Lat/petrak/hexcasting/api/casting/iota/Iota;)Z", "Lram/talia/moreiotas/api/casting/iota/MatrixIota;", "", "convertMatrix", "(Lram/talia/moreiotas/api/casting/iota/MatrixIota;)[B", "Lram/talia/moreiotas/api/casting/iota/StringIota;", "convertString", "(Lram/talia/moreiotas/api/casting/iota/StringIota;)[B", "Ljava/io/ByteArrayInputStream;", "bytes", "decode", "(ILjava/io/ByteArrayInputStream;)Lat/petrak/hexcasting/api/casting/iota/Iota;", "", "Lat/petrak/hexcasting/api/casting/iota/IotaType;", "target", "", "defineTypes", "(Ljava/util/Map;)V", "encode", "(Lat/petrak/hexcasting/api/casting/iota/Iota;)[B", "readMatrix", "(Ljava/io/ByteArrayInputStream;)Lat/petrak/hexcasting/api/casting/iota/Iota;", "readString", "mediatransport-common"})
@SourceDebugExtension(value={"SMAP\nMoreIotasConversions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoreIotasConversions.kt\npenguinencounter/mediatransport/conversions/MoreIotasConversions\n+ 2 Types.kt\npenguinencounter/mediatransport/conversions/TypesKt\n*L\n1#1,120:1\n52#2,9:121\n52#2,9:130\n66#2,6:139\n66#2,6:145\n*S KotlinDebug\n*F\n+ 1 MoreIotasConversions.kt\npenguinencounter/mediatransport/conversions/MoreIotasConversions\n*L\n35#1:121,9\n54#1:130,9\n67#1:139,6\n78#1:145,6\n*E\n"})
public final class MoreIotasConversions
implements Encoder,
Decoder {
    @Override
    public boolean canEncode(@NotNull Iota it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iota iota = it;
        return iota instanceof StringIota ? true : iota instanceof MatrixIota;
    }

    @Override
    @NotNull
    public byte[] encode(@NotNull Iota it) throws MishapNotSendable {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iota iota = it;
        if (iota instanceof StringIota) {
            byArray = this.convertString((StringIota)it);
        } else if (iota instanceof MatrixIota) {
            byArray = this.convertMatrix((MatrixIota)it);
        } else {
            TypesKt.misdispatched(Reflection.getOrCreateKotlinClass(this.getClass()), it);
            throw new KotlinNothingValueException();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] convertString(@NotNull StringIota it) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean $i$f$buildData = false;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream baos$iv = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataOutputStream(baos$iv);
            Throwable throwable2 = null;
            try {
                DataOutputStream dos$iv = (DataOutputStream)closeable2;
                boolean bl2 = false;
                DataOutputStream $this$convertString_u24lambda_u240 = dos$iv;
                boolean bl3 = false;
                String string = it.getString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                byte[] byArray2 = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                byte[] theString = byArray2;
                $this$convertString_u24lambda_u240.writeByte(1);
                $this$convertString_u24lambda_u240.writeInt(theString.length);
                $this$convertString_u24lambda_u240.write(theString);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byte[] byArray3 = baos$iv.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toByteArray(...)");
            byArray = byArray3;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] convertMatrix(@NotNull MatrixIota it) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DoubleMatrix data = it.getMatrix();
        if (data.rows * data.columns > MediaTransportConfig.getServer().getMatrixMaxArea()) {
            throw MishapNotSendable.Companion.reason((Iota)it, "matrix_too_big");
        }
        if (data.rows > 255) {
            throw MishapNotSendable.Companion.reason((Iota)it, "matrix_too_many_rows");
        }
        if (data.columns > 255) {
            throw MishapNotSendable.Companion.reason((Iota)it, "matrix_too_many_cols");
        }
        if (data.rows < 0 || data.columns < 0) {
            throw MishapNotSendable.Companion.reason((Iota)it, "corrupt");
        }
        boolean $i$f$buildData = false;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream baos$iv = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataOutputStream(baos$iv);
            Throwable throwable2 = null;
            try {
                DataOutputStream dos$iv = (DataOutputStream)closeable2;
                boolean bl2 = false;
                DataOutputStream $this$convertMatrix_u24lambda_u241 = dos$iv;
                boolean bl3 = false;
                $this$convertMatrix_u24lambda_u241.writeByte(64);
                $this$convertMatrix_u24lambda_u241.writeByte(data.rows);
                $this$convertMatrix_u24lambda_u241.writeByte(data.columns);
                int n = data.rows;
                for (int i = 0; i < n; ++i) {
                    int n2 = data.columns;
                    for (int j = 0; j < n2; ++j) {
                        $this$convertMatrix_u24lambda_u241.writeDouble(data.get(i, j));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byte[] byArray2 = baos$iv.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            byArray = byArray2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Iota readString(@NotNull ByteArrayInputStream bytes) {
        Iota iota;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        boolean $i$f$unpackData = false;
        Closeable closeable = new DataInputStream(bytes);
        Throwable throwable = null;
        try {
            Iota iota2;
            DataInputStream dis$iv = (DataInputStream)closeable;
            boolean bl = false;
            DataInputStream $this$readString_u24lambda_u242 = dis$iv;
            boolean bl2 = false;
            int size = $this$readString_u24lambda_u242.readInt();
            try {
                Iota iota3;
                byte[] bytes2 = $this$readString_u24lambda_u242.readNBytes(size);
                if (bytes2.length != size) {
                    iota3 = (Iota)new GarbageIota();
                } else {
                    Intrinsics.checkNotNull((Object)bytes2);
                    iota3 = (Iota)StringIota.make((String)new String(bytes2, Charsets.UTF_8));
                }
                iota2 = iota3;
            }
            catch (MishapInvalidIota mishapInvalidIota) {
                iota2 = (Iota)new GarbageIota();
            }
            Iota iota4 = iota2;
            iota = iota4;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)iota, (String)"unpackData(...)");
        return iota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Iota readMatrix(@NotNull ByteArrayInputStream bytes) {
        Iota iota;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        boolean $i$f$unpackData = false;
        Closeable closeable = new DataInputStream(bytes);
        Throwable throwable = null;
        try {
            Iota iota2;
            DataInputStream dis$iv = (DataInputStream)closeable;
            boolean bl = false;
            DataInputStream $this$readMatrix_u24lambda_u243 = dis$iv;
            boolean bl2 = false;
            int rows = $this$readMatrix_u24lambda_u243.read();
            int cols = $this$readMatrix_u24lambda_u243.read();
            if (rows == -1 || cols == -1) {
                iota2 = (Iota)new GarbageIota();
            } else if (rows * cols > MediaTransportConfig.getServer().getMatrixMaxArea()) {
                iota2 = (Iota)new GarbageIota();
            } else {
                DoubleMatrix mat = new DoubleMatrix(rows, cols);
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        mat.put(i, j, $this$readMatrix_u24lambda_u243.readDouble());
                    }
                }
                iota2 = (Iota)new MatrixIota(mat);
            }
            iota = iota2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return iota;
    }

    @Override
    @NotNull
    public Iota decode(int type, @NotNull ByteArrayInputStream bytes) {
        Iota iota;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            iota = switch (type) {
                case 1 -> this.readString(bytes);
                case 64 -> this.readMatrix(bytes);
                default -> (Iota)new GarbageIota();
            };
        }
        catch (EOFException eOFException) {
            iota = (Iota)new GarbageIota();
        }
        return iota;
    }

    @Override
    public boolean canDecode(int type) {
        return switch (type) {
            case 1, 64 -> true;
            default -> false;
        };
    }

    @Override
    public void defineTypes(@NotNull Map<Integer, IotaType<?>> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)StringIota.TYPE), TuplesKt.to((Object)64, (Object)MatrixIota.TYPE)};
        this.define(target, pairArray);
    }

    @Override
    public void define(@NotNull Map<Integer, IotaType<?>> $this$define, Pair<Integer, ? extends IotaType<?>> ... tuples) {
        Encoder.DefaultImpls.define(this, $this$define, tuples);
    }
}

