/*
 * Decompiled with CFR 0.152.
 */
package penguinencounter.mediatransport;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.figuramc.figura.server.FiguraCustomPackets;
import org.figuramc.figura.server.FiguraServer;
import org.figuramc.figura.server.packets.CustomFSBPacket;
import org.figuramc.figura.server.packets.Packet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import penguinencounter.mediatransport.MediaTransport;
import penguinencounter.mediatransport.MediaTransportServer;
import penguinencounter.mediatransport.casting.mishaps.MishapTooFast;
import penguinencounter.mediatransport.config.MediaTransportConfig;
import penguinencounter.mediatransport.networking.figura.MediaTransportExternS2CMessage;
import penguinencounter.mediatransport.networking.figura.MediaTransportFigura;
import penguinencounter.mediatransport.networking.figura.MediaTransportListener;
import penguinencounter.mediatransport.networking.figura.MediaTransportS2CMessage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u001d\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000fJC\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u0010H\u0082\b\u00a2\u0006\u0004\b\u000e\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0017\u0010\u000fJ\u0015\u0010\u0018\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001eR#\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001a0\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R#\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$0\u001f8\u0006\u00a2\u0006\f\n\u0004\b%\u0010!\u001a\u0004\b&\u0010#R)\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060'0\u001f8\u0006\u00a2\u0006\f\n\u0004\b(\u0010!\u001a\u0004\b)\u0010#\u00a8\u0006*"}, d2={"Lpenguinencounter/mediatransport/MediaTransportServer;", "", "<init>", "()V", "Ljava/util/UUID;", "uuid", "", "bytes", "", "enqueue", "(Ljava/util/UUID;[B)V", "initializeFigura", "Lnet/minecraft/server/level/ServerPlayer;", "player", "tell", "(Lnet/minecraft/server/level/ServerPlayer;[B)V", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "data", "Lorg/figuramc/figura/server/packets/CustomFSBPacket;", "packet", "(Lnet/minecraft/server/level/ServerPlayer;[BLkotlin/jvm/functions/Function1;)V", "tellExternal", "updateCooldown", "(Lnet/minecraft/server/level/ServerPlayer;)V", "", "cost", "", "useCooldown", "(Lnet/minecraft/server/level/ServerPlayer;D)Z", "", "cooldowns", "Ljava/util/Map;", "getCooldowns", "()Ljava/util/Map;", "", "lastTickUsed", "getLastTickUsed", "", "transportQueue", "getTransportQueue", "mediatransport-common"})
@SourceDebugExtension(value={"SMAP\nMediaTransportServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaTransportServer.kt\npenguinencounter/mediatransport/MediaTransportServer\n*L\n1#1,83:1\n61#1,10:84\n61#1,10:94\n*S KotlinDebug\n*F\n+ 1 MediaTransportServer.kt\npenguinencounter/mediatransport/MediaTransportServer\n*L\n72#1:84,10\n73#1:94,10\n*E\n"})
public final class MediaTransportServer {
    @NotNull
    public static final MediaTransportServer INSTANCE = new MediaTransportServer();
    @NotNull
    private static final Map<UUID, List<byte[]>> transportQueue = new LinkedHashMap();
    @NotNull
    private static final Map<UUID, Double> cooldowns = new LinkedHashMap();
    @NotNull
    private static final Map<UUID, Integer> lastTickUsed = new LinkedHashMap();

    private MediaTransportServer() {
    }

    @NotNull
    public final Map<UUID, List<byte[]>> getTransportQueue() {
        return transportQueue;
    }

    @NotNull
    public final Map<UUID, Double> getCooldowns() {
        return cooldowns;
    }

    @NotNull
    public final Map<UUID, Integer> getLastTickUsed() {
        return lastTickUsed;
    }

    public final void updateCooldown(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MinecraftServer theServer = player.f_8924_;
        int now = theServer.m_129921_();
        UUID uuid = player.m_20148_();
        Map<UUID, Integer> map = lastTickUsed;
        Intrinsics.checkNotNull((Object)uuid);
        Integer n = map.get(uuid);
        if (n == null) {
            boolean bl = false;
            Integer n2 = now;
            lastTickUsed.put(uuid, n2);
            cooldowns.put(uuid, MediaTransportConfig.getServer().getRateLimitMaxValue());
            return;
        }
        int lastUsed = ((Number)n).intValue();
        double chargeSinceLastUse = (double)(now - lastUsed) * MediaTransportConfig.getServer().getRateLimitChargePerTick();
        cooldowns.compute(uuid, (arg_0, arg_1) -> MediaTransportServer.updateCooldown$lambda$1((Function2)new Function2<UUID, Double, Double>(chargeSinceLastUse){
            final /* synthetic */ double $chargeSinceLastUse;
            {
                this.$chargeSinceLastUse = $chargeSinceLastUse;
                super(2);
            }

            @Nullable
            public final Double invoke(@NotNull UUID uUID, @Nullable Double last) {
                Intrinsics.checkNotNullParameter((Object)uUID, (String)"<anonymous parameter 0>");
                Double d = last;
                Intrinsics.checkNotNull((Object)d);
                return Math.min(d + this.$chargeSinceLastUse, MediaTransportConfig.getServer().getRateLimitMaxValue());
            }
        }, arg_0, arg_1));
    }

    public final boolean useCooldown(@NotNull ServerPlayer player, double cost) throws MishapTooFast {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.updateCooldown(player);
        Double d = cooldowns.get(player.m_20148_());
        Intrinsics.checkNotNull((Object)d);
        double cooldownValue = ((Number)d).doubleValue();
        if (cooldownValue < cost) {
            throw new MishapTooFast(cost, cooldownValue);
        }
        cooldowns.compute(player.m_20148_(), (arg_0, arg_1) -> MediaTransportServer.useCooldown$lambda$2((Function2)new Function2<UUID, Double, Double>(cost){
            final /* synthetic */ double $cost;
            {
                this.$cost = $cost;
                super(2);
            }

            @Nullable
            public final Double invoke(@NotNull UUID uUID, @Nullable Double last) {
                Intrinsics.checkNotNullParameter((Object)uUID, (String)"<anonymous parameter 0>");
                Double d = last;
                Intrinsics.checkNotNull((Object)d);
                return Math.max(0.0, d - this.$cost);
            }
        }, arg_0, arg_1));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueue(@NotNull UUID uuid, @NotNull byte[] bytes) {
        List theQueue2;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        List list = transportQueue.computeIfAbsent(uuid, arg_0 -> MediaTransportServer.enqueue$lambda$3(enqueue.theQueue.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"computeIfAbsent(...)");
        List list2 = theQueue2 = list;
        synchronized (list2) {
            boolean bl = false;
            theQueue2.add(bytes);
            if (theQueue2.size() > 6) {
                theQueue2.remove(0);
            }
            MediaTransport.LOGGER.info("Added item to queue for " + uuid + ", now " + theQueue2.size() + " item(s)");
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void tell(ServerPlayer player, byte[] bytes, Function1<? super byte[], ? extends CustomFSBPacket> packet) {
        boolean $i$f$tell = false;
        if (!FiguraServer.initialized()) {
            MediaTransport.LOGGER.warn("not initialized");
            return;
        }
        MediaTransport.LOGGER.info("Sending Figura packet, " + bytes.length + " payload bytes");
        FiguraServer figuraServer = FiguraServer.getInstance();
        Intrinsics.checkNotNull((Object)figuraServer);
        FiguraServer server = figuraServer;
        server.sendPacket(player.m_20148_(), (Packet)packet.invoke((Object)bytes));
    }

    /*
     * WARNING - void declaration
     */
    public final void tell(@NotNull ServerPlayer player, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        MediaTransportServer this_$iv = this;
        boolean $i$f$tell = false;
        if (!FiguraServer.initialized()) {
            MediaTransport.LOGGER.warn("not initialized");
        } else {
            void p0;
            MediaTransport.LOGGER.info("Sending Figura packet, " + bytes.length + " payload bytes");
            FiguraServer figuraServer = FiguraServer.getInstance();
            Intrinsics.checkNotNull((Object)figuraServer);
            FiguraServer server$iv = figuraServer;
            byte[] byArray = bytes;
            UUID uUID = player.m_20148_();
            FiguraServer figuraServer2 = server$iv;
            boolean bl = false;
            MediaTransportS2CMessage mediaTransportS2CMessage = new MediaTransportS2CMessage((byte[])p0);
            figuraServer2.sendPacket(uUID, (Packet)mediaTransportS2CMessage);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void tellExternal(@NotNull ServerPlayer player, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        MediaTransportServer this_$iv = this;
        boolean $i$f$tell = false;
        if (!FiguraServer.initialized()) {
            MediaTransport.LOGGER.warn("not initialized");
        } else {
            void p0;
            MediaTransport.LOGGER.info("Sending Figura packet, " + bytes.length + " payload bytes");
            FiguraServer figuraServer = FiguraServer.getInstance();
            Intrinsics.checkNotNull((Object)figuraServer);
            FiguraServer server$iv = figuraServer;
            byte[] byArray = bytes;
            UUID uUID = player.m_20148_();
            FiguraServer figuraServer2 = server$iv;
            boolean bl = false;
            MediaTransportExternS2CMessage mediaTransportExternS2CMessage = new MediaTransportExternS2CMessage((byte[])p0);
            figuraServer2.sendPacket(uUID, (Packet)mediaTransportExternS2CMessage);
        }
    }

    public final void initializeFigura() {
        if (!FiguraServer.initialized()) {
            throw new IllegalStateException("the point was that you were supposed to mixin somewhere to call this...");
        }
        FiguraServer figuraServer = FiguraServer.getInstance();
        Intrinsics.checkNotNull((Object)figuraServer);
        FiguraServer server = figuraServer;
        MediaTransport.LOGGER.info("figura server started, okay");
        FiguraCustomPackets figuraCustomPackets = server.customPackets();
        Intrinsics.checkNotNull((Object)figuraCustomPackets);
        figuraCustomPackets.registerListener(MediaTransportFigura.INSTANCE.getChannelC2S(), (FiguraCustomPackets.CustomPacketListener)MediaTransportListener.INSTANCE);
    }

    private static final Double updateCooldown$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Double)$tmp0.invoke(p0, p1);
    }

    private static final Double useCooldown$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Double)$tmp0.invoke(p0, p1);
    }

    private static final List enqueue$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }
}

