/*
 * Decompiled with CFR 0.152.
 */
package penguinencounter.mediatransport.conversions;

import at.petrak.hexcasting.api.casting.SpellList;
import at.petrak.hexcasting.api.casting.iota.BooleanIota;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.GarbageIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.ListIota;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.iota.Vec3Iota;
import at.petrak.hexcasting.api.casting.math.HexAngle;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import penguinencounter.mediatransport.conversions.Decoder;
import penguinencounter.mediatransport.conversions.Encoder;
import penguinencounter.mediatransport.conversions.Types;
import penguinencounter.mediatransport.conversions.TypesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b \u0010!J'\u0010&\u001a\u00020%2\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\"H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010*\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010,\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b,\u0010+J\u0015\u0010-\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b-\u0010+J\u0015\u0010.\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b.\u0010+\u00a8\u0006/"}, d2={"Lpenguinencounter/mediatransport/conversions/HexConversions;", "Lpenguinencounter/mediatransport/conversions/Encoder;", "Lpenguinencounter/mediatransport/conversions/Decoder;", "<init>", "()V", "", "type", "", "canDecode", "(I)Z", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "it", "canEncode", "(Lat/petrak/hexcasting/api/casting/iota/Iota;)Z", "Lat/petrak/hexcasting/api/casting/iota/BooleanIota;", "", "convertBoolean", "(Lat/petrak/hexcasting/api/casting/iota/BooleanIota;)[B", "Lat/petrak/hexcasting/api/casting/iota/DoubleIota;", "convertDouble", "(Lat/petrak/hexcasting/api/casting/iota/DoubleIota;)[B", "Lat/petrak/hexcasting/api/casting/iota/ListIota;", "convertList", "(Lat/petrak/hexcasting/api/casting/iota/ListIota;)[B", "Lat/petrak/hexcasting/api/casting/iota/PatternIota;", "convertPattern", "(Lat/petrak/hexcasting/api/casting/iota/PatternIota;)[B", "Lat/petrak/hexcasting/api/casting/iota/Vec3Iota;", "convertVec3", "(Lat/petrak/hexcasting/api/casting/iota/Vec3Iota;)[B", "Ljava/io/ByteArrayInputStream;", "bytes", "decode", "(ILjava/io/ByteArrayInputStream;)Lat/petrak/hexcasting/api/casting/iota/Iota;", "", "Lat/petrak/hexcasting/api/casting/iota/IotaType;", "target", "", "defineTypes", "(Ljava/util/Map;)V", "encode", "(Lat/petrak/hexcasting/api/casting/iota/Iota;)[B", "readDouble", "(Ljava/io/ByteArrayInputStream;)Lat/petrak/hexcasting/api/casting/iota/Iota;", "readList", "readPattern", "readVec3", "mediatransport-common"})
@SourceDebugExtension(value={"SMAP\nHexConversions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HexConversions.kt\npenguinencounter/mediatransport/conversions/HexConversions\n+ 2 Types.kt\npenguinencounter/mediatransport/conversions/TypesKt\n*L\n1#1,156:1\n50#2,9:157\n50#2,9:166\n50#2,9:175\n50#2,7:184\n50#2,9:191\n57#2,2:200\n64#2,6:202\n64#2,6:208\n64#2,6:214\n64#2,6:220\n*S KotlinDebug\n*F\n+ 1 HexConversions.kt\npenguinencounter/mediatransport/conversions/HexConversions\n*L\n48#1:157,9\n53#1:166,9\n63#1:175,9\n71#1:184,7\n76#1:191,9\n71#1:200,2\n94#1:202,6\n98#1:208,6\n108#1:214,6\n118#1:220,6\n*E\n"})
public final class HexConversions
implements Encoder,
Decoder {
    @Override
    public boolean canEncode(@NotNull Iota it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iota iota = it;
        return (((((iota instanceof BooleanIota ? true : iota instanceof DoubleIota) ? true : iota instanceof ListIota) ? true : iota instanceof NullIota) ? true : iota instanceof PatternIota) ? true : iota instanceof Vec3Iota) ? true : iota instanceof GarbageIota;
    }

    @Override
    @NotNull
    public byte[] encode(@NotNull Iota it) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iota iota = it;
        if (iota instanceof BooleanIota) {
            byArray = this.convertBoolean((BooleanIota)it);
        } else if (iota instanceof NullIota) {
            byArray = Types.INSTANCE.getNullData();
        } else if (iota instanceof GarbageIota) {
            byArray = Types.INSTANCE.getGarbageData();
        } else if (iota instanceof DoubleIota) {
            byArray = this.convertDouble((DoubleIota)it);
        } else if (iota instanceof PatternIota) {
            byArray = this.convertPattern((PatternIota)it);
        } else if (iota instanceof Vec3Iota) {
            byArray = this.convertVec3((Vec3Iota)it);
        } else if (iota instanceof ListIota) {
            byArray = this.convertList((ListIota)it);
        } else {
            TypesKt.misdispatched(Reflection.getOrCreateKotlinClass(this.getClass()), it);
            throw new KotlinNothingValueException();
        }
        return byArray;
    }

    @NotNull
    public final byte[] convertBoolean(@NotNull BooleanIota it) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean bl = it.getBool();
        if (bl) {
            byArray = Types.INSTANCE.getTrueData();
        } else if (!bl) {
            byArray = Types.INSTANCE.getFalseData();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] convertDouble(@NotNull DoubleIota it) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean $i$f$buildData = false;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream baos$iv = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataOutputStream(baos$iv);
            Throwable throwable2 = null;
            try {
                DataOutputStream dos$iv = (DataOutputStream)closeable2;
                boolean bl2 = false;
                DataOutputStream $this$convertDouble_u24lambda_u240 = dos$iv;
                boolean bl3 = false;
                $this$convertDouble_u24lambda_u240.writeByte(5);
                $this$convertDouble_u24lambda_u240.writeDouble(it.getDouble());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byte[] byArray2 = baos$iv.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            byArray = byArray2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] convertPattern(@NotNull PatternIota it) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean $i$f$buildData = false;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream baos$iv = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataOutputStream(baos$iv);
            Throwable throwable2 = null;
            try {
                DataOutputStream dos$iv = (DataOutputStream)closeable2;
                boolean bl2 = false;
                DataOutputStream $this$convertPattern_u24lambda_u241 = dos$iv;
                boolean bl3 = false;
                HexPattern pattern = it.getPattern();
                $this$convertPattern_u24lambda_u241.writeByte(6);
                $this$convertPattern_u24lambda_u241.writeByte(pattern.getStartDir().ordinal());
                $this$convertPattern_u24lambda_u241.writeInt(pattern.getAngles().size());
                for (HexAngle angle : pattern.getAngles()) {
                    $this$convertPattern_u24lambda_u241.writeByte(angle.ordinal());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byte[] byArray2 = baos$iv.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            byArray = byArray2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] convertVec3(@NotNull Vec3Iota it) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean $i$f$buildData = false;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream baos$iv = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataOutputStream(baos$iv);
            Throwable throwable2 = null;
            try {
                DataOutputStream dos$iv = (DataOutputStream)closeable2;
                boolean bl2 = false;
                DataOutputStream $this$convertVec3_u24lambda_u242 = dos$iv;
                boolean bl3 = false;
                $this$convertVec3_u24lambda_u242.writeByte(7);
                Vec3 vec3 = it.getVec3();
                $this$convertVec3_u24lambda_u242.writeDouble(vec3.f_82479_);
                $this$convertVec3_u24lambda_u242.writeDouble(vec3.f_82480_);
                $this$convertVec3_u24lambda_u242.writeDouble(vec3.f_82481_);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byte[] byArray2 = baos$iv.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            byArray = byArray2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] convertList(@NotNull ListIota it) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean $i$f$buildData = false;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream baos$iv = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataOutputStream(baos$iv);
            Throwable throwable2 = null;
            try {
                byte[] byArray2;
                DataOutputStream dos$iv = (DataOutputStream)closeable2;
                boolean bl2 = false;
                DataOutputStream $this$convertList_u24lambda_u244 = dos$iv;
                boolean bl3 = false;
                $this$convertList_u24lambda_u244.writeByte(8);
                int size = 0;
                SpellList theList = null;
                theList = it.getList();
                boolean $i$f$buildData2 = false;
                Closeable closeable3 = new ByteArrayOutputStream();
                Throwable throwable3 = null;
                try {
                    ByteArrayOutputStream baos$iv2 = (ByteArrayOutputStream)closeable3;
                    $i$a$-use-TypesKt$buildData$2$iv = false;
                    Closeable closeable4 = new DataOutputStream(baos$iv2);
                    Throwable throwable4 = null;
                    try {
                        DataOutputStream dos$iv2 = (DataOutputStream)closeable4;
                        $i$a$-use-TypesKt$buildData$2$1$iv = false;
                        DataOutputStream $this$convertList_u24lambda_u244_u24lambda_u243 = dos$iv2;
                        boolean bl4 = false;
                        while (theList.getNonEmpty()) {
                            ++size;
                            $this$convertList_u24lambda_u244_u24lambda_u243.write(Encoder.Companion.encode(theList.getCar()));
                            theList = theList.getCdr();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                    }
                    byte[] byArray3 = baos$iv2.toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toByteArray(...)");
                    byArray2 = byArray3;
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                byte[] intermediary = byArray2;
                $this$convertList_u24lambda_u244.writeInt(size);
                $this$convertList_u24lambda_u244.write(intermediary);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byte[] byArray4 = baos$iv.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"toByteArray(...)");
            byArray = byArray4;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    @Override
    public boolean canDecode(int type) {
        return switch (type) {
            case 2, 3, 4, 5, 6, 7, 8, 255 -> true;
            default -> false;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Iota readDouble(@NotNull ByteArrayInputStream bytes) {
        DoubleIota doubleIota;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        boolean $i$f$unpackData = false;
        Closeable closeable = new DataInputStream(bytes);
        Throwable throwable = null;
        try {
            DataInputStream dis$iv = (DataInputStream)closeable;
            boolean bl = false;
            DataInputStream $this$readDouble_u24lambda_u245 = dis$iv;
            boolean bl2 = false;
            doubleIota = new DoubleIota($this$readDouble_u24lambda_u245.readDouble());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (Iota)doubleIota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Iota readVec3(@NotNull ByteArrayInputStream bytes) {
        Vec3Iota vec3Iota;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        boolean $i$f$unpackData = false;
        Closeable closeable = new DataInputStream(bytes);
        Throwable throwable = null;
        try {
            DataInputStream dis$iv = (DataInputStream)closeable;
            boolean bl = false;
            DataInputStream $this$readVec3_u24lambda_u246 = dis$iv;
            boolean bl2 = false;
            vec3Iota = new Vec3Iota(new Vec3($this$readVec3_u24lambda_u246.readDouble(), $this$readVec3_u24lambda_u246.readDouble(), $this$readVec3_u24lambda_u246.readDouble()));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (Iota)vec3Iota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Iota readPattern(@NotNull ByteArrayInputStream bytes) {
        PatternIota patternIota;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        boolean $i$f$unpackData = false;
        Closeable closeable = new DataInputStream(bytes);
        Throwable throwable = null;
        try {
            DataInputStream dis$iv = (DataInputStream)closeable;
            boolean bl = false;
            DataInputStream $this$readPattern_u24lambda_u248 = dis$iv;
            boolean bl2 = false;
            HexDir startDir = (HexDir)EntriesMappings.entries$1.get((int)$this$readPattern_u24lambda_u248.readByte());
            int nAngles = $this$readPattern_u24lambda_u248.readInt();
            ArrayList<HexAngle> arrayList = new ArrayList<HexAngle>(nAngles);
            int n = 0;
            while (n < nAngles) {
                int n2;
                int n3 = n2 = n++;
                ArrayList<HexAngle> arrayList2 = arrayList;
                boolean bl3 = false;
                arrayList2.add((HexAngle)EntriesMappings.entries$0.get((int)$this$readPattern_u24lambda_u248.readByte()));
            }
            List angles = arrayList;
            patternIota = new PatternIota(new HexPattern(startDir, angles));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (Iota)patternIota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Iota readList(@NotNull ByteArrayInputStream bytes) {
        ListIota listIota;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        boolean $i$f$unpackData = false;
        Closeable closeable = new DataInputStream(bytes);
        Throwable throwable = null;
        try {
            DataInputStream dis$iv = (DataInputStream)closeable;
            boolean bl = false;
            DataInputStream $this$readList_u24lambda_u2410 = dis$iv;
            boolean bl2 = false;
            int size = $this$readList_u24lambda_u2410.readInt();
            ArrayList<Iota> arrayList = new ArrayList<Iota>(size);
            int n = 0;
            while (n < size) {
                int n2;
                int n3 = n2 = n++;
                ArrayList<Iota> arrayList2 = arrayList;
                boolean bl3 = false;
                arrayList2.add(Decoder.Companion.decode(bytes));
            }
            List iotas = arrayList;
            listIota = new ListIota(iotas);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (Iota)listIota;
    }

    @Override
    @NotNull
    public Iota decode(int type, @NotNull ByteArrayInputStream bytes) {
        Iota iota;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            iota = switch (type) {
                case 2 -> (Iota)new BooleanIota(true);
                case 3 -> (Iota)new BooleanIota(false);
                case 4 -> (Iota)new NullIota();
                case 255 -> (Iota)new GarbageIota();
                case 5 -> this.readDouble(bytes);
                case 7 -> this.readVec3(bytes);
                case 6 -> this.readPattern(bytes);
                case 8 -> this.readList(bytes);
                default -> (Iota)new GarbageIota();
            };
        }
        catch (EOFException eOFException) {
            iota = (Iota)new GarbageIota();
        }
        return iota;
    }

    @Override
    public void defineTypes(@NotNull Map<Integer, IotaType<?>> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)2, (Object)BooleanIota.TYPE), TuplesKt.to((Object)3, (Object)BooleanIota.TYPE), TuplesKt.to((Object)4, (Object)NullIota.TYPE), TuplesKt.to((Object)255, (Object)GarbageIota.TYPE), TuplesKt.to((Object)5, (Object)DoubleIota.TYPE), TuplesKt.to((Object)7, (Object)Vec3Iota.TYPE), TuplesKt.to((Object)6, (Object)PatternIota.TYPE), TuplesKt.to((Object)8, (Object)ListIota.TYPE)};
        this.define(target, pairArray);
    }

    @Override
    public void define(@NotNull Map<Integer, IotaType<?>> $this$define, Pair<Integer, ? extends IotaType<?>> ... tuples) {
        Encoder.DefaultImpls.define(this, $this$define, tuples);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<HexAngle> entries$0;
        public static final /* synthetic */ EnumEntries<HexDir> entries$1;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])HexAngle.values()));
            entries$1 = EnumEntriesKt.enumEntries((Enum[])((Enum[])HexDir.values()));
        }
    }
}

