/*
 * Decompiled with CFR 0.152.
 */
package net.nova.pluralcraft;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.List;
import net.nova.pluralcraft.commands.PluginCommands;
import net.nova.pluralcraft.datatypes.SystemDataType;
import net.nova.pluralcraft.types.Member;
import net.nova.pluralcraft.types.System;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;

public class Utils {
    public static final NamespacedKey SYSTEM_KEY = new NamespacedKey("pluralcraft", "system");
    public static final NamespacedKey ACTIVE_MEMBER = new NamespacedKey("pluralcraft", "active_member");
    public static final SuggestionProvider<CommandSourceStack> SUGGESTION_PROVIDER = (context, builder) -> {
        Player player = PluginCommands.getSender((CommandSourceStack)context.getSource());
        List<String> ids = ((System)player.getPersistentDataContainer().get(SYSTEM_KEY, (PersistentDataType)SystemDataType.INSTANCE)).members().stream().map(Member::id).toList();
        for (String id : ids) {
            if (!id.startsWith(builder.getRemaining())) continue;
            builder.suggest(id);
        }
        return builder.buildFuture();
    };

    public static System getSystem(Player player) {
        return (System)player.getPersistentDataContainer().get(SYSTEM_KEY, (PersistentDataType)SystemDataType.INSTANCE);
    }

    public static boolean hasSystem(Player player) {
        return player.getPersistentDataContainer().has(SYSTEM_KEY);
    }

    public static void createSystem(Player player, String name) {
        player.getPersistentDataContainer().set(SYSTEM_KEY, (PersistentDataType)SystemDataType.INSTANCE, (Object)new System(name, new ArrayList<Member>()));
    }

    public static void deleteSystem(Player player) {
        player.getPersistentDataContainer().remove(SYSTEM_KEY);
    }

    public static boolean hasMemberWithId(Player player, String id) {
        System system = (System)player.getPersistentDataContainer().get(SYSTEM_KEY, (PersistentDataType)SystemDataType.INSTANCE);
        for (Member member : system.members()) {
            if (!member.id().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static void addMember(Player player, String id, String name) {
        System system = (System)player.getPersistentDataContainer().get(SYSTEM_KEY, (PersistentDataType)SystemDataType.INSTANCE);
        system.members().add(new Member(id, name));
        player.getPersistentDataContainer().set(SYSTEM_KEY, (PersistentDataType)SystemDataType.INSTANCE, (Object)system);
    }

    public static void removeMember(Player player, String id) {
        String activeMemberId = (String)player.getPersistentDataContainer().get(ACTIVE_MEMBER, PersistentDataType.STRING);
        if (id.equals(activeMemberId)) {
            Utils.removeActiveMember(player);
            player.sendRichMessage("<yellow>Cleared active member since it was removed.</yellow>");
        }
        System system = (System)player.getPersistentDataContainer().get(SYSTEM_KEY, (PersistentDataType)SystemDataType.INSTANCE);
        ArrayList<Member> newMembers = new ArrayList<Member>();
        for (Member member : system.members()) {
            if (member.id().equals(id)) continue;
            newMembers.add(member);
        }
        player.getPersistentDataContainer().set(SYSTEM_KEY, (PersistentDataType)SystemDataType.INSTANCE, (Object)new System(system.name(), newMembers));
    }

    public static void removeActiveMember(Player player) {
        player.getPersistentDataContainer().remove(ACTIVE_MEMBER);
    }

    public static void setActiveMember(Player player, String id) {
        player.getPersistentDataContainer().set(ACTIVE_MEMBER, PersistentDataType.STRING, (Object)id);
    }

    public static boolean hasActiveMember(Player player) {
        return player.getPersistentDataContainer().has(ACTIVE_MEMBER);
    }

    public static String getActiveMemberId(Player player) {
        return (String)player.getPersistentDataContainer().get(ACTIVE_MEMBER, PersistentDataType.STRING);
    }

    public static String getActiveMemberName(Player player) {
        String id = (String)player.getPersistentDataContainer().get(ACTIVE_MEMBER, PersistentDataType.STRING);
        System system = (System)player.getPersistentDataContainer().get(SYSTEM_KEY, (PersistentDataType)SystemDataType.INSTANCE);
        for (Member member : system.members()) {
            if (!member.id().equals(id)) continue;
            return member.name();
        }
        return null;
    }
}

