/*
 * Decompiled with CFR 0.152.
 */
package net.nova.pluralcraft.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.nova.pluralcraft.PluralCraft;
import net.nova.pluralcraft.Utils;
import net.nova.pluralcraft.types.Member;
import net.nova.pluralcraft.types.System;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PluginCommands {
    public static void register(PluralCraft plugin) {
        plugin.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, registrar -> {
            Commands commands = (Commands)registrar.registrar();
            commands.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pluralcraft").requires(stack -> {
                Entity sender = stack.getExecutor();
                if (sender == null) {
                    sender = stack.getSender();
                }
                return sender instanceof Player;
            })).executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                sender.sendRichMessage("<yellow>Usage: /pluralcraft <create|delete|add|remove|setActiveMember|clearActiveMember|getActiveMember|getSystemInfo>");
                return 1;
            })).then(((LiteralArgumentBuilder)Commands.literal((String)"create").executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                sender.sendRichMessage("<yellow>Usage: /pluralcraft create [name]");
                return 1;
            })).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                if (Utils.hasSystem(sender)) {
                    sender.sendRichMessage("<red>You already have a system registered.</red>");
                } else {
                    Utils.createSystem(sender, StringArgumentType.getString((CommandContext)ctx, (String)"name"));
                    sender.sendRichMessage("<green>Created system!</green>");
                }
                return 1;
            })))).then(Commands.literal((String)"delete").executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                if (!Utils.hasSystem(sender)) {
                    sender.sendRichMessage("<red>You don't have a system to delete.</red>");
                } else {
                    Utils.deleteSystem(sender);
                    sender.sendRichMessage("<green>System deleted!</green>");
                }
                return 1;
            }))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                sender.sendRichMessage("<yellow>Usage: /pluralcraft add [id] [name]");
                return 1;
            })).then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
                if (!Utils.hasSystem(sender)) {
                    sender.sendRichMessage("<red>You must register a system before you can add members.</red>");
                } else if (Utils.hasMemberWithId(sender, id)) {
                    sender.sendRichMessage("<red>You already have a member with that ID.</red>");
                } else {
                    Utils.addMember(sender, id, StringArgumentType.getString((CommandContext)ctx, (String)"name"));
                    sender.sendRichMessage("<green>Created member!</green>");
                }
                return 1;
            }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                sender.sendRichMessage("<yellow>Usage: /pluralcraft remove [id]");
                return 1;
            })).then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).suggests(Utils.SUGGESTION_PROVIDER).executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
                if (!Utils.hasSystem(sender)) {
                    sender.sendRichMessage("<red>You do not have a system registered.</red>");
                } else if (!Utils.hasMemberWithId(sender, id)) {
                    sender.sendRichMessage("<red>You do not have a member with that ID.</red>");
                } else {
                    Utils.removeMember(sender, id);
                    sender.sendRichMessage("<green>Removed member!</green>");
                }
                return 1;
            })))).then(((LiteralArgumentBuilder)Commands.literal((String)"setActiveMember").executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                sender.sendRichMessage("<yellow>Usage: /pluralcraft setActiveMember [id]");
                return 1;
            })).then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).suggests(Utils.SUGGESTION_PROVIDER).executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
                if (!Utils.hasSystem(sender)) {
                    sender.sendRichMessage("<red>You do not have a system registered.</red>");
                } else if (!Utils.hasMemberWithId(sender, id)) {
                    sender.sendRichMessage("<red>You do not have a member with that ID.</red>");
                } else {
                    Utils.setActiveMember(sender, id);
                    sender.sendRichMessage("<green>Set active member!</green>");
                }
                return 1;
            })))).then(Commands.literal((String)"clearActiveMember").executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                if (!Utils.hasSystem(sender)) {
                    sender.sendRichMessage("<red>You do not have a system registered.</red>");
                } else {
                    Utils.removeActiveMember(sender);
                    sender.sendRichMessage("<green>Cleared active member!</green>");
                }
                return 1;
            }))).then(((LiteralArgumentBuilder)Commands.literal((String)"getActiveMember").executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                if (!Utils.hasSystem(sender)) {
                    sender.sendRichMessage("<red>You do not have a system registered.</red>");
                } else {
                    String name = Utils.getActiveMemberName(sender);
                    if (name == null) {
                        sender.sendRichMessage("<yellow>There is no active member currently.</yellow>");
                    } else {
                        sender.sendRichMessage("<green>Current active member is %s.</green>".formatted(name));
                    }
                }
                return 1;
            })).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                Player target = (Player)((List)((PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)ctx.getSource())).getFirst();
                if (!Utils.hasSystem(target)) {
                    sender.sendRichMessage("<red>The target does not have a system registered.</red>");
                } else {
                    String name = Utils.getActiveMemberName(target);
                    if (name == null) {
                        sender.sendRichMessage("<yellow>%s has no active member currently.</yellow>".formatted(target.getName()));
                    } else {
                        sender.sendRichMessage("<green>Current active member for %s is %s.</green>".formatted(target.getName(), name));
                    }
                }
                return 1;
            })))).then(((LiteralArgumentBuilder)Commands.literal((String)"getSystemInfo").executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                sender.sendMessage(PluginCommands.getSystemTree(sender));
                return 1;
            })).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).executes(ctx -> {
                Player sender = PluginCommands.getSender((CommandSourceStack)ctx.getSource());
                Player target = (Player)((List)((PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)ctx.getSource())).getFirst();
                sender.sendMessage(PluginCommands.getSystemTree(target));
                return 1;
            })))).build());
        });
    }

    public static Component getSystemTree(Player player) {
        if (Utils.hasSystem(player)) {
            System system = Utils.getSystem(player);
            TextComponent component = Component.empty();
            component = component.append((Component)Component.text((String)system.name(), (TextColor)NamedTextColor.GREEN));
            if (system.members().isEmpty()) {
                component = component.append((Component)Component.newline()).append((Component)Component.text((String)"This system has no members.", (TextColor)NamedTextColor.RED));
            } else {
                String activeMemberId = Utils.getActiveMemberId(player);
                for (Member member : system.members()) {
                    component = component.append((Component)Component.newline()).append(((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)Component.text((String)"- ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)member.name(), (TextColor)(member.id().equals(activeMemberId) ? NamedTextColor.GOLD : NamedTextColor.YELLOW)))).append((Component)Component.space())).append((Component)Component.text((String)"(%s)".formatted(member.id()), (TextColor)NamedTextColor.GRAY)));
                }
            }
            return component;
        }
        return Component.text((String)"%s does not have a system.".formatted(player.getName()), (TextColor)NamedTextColor.RED);
    }

    public static Player getSender(CommandSourceStack stack) {
        Entity sender = stack.getExecutor();
        if (sender == null) {
            sender = stack.getSender();
        }
        return (Player)sender;
    }
}

