/*
 * Decompiled with CFR 0.152.
 */
package net.nova.pluralcraft.datatypes;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.nova.pluralcraft.types.Member;
import net.nova.pluralcraft.types.System;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class SystemDataType
implements PersistentDataType<byte[], System> {
    public static final SystemDataType INSTANCE = new SystemDataType();

    private SystemDataType() {
    }

    @NotNull
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    @NotNull
    public Class<System> getComplexType() {
        return System.class;
    }

    public byte @NotNull [] toPrimitive(@NotNull System system, @NotNull PersistentDataAdapterContext persistentDataAdapterContext) {
        int size = 0;
        size += 4;
        byte[] systemNameBytes = system.name().getBytes(StandardCharsets.UTF_8);
        size += systemNameBytes.length;
        size += 4;
        for (Member member : system.members()) {
            size += 8;
            size += member.name().getBytes(StandardCharsets.UTF_8).length;
            size += member.id().getBytes(StandardCharsets.UTF_8).length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.putInt(systemNameBytes.length);
        buffer.put(systemNameBytes);
        buffer.putInt(system.members().size());
        for (Member member : system.members()) {
            byte[] memberNameBytes = member.name().getBytes(StandardCharsets.UTF_8);
            byte[] memberIdBytes = member.id().getBytes(StandardCharsets.UTF_8);
            buffer.putInt(memberNameBytes.length);
            buffer.put(memberNameBytes);
            buffer.putInt(memberIdBytes.length);
            buffer.put(memberIdBytes);
        }
        return buffer.array();
    }

    @NotNull
    public System fromPrimitive(byte @NotNull [] bytes, @NotNull PersistentDataAdapterContext persistentDataAdapterContext) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int systemNameSize = buffer.getInt();
        byte[] systemNameBytes = new byte[systemNameSize];
        buffer.get(systemNameBytes);
        ArrayList<Member> members = new ArrayList<Member>();
        int memberCount = buffer.getInt();
        for (int i = 0; i < memberCount; ++i) {
            int memberNameSize = buffer.getInt();
            byte[] memberNameBytes = new byte[memberNameSize];
            buffer.get(memberNameBytes);
            int memberIdSize = buffer.getInt();
            byte[] memberIdBytes = new byte[memberIdSize];
            buffer.get(memberIdBytes);
            members.add(new Member(new String(memberIdBytes, StandardCharsets.UTF_8), new String(memberNameBytes, StandardCharsets.UTF_8)));
        }
        return new System(new String(systemNameBytes, StandardCharsets.UTF_8), members);
    }
}

