/*
 * Decompiled with CFR 0.152.
 */
package walksy.crosshairaddons.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_310;
import walksy.crosshairaddons.manager.ShieldCooldownManager;

public class ShieldStateManager {
    private static final int MATCH_RADIUS = 5;
    private static final long ATTACK_ENTRY_TTL_MS = 1000L;
    private static final long CLIENT_DISABLE_GRACE_MS = 250L;
    private static final int DEFAULT_COOLDOWN_TICKS = 100;
    private final Map<class_1657, Integer> shieldUseTicks = new HashMap<class_1657, Integer>();
    private final Map<class_1657, AttackEntry> attackedPlayerEntries = new HashMap<class_1657, AttackEntry>();
    private final class_310 client = class_310.method_1551();
    private final Consumer<class_1657> onShieldBreak;
    private final ShieldCooldownManager cooldownManager = new ShieldCooldownManager();
    private boolean clientShieldDisabled = false;
    private long lastClientShieldDisabledAt = 0L;

    public ShieldStateManager(Consumer<class_1657> onShieldBreak) {
        this.onShieldBreak = onShieldBreak;
    }

    public void set(class_1657 player) {
        if (player == null) {
            return;
        }
        this.cooldownManager.setCooldown(player, 100);
        if (this.client != null && this.client.field_1724 != null && player == this.client.field_1724) {
            this.clientShieldDisabled = true;
            this.lastClientShieldDisabledAt = System.currentTimeMillis();
        }
        if (this.attackedPlayerEntries.containsKey(player)) {
            this.onShieldBreak.accept(player);
        }
    }

    public void update() {
        long now = System.currentTimeMillis();
        if (this.client == null || this.client.field_1687 == null) {
            return;
        }
        for (class_1657 player : this.client.field_1687.method_18456()) {
            if (this.isHoldingUsableShield(player) && player.method_6115()) {
                int current = this.shieldUseTicks.getOrDefault(player, 0);
                this.shieldUseTicks.put(player, current + 1);
                continue;
            }
            this.shieldUseTicks.put(player, 0);
        }
        this.attackedPlayerEntries.entrySet().removeIf(e -> now - ((AttackEntry)e.getValue()).time > 1000L);
        this.cooldownManager.tick();
        if (this.client.field_1724 != null) {
            boolean nowDisabled = this.cooldownManager.isCoolingDown((class_1657)this.client.field_1724);
            if (nowDisabled && !this.clientShieldDisabled) {
                this.lastClientShieldDisabledAt = System.currentTimeMillis();
            }
            this.clientShieldDisabled = nowDisabled;
        } else {
            this.clientShieldDisabled = false;
        }
    }

    public void handleEntityStatus(class_1657 player, byte status) {
        int SHIELD_BREAK_STATUS = 30;
        if (status == 30) {
            this.set(player);
        }
    }

    public void handleBreakPacket(double x, double y, double z) {
        if (this.client == null || this.client.field_1687 == null || this.client.field_1724 == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastClientShieldDisabledAt <= 250L) {
            return;
        }
        double matchRadiusSq = 25.0;
        class_1657 matched = null;
        this.attackedPlayerEntries.entrySet().removeIf(e -> now - ((AttackEntry)e.getValue()).time > 1000L);
        double bestScore = Double.NEGATIVE_INFINITY;
        for (Map.Entry<class_1657, AttackEntry> e2 : this.attackedPlayerEntries.entrySet()) {
            double dz;
            double dy;
            double dx;
            double distSq;
            class_1657 candidate = e2.getKey();
            AttackEntry ae = e2.getValue();
            if (candidate == null || candidate == this.client.field_1724 || now - ae.time > 1000L || (distSq = (dx = ae.targetPos.field_1352 - x) * dx + (dy = ae.targetPos.field_1351 - y) * dy + (dz = ae.targetPos.field_1350 - z) * dz) > 25.0) continue;
            double score = (25.0 - distSq) / 25.0;
            if (ae.wasBlocking) {
                score += 0.3;
            }
            if (!(score > bestScore)) continue;
            bestScore = score;
            matched = candidate;
        }
        if (matched != null) {
            this.set(matched);
            this.attackedPlayerEntries.remove(matched);
        }
    }

    public void handlePlayerAttack(class_1657 target) {
        boolean estBlocking;
        if (this.client == null || this.client.field_1724 == null || target == null) {
            return;
        }
        boolean bl = estBlocking = this.shieldUseTicks.getOrDefault(target, 0) >= 3;
        if (this.disablesShield((class_1657)this.client.field_1724)) {
            this.attackedPlayerEntries.put(target, new AttackEntry(this.client.field_1724.method_19538(), target.method_19538(), System.currentTimeMillis(), estBlocking));
        }
    }

    public boolean isCoolingDown(class_1657 player) {
        if (player == null) {
            return false;
        }
        if (this.client != null && this.client.field_1724 != null && player == this.client.field_1724) {
            return this.client.field_1724.method_7357().method_7904(class_1802.field_8255);
        }
        return this.cooldownManager.isCoolingDown(player);
    }

    public float getCooldownProgress(class_1657 player) {
        if (player == null) {
            return 0.0f;
        }
        if (this.client != null && this.client.field_1724 != null && player == this.client.field_1724) {
            return this.client.field_1724.method_7357().method_7905(class_1802.field_8255, 0.0f);
        }
        int remaining = this.cooldownManager.getRemainingTicks(player);
        if (remaining <= 0) {
            return 0.0f;
        }
        float frac = (float)remaining / 100.0f;
        return Math.max(0.0f, Math.min(1.0f, frac));
    }

    public boolean isUsingShield(class_1657 player, boolean factorDelay) {
        return this.shieldUseTicks.getOrDefault(player, 0) >= (factorDelay ? 5 : 1);
    }

    public boolean isHoldingUsableShield(class_1657 entity) {
        return (entity.method_6047().method_31574(class_1802.field_8255) || entity.method_6079().method_31574(class_1802.field_8255)) && !this.isHoldingAnimationItemMainHand(entity);
    }

    private boolean isHoldingAnimationItemMainHand(class_1657 entity) {
        return entity.method_6047().method_7935((class_1309)entity) != 0 && !entity.method_6047().method_31574(class_1802.field_8255);
    }

    public boolean disablesShield(class_1657 player) {
        return player != null && player.method_59958().method_7909() instanceof class_1743;
    }

    private record AttackEntry(class_243 attackPos, class_243 targetPos, long time, boolean wasBlocking) {
    }
}

