/*
 * Decompiled with CFR 0.152.
 */
package walksy.crosshairaddons.manager;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import walksy.crosshairaddons.CrosshairAddons;
import walksy.crosshairaddons.config.Config;
import walksy.crosshairaddons.manager.ShieldStateManager;
import walksy.crosshairaddons.manager.State;

public class AddonStateManager {
    private int hitmarkerTime = 0;
    private int shieldBreakTime = 0;
    private int hoveredEntityTime = 0;
    private final ShieldStateManager shieldStateManager = new ShieldStateManager(this::onShieldBreak);

    void onShieldBreak(class_1657 player) {
        this.shieldBreakTime = Config.shieldBreakDuration;
        Config.shieldBreakAddon.resetAnimation();
    }

    public void onAttackEntity(class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.shieldStateManager.handlePlayerAttack(player);
            if (Config.hitmarkerToggleOnAttack) {
                this.hitmarkerTime = Config.hitmarkerDuration;
                Config.hitmarkerAddon.resetAnimation();
            }
        }
    }

    public void onByteStatusUpdate(class_1657 player, byte arg) {
        this.shieldStateManager.handleEntityStatus(player, arg);
    }

    public void handleBreakPacket(double x, double y, double z) {
        this.shieldStateManager.handleBreakPacket(x, y, z);
    }

    public void onArrowHit() {
        this.hitmarkerTime = Config.hitmarkerDuration;
        Config.hitmarkerAddon.resetAnimation();
    }

    public void tick() {
        this.shieldStateManager.update();
        if (this.hitmarkerTime > 0) {
            --this.hitmarkerTime;
        }
        if (this.shieldBreakTime > 0) {
            --this.shieldBreakTime;
        }
    }

    public void checkTarget() {
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null && client.field_1687 != null) {
            if (client.field_1692 != null) {
                ++this.hoveredEntityTime;
                if (this.hoveredEntityTime == 1) {
                    class_1657 player;
                    Config.entityIndicatorAddon.resetAnimation();
                    class_1297 class_12972 = client.field_1692;
                    if (class_12972 instanceof class_1657 && this.shieldStateManager.isUsingShield(player = (class_1657)class_12972, Config.shieldIndicatorFactorDelay)) {
                        Config.shieldIndicatorAddon.resetAnimation();
                    }
                }
            } else {
                this.hoveredEntityTime = 0;
            }
        }
    }

    public boolean get(State state) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1687 == null) {
            return false;
        }
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case State.ELYTRA -> {
                if (class_310.method_1551().field_1724.method_6118(class_1304.field_6174).method_31574(class_1802.field_8833) && Config.elytraAddonEnabled) {
                    yield true;
                }
                yield false;
            }
            case State.HITMARKER -> {
                if ((!Config.hitmarkerStopOnAnimationEnd && this.hitmarkerTime > 0 || Config.hitmarkerStopOnAnimationEnd && !Config.hitmarkerAddon.hasPlayedOnce()) && Config.hitmarkerAddonEnabled) {
                    yield true;
                }
                yield false;
            }
            case State.SHIELD_BREAK -> {
                if ((!Config.shieldBreakStopOnAnimationEnd && this.shieldBreakTime > 0 || Config.shieldBreakStopOnAnimationEnd && !Config.shieldBreakAddon.hasPlayedOnce()) && Config.shieldBreakAddonEnabled) {
                    yield true;
                }
                yield false;
            }
            case State.SHIELD_INDICATOR -> {
                class_1657 player;
                class_1297 target = class_310.method_1551().field_1692;
                if (!Config.shieldIndicatorEnabled) {
                    yield false;
                }
                if (target instanceof class_1657 && this.shieldStateManager.isUsingShield(player = (class_1657)target, Config.shieldIndicatorFactorDelay)) {
                    yield true;
                }
                yield false;
            }
            case State.INDICATOR -> {
                class_1297 target = class_310.method_1551().field_1692;
                if (target == null || !Config.entityIndicatorAddonEnabled) {
                    yield false;
                }
                if (Config.entityIndicatorShowAll) {
                    yield true;
                }
                for (String entityID : Config.entityIndicatorEntityList) {
                    class_1299<?> type = CrosshairAddons.getEntityTypeFromString(entityID);
                    if (type == null) {
                        yield false;
                    }
                    if (!type.equals((Object)target.method_5864())) continue;
                    yield true;
                }
                yield false;
            }
        };
    }
}

