/*
 * Decompiled with CFR 0.152.
 */
package org.ylf.zpython;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ApiKeyManager {
    private final JavaPlugin plugin;
    private final File apiKeysFile;
    private final YamlConfiguration apiKeysConfig;
    private final Map<String, ApiKey> apiKeys;
    private final Logger logger;
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String SECRET_KEY = "ZPythonAPI2024!@";
    private static final String IV = "ZPythonIV2024!@#";

    public ApiKeyManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.apiKeys = new ConcurrentHashMap<String, ApiKey>();
        this.apiKeysFile = new File(plugin.getDataFolder(), "api_keys.yml");
        this.apiKeysConfig = YamlConfiguration.loadConfiguration((File)this.apiKeysFile);
        this.loadApiKeys();
    }

    public ApiKey createApiKey(final String name, final String owner, final Set<String> permissions) {
        ApiKey apiKey;
        block10: {
            final String key = this.generateApiKey();
            apiKey = new ApiKey(key, name, owner, permissions);
            this.apiKeys.put(key, apiKey);
            this.saveApiKeys();
            this.logger.info("Created API key: " + name + " for owner: " + owner);
            try {
                String baseUrl = this.plugin.getConfig().getString("dashboard.url", "");
                if (baseUrl == null || baseUrl.trim().isEmpty()) break block10;
                String serverIp = this.plugin.getServer().getIp();
                int serverPort = this.plugin.getServer().getPort();
                final String serverKey = (serverIp != null && !serverIp.isEmpty() ? serverIp : "127.0.0.1") + ":" + serverPort;
                URL url = new URL(baseUrl.replaceAll("/+$", "") + "/api/keys/sync");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(7000);
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                String json = new Gson().toJson((Object)new HashMap<String, Object>(){
                    {
                        this.put("key", key);
                        this.put("name", name);
                        this.put("owner_tag", owner);
                        this.put("permissions", new ArrayList(permissions));
                        this.put("server_key", serverKey);
                        this.put("active", true);
                        this.put("created_at", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date()));
                    }
                });
                try (OutputStream os = conn.getOutputStream();){
                    os.write(json.getBytes(StandardCharsets.UTF_8));
                }
                int code = conn.getResponseCode();
                if (code >= 200 && code < 300) {
                    this.logger.info("Synced API key to dashboard: " + name);
                } else {
                    this.logger.warning("Dashboard sync failed: HTTP " + code);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return apiKey;
    }

    private String generateApiKey() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes).replaceAll("[^a-zA-Z0-9]", "").substring(0, 32);
    }

    public boolean isValidApiKey(String key) {
        ApiKey apiKey = this.apiKeys.get(key);
        return apiKey != null && apiKey.isActive();
    }

    public ApiKey getApiKey(String key) {
        return this.apiKeys.get(key);
    }

    public boolean hasPermission(String key, String permission) {
        ApiKey apiKey = this.apiKeys.get(key);
        return apiKey != null && apiKey.hasPermission(permission);
    }

    public boolean deleteApiKey(String key) {
        ApiKey removed = this.apiKeys.remove(key);
        if (removed != null) {
            this.saveApiKeys();
            this.logger.info("Deleted API key: " + removed.getName());
            return true;
        }
        return false;
    }

    public List<ApiKey> getAllApiKeys() {
        return new ArrayList<ApiKey>(this.apiKeys.values());
    }

    public List<ApiKey> getApiKeysByOwner(String owner) {
        return this.apiKeys.values().stream().filter(key -> key.getOwner().equals(owner)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public boolean toggleApiKey(String key) {
        ApiKey apiKey = this.apiKeys.get(key);
        if (apiKey != null) {
            apiKey.setActive(!apiKey.isActive());
            this.saveApiKeys();
            this.logger.info("Toggled API key: " + apiKey.getName() + " to " + (apiKey.isActive() ? "active" : "inactive"));
            return true;
        }
        return false;
    }

    private void loadApiKeys() {
        if (!this.apiKeysFile.exists()) {
            return;
        }
        try {
            for (String key : this.apiKeysConfig.getKeys(false)) {
                String decryptedData;
                ApiKey apiKey;
                String encryptedData;
                if (key.equals("version") || (encryptedData = this.apiKeysConfig.getString(key + ".data")) == null || (apiKey = this.deserializeApiKey(key, decryptedData = this.decrypt(encryptedData))) == null) continue;
                this.apiKeys.put(key, apiKey);
            }
            this.logger.info("Loaded " + this.apiKeys.size() + " API keys");
        }
        catch (Exception e) {
            this.logger.severe("Failed to load API keys: " + e.getMessage());
        }
    }

    private void saveApiKeys() {
        try {
            this.apiKeysConfig.set("version", (Object)"1.0");
            for (ApiKey apiKey : this.apiKeys.values()) {
                String serialized = this.serializeApiKey(apiKey);
                try {
                    String encrypted = this.encrypt(serialized);
                    this.apiKeysConfig.set(apiKey.getKey() + ".data", (Object)encrypted);
                }
                catch (Exception e) {
                    this.logger.severe("Failed to encrypt API key " + apiKey.getKey() + ": " + e.getMessage());
                }
            }
            this.apiKeysConfig.save(this.apiKeysFile);
        }
        catch (IOException e) {
            this.logger.severe("Failed to save API keys: " + e.getMessage());
        }
    }

    private String encrypt(String data) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(SECRET_KEY.getBytes(StandardCharsets.UTF_8), "AES");
        IvParameterSpec iv = new IvParameterSpec(IV.getBytes(StandardCharsets.UTF_8));
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, (Key)secretKey, iv);
        byte[] encrypted = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encrypted);
    }

    private String decrypt(String encryptedData) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(SECRET_KEY.getBytes(StandardCharsets.UTF_8), "AES");
        IvParameterSpec iv = new IvParameterSpec(IV.getBytes(StandardCharsets.UTF_8));
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, (Key)secretKey, iv);
        byte[] decrypted = cipher.doFinal(Base64.getDecoder().decode(encryptedData));
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    private String serializeApiKey(ApiKey apiKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(apiKey.getName()).append("|");
        sb.append(apiKey.getOwner()).append("|");
        sb.append(apiKey.getCreatedAt()).append("|");
        sb.append(apiKey.isActive()).append("|");
        sb.append(String.join((CharSequence)",", apiKey.getPermissions()));
        return sb.toString();
    }

    private ApiKey deserializeApiKey(String key, String data) {
        try {
            String[] parts = data.split("\\|");
            if (parts.length >= 5) {
                String name = parts[0];
                String owner = parts[1];
                long createdAt = Long.parseLong(parts[2]);
                boolean active = Boolean.parseBoolean(parts[3]);
                HashSet<String> permissions = new HashSet<String>(Arrays.asList(parts[4].split(",")));
                ApiKey apiKey = new ApiKey(key, name, owner, permissions);
                apiKey.setActive(active);
                return apiKey;
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to deserialize API key: " + e.getMessage());
        }
        return null;
    }

    public static Set<String> getAllPermissions() {
        HashSet<String> permissions = new HashSet<String>();
        permissions.add("project.create");
        permissions.add("project.delete");
        permissions.add("project.run");
        permissions.add("project.stop");
        permissions.add("project.restart");
        permissions.add("project.upload");
        permissions.add("project.files.manage");
        permissions.add("project.files.view");
        permissions.add("project.folders.manage");
        permissions.add("project.libraries.manage");
        permissions.add("project.console.view");
        permissions.add("project.status.view");
        permissions.add("project.limits.manage");
        permissions.add("api.keys.manage");
        return permissions;
    }

    public static class ApiKey {
        private final String key;
        private final String name;
        private final String owner;
        private final long createdAt;
        private final Set<String> permissions;
        private boolean active;

        public ApiKey(String key, String name, String owner, Set<String> permissions) {
            this.key = key;
            this.name = name;
            this.owner = owner;
            this.createdAt = System.currentTimeMillis();
            this.permissions = new HashSet<String>(permissions);
            this.active = true;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getOwner() {
            return this.owner;
        }

        public long getCreatedAt() {
            return this.createdAt;
        }

        public Set<String> getPermissions() {
            return new HashSet<String>(this.permissions);
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void addPermission(String permission) {
            this.permissions.add(permission);
        }

        public void removePermission(String permission) {
            this.permissions.remove(permission);
        }

        public boolean hasPermission(String permission) {
            return this.active && this.permissions.contains(permission);
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("key", this.key);
            map.put("name", this.name);
            map.put("owner", this.owner);
            map.put("createdAt", this.createdAt);
            map.put("permissions", new ArrayList<String>(this.permissions));
            map.put("active", this.active);
            return map;
        }
    }
}

