/*
 * Decompiled with CFR 0.152.
 */
package org.ylf.zpython;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.ylf.zpython.ApiKeyManager;
import org.ylf.zpython.Zpython;

public class HttpApiHandler {
    private final JavaPlugin plugin;
    private final ApiKeyManager apiKeyManager;
    private final Logger logger;
    private final Gson gson;
    private HttpServer httpServer;
    private final int apiPort;
    private final String bindAddress;
    private final boolean autoStart;
    private final int maxConnections;
    private final int timeout;

    public HttpApiHandler(JavaPlugin plugin, ApiKeyManager apiKeyManager) {
        this.plugin = plugin;
        this.apiKeyManager = apiKeyManager;
        this.logger = plugin.getLogger();
        this.gson = new Gson();
        this.apiPort = plugin.getConfig().getInt("api.port", 8080);
        this.bindAddress = plugin.getConfig().getString("api.bindAddress", "0.0.0.0");
        this.autoStart = plugin.getConfig().getBoolean("api.autoStart", true);
        this.maxConnections = plugin.getConfig().getInt("api.maxConnections", 100);
        this.timeout = plugin.getConfig().getInt("api.timeout", 30000);
        this.logger.info("HttpApiHandler initialized - AutoStart: " + this.autoStart + ", Port: " + this.apiPort);
        if (this.autoStart) {
            this.startHttpServer();
        } else {
            this.logger.info("HTTP server auto-start is disabled in config");
        }
    }

    private void startHttpServer() {
        try {
            this.logger.info("Starting HTTP API server on port " + this.apiPort + " with bind address " + this.bindAddress);
            this.httpServer = new HttpServer(this.apiPort, this.maxConnections, this.timeout);
            this.httpServer.start();
            this.logger.info("HTTP API server started successfully on port " + this.apiPort);
        }
        catch (Exception e) {
            this.logger.severe("Failed to start HTTP API server on port " + this.apiPort + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void stopHttpServer() {
        if (this.httpServer != null) {
            this.httpServer.stop();
            this.logger.info("HTTP API server stopped");
        }
    }

    public void restartHttpServer() {
        this.stopHttpServer();
        this.startHttpServer();
    }

    public boolean isServerRunning() {
        return this.httpServer != null && this.httpServer.isRunning();
    }

    public int getApiPort() {
        return this.apiPort;
    }

    public int getCurrentConnections() {
        return this.httpServer != null ? this.httpServer.getCurrentConnections() : 0;
    }

    public ApiResponse handleApiRequest(String apiKey, String action, Map<String, Object> data) {
        this.logger.info("=== API REQUEST RECEIVED ===");
        this.logger.info("Action: " + action);
        this.logger.info("Data: " + String.valueOf(data));
        this.logger.info("API Key: " + (String)(apiKey != null ? apiKey.substring(0, Math.min(8, apiKey.length())) + "..." : "null"));
        boolean allowCreateWithoutKey = this.plugin.getConfig().getBoolean("api.allowCreateWithoutKey", false);
        if (!(allowCreateWithoutKey && "api.keys.manage".equals(action) && data != null && "create".equals(data.get("keyAction")) || this.apiKeyManager.isValidApiKey(apiKey))) {
            this.logger.warning("Invalid API key: " + (String)(apiKey != null ? apiKey.substring(0, Math.min(8, apiKey.length())) + "..." : "null"));
            return new ApiResponse(false, "Invalid API key", null);
        }
        ApiKeyManager.ApiKey key = this.apiKeyManager.getApiKey(apiKey);
        if (!(allowCreateWithoutKey && "api.keys.manage".equals(action) && data != null && "create".equals(data.get("keyAction")) || key != null)) {
            return new ApiResponse(false, "API key not found", null);
        }
        if (!(allowCreateWithoutKey && "api.keys.manage".equals(action) && data != null && "create".equals(data.get("keyAction")) || key.hasPermission(action))) {
            return new ApiResponse(false, "Insufficient permissions for action: " + action, null);
        }
        try {
            switch (action) {
                case "project.create": {
                    return this.handleProjectCreate(data);
                }
                case "project.delete": {
                    return this.handleProjectDelete(data);
                }
                case "project.run": {
                    return this.handleProjectRun(data);
                }
                case "project.stop": {
                    return this.handleProjectStop(data);
                }
                case "project.restart": {
                    return this.handleProjectRestart(data);
                }
                case "project.upload": {
                    return this.handleProjectUpload(data);
                }
                case "project.files.manage": {
                    return this.handleProjectFilesManage(data);
                }
                case "project.files.view": {
                    return this.handleProjectFilesView(data);
                }
                case "project.folders.manage": {
                    return this.handleProjectFoldersManage(data);
                }
                case "project.libraries.manage": {
                    return this.handleProjectLibrariesManage(data);
                }
                case "project.console.view": {
                    return this.handleProjectConsoleView(data);
                }
                case "project.status.view": {
                    return this.handleProjectStatusView(data);
                }
                case "project.limits.manage": {
                    return this.handleProjectLimitsManage(data);
                }
                case "api.keys.manage": {
                    return this.handleApiKeysManage(data);
                }
                case "project.process.start": {
                    return this.handleProjectProcessStart(data);
                }
                case "project.process.stop": {
                    return this.handleProjectProcessStop(data);
                }
                case "project.process.list": {
                    return this.handleProjectProcessList(data);
                }
                case "server.console.get": {
                    return this.handleServerConsoleGet(data);
                }
                case "server.settings.get": {
                    return this.handleServerSettingsGet(data);
                }
                case "server.settings.update": {
                    return this.handleServerSettingsUpdate(data);
                }
            }
            return new ApiResponse(false, "Unknown action: " + action, null);
        }
        catch (Exception e) {
            this.logger.severe("Error handling API request: " + e.getMessage());
            return new ApiResponse(false, "Internal server error: " + e.getMessage(), null);
        }
    }

    private ApiResponse handleProjectCreate(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        String mainFile = (String)data.get("mainFile");
        if (projectName == null || projectName.trim().isEmpty()) {
            return new ApiResponse(false, "Project name is required", null);
        }
        File projectDir = new File(this.plugin.getDataFolder(), "projects/" + projectName);
        if (projectDir.exists()) {
            return new ApiResponse(false, "Project already exists", null);
        }
        if (!projectDir.mkdirs()) {
            return new ApiResponse(false, "Failed to create project directory", null);
        }
        if (mainFile != null && !mainFile.trim().isEmpty()) {
            File mainFileObj = new File(projectDir, mainFile);
            try {
                if (!mainFileObj.createNewFile()) {
                    return new ApiResponse(false, "Failed to create main file", null);
                }
            }
            catch (IOException e) {
                return new ApiResponse(false, "Failed to create main file: " + e.getMessage(), null);
            }
        }
        File configFile = new File(projectDir, "project_config.yml");
        try {
            YamlConfiguration config = new YamlConfiguration();
            config.set("name", (Object)projectName);
            config.set("mainFile", (Object)(mainFile != null ? mainFile : "main.py"));
            config.set("createdAt", (Object)System.currentTimeMillis());
            Object cpuLimit = data.get("cpuLimit");
            Object ramLimit = data.get("ramLimit");
            Object diskLimit = data.get("diskLimit");
            if (cpuLimit != null) {
                try {
                    double cpu = Double.parseDouble(cpuLimit.toString());
                    if (cpu > 0.0 && cpu <= 100.0) {
                        config.set("limits.cpu", (Object)cpu);
                    }
                }
                catch (NumberFormatException cpu) {
                    // empty catch block
                }
            }
            if (ramLimit != null) {
                try {
                    long ram = Long.parseLong(ramLimit.toString());
                    if (ram > 0L && ram <= 10240L) {
                        config.set("limits.ram", (Object)ram);
                    }
                }
                catch (NumberFormatException ram) {
                    // empty catch block
                }
            }
            if (diskLimit != null) {
                try {
                    long disk = Long.parseLong(diskLimit.toString());
                    if (disk > 0L && disk <= 102400L) {
                        config.set("limits.disk", (Object)disk);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            config.save(configFile);
        }
        catch (IOException e) {
            this.logger.warning("Failed to create project config for " + projectName + ": " + e.getMessage());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("projectName", projectName);
        result.put("projectPath", projectDir.getAbsolutePath());
        HashMap<String, Object> limits = new HashMap<String, Object>();
        if (data.get("cpuLimit") != null) {
            limits.put("cpu", data.get("cpuLimit"));
        }
        if (data.get("ramLimit") != null) {
            limits.put("ram", data.get("ramLimit"));
        }
        if (data.get("diskLimit") != null) {
            limits.put("disk", data.get("diskLimit"));
        }
        if (!limits.isEmpty()) {
            result.put("limits", limits);
        }
        return new ApiResponse(true, "Project created successfully", result);
    }

    private ApiResponse handleProjectDelete(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        if (projectName == null || projectName.trim().isEmpty()) {
            return new ApiResponse(false, "Project name is required", null);
        }
        File projectDir = new File(this.plugin.getDataFolder(), "projects/" + projectName);
        if (!projectDir.exists()) {
            return new ApiResponse(false, "Project not found", null);
        }
        if (!this.deleteDirectory(projectDir)) {
            return new ApiResponse(false, "Failed to delete project", null);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("projectName", projectName);
        result.put("deleted", true);
        return new ApiResponse(true, "Project deleted successfully", result);
    }

    private ApiResponse handleProjectRun(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        if (projectName == null || projectName.trim().isEmpty()) {
            return new ApiResponse(false, "Project name is required", null);
        }
        try {
            if (this.plugin instanceof Zpython) {
                boolean started;
                String fileName;
                Zpython main;
                block10: {
                    main = (Zpython)this.plugin;
                    fileName = "app.py";
                    try {
                        File projectsDir = new File(main.getDataFolder(), "projects");
                        File settingsFile = new File(projectsDir, projectName + "_settings.json");
                        if (!settingsFile.exists()) break block10;
                        String json = new String(Files.readAllBytes(settingsFile.toPath()), StandardCharsets.UTF_8);
                        try {
                            String s;
                            Object v;
                            Gson _g = new Gson();
                            Map cfg = (Map)_g.fromJson(json, Map.class);
                            Object object = v = cfg != null ? (Object)cfg.get("script") : null;
                            if (v != null && !(s = v.toString().trim()).isEmpty()) {
                                fileName = s;
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception projectsDir) {
                        // empty catch block
                    }
                }
                if (!(started = main.startProjectProcess(projectName, fileName))) {
                    return new ApiResponse(false, "Failed to start project process", null);
                }
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("projectName", projectName);
            result.put("started", true);
            return new ApiResponse(true, "Project started", result);
        }
        catch (Throwable t) {
            return new ApiResponse(false, "Failed to start project: " + t.getMessage(), null);
        }
    }

    private ApiResponse handleProjectStop(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        if (projectName == null || projectName.trim().isEmpty()) {
            return new ApiResponse(false, "Project name is required", null);
        }
        try {
            if (this.plugin instanceof Zpython) {
                Zpython main = (Zpython)this.plugin;
                main.getServer().getScheduler().runTask((Plugin)main, () -> {
                    try {
                        main.stopProjectProcess(projectName, "legacy:" + projectName);
                        Map<String, String> procs = main.getProjectProcesses(projectName);
                        for (Map.Entry<String, String> e : procs.entrySet()) {
                            try {
                                main.stopProjectProcess(projectName, e.getKey());
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("projectName", projectName);
            result.put("status", "stopped");
            return new ApiResponse(true, "Project stopped successfully", result);
        }
        catch (Throwable t) {
            return new ApiResponse(false, "Failed to stop project: " + t.getMessage(), null);
        }
    }

    private ApiResponse handleProjectRestart(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        if (projectName == null || projectName.trim().isEmpty()) {
            return new ApiResponse(false, "Project name is required", null);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("projectName", projectName);
        result.put("status", "restarted");
        return new ApiResponse(true, "Project restarted successfully", result);
    }

    private ApiResponse handleProjectUpload(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        String fileName = (String)data.get("fileName");
        String fileContent = (String)data.get("fileContent");
        if (projectName == null || fileName == null || fileContent == null) {
            return new ApiResponse(false, "Project name, file name and content are required", null);
        }
        File projectDir = new File(this.plugin.getDataFolder(), "projects/" + projectName);
        if (!projectDir.exists()) {
            return new ApiResponse(false, "Project not found", null);
        }
        File file = new File(projectDir, fileName);
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try (FileWriter writer = new FileWriter(file);){
                writer.write(fileContent);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("projectName", projectName);
            result.put("fileName", fileName);
            result.put("uploaded", true);
            return new ApiResponse(true, "File uploaded successfully", result);
        }
        catch (IOException e) {
            return new ApiResponse(false, "Failed to upload file: " + e.getMessage(), null);
        }
    }

    private ApiResponse handleProjectFilesManage(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        String action = (String)data.get("fileAction");
        String fileName = (String)data.get("fileName");
        String fileContent = (String)data.get("fileContent");
        if (projectName == null || action == null || fileName == null) {
            return new ApiResponse(false, "Project name, action and file name are required", null);
        }
        File projectDir = new File(this.plugin.getDataFolder(), "projects/" + projectName);
        if (!projectDir.exists()) {
            return new ApiResponse(false, "Project not found", null);
        }
        File file = new File(projectDir, fileName);
        switch (action) {
            case "create": 
            case "update": {
                if (fileContent == null) {
                    return new ApiResponse(false, "File content is required for create/update", null);
                }
                try {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    try (FileWriter writer = new FileWriter(file);){
                        writer.write(fileContent);
                        break;
                    }
                }
                catch (IOException e) {
                    return new ApiResponse(false, "Failed to manage file: " + e.getMessage(), null);
                }
            }
            case "delete": {
                if (file.delete()) break;
                return new ApiResponse(false, "Failed to delete file", null);
            }
            default: {
                return new ApiResponse(false, "Unknown file action: " + action, null);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("projectName", projectName);
        result.put("fileName", fileName);
        result.put("action", action);
        result.put("success", true);
        return new ApiResponse(true, "File action completed successfully", result);
    }

    private ApiResponse handleProjectFilesView(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        String fileName = (String)data.get("fileName");
        if (projectName == null) {
            return new ApiResponse(false, "Project name is required", null);
        }
        File projectDir = new File(this.plugin.getDataFolder(), "projects/" + projectName);
        if (!projectDir.exists()) {
            return new ApiResponse(false, "Project not found", null);
        }
        if (fileName != null) {
            File file = new File(projectDir, fileName);
            if (!file.exists()) {
                return new ApiResponse(false, "File not found", null);
            }
            try {
                String content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("projectName", projectName);
                result.put("fileName", fileName);
                result.put("content", content);
                result.put("size", file.length());
                result.put("lastModified", file.lastModified());
                return new ApiResponse(true, "File content retrieved", result);
            }
            catch (IOException e) {
                return new ApiResponse(false, "Failed to read file: " + e.getMessage(), null);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("projectName", projectName);
        result.put("files", this.listFiles(projectDir));
        return new ApiResponse(true, "File list retrieved", result);
    }

    private ApiResponse handleProjectFoldersManage(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        String action = (String)data.get("folderAction");
        String folderName = (String)data.get("folderName");
        if (projectName == null || action == null || folderName == null) {
            return new ApiResponse(false, "Project name, action and folder name are required", null);
        }
        File projectDir = new File(this.plugin.getDataFolder(), "projects/" + projectName);
        if (!projectDir.exists()) {
            return new ApiResponse(false, "Project not found", null);
        }
        File folder = new File(projectDir, folderName);
        switch (action) {
            case "create": {
                if (folder.mkdirs()) break;
                return new ApiResponse(false, "Failed to create folder", null);
            }
            case "delete": {
                if (this.deleteDirectory(folder)) break;
                return new ApiResponse(false, "Failed to delete folder", null);
            }
            default: {
                return new ApiResponse(false, "Unknown folder action: " + action, null);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("projectName", projectName);
        result.put("folderName", folderName);
        result.put("action", action);
        result.put("success", true);
        return new ApiResponse(true, "Folder action completed successfully", result);
    }

    private ApiResponse handleProjectLibrariesManage(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        String action = (String)data.get("libraryAction");
        String libraryName = (String)data.get("libraryName");
        String libraryVersion = (String)data.get("libraryVersion");
        if (projectName == null || action == null || libraryName == null) {
            return new ApiResponse(false, "Project name, action and library name are required", null);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("projectName", projectName);
        result.put("libraryName", libraryName);
        result.put("action", action);
        result.put("success", true);
        return new ApiResponse(true, "Library action completed successfully", result);
    }

    private ApiResponse handleProjectConsoleView(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        if (projectName == null) {
            return new ApiResponse(false, "Project name is required", null);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("projectName", projectName);
        result.put("consoleOutput", "Console output not implemented yet");
        return new ApiResponse(true, "Console output retrieved", result);
    }

    private ApiResponse handleProjectStatusView(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        if (projectName == null) {
            return new ApiResponse(false, "Project name is required", null);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("projectName", projectName);
        result.put("status", "unknown");
        result.put("uptime", 0);
        result.put("memoryUsage", 0);
        result.put("cpuUsage", 0);
        return new ApiResponse(true, "Project status retrieved", result);
    }

    private ApiResponse handleProjectLimitsManage(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        String limitAction = (String)data.get("limitAction");
        if (projectName == null || projectName.trim().isEmpty()) {
            return new ApiResponse(false, "Project name is required", null);
        }
        if (limitAction == null) {
            return new ApiResponse(false, "limitAction is required", null);
        }
        File projectDir = new File(this.plugin.getDataFolder(), "projects/" + projectName);
        if (!projectDir.exists()) {
            return new ApiResponse(false, "Project not found", null);
        }
        File configFile = new File(projectDir, "project_config.yml");
        switch (limitAction.toLowerCase()) {
            case "set": {
                return this.handleProjectLimitsSet(data, configFile);
            }
            case "get": {
                return this.handleProjectLimitsGet(configFile);
            }
            case "remove": {
                return this.handleProjectLimitsRemove(data, configFile);
            }
        }
        return new ApiResponse(false, "Unknown limit action: " + limitAction, null);
    }

    private ApiResponse handleProjectLimitsSet(Map<String, Object> data, File configFile) {
        try {
            YamlConfiguration config;
            if (configFile.exists()) {
                config = YamlConfiguration.loadConfiguration((File)configFile);
            } else {
                config = new YamlConfiguration();
                config.set("name", data.get("name"));
                config.set("createdAt", (Object)System.currentTimeMillis());
            }
            Object cpuLimit = data.get("cpuLimit");
            Object ramLimit = data.get("ramLimit");
            Object diskLimit = data.get("diskLimit");
            if (cpuLimit != null) {
                try {
                    double cpu = Double.parseDouble(cpuLimit.toString());
                    if (!(cpu > 0.0) || !(cpu <= 100.0)) {
                        return new ApiResponse(false, "CPU limit must be between 0.1 and 100", null);
                    }
                    config.set("limits.cpu", (Object)cpu);
                }
                catch (NumberFormatException e) {
                    return new ApiResponse(false, "Invalid CPU limit value", null);
                }
            }
            if (ramLimit != null) {
                try {
                    long ram = Long.parseLong(ramLimit.toString());
                    if (ram <= 0L || ram > 10240L) {
                        return new ApiResponse(false, "RAM limit must be between 1 and 10240 MB", null);
                    }
                    config.set("limits.ram", (Object)ram);
                }
                catch (NumberFormatException e) {
                    return new ApiResponse(false, "Invalid RAM limit value", null);
                }
            }
            if (diskLimit != null) {
                try {
                    long disk = Long.parseLong(diskLimit.toString());
                    if (disk <= 0L || disk > 102400L) {
                        return new ApiResponse(false, "Disk limit must be between 1 and 102400 MB", null);
                    }
                    config.set("limits.disk", (Object)disk);
                }
                catch (NumberFormatException e) {
                    return new ApiResponse(false, "Invalid disk limit value", null);
                }
            }
            config.save(configFile);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("projectName", data.get("name"));
            result.put("limits", this.getCurrentLimits(config));
            return new ApiResponse(true, "Project limits updated successfully", result);
        }
        catch (IOException e) {
            return new ApiResponse(false, "Failed to update project limits: " + e.getMessage(), null);
        }
    }

    private ApiResponse handleProjectLimitsGet(File configFile) {
        if (!configFile.exists()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("limits", new HashMap());
            return new ApiResponse(true, "No limits configured for project", result);
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("limits", this.getCurrentLimits(config));
            return new ApiResponse(true, "Project limits retrieved successfully", result);
        }
        catch (Exception e) {
            return new ApiResponse(false, "Failed to read project limits: " + e.getMessage(), null);
        }
    }

    private ApiResponse handleProjectLimitsRemove(Map<String, Object> data, File configFile) {
        try {
            if (!configFile.exists()) {
                return new ApiResponse(false, "Project configuration not found", null);
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            String limitType = (String)data.get("limitType");
            if (limitType == null) {
                return new ApiResponse(false, "limitType is required (cpu, ram, disk, or all)", null);
            }
            switch (limitType.toLowerCase()) {
                case "cpu": {
                    config.set("limits.cpu", null);
                    break;
                }
                case "ram": {
                    config.set("limits.ram", null);
                    break;
                }
                case "disk": {
                    config.set("limits.disk", null);
                    break;
                }
                case "all": {
                    config.set("limits", null);
                    break;
                }
                default: {
                    return new ApiResponse(false, "Invalid limit type. Use: cpu, ram, disk, or all", null);
                }
            }
            config.save(configFile);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("projectName", data.get("name"));
            result.put("removed", limitType);
            return new ApiResponse(true, "Project limit removed successfully", result);
        }
        catch (IOException e) {
            return new ApiResponse(false, "Failed to remove project limit: " + e.getMessage(), null);
        }
    }

    private Map<String, Object> getCurrentLimits(YamlConfiguration config) {
        HashMap<String, Object> limits = new HashMap<String, Object>();
        if (config.contains("limits.cpu")) {
            limits.put("cpu", config.getDouble("limits.cpu"));
        }
        if (config.contains("limits.ram")) {
            limits.put("ram", config.getLong("limits.ram"));
        }
        if (config.contains("limits.disk")) {
            limits.put("disk", config.getLong("limits.disk"));
        }
        return limits;
    }

    private ApiResponse handleApiKeysManage(Map<String, Object> data) {
        String action = (String)data.get("keyAction");
        if (action == null) {
            return new ApiResponse(false, "Key action is required", null);
        }
        switch (action) {
            case "list": {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("apiKeys", this.apiKeyManager.getAllApiKeys().stream().map(ApiKeyManager.ApiKey::toMap).collect(Collectors.toList()));
                return new ApiResponse(true, "API keys list retrieved", result);
            }
            case "create": {
                String name = (String)data.get("name");
                String owner = this.plugin.getConfig().getString("discordOwnerTag", "");
                HashSet<String> permissions = new HashSet((List)data.get("permissions"));
                if (name == null || name.trim().isEmpty()) {
                    return new ApiResponse(false, "Name is required", null);
                }
                if (permissions == null || permissions.isEmpty()) {
                    permissions = ApiKeyManager.getAllPermissions();
                }
                ApiKeyManager.ApiKey newKey = this.apiKeyManager.createApiKey(name, owner, permissions);
                HashMap<String, Object> createResult = new HashMap<String, Object>();
                createResult.put("apiKey", newKey.toMap());
                return new ApiResponse(true, "API key created successfully", createResult);
            }
            case "delete": {
                String keyToDelete = (String)data.get("key");
                if (keyToDelete == null) {
                    return new ApiResponse(false, "API key is required for deletion", null);
                }
                boolean deleted = this.apiKeyManager.deleteApiKey(keyToDelete);
                if (deleted) {
                    HashMap<String, Object> deleteResult = new HashMap<String, Object>();
                    deleteResult.put("deleted", true);
                    return new ApiResponse(true, "API key deleted successfully", deleteResult);
                }
                return new ApiResponse(false, "Failed to delete API key", null);
            }
            case "toggle": {
                String keyToToggle = (String)data.get("key");
                if (keyToToggle == null) {
                    return new ApiResponse(false, "API key is required for toggle", null);
                }
                boolean toggled = this.apiKeyManager.toggleApiKey(keyToToggle);
                if (toggled) {
                    ApiKeyManager.ApiKey toggledKey = this.apiKeyManager.getApiKey(keyToToggle);
                    HashMap<String, Object> toggleResult = new HashMap<String, Object>();
                    toggleResult.put("apiKey", toggledKey.toMap());
                    return new ApiResponse(true, "API key toggled successfully", toggleResult);
                }
                return new ApiResponse(false, "Failed to toggle API key", null);
            }
        }
        return new ApiResponse(false, "Unknown key action: " + action, null);
    }

    private ApiResponse handleProjectProcessStart(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        String fileName = (String)data.get("fileName");
        this.logger.info("Starting project process: " + projectName + " with file: " + fileName);
        if (projectName == null || fileName == null) {
            this.logger.warning("Project name or file name is null");
            return new ApiResponse(false, "Project name and file name are required", null);
        }
        if (this.plugin instanceof Zpython) {
            Zpython main = (Zpython)this.plugin;
            boolean success = main.startProjectProcess(projectName, fileName);
            this.logger.info("Process start result: " + success);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("projectName", projectName);
            result.put("fileName", fileName);
            result.put("started", success);
            return new ApiResponse(success, success ? "Process started successfully" : "Failed to start process", result);
        }
        this.logger.warning("Plugin instance not available");
        return new ApiResponse(false, "Plugin instance not available", null);
    }

    private ApiResponse handleProjectProcessStop(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        String fileName = (String)data.get("fileName");
        if (projectName == null || fileName == null) {
            return new ApiResponse(false, "Project name and file name are required", null);
        }
        if (this.plugin instanceof Zpython) {
            Zpython main = (Zpython)this.plugin;
            boolean success = main.stopProjectProcess(projectName, fileName);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("projectName", projectName);
            result.put("fileName", fileName);
            result.put("stopped", success);
            return new ApiResponse(success, success ? "Process stopped successfully" : "Process not found or already stopped", result);
        }
        return new ApiResponse(false, "Plugin instance not available", null);
    }

    private ApiResponse handleProjectProcessList(Map<String, Object> data) {
        String projectName = (String)data.get("name");
        this.logger.info("Getting process list for project: " + projectName);
        if (projectName == null) {
            this.logger.warning("Project name is null");
            return new ApiResponse(false, "Project name is required", null);
        }
        if (this.plugin instanceof Zpython) {
            Zpython main = (Zpython)this.plugin;
            Map<String, String> processes = main.getProjectProcesses(projectName);
            this.logger.info("Found " + processes.size() + " processes for project " + projectName + ": " + String.valueOf(processes));
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("projectName", projectName);
            result.put("processes", processes);
            result.put("count", processes.size());
            return new ApiResponse(true, "Process list retrieved", result);
        }
        this.logger.warning("Plugin instance not available");
        return new ApiResponse(false, "Plugin instance not available", null);
    }

    private ApiResponse handleServerConsoleGet(Map<String, Object> data) {
        if (this.plugin instanceof Zpython) {
            Zpython main = (Zpython)this.plugin;
            List<String> consoleLines = main.getServerConsoleLines();
            int since = ((Number)data.getOrDefault("since", 0)).intValue();
            List<Object> lines = new ArrayList();
            if (since < consoleLines.size()) {
                lines = consoleLines.subList(since, consoleLines.size());
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("lines", lines);
            result.put("next", consoleLines.size());
            result.put("total", consoleLines.size());
            return new ApiResponse(true, "Console lines retrieved", result);
        }
        return new ApiResponse(false, "Plugin instance not available", null);
    }

    private ApiResponse handleServerSettingsGet(Map<String, Object> data) {
        if (this.plugin instanceof Zpython) {
            Zpython main = (Zpython)this.plugin;
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("serverName", main.getServerName());
            result.put("settings", main.getServerSettings());
            result.put("config", main.getServerConfig());
            return new ApiResponse(true, "Server settings retrieved", result);
        }
        return new ApiResponse(false, "Plugin instance not available", null);
    }

    private ApiResponse handleServerSettingsUpdate(Map<String, Object> data) {
        if (this.plugin instanceof Zpython) {
            Map config;
            Zpython main = (Zpython)this.plugin;
            String serverName = (String)data.get("serverName");
            boolean success = main.updateServerSettings(serverName, config = (Map)data.get("config"));
            if (success) {
                return new ApiResponse(true, "Server settings updated successfully", null);
            }
            return new ApiResponse(false, "Failed to update server settings", null);
        }
        return new ApiResponse(false, "Plugin instance not available", null);
    }

    private boolean deleteDirectory(File dir) {
        File[] files;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                this.deleteDirectory(file);
            }
        }
        return dir.delete();
    }

    private Map<String, Object> listFiles(File dir) {
        File[] files;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                HashMap<String, Object> fileInfo = new HashMap<String, Object>();
                fileInfo.put("name", file.getName());
                fileInfo.put("isDirectory", file.isDirectory());
                fileInfo.put("size", file.length());
                fileInfo.put("lastModified", file.lastModified());
                result.put(file.getName(), fileInfo);
            }
        }
        return result;
    }

    private class HttpServer {
        private final int port;
        private final int maxConnections;
        private final int timeout;
        private ServerSocket serverSocket;
        private boolean running;
        private int currentConnections = 0;
        private final Object connectionLock = new Object();

        public HttpServer(int port, int maxConnections, int timeout) {
            this.port = port;
            this.maxConnections = maxConnections;
            this.timeout = timeout;
        }

        public void start() throws IOException {
            InetAddress bindInet = InetAddress.getByName(HttpApiHandler.this.bindAddress);
            try {
                this.serverSocket = new ServerSocket(this.port, 50, bindInet);
            }
            catch (BindException be) {
                if (!"0.0.0.0".equals(HttpApiHandler.this.bindAddress)) {
                    HttpApiHandler.this.logger.warning("Failed to bind to " + HttpApiHandler.this.bindAddress + ":" + this.port + " (" + be.getMessage() + "). Falling back to 0.0.0.0");
                    this.serverSocket = new ServerSocket(this.port, 50, InetAddress.getByName("0.0.0.0"));
                }
                throw be;
            }
            this.serverSocket.setSoTimeout(this.timeout);
            this.running = true;
            String actualBind = this.serverSocket.getInetAddress().getHostAddress();
            HttpApiHandler.this.logger.info("HTTP API server listening on " + actualBind + ":" + this.port + " (timeout=" + this.timeout + "ms, maxConnections=" + this.maxConnections + ")");
            new Thread(() -> {
                while (this.running) {
                    try {
                        Socket clientSocket = this.serverSocket.accept();
                        Object object = this.connectionLock;
                        synchronized (object) {
                            if (this.currentConnections >= this.maxConnections) {
                                HttpApiHandler.this.logger.warning("API connection limit reached (" + this.maxConnections + "), rejecting connection from " + (clientSocket.getInetAddress() != null ? clientSocket.getInetAddress().getHostAddress() : "unknown"));
                                clientSocket.close();
                                continue;
                            }
                            ++this.currentConnections;
                        }
                        new Thread(() -> {
                            try {
                                this.handleClient(clientSocket);
                            }
                            finally {
                                Object object = this.connectionLock;
                                synchronized (object) {
                                    --this.currentConnections;
                                }
                            }
                        }).start();
                    }
                    catch (SocketTimeoutException e) {
                    }
                    catch (IOException e) {
                        if (!this.running) continue;
                        HttpApiHandler.this.logger.warning("API accept error: " + e.getMessage());
                    }
                }
            }).start();
        }

        public void stop() {
            this.running = false;
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public boolean isRunning() {
            return this.running;
        }

        public int getCurrentConnections() {
            return this.currentConnections;
        }

        private void handleClient(Socket clientSocket) {
            try (Socket socket = clientSocket;){
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                String clientIp = clientSocket.getInetAddress() != null ? clientSocket.getInetAddress().getHostAddress() : "unknown";
                String requestLine = in.readLine();
                if (requestLine == null) {
                    return;
                }
                String[] parts = requestLine.split(" ");
                if (parts.length < 3) {
                    return;
                }
                String method = parts[0];
                String path = parts[1];
                HashMap<String, String> headers = new HashMap<String, String>();
                while ((line = in.readLine()) != null && !line.isEmpty()) {
                    if (!line.contains(":")) continue;
                    String[] header = line.split(":", 2);
                    headers.put(header[0].trim().toLowerCase(), header[1].trim());
                }
                StringBuilder body = new StringBuilder();
                if (headers.containsKey("content-length")) {
                    int contentLength = Integer.parseInt((String)headers.get("content-length"));
                    char[] buffer = new char[contentLength];
                    in.read(buffer, 0, contentLength);
                    body.append(buffer);
                }
                String response = this.handleRequest(method, path, headers, body.toString(), clientIp);
                String contentType = "application/json";
                out.println("HTTP/1.1 200 OK");
                out.println("Content-Type: " + contentType);
                out.println("Access-Control-Allow-Origin: *");
                out.println("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
                out.println("Access-Control-Allow-Headers: Content-Type, Authorization");
                out.println("Content-Length: " + response.getBytes(StandardCharsets.UTF_8).length);
                out.println();
                out.println(response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private String handleRequest(String method, String path, Map<String, String> headers, String body, String clientIp) {
            try {
                if (method.equals("OPTIONS")) {
                    return "";
                }
                if (method.equals("POST") && path.equals("/api")) {
                    Map requestData = (Map)HttpApiHandler.this.gson.fromJson(body, Map.class);
                    if (requestData == null) {
                        HttpApiHandler.this.logger.warning("API request: invalid JSON from " + clientIp);
                        return this.createErrorResponse("Invalid JSON request");
                    }
                    String apiKey = (String)requestData.get("apiKey");
                    String action = (String)requestData.get("action");
                    Map data = (Map)requestData.get("data");
                    if (apiKey == null || action == null) {
                        HttpApiHandler.this.logger.warning("API request: missing fields from " + clientIp + ", action=" + action);
                        return this.createErrorResponse("Missing apiKey or action");
                    }
                    String maskedKey = apiKey.length() > 8 ? apiKey.substring(0, 4) + "***" + apiKey.substring(apiKey.length() - 4) : "***";
                    String owner = null;
                    try {
                        ApiKeyManager.ApiKey k = HttpApiHandler.this.apiKeyManager.getApiKey(apiKey);
                        if (k != null) {
                            owner = k.getOwner();
                        }
                    }
                    catch (Exception k) {
                        // empty catch block
                    }
                    HttpApiHandler.this.logger.info("API request from " + clientIp + ": action='" + action + "', key=" + maskedKey + (String)(owner != null ? ", owner='" + owner + "'" : ""));
                    ApiResponse apiResponse = HttpApiHandler.this.handleApiRequest(apiKey, action, data != null ? data : new HashMap());
                    if (apiResponse != null) {
                        HttpApiHandler.this.logger.info("API result to " + clientIp + ": action='" + action + "' => " + (apiResponse.isSuccess() ? "success" : "fail") + (String)(apiResponse.getMessage() != null ? ": " + apiResponse.getMessage() : ""));
                    }
                    return apiResponse.toJson();
                }
                if (method.equals("POST") && ("/api/project/run".equals(path) || "/api/project/stop".equals(path))) {
                    Map<String, String> requestData = new HashMap();
                    try {
                        if (body != null && !body.isEmpty() && body.trim().startsWith("{")) {
                            requestData = (Map)HttpApiHandler.this.gson.fromJson(body, Map.class);
                        } else if (body != null && !body.isEmpty()) {
                            String[] pairs;
                            for (String p : pairs = body.split("&")) {
                                int idx = p.indexOf(61);
                                if (idx <= 0) continue;
                                String k = URLDecoder.decode(p.substring(0, idx), StandardCharsets.UTF_8);
                                String v = URLDecoder.decode(p.substring(idx + 1), StandardCharsets.UTF_8);
                                requestData.put(k, v);
                            }
                        }
                    }
                    catch (Exception pairs) {
                        // empty catch block
                    }
                    String apiKey = (String)requestData.get("apiKey");
                    String name = (String)requestData.get("name");
                    String action = "/api/project/run".equals(path) ? "project.run" : "project.stop";
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    if (name != null) {
                        data.put("name", name);
                    }
                    ApiResponse resp = HttpApiHandler.this.handleApiRequest(apiKey, action, data);
                    return resp.toJson();
                }
                HttpApiHandler.this.logger.warning("HTTP unknown endpoint from " + clientIp + ": method=" + method + ", path=" + path);
                return this.createErrorResponse("Endpoint not found");
            }
            catch (Exception e) {
                HttpApiHandler.this.logger.severe("HTTP handler error for " + clientIp + ": " + e.getMessage());
                return this.createErrorResponse("Internal server error: " + e.getMessage());
            }
        }

        private String createErrorResponse(String message) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", false);
            response.put("message", message);
            response.put("data", null);
            return new Gson().toJson(response);
        }
    }

    public static class ApiResponse {
        private final boolean success;
        private final String message;
        private final Map<String, Object> data;

        public ApiResponse(boolean success, String message, Map<String, Object> data) {
            this.success = success;
            this.message = message;
            this.data = data;
        }

        public String toJson() {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", this.success);
            response.put("message", this.message);
            if (this.data != null) {
                response.put("data", this.data);
            }
            return new Gson().toJson(response);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public Map<String, Object> getData() {
            return this.data;
        }
    }
}

