/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.services.PunishmentService;
import me.wethink.weGuardian.services.TemplateService;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class KickCommand
implements CommandExecutor,
TabCompleter {
    private final WeGuardian plugin;
    private final PunishmentService punishmentService;
    private final TemplateService templateService;

    public KickCommand(WeGuardian plugin, PunishmentService punishmentService) {
        this.plugin = plugin;
        this.punishmentService = punishmentService;
        this.templateService = plugin.getTemplateService();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("weguardian.kick")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(MessageUtils.colorize("&cUsage: /kick <player> <reason> [-s] [-t template] [--ip]"));
            sender.sendMessage(MessageUtils.colorize("&7Options:"));
            sender.sendMessage(MessageUtils.colorize("&7  -s: Silent kick (no broadcast)"));
            sender.sendMessage(MessageUtils.colorize("&7  -t <template>: Use punishment template"));
            sender.sendMessage(MessageUtils.colorize("&7  --ip: Kick all players with same IP"));
            return true;
        }
        String targetName = args[0];
        boolean silent = false;
        boolean ipKick = false;
        ArrayList<String> reasonParts = new ArrayList<String>();
        String tempTemplate = null;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-s")) {
                silent = true;
                continue;
            }
            if (arg.equals("--ip")) {
                ipKick = true;
                continue;
            }
            if (arg.equals("-t") && i + 1 < args.length) {
                tempTemplate = args[i + 1];
                ++i;
                continue;
            }
            reasonParts.add(arg);
        }
        boolean finalSilent = silent;
        String template = tempTemplate;
        if (reasonParts.isEmpty()) {
            sender.sendMessage(MessageUtils.colorize("&cYou must provide a reason for the kick."));
            return true;
        }
        String reason = String.join((CharSequence)" ", reasonParts);
        if (ipKick) {
            this.handleIPKick(sender, targetName, reason, finalSilent, template);
            return true;
        }
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            sender.sendMessage(MessageUtils.colorize("&cPlayer '" + targetName + "' is not online."));
            return true;
        }
        UUID targetUuid = target.getUniqueId();
        this.plugin.getPunishmentService().canPunish(sender, targetUuid).thenAccept(canPunish -> {
            if (!canPunish.booleanValue()) {
                sender.sendMessage(MessageUtils.colorize("&cYou cannot kick this player due to permission hierarchy."));
                return;
            }
            String staffName = sender.getName();
            if (template != null && this.templateService.hasTemplate(template)) {
                this.templateService.executePunishmentFromTemplate(target.getUniqueId(), target.getName(), staffName, template, reason).thenAccept(success -> {
                    if (success.booleanValue()) {
                        sender.sendMessage(MessageUtils.colorize("&aSuccessfully applied template '" + template + "' punishment to " + target.getName()));
                    } else {
                        sender.sendMessage(MessageUtils.colorize("&cFailed to apply template punishment."));
                    }
                });
            } else {
                ((CompletableFuture)this.punishmentService.kick(target.getName(), staffName, reason).thenAccept(success -> {
                    if (success.booleanValue()) {
                        String message = "&aSuccessfully kicked " + target.getName() + " for: &e" + reason;
                        if (finalSilent) {
                            message = message + " &7(Silent)";
                        }
                        sender.sendMessage(MessageUtils.colorize(message));
                        this.plugin.getLogger().info(staffName + " kicked " + target.getName() + " for: " + reason + (finalSilent ? " (Silent)" : ""));
                    } else {
                        sender.sendMessage(MessageUtils.colorize("&cFailed to kick " + target.getName() + ". Player may have disconnected."));
                    }
                })).exceptionally(throwable -> {
                    sender.sendMessage(MessageUtils.colorize("&cError processing kick: " + throwable.getMessage()));
                    this.plugin.getLogger().severe("Error in kick command: " + throwable.getMessage());
                    return null;
                });
            }
        });
        return true;
    }

    private void handleIPKick(CommandSender sender, String targetName, String reason, boolean silent, String template) {
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            sender.sendMessage(MessageUtils.colorize("&cPlayer '" + targetName + "' is not online."));
            return;
        }
        if (!sender.hasPermission("weguardian.ipkick")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use IP kick."));
            return;
        }
        UUID targetUuid = target.getUniqueId();
        this.plugin.getPunishmentService().canPunish(sender, targetUuid).thenAccept(canPunish -> {
            if (!canPunish.booleanValue()) {
                sender.sendMessage(MessageUtils.colorize("&cYou cannot kick this player due to permission hierarchy."));
                return;
            }
            String targetIP = target.getAddress().getAddress().getHostAddress();
            String staffName = sender.getName();
            ArrayList playersToKick = new ArrayList();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getAddress().getAddress().getHostAddress().equals(targetIP)) continue;
                this.plugin.getPunishmentService().canPunish(sender, player.getUniqueId()).thenAccept(canPunishPlayer -> {
                    if (canPunishPlayer.booleanValue()) {
                        playersToKick.add(player);
                    }
                });
            }
            if (playersToKick.isEmpty()) {
                sender.sendMessage(MessageUtils.colorize("&cNo kickable players found with IP: " + targetIP));
                return;
            }
            for (Player player : playersToKick) {
                this.punishmentService.kick(player.getName(), staffName, reason + " (IP Kick)").thenAccept(success -> {
                    if (success.booleanValue()) {
                        String message = "&aIP kicked " + player.getName() + " (" + targetIP + ") for: &e" + reason;
                        if (silent) {
                            message = message + " &7(Silent)";
                        }
                        sender.sendMessage(MessageUtils.colorize(message));
                        this.plugin.getLogger().info(staffName + " IP kicked " + player.getName() + " (" + targetIP + ") for: " + reason + (silent ? " (Silent)" : ""));
                    }
                });
            }
            sender.sendMessage(MessageUtils.colorize("&aKicked " + playersToKick.size() + " player(s) with IP: " + targetIP));
        });
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(player.getName());
            }
        } else if (args.length > 1) {
            String lastArg = args[args.length - 1];
            if (args.length > 2 && args[args.length - 2].equals("-t")) {
                this.templateService.getAllTemplates().forEach(template -> {
                    if (template.getName().toLowerCase().startsWith(lastArg.toLowerCase())) {
                        completions.add(template.getName());
                    }
                });
            } else {
                if (!Arrays.asList(args).contains("-s")) {
                    completions.add("-s");
                }
                if (!Arrays.asList(args).contains("-t")) {
                    completions.add("-t");
                }
                if (!Arrays.asList(args).contains("--ip") && sender.hasPermission("weguardian.ipkick")) {
                    completions.add("--ip");
                }
                completions.addAll(Arrays.asList("Inappropriate behavior", "Spam", "Disrespect", "AFK", "Lag", "Rule violation", "Trolling", "Reconnect"));
            }
        }
        return completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

