/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class WeGuardianCommand
implements CommandExecutor,
TabCompleter {
    private final WeGuardian plugin;

    public WeGuardianCommand(WeGuardian plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.showHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "about": {
                this.handleAbout(sender);
                break;
            }
            case "version": {
                this.handleVersion(sender);
                break;
            }
            case "help": {
                this.showHelp(sender);
                break;
            }
            default: {
                this.showHelp(sender);
            }
        }
        return true;
    }

    private void handleReload(CommandSender sender) {
        if (!sender.hasPermission("weguardian.reload")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to reload the plugin."));
            return;
        }
        sender.sendMessage(MessageUtils.colorize("&6\u26a1 Reloading WeGuardian..."));
        try {
            this.plugin.reloadConfigurations();
            this.plugin.getTemplateService().reloadTemplates();
            sender.sendMessage(MessageUtils.colorize("&a\u2713 Reload complete"));
            sender.sendMessage(MessageUtils.colorize("&7  - config.yml"));
            sender.sendMessage(MessageUtils.colorize("&7  - messages.yml"));
            sender.sendMessage(MessageUtils.colorize("&7  - gui/*.yml"));
            sender.sendMessage(MessageUtils.colorize("&7  - templates.yml"));
        }
        catch (Exception e) {
            sender.sendMessage(MessageUtils.colorize("&c\u2717 Error reloading: " + e.getMessage()));
            this.plugin.getLogger().severe("Error reloading configuration: " + e.getMessage());
        }
    }

    private void handleAbout(CommandSender sender) {
        sender.sendMessage(MessageUtils.colorize("&6&l=== WeGuardian Plugin Information ==="));
        sender.sendMessage(MessageUtils.colorize("&7Version: &f" + this.plugin.getPluginMeta().getVersion()));
        sender.sendMessage(MessageUtils.colorize("&7Authors: &f" + String.join((CharSequence)", ", this.plugin.getPluginMeta().getAuthors())));
        sender.sendMessage(MessageUtils.colorize("&7Description: &f" + this.plugin.getPluginMeta().getDescription()));
        sender.sendMessage(MessageUtils.colorize("&7Website: &f" + this.plugin.getPluginMeta().getWebsite()));
        sender.sendMessage("");
        sender.sendMessage(MessageUtils.colorize("&6Features:"));
        sender.sendMessage(MessageUtils.colorize("&7  \u2022 GUI-driven punishment system"));
        sender.sendMessage(MessageUtils.colorize("&7  \u2022 Cross-server MySQL support"));
        sender.sendMessage(MessageUtils.colorize("&7  \u2022 ActionBar + Chat notifications"));
        sender.sendMessage(MessageUtils.colorize("&7  \u2022 Staff statistics & accountability"));
        sender.sendMessage(MessageUtils.colorize("&7  \u2022 PlaceholderAPI integration"));
        sender.sendMessage(MessageUtils.colorize("&7  \u2022 Folia & Paper compatible"));
        sender.sendMessage("");
        sender.sendMessage(MessageUtils.colorize("&7Use &f/weguardian help &7for command list"));
    }

    private void handleVersion(CommandSender sender) {
        sender.sendMessage(MessageUtils.colorize("&6WeGuardian &7v" + this.plugin.getPluginMeta().getVersion()));
        sender.sendMessage(MessageUtils.colorize("&7Running on: &f" + this.plugin.getServer().getName() + " " + this.plugin.getServer().getVersion()));
        sender.sendMessage(MessageUtils.colorize("&7Java Version: &f" + System.getProperty("java.version")));
        String dbType = this.plugin.getConfig().getBoolean("database.mysql.enabled", false) ? "MySQL" : "SQLite";
        sender.sendMessage(MessageUtils.colorize("&7Database: &f" + dbType));
        boolean placeholderAPI = this.plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI");
        sender.sendMessage(MessageUtils.colorize("&7PlaceholderAPI: " + (placeholderAPI ? "&aEnabled" : "&cDisabled")));
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage(MessageUtils.colorize("&6&l=== WeGuardian Commands ==="));
        sender.sendMessage(MessageUtils.colorize("&f/weguardian reload &7- Reload all configuration files"));
        sender.sendMessage(MessageUtils.colorize("&f/weguardian about &7- Show plugin information"));
        sender.sendMessage(MessageUtils.colorize("&f/weguardian version &7- Show version details"));
        sender.sendMessage(MessageUtils.colorize("&f/weguardian help &7- Show this help menu"));
        sender.sendMessage("");
        sender.sendMessage(MessageUtils.colorize("&6Main Commands:"));
        sender.sendMessage(MessageUtils.colorize("&f/punish <player> &7- Open punishment GUI"));
        sender.sendMessage(MessageUtils.colorize("&f/history <player> &7- View punishment history"));
        sender.sendMessage(MessageUtils.colorize("&f/checkban <player> &7- Check ban/mute status"));
        sender.sendMessage(MessageUtils.colorize("&f/stats &7- View global statistics"));
        sender.sendMessage("");
        sender.sendMessage(MessageUtils.colorize("&7For full command list, see the plugin documentation"));
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("reload", "about", "version", "help");
            return subCommands.stream().filter(cmd -> cmd.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

