/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.gui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import me.wethink.weGuardian.WeGuardian;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class GUIConfigLoader {
    private final WeGuardian plugin;
    private final Map<String, FileConfiguration> guiConfigs = new HashMap<String, FileConfiguration>();
    private final String[] guiFiles = new String[]{"main", "ban", "tempban", "mute", "tempmute", "kick", "warn", "notes", "unban", "unmute"};

    public GUIConfigLoader(WeGuardian plugin) {
        this.plugin = plugin;
        this.loadAllGUIConfigs();
    }

    private void loadAllGUIConfigs() {
        File guiFolder = new File(this.plugin.getDataFolder(), "gui");
        if (!guiFolder.exists()) {
            guiFolder.mkdirs();
        }
        for (String guiName : this.guiFiles) {
            String fileName = guiName + ".yml";
            File guiFile = new File(guiFolder, fileName);
            if (!guiFile.exists()) {
                this.saveDefaultGUIFile(fileName, guiFile);
            }
            try {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)guiFile);
                this.guiConfigs.put(guiName, (FileConfiguration)config);
                this.plugin.debug("Loaded GUI config: " + fileName);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to load GUI config " + fileName + ": " + e.getMessage());
            }
        }
    }

    private void saveDefaultGUIFile(String fileName, File guiFile) {
        try (InputStream resource = this.plugin.getResource("gui/" + fileName);){
            if (resource != null) {
                Files.copy(resource, guiFile.toPath(), new CopyOption[0]);
                this.plugin.getLogger().info("Created default GUI file: " + fileName);
            } else {
                this.plugin.getLogger().warning("Default GUI file not found in resources: " + fileName);
                this.createMinimalGUIFile(guiFile, fileName);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save default GUI file " + fileName + ": " + e.getMessage());
            this.createMinimalGUIFile(guiFile, fileName);
        }
    }

    private void createMinimalGUIFile(File guiFile, String fileName) {
        try {
            if (guiFile.createNewFile()) {
                this.plugin.getLogger().info("Created minimal GUI file: " + fileName);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to create minimal GUI file " + fileName + ": " + e.getMessage());
        }
    }

    public FileConfiguration getGUIConfig(String guiName) {
        return this.guiConfigs.get(guiName);
    }

    public void reloadGUIConfig(String guiName) {
        File guiFile = new File(this.plugin.getDataFolder(), "gui/" + guiName + ".yml");
        if (guiFile.exists()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)guiFile);
            this.guiConfigs.put(guiName, (FileConfiguration)config);
        }
    }

    public void reloadAllGUIConfigs() {
        this.guiConfigs.clear();
        this.loadAllGUIConfigs();
    }
}

