/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.gui.menus;

import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.gui.MenuHandler;
import me.wethink.weGuardian.gui.menus.MenuManager;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class BanMenu
extends MenuHandler {
    private final MenuManager menuManager;

    public BanMenu(WeGuardian plugin, MenuManager menuManager) {
        super(plugin, "ban");
        this.menuManager = menuManager;
    }

    @Override
    protected ConfigurationSection getMenuConfig() {
        return this.plugin.getGUIConfigLoader().getGUIConfig("ban");
    }

    @Override
    protected void handleItemClick(Player staff, String targetPlayer, String itemKey, ConfigurationSection itemConfig) {
        String reason;
        String menuType;
        String[] parts;
        String action = itemConfig.getString("action", "");
        this.plugin.getLogger().info("BanMenu: Player " + staff.getName() + " clicked item " + itemKey + " with action: " + action);
        if (action.startsWith("execute_punishment:") && (parts = action.split(":", 3)).length >= 3) {
            String punishmentType = parts[1];
            String reason2 = parts[2];
            this.executeBan(staff, targetPlayer, reason2);
            return;
        }
        if (action.startsWith("open_menu:") && (menuType = action.substring("open_menu:".length())).equals("main")) {
            this.menuManager.setActiveMenu(staff, this.menuManager.getMainMenu());
            this.menuManager.getMainMenu().openMenu(staff, targetPlayer);
            return;
        }
        if (action.equals("back") || itemKey.equals("back")) {
            this.menuManager.setActiveMenu(staff, this.menuManager.getMainMenu());
            this.menuManager.getMainMenu().openMenu(staff, targetPlayer);
            return;
        }
        if (action.equals("close") || itemKey.equals("close")) {
            staff.closeInventory();
            return;
        }
        if (action.startsWith("custom_reason:")) {
            staff.sendMessage(MessageUtils.colorize("&eCustom input feature coming in next update!"));
            staff.sendMessage(MessageUtils.colorize("&7For now, please use the predefined options."));
            return;
        }
        if (itemConfig.contains("reason")) {
            reason = itemConfig.getString("reason", "No reason specified");
            this.executeBan(staff, targetPlayer, reason);
            return;
        }
        reason = itemConfig.getString("reason", itemConfig.getString("default-reason", "No reason specified"));
        this.executeBan(staff, targetPlayer, reason);
    }

    private void executeBan(Player staff, String targetPlayer, String reason) {
        staff.closeInventory();
        this.clearSelectedData(staff);
        staff.sendMessage(MessageUtils.colorize("&eExecuting ban on &a" + targetPlayer + " &efor: &f" + reason));
        ((CompletableFuture)this.plugin.getPunishmentService().ban(targetPlayer, staff.getName(), reason).thenAccept(success -> {
            if (success.booleanValue()) {
                staff.sendMessage(MessageUtils.colorize("&aSuccessfully banned " + targetPlayer + " for: &e" + reason));
            } else {
                staff.sendMessage(MessageUtils.colorize("&cFailed to ban " + targetPlayer + ". Player may already be banned."));
            }
        })).exceptionally(throwable -> {
            this.plugin.getLogger().severe("Error executing ban: " + throwable.getMessage());
            staff.sendMessage(MessageUtils.colorize("&cAn error occurred while executing the ban."));
            return null;
        });
    }

    @Override
    protected void onMenuOpen(Player staff, String targetPlayer) {
        this.plugin.debug("Staff %s opened ban menu for %s", staff.getName(), targetPlayer);
    }
}

