/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.gui.menus;

import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.gui.MenuHandler;
import me.wethink.weGuardian.gui.menus.MenuManager;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class KickMenu
extends MenuHandler {
    private final MenuManager menuManager;

    public KickMenu(WeGuardian plugin, MenuManager menuManager) {
        super(plugin, "kick");
        this.menuManager = menuManager;
    }

    @Override
    protected ConfigurationSection getMenuConfig() {
        return this.plugin.getGUIConfigLoader().getGUIConfig("kick");
    }

    @Override
    protected void handleItemClick(Player staff, String targetPlayer, String itemKey, ConfigurationSection itemConfig) {
        String reason;
        String menuType;
        String[] parts;
        String action = itemConfig.getString("action", "");
        this.plugin.getLogger().info("KickMenu: Player " + staff.getName() + " clicked item " + itemKey + " with action: " + action);
        if (action.startsWith("execute_punishment:") && (parts = action.split(":", 3)).length >= 3) {
            String reason2 = parts[2];
            this.executeKick(staff, targetPlayer, reason2);
            return;
        }
        if (action.startsWith("open_menu:") && (menuType = action.substring("open_menu:".length())).equals("main")) {
            this.menuManager.setActiveMenu(staff, this.menuManager.getMainMenu());
            this.menuManager.getMainMenu().openMenu(staff, targetPlayer);
            return;
        }
        if (action.equals("back") || itemKey.equals("back")) {
            this.menuManager.setActiveMenu(staff, this.menuManager.getMainMenu());
            this.menuManager.getMainMenu().openMenu(staff, targetPlayer);
            return;
        }
        if (action.equals("close") || itemKey.equals("close")) {
            staff.closeInventory();
            return;
        }
        if (action.startsWith("custom_reason:")) {
            staff.sendMessage(MessageUtils.colorize("&eCustom input feature coming in next update!"));
            staff.sendMessage(MessageUtils.colorize("&7For now, please use the predefined options."));
            return;
        }
        if (itemConfig.contains("reason")) {
            reason = itemConfig.getString("reason", "No reason specified");
            this.executeKick(staff, targetPlayer, reason);
            return;
        }
        reason = itemConfig.getString("reason", "No reason specified");
        this.executeKick(staff, targetPlayer, reason);
    }

    private void executeKick(Player staff, String targetPlayer, String reason) {
        staff.closeInventory();
        this.clearSelectedData(staff);
        staff.sendMessage(MessageUtils.colorize("&eExecuting kick on &a" + targetPlayer + " &efor: &f" + reason));
        ((CompletableFuture)this.plugin.getPunishmentService().kick(targetPlayer, staff.getName(), reason).thenAccept(success -> {
            if (success.booleanValue()) {
                staff.sendMessage(MessageUtils.colorize("&aSuccessfully kicked " + targetPlayer + " for: &e" + reason));
            } else {
                staff.sendMessage(MessageUtils.colorize("&cFailed to kick " + targetPlayer + ". Player may not be online."));
            }
        })).exceptionally(throwable -> {
            this.plugin.getLogger().severe("Error executing kick: " + throwable.getMessage());
            staff.sendMessage(MessageUtils.colorize("&cAn error occurred while executing the kick."));
            return null;
        });
    }

    @Override
    protected void onMenuOpen(Player staff, String targetPlayer) {
        if (this.plugin.getConfig().getBoolean("debug.enabled", false)) {
            this.plugin.debug("Staff %s opened kick menu for %s", staff.getName(), targetPlayer);
        }
    }
}

