/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.services;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import org.bukkit.configuration.file.FileConfiguration;

public class DiscordWebhookService {
    private final WeGuardian plugin;
    private final HttpClient httpClient;
    private static final DateTimeFormatter DISCORD_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public DiscordWebhookService(WeGuardian plugin) {
        this.plugin = plugin;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public void sendPunishmentWebhook(Punishment punishment) {
        FileConfiguration config = this.plugin.getConfig();
        if (!config.getBoolean("discord.enabled", false)) {
            return;
        }
        String eventKey = this.getEventKey(punishment.getType());
        if (eventKey == null || !config.getBoolean("discord.send_on." + eventKey, true)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String webhookUrl = config.getString("discord.webhook_url");
                if (webhookUrl == null || webhookUrl.equals("https://discord.com/api/webhooks/YOUR_WEBHOOK_URL")) {
                    return;
                }
                String payload = this.createPunishmentPayload(punishment, config);
                this.sendWebhook(webhookUrl, payload);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to send Discord webhook: " + e.getMessage());
            }
        });
    }

    public void sendUnpunishmentWebhook(Punishment punishment, String staffName) {
        FileConfiguration config = this.plugin.getConfig();
        if (!config.getBoolean("discord.enabled", false)) {
            return;
        }
        String eventKey = this.getUnpunishmentEventKey(punishment.getType());
        if (eventKey == null || !config.getBoolean("discord.send_on." + eventKey, true)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String webhookUrl = config.getString("discord.webhook_url");
                if (webhookUrl == null || webhookUrl.equals("https://discord.com/api/webhooks/YOUR_WEBHOOK_URL")) {
                    return;
                }
                String payload = this.createUnpunishmentPayload(punishment, staffName, config);
                this.sendWebhook(webhookUrl, payload);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to send Discord webhook: " + e.getMessage());
            }
        });
    }

    private void sendWebhook(String webhookUrl, String payload) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(webhookUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(payload)).timeout(Duration.ofSeconds(30L)).build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            this.plugin.getLogger().warning("Discord webhook failed with status: " + response.statusCode() + " - " + response.body());
        }
    }

    private String createPunishmentPayload(Punishment punishment, FileConfiguration config) {
        String username = config.getString("discord.username", "WeGuardian");
        String avatarUrl = config.getString("discord.avatar_url", "");
        int embedColor = config.getInt("discord.embed_color", 0xFF0000);
        String title = this.getTitle(punishment.getType(), false);
        String description = this.createDescription(punishment);
        String timestamp = punishment.getCreatedAt().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "Z";
        return String.format("{\n  \"username\": \"%s\",\n  \"avatar_url\": \"%s\",\n  \"embeds\": [\n    {\n      \"title\": \"%s\",\n      \"description\": \"%s\",\n      \"color\": %d,\n      \"timestamp\": \"%s\",\n      \"fields\": [\n        {\n          \"name\": \"Player\",\n          \"value\": \"%s\",\n          \"inline\": true\n        },\n        {\n          \"name\": \"Staff\",\n          \"value\": \"%s\",\n          \"inline\": true\n        },\n        {\n          \"name\": \"Reason\",\n          \"value\": \"%s\",\n          \"inline\": false\n        }%s\n      ]\n    }\n  ]\n}", username, avatarUrl, title, description, embedColor, timestamp, punishment.getTargetName() != null ? punishment.getTargetName() : "Unknown", punishment.getStaffName() != null ? punishment.getStaffName() : "Console", punishment.getReason() != null ? punishment.getReason() : "No reason specified", punishment.getExpiresAt() != null ? String.format(",\n    {\n      \"name\": \"Duration\",\n      \"value\": \"%s\",\n      \"inline\": true\n    },\n    {\n      \"name\": \"Expires\",\n      \"value\": \"%s\",\n      \"inline\": true\n    }", this.getDurationString(punishment), punishment.getExpiresAt().format(DISCORD_TIME_FORMAT)) : "");
    }

    private String createUnpunishmentPayload(Punishment punishment, String staffName, FileConfiguration config) {
        String username = config.getString("discord.username", "WeGuardian");
        String avatarUrl = config.getString("discord.avatar_url", "");
        int embedColor = 65280;
        String title = this.getTitle(punishment.getType(), true);
        String description = String.format("%s has been %s", punishment.getTargetName() != null ? punishment.getTargetName() : "Unknown", punishment.getType() == PunishmentType.BAN || punishment.getType() == PunishmentType.TEMPBAN ? "unbanned" : "unmuted");
        return String.format("{\n  \"username\": \"%s\",\n  \"avatar_url\": \"%s\",\n  \"embeds\": [\n    {\n      \"title\": \"%s\",\n      \"description\": \"%s\",\n      \"color\": %d,\n      \"fields\": [\n        {\n          \"name\": \"Player\",\n          \"value\": \"%s\",\n          \"inline\": true\n        },\n        {\n          \"name\": \"Staff\",\n          \"value\": \"%s\",\n          \"inline\": true\n        },\n        {\n          \"name\": \"Original Reason\",\n          \"value\": \"%s\",\n          \"inline\": false\n        }\n      ]\n    }\n  ]\n}", username, avatarUrl, title, description, embedColor, punishment.getTargetName() != null ? punishment.getTargetName() : "Unknown", staffName != null ? staffName : "Console", punishment.getReason() != null ? punishment.getReason() : "No reason specified");
    }

    private String createDescription(Punishment punishment) {
        String action = switch (punishment.getType()) {
            case PunishmentType.BAN, PunishmentType.IPBAN -> "banned";
            case PunishmentType.TEMPBAN -> "temporarily banned";
            case PunishmentType.MUTE, PunishmentType.IPMUTE -> "muted";
            case PunishmentType.TEMPMUTE -> "temporarily muted";
            case PunishmentType.KICK, PunishmentType.IPKICK -> "kicked";
            case PunishmentType.WARN, PunishmentType.IPWARN -> "warned";
            default -> "punished";
        };
        return String.format("%s has been %s", punishment.getTargetName() != null ? punishment.getTargetName() : "Unknown", action);
    }

    private String getTitle(PunishmentType type, boolean isUnpunishment) {
        if (isUnpunishment) {
            return switch (type) {
                case PunishmentType.BAN, PunishmentType.IPBAN, PunishmentType.TEMPBAN -> "Player Unbanned";
                case PunishmentType.MUTE, PunishmentType.IPMUTE, PunishmentType.TEMPMUTE -> "Player Unmuted";
                default -> "Punishment Removed";
            };
        }
        return switch (type) {
            case PunishmentType.BAN, PunishmentType.IPBAN -> "Player Banned";
            case PunishmentType.TEMPBAN -> "Player Temporarily Banned";
            case PunishmentType.MUTE, PunishmentType.IPMUTE -> "Player Muted";
            case PunishmentType.TEMPMUTE -> "Player Temporarily Muted";
            case PunishmentType.KICK, PunishmentType.IPKICK -> "Player Kicked";
            case PunishmentType.WARN, PunishmentType.IPWARN -> "Player Warned";
            default -> "Player Punished";
        };
    }

    private String getDurationString(Punishment punishment) {
        if (punishment.getExpiresAt() == null) {
            return "Permanent";
        }
        Duration duration = Duration.between(punishment.getCreatedAt(), punishment.getExpiresAt());
        long days = duration.toDays();
        long hours = duration.toHoursPart();
        long minutes = duration.toMinutesPart();
        if (days > 0L) {
            return String.format("%dd %dh %dm", days, hours, minutes);
        }
        if (hours > 0L) {
            return String.format("%dh %dm", hours, minutes);
        }
        return String.format("%dm", minutes);
    }

    private String getEventKey(PunishmentType type) {
        return switch (type) {
            case PunishmentType.BAN, PunishmentType.IPBAN -> "ban";
            case PunishmentType.TEMPBAN -> "tempban";
            case PunishmentType.MUTE, PunishmentType.IPMUTE -> "mute";
            case PunishmentType.TEMPMUTE -> "tempmute";
            case PunishmentType.KICK, PunishmentType.IPKICK -> "kick";
            case PunishmentType.WARN, PunishmentType.IPWARN -> "warn";
            default -> null;
        };
    }

    private String getUnpunishmentEventKey(PunishmentType type) {
        return switch (type) {
            case PunishmentType.BAN, PunishmentType.IPBAN, PunishmentType.TEMPBAN -> "unban";
            case PunishmentType.MUTE, PunishmentType.IPMUTE, PunishmentType.TEMPMUTE -> "unmute";
            default -> null;
        };
    }
}

