/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weGuardian.web.SessionManager;

public class PunishmentsApiServlet
extends HttpServlet {
    private final WeGuardian plugin;
    private final SessionManager sessionManager;
    private final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)LocalDateTime.class), (src, typeOfSrc, context) -> context.serialize(src.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME))).create();

    public PunishmentsApiServlet(WeGuardian plugin, SessionManager sessionManager) {
        this.plugin = plugin;
        this.sessionManager = sessionManager;
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sessionId = this.getSessionIdFromCookies(request);
        if (sessionId == null || !this.sessionManager.isValidSession(sessionId)) {
            response.setStatus(401);
            return;
        }
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.equals("/")) {
            this.handleGetActivePunishments(request, response);
        } else if (pathInfo.startsWith("/active")) {
            this.handleGetActivePunishments(request, response);
        } else {
            response.setStatus(404);
        }
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sessionId = this.getSessionIdFromCookies(request);
        if (sessionId == null || !this.sessionManager.isValidSession(sessionId)) {
            response.setStatus(401);
            return;
        }
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.equals("/")) {
            this.handleApplyPunishment(request, response);
        } else if (pathInfo.startsWith("/revoke/")) {
            String punishmentIdStr = pathInfo.substring("/revoke/".length());
            this.handleRevokePunishment(request, response, punishmentIdStr);
        } else {
            response.setStatus(404);
        }
    }

    private void handleGetActivePunishments(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        try {
            CompletableFuture<List<Punishment>> future = this.plugin.getDatabaseManager().getAllActivePunishments();
            List<Punishment> punishments = future.join();
            JsonObject result = new JsonObject();
            result.add("punishments", this.gson.toJsonTree(punishments));
            result.addProperty("success", true);
            PrintWriter out = response.getWriter();
            out.print(this.gson.toJson(result));
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error getting active punishments: " + e.getMessage());
            JsonObject error = new JsonObject();
            error.addProperty("success", false);
            error.addProperty("error", "Failed to retrieve punishments");
            response.setStatus(500);
            PrintWriter out = response.getWriter();
            out.print(this.gson.toJson(error));
        }
    }

    private void handleApplyPunishment(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        try {
            String line;
            BufferedReader reader = request.getReader();
            StringBuilder json = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                json.append(line);
            }
            JsonObject requestData = this.gson.fromJson(json.toString(), JsonObject.class);
            String targetName = requestData.get("targetName").getAsString();
            String punishmentType = requestData.get("type").getAsString();
            String reason = requestData.get("reason").getAsString();
            String duration = requestData.has("duration") ? requestData.get("duration").getAsString() : null;
            SessionManager.Session session = this.sessionManager.getSession(this.getSessionIdFromCookies(request));
            String staffName = session.getUsername();
            PunishmentType type = PunishmentType.valueOf(punishmentType.toUpperCase());
            CompletableFuture<Boolean> future = this.plugin.getPunishmentService().executePunishment(type, targetName, staffName, reason, duration);
            boolean success = future.join();
            JsonObject result = new JsonObject();
            result.addProperty("success", success);
            if (success) {
                result.addProperty("message", "Punishment applied successfully");
                this.plugin.getWebDashboardService().getWebSocketHandler().broadcastStats();
            } else {
                result.addProperty("error", "Failed to apply punishment");
            }
            PrintWriter out = response.getWriter();
            out.print(this.gson.toJson(result));
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error applying punishment: " + e.getMessage());
            JsonObject error = new JsonObject();
            error.addProperty("success", false);
            error.addProperty("error", "Failed to apply punishment: " + e.getMessage());
            response.setStatus(500);
            PrintWriter out = response.getWriter();
            out.print(this.gson.toJson(error));
        }
    }

    private void handleRevokePunishment(HttpServletRequest request, HttpServletResponse response, String punishmentIdStr) throws IOException {
        response.setContentType("application/json");
        try {
            int punishmentId = Integer.parseInt(punishmentIdStr);
            SessionManager.Session session = this.sessionManager.getSession(this.getSessionIdFromCookies(request));
            String staffName = session.getUsername();
            CompletableFuture<Void> future = this.plugin.getDatabaseManager().removePunishment(punishmentId, UUID.randomUUID(), staffName, "Revoked via web dashboard");
            future.join();
            JsonObject result = new JsonObject();
            result.addProperty("success", true);
            result.addProperty("message", "Punishment revoked successfully");
            this.plugin.getWebDashboardService().getWebSocketHandler().broadcastStats();
            PrintWriter out = response.getWriter();
            out.print(this.gson.toJson(result));
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error revoking punishment: " + e.getMessage());
            JsonObject error = new JsonObject();
            error.addProperty("success", false);
            error.addProperty("error", "Failed to revoke punishment: " + e.getMessage());
            response.setStatus(500);
            PrintWriter out = response.getWriter();
            out.print(this.gson.toJson(error));
        }
    }

    private String getSessionIdFromCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"sessionId".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

