/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.wethink.weGuardian.commands.AltsCommand;
import me.wethink.weGuardian.commands.BanCommand;
import me.wethink.weGuardian.commands.BanMenuCommand;
import me.wethink.weGuardian.commands.BanlistCommand;
import me.wethink.weGuardian.commands.BlameCommand;
import me.wethink.weGuardian.commands.CheckbanCommand;
import me.wethink.weGuardian.commands.HistoryCommand;
import me.wethink.weGuardian.commands.IPBanCommand;
import me.wethink.weGuardian.commands.IPMuteCommand;
import me.wethink.weGuardian.commands.KickCommand;
import me.wethink.weGuardian.commands.KickMenuCommand;
import me.wethink.weGuardian.commands.MuteCommand;
import me.wethink.weGuardian.commands.MuteMenuCommand;
import me.wethink.weGuardian.commands.MutelistCommand;
import me.wethink.weGuardian.commands.NotesMenuCommand;
import me.wethink.weGuardian.commands.PunishCommand;
import me.wethink.weGuardian.commands.TempIPBanCommand;
import me.wethink.weGuardian.commands.TempbanCommand;
import me.wethink.weGuardian.commands.TempbanMenuCommand;
import me.wethink.weGuardian.commands.TempmuteCommand;
import me.wethink.weGuardian.commands.TempmuteMenuCommand;
import me.wethink.weGuardian.commands.UnbanCommand;
import me.wethink.weGuardian.commands.UnbanIPCommand;
import me.wethink.weGuardian.commands.UnbanMenuCommand;
import me.wethink.weGuardian.commands.UnmuteCommand;
import me.wethink.weGuardian.commands.UnmuteMenuCommand;
import me.wethink.weGuardian.commands.UnwarnCommand;
import me.wethink.weGuardian.commands.WarnCommand;
import me.wethink.weGuardian.commands.WarnMenuCommand;
import me.wethink.weGuardian.commands.WarnsCommand;
import me.wethink.weGuardian.commands.WeGuardianCommand;
import me.wethink.weGuardian.database.DatabaseManager;
import me.wethink.weGuardian.database.HikariDatabaseManager;
import me.wethink.weGuardian.database.YamlDatabaseManager;
import me.wethink.weGuardian.gui.GUIConfigLoader;
import me.wethink.weGuardian.gui.PunishmentGUI;
import me.wethink.weGuardian.listeners.AsyncSuggestionsListener;
import me.wethink.weGuardian.listeners.ChatListener;
import me.wethink.weGuardian.listeners.PlayerListener;
import me.wethink.weGuardian.services.ConsoleCommandService;
import me.wethink.weGuardian.services.CrossServerSyncService;
import me.wethink.weGuardian.services.MenuValidationService;
import me.wethink.weGuardian.services.NotificationService;
import me.wethink.weGuardian.services.PunishmentService;
import me.wethink.weGuardian.services.TemplateService;
import me.wethink.weGuardian.utils.WeGuardianPlaceholderExpansion;
import me.wethink.weGuardian.web.WebDashboardService;
import me.wethink.weguardian.lib.bstats.bukkit.Metrics;
import me.wethink.weguardian.lib.bstats.charts.SimplePie;
import me.wethink.weguardian.lib.bstats.charts.SingleLineChart;
import me.wethink.weguardian.lib.folialib.FoliaLib;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class WeGuardian
extends JavaPlugin {
    private static final long CACHE_DURATION = 300000L;
    private final ConcurrentHashMap<String, String> messageCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> cacheTimestamps = new ConcurrentHashMap();
    private FoliaLib foliaLib;
    private DatabaseManager databaseManager;
    private PunishmentService punishmentService;
    private NotificationService notificationService;
    private TemplateService templateService;
    private CrossServerSyncService crossServerSyncService;
    private MenuValidationService menuValidationService;
    private PunishmentGUI punishmentGUI;
    private GUIConfigLoader guiConfigLoader;
    private WebDashboardService webDashboardService;
    private ConsoleCommandService consoleCommandService;
    private FileConfiguration messagesConfig;
    private FileConfiguration guiConfig;
    private FileConfiguration reasonsConfig;
    private ScheduledExecutorService executorService;

    public void onEnable() {
        this.foliaLib = new FoliaLib((Plugin)this);
        boolean isFolia = this.foliaLib.isFolia();
        String platform = isFolia ? "Folia" : "Paper/Spigot/Bukkit";
        this.debug("Starting WeGuardian on " + platform + " platform");
        int threadPoolSize = isFolia ? 4 : 2;
        this.executorService = Executors.newScheduledThreadPool(threadPoolSize);
        if (isFolia) {
            this.debug("Folia detected - Using region-based scheduling optimizations");
        }
        this.loadConfigurations();
        this.saveDefaultConfig();
        this.initializeManagers();
        this.initializeDatabase();
        this.initializeServices();
        this.initializeListeners();
        this.registerCommands();
        this.registerPlaceholders();
        this.initializeMetrics();
        this.foliaLib.getScheduler().runTimerAsync(this::cleanupCache, 6000L, 6000L);
        this.sendStartupMessage();
    }

    public void onDisable() {
        this.sendShutdownMessage();
        if (this.foliaLib != null) {
            this.foliaLib.getScheduler().cancelAllTasks();
        }
        if (this.punishmentService != null) {
            this.punishmentService.shutdown();
        }
        if (this.notificationService != null) {
            this.notificationService.shutdown();
        }
        if (this.crossServerSyncService != null) {
            this.crossServerSyncService.shutdown();
        }
        if (this.webDashboardService != null) {
            this.webDashboardService.stop();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private void initializeManagers() {
    }

    private void initializeDatabase() {
        String databaseType = this.getConfig().getString("database.type", "yaml").toLowerCase();
        boolean useMySQL = this.getConfig().getBoolean("database.mysql.enabled", false);
        if (useMySQL && "mysql".equals(databaseType)) {
            this.debug("Initializing MySQL database connection...");
            this.databaseManager = new HikariDatabaseManager(this);
        } else {
            this.debug("Initializing YAML file storage...");
            this.databaseManager = new YamlDatabaseManager(this);
        }
        try {
            this.databaseManager.initialize().get();
            this.debug("Database initialized successfully! Type: " + (useMySQL ? "MySQL" : "YAML"));
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize database: " + e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void initializeServices() {
        this.guiConfigLoader = new GUIConfigLoader(this);
        this.punishmentService = new PunishmentService(this);
        this.notificationService = new NotificationService(this);
        this.templateService = new TemplateService(this);
        this.crossServerSyncService = new CrossServerSyncService(this);
        this.menuValidationService = new MenuValidationService(this);
        this.punishmentGUI = new PunishmentGUI(this);
        this.webDashboardService = new WebDashboardService(this);
        this.consoleCommandService = new ConsoleCommandService(this);
        if (this.crossServerSyncService.isEnabled()) {
            this.foliaLib.getScheduler().runNextTick(task -> this.crossServerSyncService.validateServerConnections());
        }
        if (this.menuValidationService.isValidationEnabled()) {
            this.foliaLib.getScheduler().runNextTick(task -> this.menuValidationService.validateMenuPerformance());
        }
        if (this.getConfig().getBoolean("web-dashboard.enabled", false)) {
            this.foliaLib.getScheduler().runAsync(task -> this.webDashboardService.start());
        }
    }

    private void initializeListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this, this.databaseManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this, this.databaseManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AsyncSuggestionsListener(this, this.databaseManager, this.templateService), (Plugin)this);
    }

    private void registerCommands() {
        this.getCommand("punish").setExecutor((CommandExecutor)new PunishCommand(this, this.punishmentGUI));
        this.getCommand("ban").setExecutor((CommandExecutor)new BanCommand(this, this.punishmentService));
        this.getCommand("tempban").setExecutor((CommandExecutor)new TempbanCommand(this, this.punishmentService));
        this.getCommand("mute").setExecutor((CommandExecutor)new MuteCommand(this, this.punishmentService));
        this.getCommand("tempmute").setExecutor((CommandExecutor)new TempmuteCommand(this, this.punishmentService));
        this.getCommand("kick").setExecutor((CommandExecutor)new KickCommand(this, this.punishmentService));
        this.getCommand("warn").setExecutor((CommandExecutor)new WarnCommand(this, this.punishmentService));
        this.getCommand("unban").setExecutor((CommandExecutor)new UnbanCommand(this, this.punishmentService));
        this.getCommand("unmute").setExecutor((CommandExecutor)new UnmuteCommand(this, this.punishmentService));
        this.getCommand("ipban").setExecutor((CommandExecutor)new IPBanCommand(this, this.punishmentService));
        this.getCommand("tempipban").setExecutor((CommandExecutor)new TempIPBanCommand(this, this.punishmentService));
        this.getCommand("ipmute").setExecutor((CommandExecutor)new IPMuteCommand(this.punishmentService));
        this.getCommand("unbanip").setExecutor((CommandExecutor)new UnbanIPCommand(this, this.punishmentService));
        this.getCommand("history").setExecutor((CommandExecutor)new HistoryCommand(this));
        this.getCommand("checkban").setExecutor((CommandExecutor)new CheckbanCommand(this));
        this.getCommand("banlist").setExecutor((CommandExecutor)new BanlistCommand(this));
        this.getCommand("mutelist").setExecutor((CommandExecutor)new MutelistCommand(this));
        this.getCommand("blame").setExecutor((CommandExecutor)new BlameCommand(this));
        this.getCommand("alts").setExecutor((CommandExecutor)new AltsCommand(this));
        this.getCommand("warns").setExecutor((CommandExecutor)new WarnsCommand(this));
        this.getCommand("unwarn").setExecutor((CommandExecutor)new UnwarnCommand(this));
        this.getCommand("banmenu").setExecutor((CommandExecutor)new BanMenuCommand(this));
        this.getCommand("tempbanmenu").setExecutor((CommandExecutor)new TempbanMenuCommand(this));
        this.getCommand("mutemenu").setExecutor((CommandExecutor)new MuteMenuCommand(this));
        this.getCommand("tempmutemenu").setExecutor((CommandExecutor)new TempmuteMenuCommand(this));
        this.getCommand("kickmenu").setExecutor((CommandExecutor)new KickMenuCommand(this));
        this.getCommand("warnmenu").setExecutor((CommandExecutor)new WarnMenuCommand(this));
        this.getCommand("notesmenu").setExecutor((CommandExecutor)new NotesMenuCommand(this));
        this.getCommand("unbanmenu").setExecutor((CommandExecutor)new UnbanMenuCommand(this));
        this.getCommand("unmutemenu").setExecutor((CommandExecutor)new UnmuteMenuCommand(this));
        if (this.getCommand("weguardian") != null) {
            WeGuardianCommand wg = new WeGuardianCommand(this);
            this.getCommand("weguardian").setExecutor((CommandExecutor)wg);
        }
    }

    private void registerPlaceholders() {
        if (this.getConfig().getBoolean("features.placeholderapi_integration", true) && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new WeGuardianPlaceholderExpansion(this, this.databaseManager).register();
            this.getLogger().info("PlaceholderAPI integration enabled");
        }
    }

    private void initializeMetrics() {
        if (this.getConfig().getBoolean("features.metrics", true)) {
            Metrics metrics = new Metrics(this, 27046);
            metrics.addCustomChart(new SimplePie("database_type", () -> this.getConfig().getString("database.type", "yaml").toLowerCase()));
            metrics.addCustomChart(new SimplePie("server_platform", () -> this.foliaLib.isFolia() ? "Folia" : "Paper/Spigot"));
            metrics.addCustomChart(new SingleLineChart("total_punishments", () -> {
                try {
                    return this.databaseManager.getTotalPunishments().join();
                }
                catch (Exception e) {
                    return 0;
                }
            }));
            this.getLogger().info("bStats metrics initialized (ID: 27046)");
        } else {
            this.getLogger().info("Metrics disabled in config");
        }
    }

    private void sendStartupMessage() {
        String[] bannerLines = new String[]{"&6\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557", "&6\u2551          &c&lWeGuardian v" + this.getPluginMeta().getVersion() + "&6           \u2551", "&6\u2551    &e\u2694 Advanced Punishment System \u2694&6    \u2551", "&6\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d", "", "&a\u2713 &7Database: &f" + this.getConfig().getString("database.type", "yaml").toUpperCase(), "&a\u2713 &7Platform: &f" + (this.foliaLib.isFolia() ? "Folia" : "Paper/Spigot/Bukkit"), "&a\u2713 &7Version: &f" + this.getPluginMeta().getVersion(), "&a\u2713 &7Messages: &f" + this.messagesConfig.getKeys(true).size() + " message keys loaded", "&a\u2713 &7GUIs: &f" + this.guiConfig.getKeys(false).size() + " sections, Reasons loaded with " + this.reasonsConfig.getKeys(false).size() + " categories", "&a\u2713 &7Services: &fInitialized", "", "&6Plugin successfully enabled!"};
        LegacyComponentSerializer serializer = LegacyComponentSerializer.legacyAmpersand();
        for (String line : bannerLines) {
            Bukkit.getConsoleSender().sendMessage((Component)serializer.deserialize(line));
        }
    }

    private void sendShutdownMessage() {
        String[] shutdownMessage;
        LegacyComponentSerializer serializer = LegacyComponentSerializer.legacyAmpersand();
        Bukkit.getConsoleSender().sendMessage((Component)serializer.deserialize("&c\u26a0 WeGuardian shutting down..."));
        for (String line : shutdownMessage = new String[]{"&c\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557", "&c\u2551          &4&lWeGuardian v" + this.getPluginMeta().getVersion() + "&c           \u2551", "&c\u2551         &6Shutting down...         &c\u2551", "&c\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d"}) {
            Bukkit.getConsoleSender().sendMessage((Component)serializer.deserialize(line));
        }
    }

    private void loadConfigurations() {
        this.loadMessagesConfig();
        this.loadGuiConfigs();
    }

    private void loadMessagesConfig() {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.debug("Loaded messages configuration with " + this.messagesConfig.getKeys(true).size() + " message keys");
    }

    private void loadGuiConfigs() {
        File mainGuiFile;
        File guiDir = new File(this.getDataFolder(), "gui");
        if (!guiDir.exists()) {
            guiDir.mkdirs();
        }
        if (!(mainGuiFile = new File(guiDir, "main.yml")).exists()) {
            this.saveResource("gui/main.yml", false);
        }
        this.guiConfig = YamlConfiguration.loadConfiguration((File)mainGuiFile);
        File reasonsFile = new File(guiDir, "reasons.yml");
        if (!reasonsFile.exists()) {
            YamlConfiguration reasonsConfig = new YamlConfiguration();
            reasonsConfig.set("ban.hacking", (Object)"Hacking/Cheating");
            reasonsConfig.set("ban.griefing", (Object)"Griefing");
            reasonsConfig.set("ban.spam", (Object)"Spamming");
            reasonsConfig.set("mute.toxic", (Object)"Toxic Behavior");
            reasonsConfig.set("mute.spam", (Object)"Chat Spam");
            reasonsConfig.set("kick.afk", (Object)"AFK in important area");
            reasonsConfig.set("warn.minor", (Object)"Minor Rule Violation");
            try {
                reasonsConfig.save(reasonsFile);
            }
            catch (Exception e) {
                this.getLogger().warning("Could not save reasons.yml: " + e.getMessage());
            }
        }
        this.reasonsConfig = YamlConfiguration.loadConfiguration((File)reasonsFile);
        this.debug("Loaded GUI configurations - Menu: " + this.guiConfig.getKeys(false).size() + " sections, Reasons loaded with " + this.reasonsConfig.getKeys(false).size() + " categories");
    }

    public void reloadConfigurations() {
        this.reloadConfig();
        this.loadConfigurations();
        this.clearMessageCache();
        this.debug("\u00a7aConfigurations reloaded successfully!");
    }

    public String getMessage(String path) {
        return this.getMessage(path, "");
    }

    public String getMessage(String path, String defaultValue) {
        if (this.messagesConfig == null) {
            return defaultValue;
        }
        String cacheKey = "msg:" + path;
        String cached = this.messageCache.get(cacheKey);
        Long timestamp = this.cacheTimestamps.get(cacheKey);
        if (cached != null && timestamp != null && System.currentTimeMillis() - timestamp < 300000L) {
            return cached;
        }
        String message = this.messagesConfig.getString(path, defaultValue);
        this.messageCache.put(cacheKey, message);
        this.cacheTimestamps.put(cacheKey, System.currentTimeMillis());
        return message;
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public FileConfiguration getGuiConfig() {
        return this.guiConfig;
    }

    public FileConfiguration getReasonsConfig() {
        return this.reasonsConfig;
    }

    public FoliaLib getFoliaLib() {
        return this.foliaLib;
    }

    public TemplateService getTemplateService() {
        return this.templateService;
    }

    public CrossServerSyncService getCrossServerSyncService() {
        return this.crossServerSyncService;
    }

    public MenuValidationService getMenuValidationService() {
        return this.menuValidationService;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public PunishmentService getPunishmentService() {
        return this.punishmentService;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public PunishmentGUI getPunishmentGUI() {
        return this.punishmentGUI;
    }

    public ConsoleCommandService getConsoleCommandService() {
        return this.consoleCommandService;
    }

    public GUIConfigLoader getGUIConfigLoader() {
        return this.guiConfigLoader;
    }

    public WebDashboardService getWebDashboardService() {
        return this.webDashboardService;
    }

    public boolean isFolia() {
        return this.foliaLib.isFolia();
    }

    public String getPlatformName() {
        return this.foliaLib.isFolia() ? "Folia" : "Paper/Spigot/Bukkit";
    }

    public String getAppealUrl() {
        return this.getConfig().getString("appeal_url", "your-server.com/appeals");
    }

    public void debug(String message) {
        if (this.getConfig().getBoolean("debug.enabled", false)) {
            this.getLogger().info("[DEBUG] " + message);
        }
    }

    public void debug(String message, Object ... args) {
        if (this.getConfig().getBoolean("debug.enabled", false)) {
            this.getLogger().info("[DEBUG] " + String.format(message, args));
        }
    }

    private void clearMessageCache() {
        this.messageCache.clear();
        this.cacheTimestamps.clear();
    }

    private void cleanupCache() {
        long currentTime = System.currentTimeMillis();
        this.cacheTimestamps.entrySet().removeIf(entry -> {
            if (currentTime - (Long)entry.getValue() > 300000L) {
                this.messageCache.remove(entry.getKey());
                return true;
            }
            return false;
        });
    }
}

