/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.database.DatabaseManager;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weGuardian.utils.MessageUtils;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class AltsCommand
implements CommandExecutor {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final WeGuardian plugin;

    public AltsCommand(WeGuardian plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!sender.hasPermission("weguardian.alts")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(MessageUtils.colorize("&cUsage: /alts <player> [--strict] [--punished] [--truealts]"));
            return true;
        }
        String targetName = args[0];
        boolean strict = Arrays.asList(args).contains("--strict");
        boolean punishedOnly = Arrays.asList(args).contains("--punished");
        boolean requireSharedPunishments = Arrays.asList(args).contains("--truealts");
        CompletableFuture<UUID> uuidFuture = this.plugin.getPunishmentService().getPlayerUUID(targetName);
        ((CompletableFuture)((CompletableFuture)uuidFuture.thenCompose(uuid -> {
            if (uuid == null) {
                sender.sendMessage(MessageUtils.colorize("&cPlayer '" + targetName + "' not found."));
                return CompletableFuture.completedFuture(null);
            }
            return this.findAltAccounts((UUID)uuid, targetName, strict, punishedOnly, requireSharedPunishments);
        })).thenAccept(altData -> {
            if (altData == null) {
                return;
            }
            this.displayAltAccounts(sender, targetName, (AltAccountData)altData, strict, punishedOnly, requireSharedPunishments);
        })).exceptionally(throwable -> {
            sender.sendMessage(MessageUtils.colorize("&cError checking alt accounts: " + throwable.getMessage()));
            this.plugin.getLogger().severe("Error in alts command: " + throwable.getMessage());
            return null;
        });
        return true;
    }

    private CompletableFuture<AltAccountData> findAltAccounts(UUID targetUuid, String targetName, boolean strict, boolean punishedOnly, boolean requireSharedPunishments) {
        long expirationTimeMillis = System.currentTimeMillis() - 5184000000L;
        return this.plugin.getDatabaseManager().getPlayerConnections(targetUuid).thenCompose(connections -> {
            if (connections.isEmpty()) {
                return CompletableFuture.completedFuture(new AltAccountData(new ArrayList<AltAccount>()));
            }
            Set targetIPs = connections.stream().map(DatabaseManager.PlayerConnection::getIp).collect(Collectors.toSet());
            List<CompletableFuture> ipFutures = targetIPs.stream().map(ip -> this.plugin.getDatabaseManager().getPlayersFromIP((String)ip, expirationTimeMillis)).collect(Collectors.toList());
            return CompletableFuture.allOf(ipFutures.toArray(new CompletableFuture[0])).thenCompose(v -> {
                HashSet<UUID> altUuids = new HashSet<UUID>();
                HashMap<UUID, Set> playerIPMap = new HashMap<UUID, Set>();
                for (CompletableFuture future : ipFutures) {
                    List ipConnections = (List)future.join();
                    for (DatabaseManager.PlayerConnection conn : ipConnections) {
                        UUID uuid2 = conn.getUuid();
                        if (uuid2.equals(targetUuid)) continue;
                        altUuids.add(uuid2);
                        playerIPMap.computeIfAbsent(uuid2, k -> new HashSet()).add(conn.getIp());
                    }
                }
                Set filteredAltUuids = strict ? altUuids.stream().filter(uuid -> {
                    HashSet sharedIPs = new HashSet(targetIPs);
                    sharedIPs.retainAll((Collection)playerIPMap.get(uuid));
                    return sharedIPs.size() > 1;
                }).collect(Collectors.toSet()) : altUuids.stream().filter(uuid -> {
                    Set playerIPs = (Set)playerIPMap.get(uuid);
                    return playerIPs.stream().anyMatch(targetIPs::contains);
                }).collect(Collectors.toSet());
                List<CompletableFuture> punishmentFutures = filteredAltUuids.stream().map(uuid -> this.plugin.getDatabaseManager().getPunishmentHistory((UUID)uuid)).collect(Collectors.toList());
                return CompletableFuture.allOf(punishmentFutures.toArray(new CompletableFuture[0])).thenApply(vv -> {
                    ArrayList<AltAccount> alts = new ArrayList<AltAccount>();
                    int i = 0;
                    for (UUID altUuid : filteredAltUuids) {
                        List punishments = (List)((CompletableFuture)punishmentFutures.get(i++)).join();
                        if (requireSharedPunishments && punishments.stream().noneMatch(p -> p.isActive() && (p.getType() == PunishmentType.BAN || p.getType() == PunishmentType.TEMPBAN)) || punishedOnly && punishments.stream().noneMatch(p -> p.isActive() && (p.getType() == PunishmentType.BAN || p.getType() == PunishmentType.TEMPBAN))) continue;
                        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)altUuid);
                        String altName = offlinePlayer.getName() != null ? offlinePlayer.getName() : "Unknown";
                        HashSet<String> sharedIPs = new HashSet<String>(targetIPs);
                        sharedIPs.retainAll((Collection)playerIPMap.get(altUuid));
                        boolean isOnline = offlinePlayer.isOnline();
                        long lastSeen = offlinePlayer.getLastSeen();
                        alts.add(new AltAccount(altUuid, altName, sharedIPs, punishments, isOnline, lastSeen));
                    }
                    alts.sort((a, b) -> {
                        boolean bBanned;
                        boolean aBanned = a.punishments.stream().anyMatch(p -> p.isActive() && (p.getType() == PunishmentType.BAN || p.getType() == PunishmentType.TEMPBAN));
                        if (aBanned != (bBanned = b.punishments.stream().anyMatch(p -> p.isActive() && (p.getType() == PunishmentType.BAN || p.getType() == PunishmentType.TEMPBAN)))) {
                            return aBanned ? -1 : 1;
                        }
                        return Long.compare(b.lastSeen, a.lastSeen);
                    });
                    return new AltAccountData(alts);
                });
            });
        });
    }

    private void displayAltAccounts(CommandSender sender, String targetName, AltAccountData data, boolean strict, boolean punishedOnly, boolean requireSharedPunishments) {
        sender.sendMessage(MessageUtils.colorize("&6&l=== Alt Accounts for " + targetName + " ==="));
        if (strict) {
            sender.sendMessage(MessageUtils.colorize("&7Mode: &eStrict (multiple shared IPs)"));
        }
        if (punishedOnly) {
            sender.sendMessage(MessageUtils.colorize("&7Filter: &cPunished accounts only"));
        }
        if (requireSharedPunishments) {
            sender.sendMessage(MessageUtils.colorize("&7Filter: &bTrue Alts (shared active bans/tempbans)"));
            data.alts.removeIf(alt -> alt.punishments.stream().noneMatch(p -> p.isActive() && (p.getType() == PunishmentType.BAN || p.getType() == PunishmentType.TEMPBAN)));
        }
        sender.sendMessage(MessageUtils.colorize("&7Found: &f" + data.alts.size() + " potential alt account(s)"));
        sender.sendMessage("");
        if (data.alts.isEmpty()) {
            sender.sendMessage(MessageUtils.colorize("&aNo alt accounts found."));
            return;
        }
        for (int i = 0; i < data.alts.size(); ++i) {
            AltAccount alt2 = data.alts.get(i);
            TextColor statusColor = TextColor.fromHexString((String)"FFFFFF");
            String statusText = "Clean";
            boolean isBanned = alt2.punishments.stream().anyMatch(p -> p.isActive() && (p.getType() == PunishmentType.BAN || p.getType() == PunishmentType.TEMPBAN));
            boolean isMuted = alt2.punishments.stream().anyMatch(p -> p.isActive() && (p.getType() == PunishmentType.MUTE || p.getType() == PunishmentType.TEMPMUTE));
            if (isBanned) {
                statusColor = TextColor.fromHexString((String)"FF0000");
                statusText = "BANNED";
            } else if (isMuted) {
                statusColor = TextColor.fromHexString((String)"FFA07A");
                statusText = "MUTED";
            } else if (!alt2.punishments.isEmpty()) {
                statusColor = TextColor.fromHexString((String)"FFD700");
                statusText = "History";
            }
            String onlineStatus = alt2.isOnline ? "&a[ONLINE]" : "&7[OFFLINE]";
            BuildableComponent altInfo = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)(i + 1 + ". ")).color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)alt2.name).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)(" " + onlineStatus)).color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)(" [" + statusText + "]")).color(statusColor))).build();
            BuildableComponent hoverText = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"Player: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)alt2.name).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nUUID: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)alt2.uuid.toString()).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nShared IPs: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)("" + alt2.sharedIPs.size())).color(TextColor.fromHexString((String)"FFFFFF")))).append(Component.text((String)"\nPunishments: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)("" + alt2.punishments.size())).color(TextColor.fromHexString((String)"FFFFFF")))).build();
            if (!alt2.isOnline && alt2.lastSeen > 0L) {
                BuildableComponent lastSeenComponent = ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"\nLast Seen: ").color(TextColor.fromHexString((String)"AAAAAA")))).append(Component.text((String)new Date(alt2.lastSeen).toString()).color(TextColor.fromHexString((String)"FFFFFF")))).build();
                hoverText = ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)hoverText)).append((Component)lastSeenComponent)).build();
            }
            altInfo = altInfo.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverText)).clickEvent(ClickEvent.runCommand((String)("/history " + alt2.name)));
            sender.sendMessage((Component)altInfo);
            sender.sendMessage(MessageUtils.colorize("&7Shared IPs: &f" + alt2.sharedIPs.stream().limit(3L).collect(Collectors.joining(", ")) + (String)(alt2.sharedIPs.size() > 3 ? " &7(+" + (alt2.sharedIPs.size() - 3) + " more)" : "")));
            List recentPunishments = alt2.punishments.stream().filter(p -> p.isActive() || p.getCreatedAt().isAfter(LocalDateTime.now().minusDays(30L))).limit(2L).collect(Collectors.toList());
            if (!recentPunishments.isEmpty()) {
                for (Punishment punishment : recentPunishments) {
                    TextColor typeColor = punishment.isActive() ? TextColor.fromHexString((String)"FF0000") : TextColor.fromHexString((String)"AAAAAA");
                    sender.sendMessage(MessageUtils.colorize("   " + String.valueOf(typeColor) + punishment.getType().name() + " &8| &7" + punishment.getReason() + " &8(" + punishment.getCreatedAt().format(DATE_FORMAT) + ")"));
                }
            }
            sender.sendMessage("");
        }
        sender.sendMessage(MessageUtils.colorize("&7Click on a player name to view their full punishment history."));
    }

    private static class AltAccountData {
        final List<AltAccount> alts;

        AltAccountData(List<AltAccount> alts) {
            this.alts = alts;
        }
    }

    private static class AltAccount {
        final UUID uuid;
        final String name;
        final Set<String> sharedIPs;
        final List<Punishment> punishments;
        final boolean isOnline;
        final long lastSeen;

        AltAccount(UUID uuid, String name, Set<String> sharedIPs, List<Punishment> punishments, boolean isOnline, long lastSeen) {
            this.uuid = uuid;
            this.name = name;
            this.sharedIPs = sharedIPs;
            this.punishments = punishments;
            this.isOnline = isOnline;
            this.lastSeen = lastSeen;
        }
    }
}

