/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.utils.MessageUtils;
import me.wethink.weGuardian.utils.TimeUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class BlameCommand
implements CommandExecutor {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final WeGuardian plugin;

    public BlameCommand(WeGuardian plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        int punishmentId;
        if (!sender.hasPermission("weguardian.blame")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(MessageUtils.colorize("&cUsage: /blame <punishment_id>"));
            return true;
        }
        try {
            punishmentId = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(MessageUtils.colorize("&cInvalid punishment ID: " + args[0]));
            return true;
        }
        ((CompletableFuture)this.plugin.getDatabaseManager().getPunishmentById(punishmentId).thenAccept(punishment -> {
            if (punishment == null) {
                sender.sendMessage(MessageUtils.colorize("&cNo punishment found with ID: " + punishmentId));
                return;
            }
            this.displayPunishmentDetails(sender, (Punishment)punishment);
        })).exceptionally(throwable -> {
            sender.sendMessage(MessageUtils.colorize("&cError retrieving punishment: " + throwable.getMessage()));
            this.plugin.getLogger().severe("Error in blame command: " + throwable.getMessage());
            return null;
        });
        return true;
    }

    private void displayPunishmentDetails(CommandSender sender, Punishment punishment) {
        String status;
        sender.sendMessage(MessageUtils.colorize("&6&l=== Punishment Details (ID: " + punishment.getId() + ") ==="));
        sender.sendMessage("");
        sender.sendMessage(MessageUtils.colorize("&7Type: &f" + punishment.getType().name()));
        String target = punishment.isIPBased() ? punishment.getTargetIP() : punishment.getTargetName();
        sender.sendMessage(MessageUtils.colorize("&7Target: &f" + target + (punishment.isIPBased() ? " &8(IP)" : " &8(Player)")));
        sender.sendMessage(MessageUtils.colorize("&7Staff: &f" + punishment.getStaffName()));
        sender.sendMessage(MessageUtils.colorize("&7Reason: &f" + punishment.getReason()));
        sender.sendMessage(MessageUtils.colorize("&7Date: &f" + punishment.getCreatedAt().format(DATE_FORMAT)));
        String string = status = punishment.isActive() ? "&aActive" : "&cInactive";
        if (punishment.isActive() && punishment.isExpired()) {
            status = "&eExpired";
        }
        sender.sendMessage(MessageUtils.colorize("&7Status: " + status));
        if (punishment.getExpiresAt() != null) {
            sender.sendMessage(MessageUtils.colorize("&7Expires: &f" + punishment.getExpiresAt().format(DATE_FORMAT)));
            if (punishment.isActive() && !punishment.isExpired()) {
                long timeLeft = Duration.between(LocalDateTime.now(), punishment.getExpiresAt()).toMillis();
                sender.sendMessage(MessageUtils.colorize("&7Time Left: &f" + TimeUtils.formatDuration(timeLeft)));
            }
        } else {
            sender.sendMessage(MessageUtils.colorize("&7Duration: &fPermanent"));
        }
        if (!punishment.isActive() && punishment.getRemovedAt() != null) {
            sender.sendMessage("");
            sender.sendMessage(MessageUtils.colorize("&c&lRemoval Information:"));
            sender.sendMessage(MessageUtils.colorize("&7Removed by: &f" + punishment.getRemovedByName()));
            sender.sendMessage(MessageUtils.colorize("&7Removed at: &f" + punishment.getRemovedAt().format(DATE_FORMAT)));
            if (punishment.getRemovalReason() != null) {
                sender.sendMessage(MessageUtils.colorize("&7Removal reason: &f" + punishment.getRemovalReason()));
            }
        }
        sender.sendMessage("");
        sender.sendMessage(MessageUtils.colorize("&7UUID: &8" + String.valueOf(punishment.getTargetUuid())));
        if (punishment.getStaffUuid() != null) {
            sender.sendMessage(MessageUtils.colorize("&7Staff UUID: &8" + String.valueOf(punishment.getStaffUuid())));
        }
        sender.sendMessage("");
    }
}

