/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weGuardian.utils.MessageUtils;
import me.wethink.weGuardian.utils.TimeUtils;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class MutelistCommand
implements CommandExecutor {
    private static final int ITEMS_PER_PAGE = 10;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final WeGuardian plugin;

    public MutelistCommand(WeGuardian plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!sender.hasPermission("weguardian.mutelist")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        int page = 1;
        String filter = null;
        boolean includeIP = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("--ip")) {
                includeIP = true;
                continue;
            }
            if (arg.equalsIgnoreCase("--page") && i + 1 < args.length) {
                try {
                    page = Integer.parseInt(args[i + 1]);
                    ++i;
                    continue;
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(MessageUtils.colorize("&cInvalid page number: " + args[i + 1]));
                    return true;
                }
            }
            if (arg.equalsIgnoreCase("--filter") && i + 1 < args.length) {
                filter = args[i + 1];
                ++i;
                continue;
            }
            if (!arg.matches("\\d+")) continue;
            try {
                page = Integer.parseInt(arg);
                continue;
            }
            catch (NumberFormatException e) {
                sender.sendMessage(MessageUtils.colorize("&cInvalid page number: " + arg));
                return true;
            }
        }
        int finalPage = page;
        String finalFilter = filter;
        boolean finalIncludeIP = includeIP;
        ((CompletableFuture)this.plugin.getDatabaseManager().getAllActivePunishments().thenAccept(punishments -> {
            List mutes = punishments.stream().filter(p -> p.getType() == PunishmentType.MUTE || p.getType() == PunishmentType.TEMPMUTE || finalIncludeIP && p.getType() == PunishmentType.IPMUTE).filter(p -> finalFilter == null || p.getTargetName().toLowerCase().contains(finalFilter.toLowerCase()) || p.getReason().toLowerCase().contains(finalFilter.toLowerCase())).collect(Collectors.toList());
            if (mutes.isEmpty()) {
                sender.sendMessage(MessageUtils.colorize("&aNo active mutes found" + (String)(finalFilter != null ? " matching filter '" + finalFilter + "'" : "") + "."));
                return;
            }
            int totalPages = (int)Math.ceil((double)mutes.size() / 10.0);
            int startIndex = (finalPage - 1) * 10;
            int endIndex = Math.min(startIndex + 10, mutes.size());
            if (finalPage > totalPages) {
                sender.sendMessage(MessageUtils.colorize("&cPage " + finalPage + " does not exist. Maximum page: " + totalPages));
                return;
            }
            sender.sendMessage(MessageUtils.colorize("&6&l=== Mute List (Page " + finalPage + "/" + totalPages + ") ==="));
            if (finalFilter != null) {
                sender.sendMessage(MessageUtils.colorize("&7Filter: &f" + finalFilter));
            }
            if (finalIncludeIP) {
                sender.sendMessage(MessageUtils.colorize("&7Including IP mutes"));
            }
            sender.sendMessage(MessageUtils.colorize("&7Total mutes: &f" + mutes.size()));
            sender.sendMessage("");
            for (int i = startIndex; i < endIndex; ++i) {
                long timeLeft;
                Punishment mute = (Punishment)mutes.get(i);
                String target = mute.isIPBased() ? mute.getTargetIP() : mute.getTargetName();
                String type = mute.getType() == PunishmentType.IPMUTE ? "IP" : "Player";
                String muteType = mute.getType() == PunishmentType.TEMPMUTE ? "Temp" : "Perm";
                BuildableComponent muteInfo = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)(i + 1 + ". ")).color(MessageUtils.parseColor("&7")))).append(Component.text((String)target).color(MessageUtils.parseColor("&6")))).append(Component.text((String)(" (" + type + " - " + muteType + ")")).color(MessageUtils.parseColor("&8")))).build();
                BuildableComponent hoverText = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"Target: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)target).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nStaff: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)mute.getStaffName()).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nReason: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)mute.getReason()).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nDate: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)mute.getCreatedAt().format(DATE_FORMAT)).color(MessageUtils.parseColor("&f")))).build();
                if (mute.getExpiresAt() != null) {
                    timeLeft = Duration.between(LocalDateTime.now(), mute.getExpiresAt()).toMillis();
                    hoverText = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"Target: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)target).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nStaff: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)mute.getStaffName()).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nReason: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)mute.getReason()).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nDate: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)mute.getCreatedAt().format(DATE_FORMAT)).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nExpires: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)mute.getExpiresAt().format(DATE_FORMAT)).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nTime Left: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)TimeUtils.formatDuration(timeLeft)).color(MessageUtils.parseColor("&f")))).build();
                } else {
                    hoverText = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"Target: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)target).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nStaff: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)mute.getStaffName()).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nReason: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)mute.getReason()).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nDate: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)mute.getCreatedAt().format(DATE_FORMAT)).color(MessageUtils.parseColor("&f")))).append(Component.text((String)"\nType: ").color(MessageUtils.parseColor("&7")))).append(Component.text((String)"Permanent").color(MessageUtils.parseColor("&c")))).build();
                }
                muteInfo = muteInfo.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverText)).clickEvent(ClickEvent.suggestCommand((String)("/unmute " + target)));
                sender.sendMessage((Component)muteInfo);
                sender.sendMessage(MessageUtils.colorize("   &7Reason: &f" + mute.getReason()));
                sender.sendMessage(MessageUtils.colorize("   &7Staff: &f" + mute.getStaffName() + " &8| &7Date: &f" + mute.getCreatedAt().format(DATE_FORMAT)));
                if (mute.getExpiresAt() != null) {
                    timeLeft = Duration.between(LocalDateTime.now(), mute.getExpiresAt()).toMillis();
                    sender.sendMessage(MessageUtils.colorize("   &7Expires: &f" + TimeUtils.formatDuration(timeLeft)));
                }
                sender.sendMessage("");
            }
            TextComponent footer = Component.text((String)"");
            if (finalPage > 1) {
                footer = ((TextComponent)((TextComponent)Component.text((String)"[\u25c0 Previous]").color(MessageUtils.parseColor("&a"))).clickEvent(ClickEvent.runCommand((String)("/mutelist " + (finalPage - 1) + (finalIncludeIP ? " --ip" : "") + (String)(finalFilter != null ? " --filter " + finalFilter : ""))))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Go to page " + (finalPage - 1)))));
            }
            footer = Component.text((String)(" Page " + finalPage + "/" + totalPages + " ")).color(MessageUtils.parseColor("&7"));
            if (finalPage < totalPages) {
                footer = ((TextComponent)((TextComponent)Component.text((String)"[Next \u25b6]").color(MessageUtils.parseColor("&a"))).clickEvent(ClickEvent.runCommand((String)("/mutelist " + (finalPage + 1) + (finalIncludeIP ? " --ip" : "") + (String)(finalFilter != null ? " --filter " + finalFilter : ""))))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Go to page " + (finalPage + 1)))));
            }
            sender.sendMessage((Component)footer);
        })).exceptionally(throwable -> {
            sender.sendMessage(MessageUtils.colorize("&cError retrieving mute list: " + throwable.getMessage()));
            this.plugin.getLogger().severe("Error in mutelist command: " + throwable.getMessage());
            return null;
        });
        return true;
    }
}

