/*
 * Decompiled with CFR 0.152.
 */
package me.wethink.weGuardian.commands;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.wethink.weGuardian.WeGuardian;
import me.wethink.weGuardian.models.PlayerData;
import me.wethink.weGuardian.models.Punishment;
import me.wethink.weGuardian.models.PunishmentType;
import me.wethink.weGuardian.utils.MessageUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RollbackCommand
implements CommandExecutor {
    private final WeGuardian plugin;

    public RollbackCommand(WeGuardian plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String staffName;
        UUID staffUuid;
        int punishmentId;
        if (!sender.hasPermission("weguardian.rollback")) {
            sender.sendMessage(MessageUtils.colorize("&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(MessageUtils.colorize("&cUsage: /rollback <punishment_id>"));
            return true;
        }
        try {
            punishmentId = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(MessageUtils.colorize("&cInvalid punishment ID. Must be a number."));
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            staffUuid = player.getUniqueId();
            staffName = player.getName();
        } else {
            staffUuid = null;
            staffName = "Console";
        }
        this.plugin.getDatabaseManager().getPunishmentById(punishmentId).thenAccept(punishment -> {
            if (punishment == null) {
                sender.sendMessage(MessageUtils.colorize("&c\u2717 Punishment #" + punishmentId + " not found."));
                return;
            }
            if (!punishment.isActive()) {
                sender.sendMessage(MessageUtils.colorize("&cPunishment #" + punishmentId + " is already inactive/expired."));
                return;
            }
            String reason = "Rolled back by " + staffName;
            ((CompletableFuture)this.plugin.getDatabaseManager().removePunishment(punishmentId, staffUuid, staffName, reason).thenAccept(result -> {
                sender.sendMessage(MessageUtils.colorize("&a\u2713 Successfully rolled back punishment #" + punishmentId));
                sender.sendMessage(MessageUtils.colorize("&7  Type: &f" + punishment.getType().name()));
                sender.sendMessage(MessageUtils.colorize("&7  Target: &f" + punishment.getTargetName()));
                sender.sendMessage(MessageUtils.colorize("&7  Original Staff: &f" + punishment.getStaffName()));
                sender.sendMessage(MessageUtils.colorize("&7  Original Reason: &f" + punishment.getReason()));
                String actionText = switch (punishment.getType()) {
                    case PunishmentType.BAN -> "unbanned";
                    case PunishmentType.TEMPBAN -> "unbanned";
                    case PunishmentType.MUTE -> "unmuted";
                    case PunishmentType.TEMPMUTE -> "unmuted";
                    case PunishmentType.WARN -> "removed warning for";
                    case PunishmentType.KICK -> "reversed kick for";
                    case PunishmentType.IPBAN -> "IP unbanned";
                    case PunishmentType.IPMUTE -> "IP unmuted";
                    case PunishmentType.IPWARN -> "removed IP warning for";
                    case PunishmentType.IPKICK -> "reversed IP kick for";
                    case PunishmentType.UNBANIP -> "reversed IP unban for";
                    case PunishmentType.UNMUTEIP -> "reversed IP unmute for";
                    default -> "reversed punishment for";
                };
                this.plugin.getNotificationService().broadcastUnpunishment((Punishment)punishment, staffName, actionText);
                this.plugin.getDatabaseManager().getPlayerData(punishment.getTargetUuid()).thenAccept(playerData -> {
                    if (playerData != null) {
                        switch (punishment.getType()) {
                            case BAN: 
                            case TEMPBAN: 
                            case IPBAN: 
                            case IPTEMPBAN: {
                                playerData.setBanned(false);
                                break;
                            }
                            case MUTE: 
                            case TEMPMUTE: 
                            case IPMUTE: 
                            case IPTEMPMUTE: {
                                playerData.setMuted(false);
                                break;
                            }
                            case UNBAN: {
                                playerData.setBanned(false);
                                break;
                            }
                            case UNMUTE: {
                                playerData.setMuted(false);
                                break;
                            }
                            case KICK: 
                            case IPKICK: {
                                playerData.setKicked(false);
                                break;
                            }
                            case NOTE: {
                                playerData.setNoted(false);
                                break;
                            }
                            case WARN: {
                                playerData.setWarned(false);
                                break;
                            }
                            case IPWARN: {
                                playerData.setIpWarned(false);
                                break;
                            }
                            case UNBANIP: {
                                playerData.setIpBanned(false);
                                break;
                            }
                            case UNMUTEIP: {
                                playerData.setIpMuted(false);
                            }
                        }
                        this.plugin.getDatabaseManager().savePlayerData((PlayerData)playerData);
                    }
                });
            })).exceptionally(ex -> {
                sender.sendMessage(MessageUtils.colorize("&c\u2717 Failed to rollback punishment: " + ex.getMessage()));
                return null;
            });
        });
        return true;
    }
}

